/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.web;

import com.alachisoft.ncache.web.CacheSession;
import com.alachisoft.ncache.web.ProxyRequest;
import com.alachisoft.ncache.web.session.SessionMonitor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.log4j.Logger;

public class ProxySession
implements HttpSession {
    private HttpSession session = null;
    private boolean invalidated = false;
    private CacheSession csession = null;
    private ProxyRequest request = null;
    private Logger logger = Logger.getLogger(ProxySession.class);

    public ProxySession(HttpSession httpSession, ProxyRequest proxyRequest, CacheSession cacheSession) {
        this.session = httpSession;
        this.csession = cacheSession;
        this.request = proxyRequest;
        if (cacheSession != null && httpSession != null) {
            this.logger.debug((Object)"Initializing proxy session with attributes from remote session.");
            this.fillLocalSession(cacheSession, httpSession);
        }
    }

    private void fillLocalSession(CacheSession cacheSession, HttpSession httpSession) {
        Set set = cacheSession.getKeys();
        for (String string : set) {
            this.logger.debug((Object)("Adding attribute [" + string + "] to local session."));
            httpSession.setAttribute(string, cacheSession.getAttribute(string));
        }
        cacheSession.clearAttributes();
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.csession.getSessionId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return this.session.getServletContext();
    }

    public void setMaxInactiveInterval(int n) {
        this.session.setMaxInactiveInterval(n);
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return this.session.getSessionContext();
    }

    public Object getAttribute(String string) {
        return this.session.getAttribute(string);
    }

    public Object getValue(String string) {
        return this.getAttribute(string);
    }

    public Enumeration getAttributeNames() {
        return this.session.getAttributeNames();
    }

    public String[] getValueNames() {
        return this.session.getValueNames();
    }

    public void setAttribute(String string, Object object) {
        this.ensureSerializable(object);
        this.session.setAttribute(string, object);
    }

    public void putValue(String string, Object object) {
        this.ensureSerializable(object);
        this.setAttribute(string, object);
    }

    public void removeAttribute(String string) {
        this.session.removeAttribute(string);
    }

    public void removeValue(String string) {
        this.removeAttribute(string);
    }

    public void invalidate() {
        this.logger.debug((Object)("Session [" + this.getId() + "] is invalidated."));
        this.invalidated = true;
        SessionMonitor.resetRequestCount(this.getId());
        this.session.invalidate();
        this.request.sessionInvalidated();
    }

    public boolean isNew() {
        return this.csession.isIsNew();
    }

    public boolean isInvalid() {
        return this.invalidated;
    }

    private void ensureSerializable(Object object) {
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("non-serializable attributes can not be added/saved in session.");
        }
    }
}

