/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.hibernate.jcache;

import com.alachisoft.ncache.client.Cache;
import com.alachisoft.ncache.client.CacheManager;
import com.alachisoft.ncache.hibernate.configuration.ConfigurationManager;
import com.alachisoft.ncache.hibernate.configuration.RegionConfiguraton;
import com.alachisoft.ncache.hibernate.jcache.HibernateNCacheCache;
import com.alachisoft.ncache.hibernate.jcache.HibernateNCacheCachingProvider;
import com.alachisoft.ncache.jsr107.NCacheManager;
import com.alachisoft.ncache.jsr107.spi.NCacheCachingProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.CacheException;
import javax.cache.configuration.Configuration;

public class HibernateNCacheManager
extends NCacheManager {
    private final ConcurrentHashMap<String, Object> allRegions = new ConcurrentHashMap();

    public HibernateNCacheManager(NCacheCachingProvider jCacheCachingProvider, ClassLoader classloader, URI uri, Properties props) {
        super(jCacheCachingProvider, classloader, uri, props);
    }

    public HibernateNCacheManager() throws URISyntaxException, Exception {
        super((NCacheCachingProvider)new HibernateNCacheCachingProvider(), null, null, new Properties());
    }

    public <K, V, C extends Configuration<K, V>> javax.cache.Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        this.checkManagerStatus();
        String configuredCacheName = "";
        RegionConfiguraton regionConfiguration = null;
        if (configuration == null) {
            // empty if block
        }
        try {
            regionConfiguration = ConfigurationManager.getInstance().getRegionConfiguration(cacheName);
            configuredCacheName = regionConfiguration.getCacheName();
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        if (this.allRegions.contains(cacheName)) {
            throw new CacheException("Cache with same name already exist");
        }
        cacheName = configuredCacheName;
        HibernateNCacheCache jCache = (HibernateNCacheCache)((Object)this.allCaches.get(cacheName));
        if (jCache != null) {
            return jCache;
        }
        try {
            Cache tayzGrid = CacheManager.getCache((String)cacheName);
            jCache = new HibernateNCacheCache(this, regionConfiguration, tayzGrid);
            javax.cache.Cache previous = (javax.cache.Cache)this.allCaches.putIfAbsent(cacheName, jCache);
            if (previous != null) {
                ((HibernateNCacheCache)previous).setClose();
            }
            return jCache;
        }
        catch (Exception ex) {
            throw new CacheException((Throwable)ex);
        }
    }
}

