/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.web;

import com.alachisoft.ncache.web.CacheSession;
import com.alachisoft.ncache.web.LockException;
import com.alachisoft.ncache.web.ProxyResponse;
import com.alachisoft.ncache.web.ProxySession;
import com.alachisoft.ncache.web.session.NCacheManager;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ProxyRequest
extends HttpServletRequestWrapper {
    private HttpServletRequest request = null;
    private HttpSession session = null;
    private CacheSession csession = null;
    private NCacheManager cacheManager = null;
    private boolean hasFatal = false;
    public static String NCACHE_SESSION_ID = "ncachesessionid";
    private String validSessionId = null;
    private Logger logger = Logger.getLogger(ProxyRequest.class);
    private ProxyResponse response = null;

    public ProxyRequest(HttpServletRequest httpServletRequest, ProxyResponse proxyResponse, NCacheManager nCacheManager) throws LockException {
        super(httpServletRequest);
        String string;
        this.logger.debug((Object)"Initializing request...");
        this.response = proxyResponse;
        this.request = httpServletRequest;
        this.cacheManager = nCacheManager;
        String string2 = null;
        String string3 = null;
        Cookie[] cookieArray = httpServletRequest.getCookies();
        for (int i = 0; cookieArray != null && i < cookieArray.length; ++i) {
            if (cookieArray[i] == null || !cookieArray[i].getName().equalsIgnoreCase(NCACHE_SESSION_ID)) continue;
            string2 = cookieArray[i].getValue();
            break;
        }
        if ((string = httpServletRequest.getRequestURI()) != null) {
            String string4;
            this.logger.debug((Object)("Query String:" + string));
            Pattern pattern = Pattern.compile("[^;]*(;(([^=]+)=([^;]+)))+");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches() && (string4 = matcher.group(3)) != null && string4.equalsIgnoreCase(NCACHE_SESSION_ID)) {
                string3 = matcher.group(4);
            }
        }
        this.csession = nCacheManager.findValidRemoteSession(httpServletRequest, new String[]{string2, string3, httpServletRequest.getRequestedSessionId()});
        if (this.csession != null) {
            this.validSessionId = this.csession.getSessionId();
        }
        this.logger.debug((Object)("Valid Session ID=" + this.validSessionId));
        if (this.validSessionId != null && this.validSessionId.length() > 0) {
            proxyResponse.setRemoteSessionId(this.validSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getSession(boolean bl) {
        this.logger.debug((Object)("Request for session, create= " + bl));
        if (!bl && this.request.getSession(false) == null) {
            this.logger.debug((Object)"No valid session, returning null");
            return null;
        }
        if (this.request.getSession(false) != null) {
            if (this.csession == null) {
                this.logger.debug((Object)"Initializing cache session");
                try {
                    HttpSession httpSession = this.request.getSession(false);
                    synchronized (httpSession) {
                        this.csession = this.cacheManager.initializeCacheSession(this.request, null);
                    }
                }
                catch (LockException lockException) {
                    this.hasFatal = true;
                    throw new RuntimeException(lockException.getMessage());
                }
            }
            if (this.session == null) {
                this.logger.debug((Object)"Creating session proxy");
                this.session = new ProxySession(this.request.getSession(false), this, this.csession);
            }
        } else if (bl) {
            this.logger.debug((Object)"No valid local session, creating new ...");
            try {
                HttpSession httpSession = this.request.getSession();
                synchronized (httpSession) {
                    this.csession = this.cacheManager.initializeCacheSession(this.request, this.csession);
                }
            }
            catch (LockException lockException) {
                this.hasFatal = true;
                throw new RuntimeException(lockException.getMessage());
            }
            this.logger.debug((Object)"Creating session proxy");
            this.session = new ProxySession(this.request.getSession(true), this, this.csession);
            this.validSessionId = this.csession.getSessionId();
            this.response.setRemoteSessionId(this.validSessionId);
        }
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public CacheSession getCacheSession() {
        return this.csession;
    }

    public void sessionInvalidated() {
        this.session = null;
        this.csession.reset();
    }

    public boolean hasFatalError() {
        return this.hasFatal;
    }
}

