/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Statistics;

import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.Enum.Time;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.EventLogger;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.PortPool;
import Alachisoft.NCache.Common.Stats.UsageStats;
import com.alachisoft.ncache.common.caching.statistics.customcounters.AverageCounter;
import com.alachisoft.ncache.common.caching.statistics.customcounters.FlipManager;
import com.alachisoft.ncache.common.caching.statistics.customcounters.NumberOfItemCounter;
import com.alachisoft.ncache.common.caching.statistics.customcounters.PerformanceCounter;
import com.alachisoft.ncache.common.caching.statistics.customcounters.PerformanceCounterBase;
import com.alachisoft.ncache.common.caching.statistics.customcounters.RateOfCounter;
import com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters.SystemCpuUsage;
import com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters.SystemFreeMemory;
import com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters.SystemMemoryUsage;
import com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters.SystemNetworkUsage;
import com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters.VMCommittedlMemory;
import com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters.VMCpuUsage;
import com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters.VMMaxMemory;
import com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters.VMMemoryUsage;
import com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters.VMNetworkUsage;
import com.alachisoft.ncache.common.caching.statistics.monitoring.CacheServerMonitor;
import com.alachisoft.ncache.common.caching.statistics.monitoring.Monitor;
import com.alachisoft.ncache.common.caching.statistics.operations.Operations;
import com.alachisoft.ncache.common.caching.statistics.operations.ServerOperations;
import java.net.InetAddress;

public class PerfStatsCollector
implements IDisposable {
    private static final String PC_CATEGORY = "NCache";
    private static ILogger logger;
    Monitor monitor;
    private String _instanceName;
    private String _port;
    private PerformanceCounterBase _pcClientBytesSentPerSec = null;
    private PerformanceCounterBase _pcClientBytesRecievedPerSec = null;
    private PerformanceCounterBase _pcRequestsPerSec = null;
    private PerformanceCounterBase _pcResponsesPerSec = null;
    private PerformanceCounterBase _pcMsecPerCacheOperation = null;
    private UsageStats _usMsecPerCacheOperation = null;
    private PerformanceCounterBase byteSentPerSec = null;
    private PerformanceCounterBase byteReceivePerSec = null;
    private PerformanceCounterBase eventQueueCount = null;
    private PerformanceCounterBase _generalNotificationQueueSize = null;
    private PerformanceCounterBase _pcSystemFreeMemory = null;
    private PerformanceCounterBase _pcSystemCpuUsage = null;
    private PerformanceCounterBase _pcSystemMemoryUsage = null;
    private PerformanceCounterBase _pcSystemNetworkUsage = null;
    private PerformanceCounterBase _pcVMCommittedMemory = null;
    private PerformanceCounterBase _pcVMCpuUsage = null;
    private PerformanceCounterBase _pcVMMemoryUsage = null;
    private PerformanceCounterBase _pcVMMaxMemory = null;
    private PerformanceCounterBase _pcVMNetworkUsage = null;
    private InetAddress iP;

    public PerfStatsCollector(String instanceName, int port, InetAddress iP, ILogger logger) {
        this._port = ":" + new Integer(port).toString();
        this._instanceName = instanceName;
        this.iP = iP;
        PerfStatsCollector.logger = logger;
    }

    public final String getInstanceName() {
        return this._instanceName;
    }

    public final void setInstanceName(String value) {
        this._instanceName = value;
    }

    public final boolean getUserHasAccessRights() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        PerfStatsCollector perfStatsCollector = this;
        synchronized (perfStatsCollector) {
            if (this.monitor != null) {
                if (this.byteSentPerSec != null && this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)ServerOperations.byteSentPerSec);
                }
                if (this.byteReceivePerSec != null && this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)ServerOperations.bytereceivePerSec);
                }
                if (this.eventQueueCount != null && this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)ServerOperations.eventQueueCount);
                }
                if (this._pcClientBytesRecievedPerSec != null) {
                    this.monitor.unRegisterCounter((Operations)ServerOperations.ClientBytesRecievedPerSec);
                    this._pcClientBytesRecievedPerSec = null;
                }
                if (this._pcClientBytesSentPerSec != null) {
                    this.monitor.unRegisterCounter((Operations)ServerOperations.ClientBytesSentPerSec);
                    this._pcClientBytesSentPerSec = null;
                }
                if (this._pcRequestsPerSec != null) {
                    this.monitor.unRegisterCounter((Operations)ServerOperations.RequestsPerSec);
                    this._pcRequestsPerSec = null;
                }
                if (this._pcResponsesPerSec != null) {
                    this.monitor.unRegisterCounter((Operations)ServerOperations.ResponsesPerSec);
                    this._pcResponsesPerSec = null;
                }
                if (this._pcMsecPerCacheOperation != null) {
                    this.monitor.unRegisterCounter((Operations)ServerOperations.MSecPerCacheOperation);
                    this._pcMsecPerCacheOperation = null;
                }
                if (this._pcVMCommittedMemory != null) {
                    this.monitor.unRegisterCounter((Operations)ServerOperations.SystemFreeMemory);
                }
                if (this._generalNotificationQueueSize != null) {
                    this.monitor.unRegisterCounter((Operations)ServerOperations.GeneralNotificationQueueSize);
                    this._generalNotificationQueueSize = null;
                }
                PortPool.getInstance().disposeSNMPPort(this._instanceName);
                this.monitor.unRegisterNode();
                this.monitor.stopJMX();
                this.monitor = null;
            }
            FlipManager.Stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void InitializePerfCounters() {
        try {
            if (!this.getUserHasAccessRights()) {
                return;
            }
            PerfStatsCollector perfStatsCollector = this;
            synchronized (perfStatsCollector) {
                this.monitor = new CacheServerMonitor(this._instanceName, logger);
                FlipManager.Start();
                this.monitor.startJMX();
                this.monitor.registerNode();
                this.byteSentPerSec = new RateOfCounter("byte sent per sec", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.byteSentPerSec, (PerformanceCounter)this.byteSentPerSec);
                this.byteReceivePerSec = new RateOfCounter("byte receive per sec", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.bytereceivePerSec, (PerformanceCounter)this.byteReceivePerSec);
                this.eventQueueCount = new NumberOfItemCounter("event queue count", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.eventQueueCount, (PerformanceCounter)this.eventQueueCount);
                this._pcRequestsPerSec = new RateOfCounter("Requests/sec", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.RequestsPerSec, (PerformanceCounter)this._pcRequestsPerSec);
                this._pcResponsesPerSec = new RateOfCounter("Response/sec", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.ResponsesPerSec, (PerformanceCounter)this._pcResponsesPerSec);
                this._pcClientBytesSentPerSec = new RateOfCounter("Client bytes sent/sec", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.ClientBytesSentPerSec, (PerformanceCounter)this._pcClientBytesSentPerSec);
                this._pcClientBytesRecievedPerSec = new RateOfCounter("Client bytes received/sec", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.ClientBytesRecievedPerSec, (PerformanceCounter)this._pcClientBytesRecievedPerSec);
                this._pcMsecPerCacheOperation = new AverageCounter("Average sec/cache operation", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.MSecPerCacheOperation, (PerformanceCounter)this._pcMsecPerCacheOperation);
                this._generalNotificationQueueSize = new NumberOfItemCounter(PC_CATEGORY, "General Notifications Queue Size", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.GeneralNotificationQueueSize, (PerformanceCounter)this._generalNotificationQueueSize);
                this._pcSystemCpuUsage = new SystemCpuUsage("Total Cpu Consumption", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.SystemCpuUsage, (PerformanceCounter)this._pcSystemCpuUsage);
                this._pcSystemFreeMemory = new SystemFreeMemory("Total Free Memory", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.SystemFreeMemory, (PerformanceCounter)this._pcSystemFreeMemory);
                this._pcSystemMemoryUsage = new SystemMemoryUsage("Total Memory Usage", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.SystemMemoryUsage, (PerformanceCounter)this._pcSystemMemoryUsage);
                this._pcSystemNetworkUsage = new SystemNetworkUsage("Totao NetworkUsage", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.SystemNetworkUsage, (PerformanceCounter)this._pcSystemNetworkUsage);
                this._pcVMCpuUsage = new VMCpuUsage("NCache Cpu Consumpiton", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.VMCpuUsage, (PerformanceCounter)this._pcVMCpuUsage);
                this._pcVMCommittedMemory = new VMCommittedlMemory("Committed Virtual Memory", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.VMCommittedMemory, (PerformanceCounter)this._pcVMCommittedMemory);
                this._pcVMMemoryUsage = new VMMemoryUsage("NCache Memory Usage", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.VMMemoryUsage, (PerformanceCounter)this._pcVMMemoryUsage);
                this._pcVMMaxMemory = new VMMaxMemory("Maximum NCache Memory Usage", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.VMMaxMemory, (PerformanceCounter)this._pcVMMaxMemory);
                this._pcVMNetworkUsage = new VMNetworkUsage("NCache Network Usage", this._instanceName);
                this.monitor.registerCounter((Operations)ServerOperations.VMNetworkUsage, (PerformanceCounter)this._pcVMNetworkUsage);
                this._usMsecPerCacheOperation = new UsageStats();
            }
        }
        catch (Exception e) {
            EventLogger.LogEvent((String)PC_CATEGORY, (String)("An error occured while initializing counters for Cache Server. " + e.toString()), (EventType)EventType.ERROR, (short)1, (int)1017);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementByteSentPerSecStats() {
        if (this.byteSentPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this.byteSentPerSec;
            synchronized (performanceCounterBase) {
                this.byteSentPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementByteSentPerSecStatsBy(long value) {
        if (this.byteSentPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this.byteSentPerSec;
            synchronized (performanceCounterBase) {
                this.byteSentPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementByteReceivePerSecStats() {
        if (this.byteReceivePerSec != null) {
            PerformanceCounterBase performanceCounterBase = this.byteReceivePerSec;
            synchronized (performanceCounterBase) {
                this.byteReceivePerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementByteReceivePerSecStatsBy(long value) {
        if (this.byteReceivePerSec != null) {
            PerformanceCounterBase performanceCounterBase = this.byteReceivePerSec;
            synchronized (performanceCounterBase) {
                this.byteReceivePerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementEventQueueCount() {
        if (this.eventQueueCount != null) {
            PerformanceCounterBase performanceCounterBase = this.eventQueueCount;
            synchronized (performanceCounterBase) {
                this.eventQueueCount.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setEventQueueCount(long value) {
        if (this.eventQueueCount != null) {
            PerformanceCounterBase performanceCounterBase = this.eventQueueCount;
            synchronized (performanceCounterBase) {
                this.eventQueueCount.setValue((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementEventQueueCountBy(long value) {
        if (this.eventQueueCount != null) {
            PerformanceCounterBase performanceCounterBase = this.eventQueueCount;
            synchronized (performanceCounterBase) {
                this.eventQueueCount.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementBytesSentPerSecStats(long bytesSent) {
        if (this._pcClientBytesSentPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this._pcClientBytesSentPerSec;
            synchronized (performanceCounterBase) {
                this._pcClientBytesSentPerSec.incrementBy((double)bytesSent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementBytesReceivedPerSecStats(long bytesReceived) {
        if (this._pcClientBytesRecievedPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this._pcClientBytesRecievedPerSec;
            synchronized (performanceCounterBase) {
                this._pcClientBytesRecievedPerSec.incrementBy((double)bytesReceived);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementRequestsPerSecStats(long requests) {
        if (this._pcRequestsPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this._pcRequestsPerSec;
            synchronized (performanceCounterBase) {
                this._pcRequestsPerSec.incrementBy((double)requests);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementResponsesPerSecStats(long responses) {
        if (this._pcResponsesPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this._pcResponsesPerSec;
            synchronized (performanceCounterBase) {
                this._pcResponsesPerSec.incrementBy((double)responses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mSecPerCacheOperationBeginSample() {
        if (this._pcMsecPerCacheOperation != null) {
            UsageStats usageStats = this._usMsecPerCacheOperation;
            synchronized (usageStats) {
                this._usMsecPerCacheOperation.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mSecPerCacheOperationEndSample() {
        if (this._pcMsecPerCacheOperation != null) {
            PerformanceCounterBase performanceCounterBase = this._pcMsecPerCacheOperation;
            synchronized (performanceCounterBase) {
                this._usMsecPerCacheOperation.EndSample();
                this._pcMsecPerCacheOperation.incrementBy(Time.toMicroSeconds((long)this._usMsecPerCacheOperation.getCurrent(), (Time)Time.nSEC));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SettNotificationQueueSizeStats(long count) {
        if (this._generalNotificationQueueSize != null) {
            PerformanceCounterBase performanceCounterBase = this._generalNotificationQueueSize;
            synchronized (performanceCounterBase) {
                this._generalNotificationQueueSize.setValue((double)count);
            }
        }
    }
}

