/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer;

import Alachisoft.NCache.Caching.CacheRenderer;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Common.DataStructures.BridgeOperation;
import Alachisoft.NCache.Common.DataStructures.BridgeOperationData;
import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.DataStructures.ReplicatorStatusInfo;
import Alachisoft.NCache.Common.DataStructures.StateTransferInfo;
import Alachisoft.NCache.Common.Enum.RtContextValue;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Logger.JLogger;
import Alachisoft.NCache.Common.Logger.LoggerNames;
import Alachisoft.NCache.Common.LoggingInfo;
import Alachisoft.NCache.Common.Monitoring.ClientNode;
import Alachisoft.NCache.Common.Monitoring.ClientProcessStats;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.CommandManagerType;
import Alachisoft.NCache.SocketServer.ConnectionManager;
import Alachisoft.NCache.SocketServer.GarbageCollectionTimer;
import Alachisoft.NCache.SocketServer.Statistics.PerfStatsCollector;
import com.alachisoft.ncache.client.internal.caching.SyncCache;
import com.alachisoft.ncache.client.internal.util.Logs;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheArgumentException;
import com.alachisoft.ncache.serialization.standard.FormatterServices;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class SocketServer
extends CacheRenderer {
    public static final int DEFAULT_SOCK_SERVER_PORT = 9800;
    public static final int DEFAULT_SOCK_BUFFER_SIZE = 32768;
    public static long CHUNK_SIZE_FOR_OBJECT = 0x40000000L;
    private static Logs _logger = new Logs();
    private static boolean _enableCacheServerCounters = true;
    private static PerfStatsCollector _perfStatsColl = null;
    private static LoggingInfo _serverLoggingInfo = new LoggingInfo();
    LoggerNames _loggerName;
    private int _serverPort;
    private int _sendBuffer;
    private int _recieveBuffer;
    private GarbageCollectionTimer gcTimer;
    private ConnectionManager _conManager;

    public SocketServer(int port, int sendBufferSize, int recieveBufferSize) {
        this._serverPort = port;
        this._sendBuffer = sendBufferSize;
        this._recieveBuffer = recieveBufferSize;
        if (ServicePropValues.CacheServer_ResponseDataSize != null) {
            CHUNK_SIZE_FOR_OBJECT = Long.parseLong(ServicePropValues.CacheServer_ResponseDataSize);
            CHUNK_SIZE_FOR_OBJECT = CHUNK_SIZE_FOR_OBJECT < 0L ? 1024L : CHUNK_SIZE_FOR_OBJECT;
            CHUNK_SIZE_FOR_OBJECT = CHUNK_SIZE_FOR_OBJECT * 1024L * 1024L;
        }
    }

    public SocketServer(int sendBufferSize, int recieveBufferSize) {
        this._sendBuffer = sendBufferSize;
        this._recieveBuffer = recieveBufferSize;
        if (ServicePropValues.CacheServer_ResponseDataSize != null) {
            CHUNK_SIZE_FOR_OBJECT = Long.parseLong(ServicePropValues.CacheServer_ResponseDataSize);
            CHUNK_SIZE_FOR_OBJECT = CHUNK_SIZE_FOR_OBJECT < 0L ? 1024L : CHUNK_SIZE_FOR_OBJECT;
            CHUNK_SIZE_FOR_OBJECT = CHUNK_SIZE_FOR_OBJECT * 1024L * 1024L;
        }
    }

    public static PerfStatsCollector getPerfStatsColl() {
        return _perfStatsColl;
    }

    public static Logs getLogger() {
        return _logger;
    }

    public static boolean getIsServerCounterEnabled() {
        return _enableCacheServerCounters;
    }

    public static void setIsServerCounterEnabled(boolean value) {
        _enableCacheServerCounters = value;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public void setServerPort(int value) {
        this._serverPort = value < 0 ? 9800 : value;
    }

    public int getSendBufferSize() {
        return this._sendBuffer;
    }

    public void setSendBufferSize(int value) {
        this._sendBuffer = value < 0 ? 32768 : value;
    }

    public int getReceiveBufferSize() {
        return this._recieveBuffer;
    }

    public void setReceiveBufferSize(int value) {
        this._recieveBuffer = value < 0 ? 32768 : value;
    }

    public void Start(InetAddress bindIP, LoggerNames loggerName, String perfStatColInstanceName, CommandManagerType cmdMgrType) throws NCacheArgumentException, Exception {
        FormatterServices.getDefault().registerKnownTypes(SyncCache.class, (short)124);
        FormatterServices.getDefault().registerKnownTypes(BridgeOperation.class, Integer.valueOf(132).shortValue());
        FormatterServices.getDefault().registerKnownTypes(BridgeOperationData.class, Integer.valueOf(152).shortValue());
        FormatterServices impl = FormatterServices.getDefault();
        impl.SetCacheContext("");
        impl.registerKnownTypes(StateTransferInfo.class, (short)130);
        impl.registerKnownTypes(ReplicatorStatusInfo.class, (short)131);
        impl.registerKnownTypes(OperationContext.class, (short)153);
        impl.registerKnownTypes(EnumerationPointer.class, (short)161);
        impl.registerKnownTypes(EnumerationDataChunk.class, (short)162);
        this._loggerName = loggerName == null ? LoggerNames.SocketServerLogs : loggerName;
        this.InitializeLogging();
        try {
            LicenseManager.LicenseType type = LicenseManager.LicenseMode(null);
        }
        catch (Exception e) {
            if (SocketServer.getLogger().getIsDetailedLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Info("SocketServer.Start", "e.Message");
            }
            throw new Exception(e.getMessage());
        }
        this._conManager = new ConnectionManager();
        this._conManager.Start(bindIP, this._serverPort, this._sendBuffer, this._recieveBuffer, _logger.getNCacheLog(), cmdMgrType);
        if (_perfStatsColl == null) {
            _perfStatsColl = new PerfStatsCollector(perfStatColInstanceName, this._serverPort, bindIP, _logger.getNCacheLog());
            _perfStatsColl.InitializePerfCounters();
        }
    }

    public void Start(InetSocketAddress bindIP) throws NCacheArgumentException, Exception {
        FormatterServices impl = FormatterServices.getDefault();
        impl.registerKnownTypes(SyncCache.class, (short)124);
        impl.registerKnownTypes(StateTransferInfo.class, (short)130);
        impl.registerKnownTypes(ReplicatorStatusInfo.class, (short)131);
        impl.registerKnownTypes(OperationContext.class, (short)153);
        impl.registerKnownTypes(EnumerationPointer.class, (short)161);
        impl.registerKnownTypes(EnumerationDataChunk.class, (short)162);
        this.InitializeLogging();
        this._conManager = new ConnectionManager();
        this._conManager.Start(bindIP, this._sendBuffer, this._recieveBuffer);
    }

    public void InitializeLogging() throws Exception {
        boolean enable_logs = false;
        boolean detailed_logs = false;
        if (ServicePropValues.Enable_Logs != null) {
            enable_logs = Boolean.parseBoolean(ServicePropValues.Enable_Logs);
        }
        if (ServicePropValues.Enable_Detailed_Logs != null) {
            detailed_logs = Boolean.parseBoolean(ServicePropValues.Enable_Detailed_Logs);
        }
        this.InitializeLogging(enable_logs, detailed_logs);
    }

    public void InitializeLogging(boolean errorOnly, boolean detailed) throws Exception {
        if (errorOnly || detailed) {
            Logs localLogger = new Logs();
            localLogger.setNCacheLog((ILogger)new JLogger());
            localLogger.getNCacheLog().Initialize(this._loggerName);
            if (detailed) {
                localLogger.getNCacheLog().SetLevel("ALL");
                localLogger.setIsErrorLogsEnabled(true);
            } else {
                localLogger.getNCacheLog().SetLevel("INFO");
            }
            localLogger.getNCacheLog().Info("SocketServer.Start", "server started successfully");
            if (errorOnly) {
                _serverLoggingInfo.SetStatus(LoggingInfo.LoggingType.Error, LoggingInfo.LogsStatus.Enable);
            }
            if (detailed) {
                _serverLoggingInfo.SetStatus(LoggingInfo.LoggingType.Detailed, detailed ? LoggingInfo.LogsStatus.Enable : LoggingInfo.LogsStatus.Disable);
            }
            localLogger.setIsDetailedLogsEnabled(detailed);
            localLogger.setIsErrorLogsEnabled(errorOnly);
            _logger = localLogger;
        } else if (_logger.getNCacheLog() != null) {
            _logger.getNCacheLog().Flush();
            _logger.getNCacheLog().SetLevel("OFF");
        }
    }

    public void Stop() throws IOException {
        if (this._conManager != null) {
            this._conManager.Stop();
        }
        _perfStatsColl.dispose();
    }

    public void StopListening() throws IOException {
        if (this._conManager != null) {
            this._conManager.StopListening();
        }
    }

    protected void finalize() throws Throwable {
        if (this._conManager != null) {
            this._conManager.Stop();
            this._conManager = null;
        }
    }

    public int getPort() {
        return this.getServerPort();
    }

    public InetAddress getIPAddress() {
        try {
            return InetAddress.getByName(ConnectionManager.getServerIpAddress());
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingInfo.LogsStatus GetLoggingStatus(LoggingInfo.LoggingSubsystem subsystem, LoggingInfo.LoggingType type) {
        switch (subsystem) {
            case Server: {
                LoggingInfo loggingInfo = _serverLoggingInfo;
                synchronized (loggingInfo) {
                    return _serverLoggingInfo.GetStatus(type);
                }
            }
            case Client: {
                return ConnectionManager.GetClientLoggingInfo(type);
            }
        }
        return LoggingInfo.LogsStatus.Disable;
    }

    /*
     * Unable to fully structure code
     */
    public void SetLoggingStatus(LoggingInfo.LoggingSubsystem subsystem, LoggingInfo.LoggingType type, LoggingInfo.LogsStatus status) throws Exception {
        block15: {
            block14: {
                if (subsystem != LoggingInfo.LoggingSubsystem.Client) break block14;
                updateClient = false;
                if (type == LoggingInfo.LoggingType.Error) ** GOTO lbl-1000
                if (type == LoggingInfo.LoggingType.Detailed) lbl-1000:
                // 2 sources

                {
                    updateClient = ConnectionManager.SetClientLoggingInfo(type, status);
                } else if (type == LoggingInfo.LoggingType.Error) {
                    if (type == LoggingInfo.LoggingType.Detailed) {
                        updateErrorLogs = ConnectionManager.SetClientLoggingInfo(LoggingInfo.LoggingType.Error, status);
                        updateDetailedLogs = ConnectionManager.SetClientLoggingInfo(LoggingInfo.LoggingType.Detailed, status);
                        v0 = updateClient = updateErrorLogs != false || updateDetailedLogs != false;
                    }
                }
                if (updateClient) {
                    ConnectionManager.UpdateClients();
                }
                break block15;
            }
            if (subsystem == LoggingInfo.LoggingSubsystem.Server) {
                switch (1.$SwitchMap$Alachisoft$NCache$Common$LoggingInfo$LogsStatus[status.ordinal()]) {
                    case 1: {
                        if (type == LoggingInfo.LoggingType.Error || type.getValue() == (LoggingInfo.LoggingType.Error.getValue() | LoggingInfo.LoggingType.Detailed.getValue())) {
                            this.InitializeLogging(false, false);
                            break;
                        }
                        if (type != LoggingInfo.LoggingType.Detailed) break;
                        this.InitializeLogging(SocketServer.getLogger().getIsErrorLogsEnabled(), false);
                        break;
                    }
                    case 2: {
                        error = SocketServer.getLogger().getIsErrorLogsEnabled();
                        detailed = SocketServer.getLogger().getIsDetailedLogsEnabled();
                        if (type == LoggingInfo.LoggingType.Error) {
                            error = true;
                            detailed = false;
                        } else if (type.getValue() == LoggingInfo.LoggingType.Detailed.getValue() | type.getValue() == (LoggingInfo.LoggingType.Error.getValue() | LoggingInfo.LoggingType.Detailed.getValue())) {
                            error = true;
                            detailed = true;
                        }
                        this.InitializeLogging(error, detailed);
                    }
                }
            }
        }
    }

    public void StartGCTimer(int dueTime, int period) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ClientNode> GetClientList(String cacheId) throws UnknownHostException {
        ArrayList<ClientNode> clients = new ArrayList<ClientNode>();
        HashMap hashMap = ConnectionManager.ConnectionTable;
        synchronized (hashMap) {
            for (Map.Entry pair : ConnectionManager.ConnectionTable.entrySet()) {
                ClientManager clientManager = pair.getValue() instanceof ClientManager ? pair.getValue() : null;
                if (clientManager.getIsDisposed() || clientManager.getCmdExecuter() == null || !clientManager.getCmdExecuter().getID().toLowerCase().equals(cacheId.toLowerCase())) continue;
                ClientNode client = new ClientNode();
                client.setAddress(new Address(clientManager.getClientSocket().getInetAddress().getHostAddress(), clientManager.getClientSocket().getPort()));
                client.setClientID(clientManager.getClientID());
                if (clientManager.IsDotNetClient) {
                    client.setClientContext(RtContextValue.NCACHE);
                } else {
                    client.setClientContext(RtContextValue.JVCACHE);
                }
                clients.add(client);
            }
        }
        return clients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ClientProcessStats> GetClientProcessStats(String cacheId) throws UnknownHostException {
        ArrayList<ClientProcessStats> clientProcessStats = new ArrayList<ClientProcessStats>();
        HashMap hashMap = ConnectionManager.ConnectionTable;
        synchronized (hashMap) {
            for (Map.Entry pair : ConnectionManager.ConnectionTable.entrySet()) {
                ClientManager clientManager = pair.getValue() instanceof ClientManager ? pair.getValue() : null;
                if (clientManager.getCmdExecuter() == null || !clientManager.getCmdExecuter().getID().toLowerCase().equals(cacheId.toLowerCase())) continue;
                Address address = new Address(clientManager.getClientSocket().getInetAddress().getHostAddress(), clientManager.getClientSocket().getPort());
                ClientProcessStats cpStats = new ClientProcessStats(clientManager.getClientID(), address, clientManager.getClientsBytesSent(), clientManager.getClientsBytesRecieved(), ConnectionManager.getServerIpAddress());
                clientProcessStats.add(cpStats);
            }
        }
        return clientProcessStats;
    }
}

