/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer;

import Alachisoft.NCache.Common.Event.NEventStart;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.LoggingInfo;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Common.Threading.ThreadPool;
import Alachisoft.NCache.Common.Util.ReaderWriterLock;
import Alachisoft.NCache.SocketServer.CallbackTasks.ICallbackTask;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.BridgeCommands.HeartBeat;
import Alachisoft.NCache.SocketServer.CommandManagerType;
import Alachisoft.NCache.SocketServer.EventTask.IEventTask;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.ICommandManager;
import Alachisoft.NCache.SocketServer.NCache;
import Alachisoft.NCache.SocketServer.SocketServer;
import Alachisoft.NCache.SocketServer.Util.HelperFxn;
import SocketServer.CommandManager;
import SocketServer.ManagementCommandManager;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tangible.RefObject;

public final class ConnectionManager
implements Runnable {
    public static final int cmdSizeHolderBytesCount = 10;
    public static final int valSizeHolderBytesCount = 10;
    public static final int totSizeHolderBytesCount = 20;
    public static final int pinnedBufferSize = 204800;
    public static final int waitIntervalHeartBeat = 30000;
    public static HashMap ConnectionTable = new HashMap(10);
    private static ReaderWriterLock _readerWriterLock = new ReaderWriterLock();
    private static String _serverIpAddress = "";
    private static int _serverPort = -1;
    private static LoggingInfo _clientLogginInfo = new LoggingInfo();
    private static LinkedList _callbackQueue = new LinkedList();
    private static Object _client_hearbeat_mutex = new Object();
    private int _maxClient = 100;
    private int _clientSendBufferSize = 0;
    private int _clientReceiveBufferSize = 0;
    private ICommandManager cmdManager;
    private Thread _callbacksThread = null;
    private ILogger _logger;
    private Selector socketSelector;
    private TrackAliveClient _trackAliveClient;
    private ServerSocketChannel _serverChannel;
    private Thread _mainThread;

    public static LinkedList getCallbackQueue() {
        return _callbackQueue;
    }

    public static Object getclient_hearbeat_mutex() {
        return _client_hearbeat_mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DisposeClient(ClientManager clientManager) {
        block10: {
            try {
                if (clientManager == null) break block10;
                if (clientManager._leftGracefully) {
                    if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                        SocketServer.getLogger().getNCacheLog().Error("ConnectionManager.ReceiveCallback", clientManager.toString() + " left gracefully");
                    }
                } else if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                    SocketServer.getLogger().getNCacheLog().Error("ConnectionManager.ReceiveCallback", "Connection lost with client (" + clientManager.toString() + ")");
                }
                if (clientManager.getClientID() != null) {
                    HashMap hashMap = ConnectionTable;
                    synchronized (hashMap) {
                        ConnectionTable.remove(clientManager.getClientID());
                    }
                }
                clientManager.dispose();
                clientManager = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void AssureSend(ClientManager clientManager, byte[] buffer) {
        ConnectionManager.AssureSend(clientManager, buffer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AssureSend(ClientManager clientManager, byte[] buffer, Object[] userPayLoad) {
        if (clientManager != null) {
            Object object = clientManager.getSendMutex();
            synchronized (object) {
                try {
                    int bytesCopied;
                    clientManager.MarkActivity();
                    int count = buffer.length;
                    int mainIndex = 0;
                    byte[] sendBuffer = clientManager.sendBuffer;
                    for (bytesCopied = 0; bytesCopied < buffer.length; bytesCopied += count) {
                        count = buffer.length - bytesCopied;
                        if (count > sendBuffer.length - mainIndex) {
                            count = sendBuffer.length - mainIndex;
                        }
                        System.arraycopy(buffer, bytesCopied, sendBuffer, mainIndex, count);
                        if ((mainIndex += count) < sendBuffer.length) continue;
                        ConnectionManager.AssureSend(clientManager, sendBuffer, sendBuffer.length);
                        mainIndex = 0;
                    }
                    if (userPayLoad != null && userPayLoad.length > 0) {
                        for (int i = 0; i < userPayLoad.length; ++i) {
                            Object tempVar = userPayLoad[i];
                            buffer = (byte[])(tempVar instanceof byte[] ? tempVar : null);
                            for (bytesCopied = 0; bytesCopied < buffer.length; bytesCopied += count) {
                                count = buffer.length - bytesCopied;
                                if (count > sendBuffer.length - mainIndex) {
                                    count = sendBuffer.length - mainIndex;
                                }
                                System.arraycopy(buffer, bytesCopied, sendBuffer, mainIndex, count);
                                if ((mainIndex += count) < sendBuffer.length) continue;
                                ConnectionManager.AssureSend(clientManager, sendBuffer, sendBuffer.length);
                                mainIndex = 0;
                            }
                            if (mainIndex < sendBuffer.length) continue;
                            ConnectionManager.AssureSend(clientManager, sendBuffer, sendBuffer.length);
                            mainIndex = 0;
                        }
                        if (mainIndex >= 0) {
                            ConnectionManager.AssureSend(clientManager, sendBuffer, mainIndex);
                            mainIndex = 0;
                        }
                    } else {
                        ConnectionManager.AssureSend(clientManager, sendBuffer, mainIndex);
                    }
                }
                catch (Exception se) {
                    ConnectionManager.DisposeClient(clientManager);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void AssureSend(ClientManager clientManager, byte[] buffer, int count) throws IOException {
        int bytesSent = 0;
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, 0, count);
        Object object = clientManager.getSendMutex();
        synchronized (object) {
            SocketChannel channel = clientManager.getSocketChannel();
            while (byteBuffer.hasRemaining()) {
                bytesSent = count - bytesSent;
                if (!channel.isConnected()) {
                    throw new IOException("Connection Manager - AssureSend: Channel not connected");
                }
                channel.write(byteBuffer);
                clientManager.AddToClientsBytesSent(bytesSent);
                if (!SocketServer.getIsServerCounterEnabled()) continue;
                SocketServer.getPerfStatsColl().incrementBytesSentPerSecStats(bytesSent);
                SocketServer.getPerfStatsColl().incrementByteSentPerSecStatsBy(bytesSent);
            }
        }
    }

    private static void AssureRecieve(ClientManager clientManager, RefObject<byte[]> buffer) {
        int bytesRecieved = 0;
        int totalBytesReceived = 0;
        do {
            try {
                bytesRecieved = clientManager.getClientSocket().getInputStream().read((byte[])buffer.argvalue, totalBytesReceived, ((byte[])buffer.argvalue).length - totalBytesReceived);
                totalBytesReceived += bytesRecieved;
                clientManager.AddToClientsBytesRecieved(bytesRecieved);
                if (!SocketServer.getIsServerCounterEnabled()) continue;
                SocketServer.getPerfStatsColl().incrementBytesReceivedPerSecStats(bytesRecieved);
                SocketServer.getPerfStatsColl().incrementByteReceivePerSecStatsBy(bytesRecieved);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (totalBytesReceived < ((byte[])buffer.argvalue).length && bytesRecieved > 0);
    }

    private static void AssureRecieve(ClientManager clientManager, RefObject<byte[]> buffer, long size) {
        int bytesRecieved = 0;
        int totalBytesReceived = 0;
        do {
            try {
                bytesRecieved = clientManager.getClientSocket().getInputStream().read((byte[])buffer.argvalue, totalBytesReceived, (int)(size - (long)totalBytesReceived));
                totalBytesReceived += bytesRecieved;
                clientManager.AddToClientsBytesRecieved(bytesRecieved);
                if (!SocketServer.getIsServerCounterEnabled()) continue;
                SocketServer.getPerfStatsColl().incrementBytesReceivedPerSecStats(bytesRecieved);
                SocketServer.getPerfStatsColl().incrementByteReceivePerSecStatsBy(bytesRecieved);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while ((long)totalBytesReceived < size && bytesRecieved > 0);
        if ((long)((byte[])buffer.argvalue).length != size) {
            byte[] bite = new byte[totalBytesReceived];
            System.arraycopy(buffer.argvalue, 0, bite, 0, totalBytesReceived);
            buffer.argvalue = bite;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SetClientLoggingInfo(LoggingInfo.LoggingType type, LoggingInfo.LogsStatus status) {
        LoggingInfo loggingInfo = _clientLogginInfo;
        synchronized (loggingInfo) {
            if (_clientLogginInfo.GetStatus(type) != status) {
                _clientLogginInfo.SetStatus(type, status);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggingInfo.LogsStatus GetClientLoggingInfo(LoggingInfo.LoggingType type) {
        LoggingInfo loggingInfo = _clientLogginInfo;
        synchronized (loggingInfo) {
            return _clientLogginInfo.GetStatus(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void UpdateClients() throws Exception {
        boolean errorOnly = false;
        boolean detailed = false;
        LoggingInfo loggingInfo = _clientLogginInfo;
        synchronized (loggingInfo) {
            errorOnly = ConnectionManager.GetClientLoggingInfo(LoggingInfo.LoggingType.Error) == LoggingInfo.LogsStatus.Enable;
            detailed = ConnectionManager.GetClientLoggingInfo(LoggingInfo.LoggingType.Detailed) == LoggingInfo.LogsStatus.Enable;
        }
        ConnectionManager.UpdateClients(errorOnly, detailed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void UpdateClients(boolean errorOnly, boolean detailed) throws Exception {
        Collection clients = null;
        HashMap hashMap = ConnectionTable;
        synchronized (hashMap) {
            clients = ConnectionTable.values();
        }
        for (Object obj : clients) {
            ICommandExecuter tempVar;
            NCache executor;
            ClientManager client = (ClientManager)(obj instanceof ClientManager ? obj : null);
            if (client == null || (executor = (NCache)((tempVar = client.getCmdExecuter()) instanceof NCache ? tempVar : null)) == null) continue;
            executor.OnLoggingInfoModified(errorOnly, detailed, client.getClientID());
        }
    }

    public static String getServerIpAddress() {
        return _serverIpAddress;
    }

    public static int getServerPort() {
        return _serverPort;
    }

    public void Start(InetAddress bindIP, int port, int sendBuffer, int receiveBuffer, ILogger logger, CommandManagerType cmdMgrType) throws Exception {
        String enablePerfCounters;
        this._logger = logger;
        this._clientSendBufferSize = sendBuffer;
        this._clientReceiveBufferSize = receiveBuffer;
        this.cmdManager = this.GetCommandManager(cmdMgrType);
        String maxPendingCon = ServicePropValues.Cache_MaxPendingConnections;
        if (maxPendingCon != null && !maxPendingCon.equals("")) {
            try {
                this._maxClient = Integer.parseInt(maxPendingCon);
            }
            catch (Exception e) {
                throw new Exception("Invalid value specified for NCache.MaxPendingConnections.");
            }
        }
        if ((enablePerfCounters = ServicePropValues.Cache_EnableServerCounters) != null && !enablePerfCounters.equals("")) {
            try {
                SocketServer.setIsServerCounterEnabled(Boolean.parseBoolean(enablePerfCounters));
            }
            catch (Exception e) {
                throw new Exception("Invalid value specified for NCache.EnableServerCounters.");
            }
        }
        if (bindIP == null) {
            try {
                bindIP = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (bindIP != null) {
                this.socketSelector = SelectorProvider.provider().openSelector();
                this._serverChannel = ServerSocketChannel.open();
                this._serverChannel.configureBlocking(false);
                InetSocketAddress isa = new InetSocketAddress(bindIP.getHostAddress(), port);
                this._serverChannel.socket().setReuseAddress(true);
                this._serverChannel.socket().bind(isa);
                this._serverChannel.socket().setReceiveBufferSize(51200);
                this._serverChannel.register(this.socketSelector, 16);
            }
        }
        catch (IOException se) {
            throw new Exception("The address " + bindIP + " specified for Server.BindToClientServerIP is not valid");
        }
        this._callbacksThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConnectionManager.this.CallbackThread();
                }
                catch (Exception exception) {
                    ConnectionManager.this._logger.Error(exception.getMessage());
                }
            }
        });
        this._callbacksThread.setDaemon(true);
        this._callbacksThread.start();
        _serverIpAddress = this._serverChannel.socket().getInetAddress().getHostAddress();
        _serverPort = this._serverChannel.socket().getLocalPort();
        this._mainThread = new Thread(this);
        this._mainThread.setPriority(5);
        this._mainThread.setDaemon(true);
        this._mainThread.start();
        if (LicenseManager.isEntCacheServer()) {
            this._trackAliveClient = new TrackAliveClient(this, ConnectionTable, 30000, this._logger);
            this._trackAliveClient.Start();
        }
    }

    public void Start(InetSocketAddress bindIP, int sendBuffer, int receiveBuffer) throws Exception {
        String enablePerfCounters;
        this._clientSendBufferSize = sendBuffer;
        this._clientReceiveBufferSize = receiveBuffer;
        String maxPendingCon = ServicePropValues.Cache_MaxPendingConnections;
        if (maxPendingCon != null && !maxPendingCon.equals("")) {
            try {
                this._maxClient = Integer.parseInt(maxPendingCon);
            }
            catch (Exception e) {
                throw new Exception("Invalid value specified for NCache.MaxPendingConnections.");
            }
        }
        if ((enablePerfCounters = ServicePropValues.Cache_EnableServerCounters) != null && !enablePerfCounters.equals("")) {
            try {
                SocketServer.setIsServerCounterEnabled(Boolean.parseBoolean(enablePerfCounters));
            }
            catch (Exception e) {
                throw new Exception("Invalid value specified for NCache.EnableServerCounters.");
            }
        }
        try {
            this.socketSelector = SelectorProvider.provider().openSelector();
            this._serverChannel = ServerSocketChannel.open();
            this._serverChannel.configureBlocking(false);
            this._serverChannel.socket().setReuseAddress(true);
            this._serverChannel.socket().bind(bindIP);
            this._serverChannel.socket().setReceiveBufferSize(51200);
            this._serverChannel.register(this.socketSelector, 16);
        }
        catch (IOException se) {
            throw new Exception("The address " + bindIP + " specified for Server.BindToClientServerIP is not valid");
        }
        this._callbacksThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConnectionManager.this.CallbackThread();
                }
                catch (Exception exception) {
                    ConnectionManager.this._logger.Error(exception.getMessage());
                }
            }
        });
        this._callbacksThread.setDaemon(true);
        this._callbacksThread.start();
        _serverIpAddress = this._serverChannel.socket().getInetAddress().getHostAddress();
        _serverPort = this._serverChannel.socket().getLocalPort();
        this._mainThread = new Thread(this);
        this._mainThread.setPriority(5);
        this._mainThread.setDaemon(true);
        this._mainThread.start();
        this._trackAliveClient = new TrackAliveClient(this, ConnectionTable, 30000, this._logger);
        this._trackAliveClient.Start();
    }

    public void Stop() throws IOException {
        this.DisposeServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runNIO() {
        while (true) {
            try {
                block7: while (true) {
                    countSelect = this.socketSelector.select();
                    ite = this.socketSelector.selectedKeys().iterator();
                    while (true) lbl-1000:
                    // 5 sources

                    {
                        if (!ite.hasNext()) continue block7;
                        key = ite.next();
                        try {
                            useSingleThread = true;
                            if (key.isValid() && key.isAcceptable()) {
                                serverSocketChannel = (ServerSocketChannel)key.channel();
                                this.acceptClient(serverSocketChannel);
                            }
                            if (!key.isValid() || !key.isReadable()) ** GOTO lbl-1000
                            client = (ClientManager)key.attachment();
                            this.processRequest(client);
                        }
                        finally {
                            ite.remove();
                            continue;
                        }
                        break;
                    }
                    break;
                }
            }
            catch (IOException var1_2) {
                continue;
            }
            catch (Exception var1_3) {
                continue;
            }
            ** GOTO lbl-1000
            break;
        }
    }

    private void acceptClient(ServerSocketChannel serverSocketChannel) throws ClosedChannelException, IOException {
        SocketChannel socketChannel = serverSocketChannel.accept();
        if (socketChannel != null) {
            Socket socket = socketChannel.socket();
            socket.setReceiveBufferSize(this._clientReceiveBufferSize);
            socket.setSendBufferSize(this._clientSendBufferSize);
            socket.setTcpNoDelay(true);
            socketChannel.configureBlocking(false);
            ClientManager client = new ClientManager(socketChannel, 20, 204800);
            client.addClientDisposedListner(new NEventStart(){

                public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                    ConnectionManager.this.OnClientDisposed((String)obj[1]);
                    return null;
                }
            }, null);
            if (SocketServer.getLogger().getIsDetailedLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Info("ConnectionManager.AcceptCallback", "accepted client : " + socket.getInetAddress().toString());
            }
            socketChannel.register(this.socketSelector, 1, client);
        }
    }

    private void processRequest(final ClientManager client) throws Exception {
        ByteBuffer lengthBuffer = null;
        String remoteAddresss = client.getSocketChannel().socket().getRemoteSocketAddress().toString();
        try {
            lengthBuffer = client.getLengthBuffer();
            if (client.getDataBuffer() == null) {
                if (!lengthBuffer.hasRemaining()) {
                    lengthBuffer.rewind();
                }
                if (!this.FillBuffer(client, lengthBuffer)) {
                    return;
                }
            }
        }
        catch (IOException ex) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("ConnectionManager.ReceiveCallback", client.toString() + " Error " + ex.toString());
            }
            ConnectionManager.DisposeClient(client);
            return;
        }
        client.MarkActivity();
        ByteBuffer messageBuffer = client.getDataBuffer();
        try {
            if (messageBuffer == null) {
                byte[] buffer = new byte[10];
                System.arraycopy(client.getLengthBuffer().array(), 20, buffer, 0, 10);
                int messageLength = HelperFxn.ToInt32(buffer, 0, 10, "Command");
                messageBuffer = ByteBuffer.allocate(messageLength);
                client.setDataBuffer(messageBuffer);
            }
            if (!this.FillBuffer(client, messageBuffer)) {
                return;
            }
            client.setDataBuffer(null);
            final byte[] commandBuffer = messageBuffer.array();
            ThreadPool.getInstance().executeTask(new Runnable(){

                @Override
                public void run() {
                    Object command = ConnectionManager.this.cmdManager.Deserialize(commandBuffer, ConnectionManager.this._maxClient);
                    try {
                        if (ServerMonitor.getMonitorActivity()) {
                            ServerMonitor.LogClientActivity((String)"ConMgr.RecvClbk", (String)("cmd_size :" + commandBuffer.length));
                        }
                        client.AddToClientsRequest(1L);
                        if (SocketServer.getIsServerCounterEnabled()) {
                            SocketServer.getPerfStatsColl().incrementRequestsPerSecStats(1L);
                        }
                        client.StartCommandExecution();
                        Date dte = new Date();
                        if (ServerMonitor.getMonitorActivity()) {
                            ServerMonitor.RegisterClient((String)client.getClientID(), (String)client.getClientSocketId());
                            ServerMonitor.StartClientActivity((String)client.getClientID());
                            ServerMonitor.LogClientActivity((String)"ConMgr.RecvClbk", (String)"enter");
                        }
                        ConnectionManager.this.cmdManager.ProcessCommand(client, command);
                    }
                    catch (Exception ex) {
                        if (ServerMonitor.getMonitorActivity()) {
                            ServerMonitor.LogClientActivity((String)"ConMgr.RecvClbk", (String)("Error :" + ex.toString()));
                        }
                        if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                            SocketServer.getLogger().getNCacheLog().Error("ConnectionManager.ReceiveCallback", client.toString() + command + " Error " + ex.toString());
                        }
                        ConnectionManager.DisposeClient(client);
                    }
                }
            });
        }
        catch (IOException ex) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("ConnectionManager.ReceiveCallback", client.toString() + " Error " + ex.toString());
            }
            ConnectionManager.DisposeClient(client);
            return;
        }
        catch (Exception ex) {
            ConnectionManager.DisposeClient(client);
        }
    }

    private boolean FillBuffer(ClientManager client, ByteBuffer buffer) throws IOException {
        SocketChannel channel = client.getSocketChannel();
        int runcount = 0;
        while (buffer.remaining() > 0) {
            if (!channel.isConnected()) {
                throw new IOException("ConnectionManager - Fill Buffer: Channel is not connected");
            }
            int byteRead = channel.read(buffer);
            if (runcount == 0 && byteRead < 0) {
                throw new IOException("ConnectionManager - Fill Buffer: Channel is not connected");
            }
            ++runcount;
            if (byteRead > 0) {
                client.AddToClientsBytesRecieved(byteRead);
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().incrementBytesReceivedPerSecStats(byteRead);
                    SocketServer.getPerfStatsColl().incrementByteReceivePerSecStatsBy(byteRead);
                }
            }
            if (byteRead > 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OnClientDisposed(String clientSocketId) {
        if (ConnectionTable != null && clientSocketId != null) {
            HashMap hashMap = ConnectionTable;
            synchronized (hashMap) {
                ConnectionTable.remove(clientSocketId);
            }
        }
    }

    private void AssureRecieve(ClientManager clientManager, RefObject<Object> command, RefObject<byte[]> value, RefObject<Long> tranSize) throws InvalidProtocolBufferException {
        value.argvalue = null;
        int commandSize = -1;
        try {
            commandSize = HelperFxn.ToInt32(clientManager.Buffer, 0, 10, "Command");
        }
        catch (Exception ex) {
            Logger.getLogger(ConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        tranSize.argvalue = (long)commandSize;
        byte[] buffer = clientManager.GetPinnedBuffer((Long)tranSize.argvalue);
        RefObject tempRef_buffer = new RefObject((Object)buffer);
        ConnectionManager.AssureRecieve(clientManager, (RefObject<byte[]>)tempRef_buffer, (Long)tranSize.argvalue);
        buffer = (byte[])tempRef_buffer.argvalue;
        command.argvalue = this.cmdManager.Deserialize(buffer, commandSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void CallbackThread() {
        Object returnVal = null;
        try {
            while (true) {
                LinkedList linkedList;
                if (ConnectionManager.getCallbackQueue().size() > 0) {
                    linkedList = ConnectionManager.getCallbackQueue();
                    // MONITORENTER : linkedList
                    returnVal = ConnectionManager.getCallbackQueue().poll();
                    if (SocketServer.getIsServerCounterEnabled()) {
                        SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                    }
                    // MONITOREXIT : linkedList
                    if (returnVal instanceof ICallbackTask) {
                        ((ICallbackTask)returnVal).Process();
                        continue;
                    }
                    if (!(returnVal instanceof IEventTask)) continue;
                    ((IEventTask)returnVal).Process();
                    continue;
                }
                linkedList = ConnectionManager.getCallbackQueue();
                // MONITORENTER : linkedList
                ConnectionManager.getCallbackQueue().wait();
                // MONITOREXIT : linkedList
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void StopListening() throws IOException {
        if (this._serverChannel != null) {
            this._serverChannel.close();
            this._serverChannel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DisposeServer() throws IOException {
        this.StopListening();
        if (this._callbacksThread != null && !this._callbacksThread.isAlive() && !this._callbacksThread.isInterrupted()) {
            this._callbacksThread.stop();
        }
        if (ConnectionTable != null) {
            HashMap hashMap = ConnectionTable;
            synchronized (hashMap) {
                Object tempVar = ConnectionTable.clone();
                HashMap cloneTable = (HashMap)(tempVar instanceof HashMap ? tempVar : null);
                for (Map.Entry pair : cloneTable.entrySet()) {
                    ((ClientManager)pair.getValue()).dispose();
                }
            }
            ConnectionTable = null;
        }
        if (LicenseManager.isEntCacheServer() && this._trackAliveClient != null) {
            this._trackAliveClient.Stop();
            this._trackAliveClient = null;
        }
        if (this._mainThread != null) {
            this._mainThread.stop();
        }
        ThreadPool.getInstance().Stop(true);
    }

    @Override
    public void run() {
        this.runNIO();
    }

    private ICommandManager GetCommandManager(CommandManagerType cmdMgrType) {
        ICommandManager cmdMgr;
        switch (cmdMgrType) {
            case NCacheClient: {
                cmdMgr = new CommandManager();
                break;
            }
            case NCacheManagement: {
                cmdMgr = new ManagementCommandManager();
                break;
            }
            default: {
                cmdMgr = new CommandManager();
            }
        }
        return cmdMgr;
    }

    public static class TrackAliveClient {
        private ConnectionManager enclosingInstance;
        private HashMap connectionTable;
        private int interval = 30000;
        private HashMap idleConnections = new HashMap();
        private Thread thread;
        private ILogger logger;

        public TrackAliveClient(ConnectionManager commandManager, HashMap connectionsTable, int waitInterval, ILogger loger) {
            this.enclosingInstance = commandManager;
            this.connectionTable = connectionsTable;
            this.interval = waitInterval;
            this.logger = loger;
        }

        public final void Start() {
            if (this.thread == null) {
                this.thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        this.Run();
                    }
                });
                this.thread.setName("ConnectionManager.TrackAliveClient");
                this.thread.setDaemon(true);
                this.thread.start();
                if (SocketServer.getLogger().getIsDetailedLogsEnabled()) {
                    SocketServer.getLogger().getNCacheLog().Info("ConnectionManager.TrackAliveClient.Start", "ConnectionManager.TrackAliveClient is successfully started.");
                }
            }
        }

        public final void Stop() {
            if (this.thread != null) {
                if (SocketServer.getLogger().getNCacheLog() != null) {
                    SocketServer.getLogger().getNCacheLog().Flush();
                }
                this.thread.stop();
                this.thread = null;
                if (SocketServer.getLogger().getIsDetailedLogsEnabled()) {
                    SocketServer.getLogger().getNCacheLog().Info("ConnectionManager.TrackAliveClient.Stop", "ConnectionManager.TrackAliveClient is stopped Successfully.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void Run() {
            block19: {
                try {
                    Thread.sleep(this.interval);
                    while (this.thread != null) {
                        block18: {
                            try {
                                ArrayList idleClients = this.GetIdleClients(this.connectionTable);
                                if (idleClients.size() > 0) {
                                    HashMap hashMap = this.idleConnections;
                                    synchronized (hashMap) {
                                        for (int i = 0; i < idleClients.size(); ++i) {
                                            ClientManager clientManager = idleClients.get(i) instanceof ClientManager ? idleClients.get(i) : null;
                                            String clientID = clientManager.getClientID();
                                            LinkedList linkedList = ConnectionManager.getCallbackQueue();
                                            synchronized (linkedList) {
                                                ConnectionManager.getCallbackQueue().offer(new HeartBeat(clientID));
                                                if (SocketServer.getIsServerCounterEnabled()) {
                                                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                                                }
                                                ConnectionManager.getCallbackQueue().notify();
                                                if (SocketServer.getLogger().getIsDetailedLogsEnabled()) {
                                                    SocketServer.getLogger().getNCacheLog().Info("ConnectionManager.TrackAliveClient.Run", "Heart Beat sent to client " + clientManager.getClientID());
                                                }
                                                continue;
                                            }
                                        }
                                    }
                                }
                                idleClients.clear();
                            }
                            catch (Exception e) {
                                if (!SocketServer.getLogger().getIsErrorLogsEnabled()) break block18;
                                SocketServer.getLogger().getNCacheLog().Error("ConnectionManager.TrackAliveClient.Run", e.toString());
                            }
                        }
                        Thread.sleep(this.interval);
                    }
                }
                catch (InterruptedException e4) {
                    if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                        SocketServer.getLogger().getNCacheLog().Error("ConnectionManager.TrackAliveClient.Run", "bridge connection manager heart beat stopped");
                    }
                }
                catch (Exception e) {
                    if (!SocketServer.getLogger().getIsErrorLogsEnabled()) break block19;
                    SocketServer.getLogger().getNCacheLog().Error("ConnectionManager.TrackAliveClient.Run", "bridge connection manager heart beat stopped. Error" + e.toString());
                }
            }
            if (SocketServer.getLogger().getIsDetailedLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Info("ConnectionManager.TrackAliveClient.Run", "exiting thread");
            }
        }

        private ArrayList GetIdleClients(HashMap connectionTable) {
            ArrayList<ClientManager> idleClients = new ArrayList<ClientManager>();
            for (Object id : connectionTable.keySet()) {
                ClientManager cm = connectionTable.get(id.toString()) instanceof ClientManager ? connectionTable.get(id) : null;
                if (cm == null || !cm.getIsIdle() || !cm.getIsBridgeSourceClient()) continue;
                idleClients.add(cm);
            }
            return idleClients;
        }
    }
}

