/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.TagComparisonType;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import Alachisoft.NCache.SocketServer.SocketServer;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.RemoveByTagCommandProtocol;
import com.alachisoft.ncache.common.protobuf.RemoveByTagResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;

public class RemoveByTagCommand
extends CommandBase {
    private OperationResult _getResult = OperationResult.Success;

    @Override
    public OperationResult getOperationResult() {
        return this._getResult;
    }

    @Override
    public boolean getCanHaveLargedata() {
        return true;
    }

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        Object data = null;
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (IllegalArgumentException arEx) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("GetCommand", "command: " + command + " Error" + arEx);
            }
            this._getResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)arEx, (long)command.getRequestID()));
            }
            return;
        }
        catch (RuntimeException exc) {
            this._getResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        try {
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
            operationContext.Add(OperationContextFieldName.ClientLastViewId, (Object)cmdInfo.ClientLastViewId);
            nCache.getCache().RemoveByTag(cmdInfo.Tags, cmdInfo.ComparisonType, operationContext);
            ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setRemoveTagResponse(RemoveByTagResponseProtocol.RemoveByTagResponse.newBuilder()).setRequestId(Long.parseLong(cmdInfo.RequestId)).setResponseType(ResponseProtocol.Response.Type.REMOVE_TAG).build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (Exception exc) {
            this._getResult = OperationResult.Failure;
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        RemoveByTagCommandProtocol.RemoveByTagCommand removeTagCommand = command.getRemoveByTagCommand();
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.Tags = removeTagCommand.getTagsList().toArray(new String[0]);
        cmdInfo.ComparisonType = TagComparisonType.forValue((int)removeTagCommand.getTagComparisonType());
        cmdInfo.ClientLastViewId = command.getClientLastViewId();
        return cmdInfo;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String[] Tags;
        public TagComparisonType ComparisonType = TagComparisonType.values()[0];
        public long ClientLastViewId;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Tags = this.Tags;
            varCopy.ComparisonType = this.ComparisonType;
            varCopy.ClientLastViewId = this.ClientLastViewId;
            return varCopy;
        }
    }
}

