/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Common.Enum.Time;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.RPCFramework.DotNetRPC.TargetObject;
import Alachisoft.NCache.Common.RPCFramework.IRPCTargetObject;
import Alachisoft.NCache.Common.RPCFramework.RPCService;
import Alachisoft.NCache.Management.MonitorServer;
import Alachisoft.NCache.SocketServer.CacheProvider;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.ManagementCommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.ManagementCommandProtocol;
import com.alachisoft.ncache.common.protobuf.ManagementResponseProtocol;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.google.protobuf.ByteString;
import java.io.FileWriter;
import java.io.IOException;

public class ManagementCommand
extends ManagementCommandBase {
    private void log(String text) {
    }

    public void print(String text) {
        try {
            String filename = "log.txt";
            FileWriter fw = new FileWriter(filename, true);
            text = (String)text + "\n";
            fw.write((String)text);
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void ExecuteCommand(ClientManager clientManager, ManagementCommandProtocol.ManagementCommand command) {
        Object result = null;
        try {
            if (LicenseManager.isExpress() && (command.getSource() == ManagementCommandProtocol.ManagementCommand.SourceType.MANAGER || command.getSource() == ManagementCommandProtocol.ManagementCommand.SourceType.MONITOR)) {
                throw new ManagementException("Not Supported For Express Edition.");
            }
            if (command.getObjectName().equals("CacheServer")) {
                String method = command.getMethodName();
                this.log(method);
                int overload = command.getOverload();
                ByteString args = command.getArguments();
                Object[] methodParameters = this.GetTargetMethodParameters(args.toByteArray());
                long bTime = System.nanoTime();
                result = CacheProvider.getManagementRPCService().InvokeMethodOnTarget(method, overload, methodParameters);
                double time = Time.toMilliSeconds((long)(System.nanoTime() - bTime), (Time)Time.nSEC);
                this.log("Time Taken by Command: " + method + " " + time);
            } else if (command.getObjectName().equals("MonitorServer")) {
                if (clientManager.getMonitorRPCService() == null) {
                    clientManager.setMonitorRPCService((RPCService<MonitorServer>)new RPCService((IRPCTargetObject)new TargetObject((Object)new MonitorServer())));
                }
                result = clientManager.getMonitorRPCService().InvokeMethodOnTarget(command.getMethodName(), command.getOverload(), this.GetTargetMethodParameters(command.getArguments().toByteArray()));
            }
            ManagementResponseProtocol.ManagementResponse.Builder response = ManagementResponseProtocol.ManagementResponse.newBuilder();
            response.setMethodName(command.getMethodName());
            response.setVersion(command.getCommandVersion());
            response.setRequestId(command.getRequestId());
            response.setReturnVal(ByteString.copyFrom((byte[])this.SerializeResponse(result)));
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ManagementResponseProtocol.ManagementResponse.Builder)response));
        }
        catch (Exception exc) {
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestId()));
        }
    }
}

