/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Management.CacheServer;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.ConnectionManager;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetOptimalServerCommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetRunningServersResponseProtocol;
import com.alachisoft.ncache.common.protobuf.KeyValuePairProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import java.util.HashMap;
import java.util.Map;

public class GetRunningServersCommand
extends CommandBase {
    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (Exception exc) {
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        Object cache = null;
        try {
            String server = ConnectionManager.getServerIpAddress();
            int port = CacheServer.getSocketServerPort();
            HashMap runningServers = new HashMap();
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            runningServers = nCache.getCache().GetRunningServers(server, Integer.valueOf(port));
            ResponseProtocol.Response.Builder resBuilder = ResponseProtocol.Response.newBuilder();
            GetRunningServersResponseProtocol.GetRunningServersResponse.Builder getRunningServerResponse = GetRunningServersResponseProtocol.GetRunningServersResponse.newBuilder();
            if (runningServers != null) {
                for (Object t : runningServers.entrySet()) {
                    Map.Entry entry = (Map.Entry)t;
                    KeyValuePairProtocol.KeyValuePair.Builder keyValue = KeyValuePairProtocol.KeyValuePair.newBuilder();
                    keyValue.setKey(entry.getKey().toString());
                    keyValue.setValue(entry.getValue().toString());
                    getRunningServerResponse.addKeyValuePair(keyValue.build());
                }
            }
            resBuilder.setGetRunningServer(getRunningServerResponse.build());
            resBuilder.setResponseType(ResponseProtocol.Response.Type.GET_RUNNING_SERVERS);
            resBuilder.setRequestId(command.getRequestID());
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)resBuilder.build()));
        }
        catch (Exception exc) {
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        GetOptimalServerCommandProtocol.GetOptimalServerCommand getOptimalServerCommand = command.getGetOptimalServerCommand();
        cmdInfo.CacheId = getOptimalServerCommand.getCacheId();
        cmdInfo.IsDotNetClient = getOptimalServerCommand.getIsDotnetClient();
        cmdInfo.Password = getOptimalServerCommand.getPwd();
        cmdInfo.PasswordBinary = getOptimalServerCommand.getBinaryPassword().toByteArray();
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.UserName = getOptimalServerCommand.getUserId();
        cmdInfo.UserNameBinary = getOptimalServerCommand.getBinaryUserId().toByteArray();
        return cmdInfo;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String CacheId;
        public String UserName;
        public String Password;
        public byte[] UserNameBinary;
        public byte[] PasswordBinary;
        public boolean IsDotNetClient;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.CacheId = this.CacheId;
            varCopy.UserName = this.UserName;
            varCopy.Password = this.Password;
            varCopy.UserNameBinary = this.UserNameBinary;
            varCopy.PasswordBinary = this.PasswordBinary;
            varCopy.IsDotNetClient = this.IsDotNetClient;
            return varCopy;
        }
    }
}

