/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Management.CacheServer;
import Alachisoft.NCache.SocketServer.CacheProvider;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.ConnectionManager;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetOptimalServerCommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetOptimalServerResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import tangible.RefObject;

public class GetOptimalServerCommand
extends CommandBase {
    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (Exception exc) {
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        Cache cache = null;
        try {
            String server = ConnectionManager.getServerIpAddress();
            int port = CacheServer.getSocketServerPort();
            cache = CacheProvider.getProvider().GetCacheInstanceIgnoreReplica(cmdInfo.CacheId, cmdInfo.UserNameBinary, cmdInfo.PasswordBinary);
            if (cache == null) {
                throw new Exception("Cache is not registered");
            }
            if (!cache.getIsRunning()) {
                throw new Exception("Cache is not running");
            }
            if (LicenseManager.isEntCacheServer() || LicenseManager.isProCacheServer()) {
                if (!cache.getCacheType().equals("mirror-server")) {
                    RefObject tempRef_server = new RefObject((Object)server);
                    RefObject tempRef_port = new RefObject((Object)port);
                    cache.GetLeastLoadedServer(tempRef_server, tempRef_port);
                    server = (String)tempRef_server.argvalue;
                    port = (Integer)tempRef_port.argvalue;
                } else if (!cache.getIsCoordinator()) {
                    RefObject tempRef_server2 = new RefObject((Object)server);
                    RefObject tempRef_port2 = new RefObject((Object)port);
                    cache.GetActiveServer(tempRef_server2, tempRef_port2);
                    server = (String)tempRef_server2.argvalue;
                    port = (Integer)tempRef_port2.argvalue;
                }
            }
            ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setGetOptimalServer(GetOptimalServerResponseProtocol.GetOptimalServerResponse.newBuilder().setServer(server).setPort(port)).setRequestId(Long.parseLong(cmdInfo.RequestId)).setResponseType(ResponseProtocol.Response.Type.GET_OPTIMAL_SERVER).build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (IllegalArgumentException exc) {
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
        catch (SecurityException exc) {
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)((Object)exc), (long)command.getRequestID()));
        }
        catch (Exception exc) {
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        GetOptimalServerCommandProtocol.GetOptimalServerCommand getOptimalServerCommand = command.getGetOptimalServerCommand();
        cmdInfo.CacheId = getOptimalServerCommand.getCacheId();
        cmdInfo.IsDotNetClient = getOptimalServerCommand.getIsDotnetClient();
        cmdInfo.Password = getOptimalServerCommand.getPwd();
        cmdInfo.PasswordBinary = getOptimalServerCommand.getBinaryPassword().toByteArray();
        cmdInfo.RequestId = Long.valueOf(command.getRequestID()).toString();
        cmdInfo.UserName = getOptimalServerCommand.getUserId();
        cmdInfo.UserNameBinary = getOptimalServerCommand.getBinaryUserId().toByteArray();
        return cmdInfo;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String CacheId;
        public String UserName;
        public String Password;
        public byte[] UserNameBinary;
        public byte[] PasswordBinary;
        public boolean IsDotNetClient;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.CacheId = this.CacheId;
            varCopy.UserName = this.UserName;
            varCopy.Password = this.Password;
            varCopy.UserNameBinary = this.UserNameBinary;
            varCopy.PasswordBinary = this.PasswordBinary;
            varCopy.IsDotNetClient = this.IsDotNetClient;
            return varCopy;
        }
    }
}

