/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.TagComparisonType;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import Alachisoft.NCache.SocketServer.SocketServer;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetKeysByTagCommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetKeysByTagResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import java.util.ArrayList;

public class GetKeysByTagCommand
extends CommandBase {
    private OperationResult _getResult = OperationResult.Success;

    @Override
    public OperationResult getOperationResult() {
        return this._getResult;
    }

    @Override
    public boolean getCanHaveLargedata() {
        return true;
    }

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        Object data = null;
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (IllegalArgumentException arEx) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("GetCommand", "command: " + command + " Error" + arEx);
            }
            this._getResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)arEx, (long)command.getRequestID()));
            }
            return;
        }
        catch (Exception exc) {
            this._getResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        try {
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            ArrayList result = null;
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.ClientLastViewId, (Object)cmdInfo.ClientLastViewId);
            result = nCache.getCache().GetKeysByTag(cmdInfo.Tags, cmdInfo.ComparisonType, operationContext);
            GetKeysByTagResponseProtocol.GetKeysByTagResponse.Builder getTagResponse = GetKeysByTagResponseProtocol.GetKeysByTagResponse.newBuilder();
            if (result != null) {
                getTagResponse.addAllKeys((Iterable)result);
            }
            ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setGetKeysByTagResponse(getTagResponse.build()).setRequestId(Long.parseLong(cmdInfo.RequestId)).setResponseType(ResponseProtocol.Response.Type.GET_KEYS_TAG).build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (Exception exc) {
            this._getResult = OperationResult.Failure;
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        GetKeysByTagCommandProtocol.GetKeysByTagCommand getTagCommand = command.getGetKeysByTagCommand();
        cmdInfo.ComparisonType = TagComparisonType.forValue((int)getTagCommand.getTagComparisonType());
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.Tags = getTagCommand.getTagsList().toArray(new String[0]);
        cmdInfo.ClientLastViewId = command.getClientLastViewId();
        return cmdInfo;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String[] Tags;
        public TagComparisonType ComparisonType = TagComparisonType.values()[0];
        public long ClientLastViewId;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Tags = this.Tags;
            varCopy.ComparisonType = this.ComparisonType;
            varCopy.ClientLastViewId = this.ClientLastViewId;
            return varCopy;
        }
    }
}

