/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.DeleteCommandProtocol;
import com.alachisoft.ncache.common.protobuf.DeleteResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import tangible.DotNetToJavaStringHelper;

public class DeleteCommand
extends CommandBase {
    private OperationResult _removeResult = OperationResult.Success;

    @Override
    public OperationResult getOperationResult() {
        return this._removeResult;
    }

    @Override
    public boolean getCanHaveLargedata() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"RemCmd.Exec", (String)"cmd parsed");
            }
        }
        catch (Exception exc) {
            this._removeResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        ICommandExecuter tempVar = clientManager.getCmdExecuter();
        NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
        if (!cmdInfo.DoAsync) {
            try {
                CallbackEntry cbEntry = null;
                if (cmdInfo.DsItemRemovedId != -1) {
                    cbEntry = new CallbackEntry(clientManager.getClientID(), -1, null, -1, -1, -1, cmdInfo.DsItemRemovedId, cmdInfo.FlagMap, EventDataFilter.None, EventDataFilter.None);
                }
                OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
                nCache.getCache().Delete(cmdInfo.Key, cmdInfo.FlagMap, cbEntry, cmdInfo.LockId, cmdInfo.Version, cmdInfo.LockAccessTypes, cmdInfo.ProviderName, operationContext);
                ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setDeleteResponse(DeleteResponseProtocol.DeleteResponse.newBuilder()).setResponseType(ResponseProtocol.Response.Type.DELETE).setRequestId(Long.parseLong(cmdInfo.RequestId)).build();
                ResponseProtocol.Response.Builder resBuilder = ResponseProtocol.Response.newBuilder();
                this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
            }
            catch (Exception exc) {
                this._removeResult = OperationResult.Failure;
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            finally {
                if (ServerMonitor.getMonitorActivity()) {
                    ServerMonitor.LogClientActivity((String)"RemCmd.Exec", (String)"cmd executed on cache");
                }
            }
        } else {
            Object[] package_Renamed = null;
            package_Renamed = !cmdInfo.RequestId.equals("-1") || cmdInfo.DsItemRemovedId != -1 ? new Object[]{cmdInfo.Key, cmdInfo.FlagMap, new CallbackEntry(clientManager.getClientID(), Integer.parseInt(cmdInfo.RequestId), null, -1, -1, (short)(cmdInfo.RequestId.equals("-1") ? -1 : 0), cmdInfo.DsItemRemovedId, cmdInfo.FlagMap, EventDataFilter.None, EventDataFilter.None)} : new Object[]{cmdInfo.Key, cmdInfo.FlagMap, null, cmdInfo.ProviderName};
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
            nCache.getCache().RemoveAsync((Object)package_Renamed, operationContext);
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        DeleteCommandProtocol.DeleteCommand removeCommand = command.getDeleteCommand();
        cmdInfo.DoAsync = removeCommand.getIsAsync();
        cmdInfo.DsItemRemovedId = (short)removeCommand.getDatasourceItemRemovedCallbackId();
        cmdInfo.FlagMap = new BitSet((byte)removeCommand.getFlag());
        cmdInfo.Key = removeCommand.getKey();
        cmdInfo.LockAccessTypes = LockAccessType.forValue((int)removeCommand.getLockAccessType());
        cmdInfo.LockId = removeCommand.getLockId();
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.Version = removeCommand.getVersion();
        cmdInfo.ProviderName = !DotNetToJavaStringHelper.isNullOrEmpty((String)removeCommand.getProviderName()) ? removeCommand.getProviderName() : null;
        return cmdInfo;
    }

    protected static final class CommandInfo {
        public boolean DoAsync;
        public String RequestId;
        public String Key;
        public BitSet FlagMap;
        public short DsItemRemovedId;
        public Object LockId;
        public long Version;
        public String ProviderName;
        public LockAccessType LockAccessTypes = LockAccessType.values()[0];

        protected CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.DoAsync = this.DoAsync;
            varCopy.RequestId = this.RequestId;
            varCopy.Key = this.Key;
            varCopy.FlagMap = this.FlagMap;
            varCopy.DsItemRemovedId = this.DsItemRemovedId;
            varCopy.LockId = this.LockId;
            varCopy.Version = this.Version;
            varCopy.ProviderName = this.ProviderName;
            varCopy.LockAccessTypes = this.LockAccessTypes;
            return varCopy;
        }
    }
}

