/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.Command.ResponseBuilders.BulkRemoveResponseBuilder;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.BulkRemoveCommandProtocol;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import java.util.ArrayList;
import java.util.HashMap;
import tangible.DotNetToJavaStringHelper;

public class BulkRemoveCommand
extends CommandBase {
    private OperationResult _removeBulkResult = OperationResult.Success;

    @Override
    public OperationResult getOperationResult() {
        return this._removeBulkResult;
    }

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (Exception exc) {
            this._removeBulkResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        Object data = null;
        try {
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            CallbackEntry cbEnrty = null;
            if (cmdInfo.DsItemsRemovedId != -1) {
                cbEnrty = new CallbackEntry(clientManager.getClientID(), -1, null, -1, -1, -1, cmdInfo.DsItemsRemovedId, cmdInfo.FlagMap, EventDataFilter.None, EventDataFilter.None);
            }
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
            operationContext.Add(OperationContextFieldName.ClientLastViewId, (Object)cmdInfo.ClientLastViewId);
            HashMap removeResult = (HashMap)nCache.getCache().Remove(cmdInfo.Keys, cmdInfo.FlagMap, cbEnrty, cmdInfo.ProviderName, operationContext);
            BulkRemoveResponseBuilder.BuildResponse(removeResult, cmdInfo.CommandVersion, cmdInfo.RequestId, this._serializedResponsePackets);
        }
        catch (Exception exc) {
            this._removeBulkResult = OperationResult.Failure;
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        BulkRemoveCommandProtocol.BulkRemoveCommand bulkRemoveCommand = command.getBulkRemoveCommand();
        cmdInfo.Keys = new ArrayList(bulkRemoveCommand.getKeysList()).toArray(new Object[0]);
        cmdInfo.DsItemsRemovedId = (short)bulkRemoveCommand.getDatasourceItemRemovedCallbackId();
        cmdInfo.FlagMap = new BitSet((byte)bulkRemoveCommand.getFlag());
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.ProviderName = !DotNetToJavaStringHelper.isNullOrEmpty((String)bulkRemoveCommand.getProviderName()) ? bulkRemoveCommand.getProviderName() : null;
        cmdInfo.ClientLastViewId = command.getClientLastViewId();
        cmdInfo.CommandVersion = command.getCommandVersion();
        return cmdInfo;
    }

    protected static final class CommandInfo {
        public String RequestId;
        public Object[] Keys;
        public BitSet FlagMap;
        public short DsItemsRemovedId;
        public String ProviderName;
        public long ClientLastViewId;
        public int CommandVersion;

        protected CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Keys = this.Keys;
            varCopy.FlagMap = this.FlagMap;
            varCopy.DsItemsRemovedId = this.DsItemsRemovedId;
            varCopy.ProviderName = this.ProviderName;
            varCopy.ClientLastViewId = this.ClientLastViewId;
            varCopy.CommandVersion = this.CommandVersion;
            return varCopy;
        }
    }
}

