/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import Alachisoft.NCache.SocketServer.Util.KeyPackageBuilder;
import SocketServer.Command.BulkAddAndInsertCommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.BulkInsertResponseProtocol;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.KeyExceptionPackageResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import java.util.HashMap;
import tangible.DotNetToJavaStringHelper;

public class BulkInsertCommand
extends BulkAddAndInsertCommandBase {
    private OperationResult _insertBulkResult = OperationResult.Success;

    @Override
    public OperationResult getOperationResult() {
        return this._insertBulkResult;
    }

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) throws Exception {
        BulkAddAndInsertCommandBase.CommandInfo cmdInfo = new BulkAddAndInsertCommandBase.CommandInfo();
        this.setClientId(clientManager.getClientID());
        ICommandExecuter tempVar = clientManager.getCmdExecuter();
        NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
        try {
            this.serailizationContext = nCache.getCacheId();
            cmdInfo = super.ParseCommand(command, clientManager, this.serailizationContext);
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"BulkInsCmd.Exec", (String)"cmd parsed");
            }
        }
        catch (Exception exc) {
            this._insertBulkResult = OperationResult.Failure;
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            return;
        }
        Object dataPackage = null;
        try {
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
            operationContext.Add(OperationContextFieldName.ClientLastViewId, (Object)cmdInfo.ClientLastViewId);
            if (!DotNetToJavaStringHelper.isNullOrEmpty((String)cmdInfo.IntendedRecipient)) {
                operationContext.Add(OperationContextFieldName.IntendedRecipient, (Object)cmdInfo.IntendedRecipient);
            }
            HashMap insertResult = (HashMap)nCache.getCache().Insert((Object[])cmdInfo.Keys, cmdInfo.Values, cmdInfo.CallbackEnteries, cmdInfo.ExpirationHint, cmdInfo.SyncDependencies, (EvictionHint[])cmdInfo.EvictionHint, cmdInfo.groupInfos, cmdInfo.QueryInfo, cmdInfo.Flags, cmdInfo.ProviderName, null, operationContext);
            KeyExceptionPackageResponseProtocol.KeyExceptionPackageResponse.Builder keyExc = KeyExceptionPackageResponseProtocol.KeyExceptionPackageResponse.newBuilder();
            KeyPackageBuilder.PackageKeysExceptions(insertResult, keyExc);
            BulkInsertResponseProtocol.BulkInsertResponse.Builder bulkInsertResponse = BulkInsertResponseProtocol.BulkInsertResponse.newBuilder().setKeyExceptionPackage(KeyExceptionPackageResponseProtocol.KeyExceptionPackageResponse.newBuilder());
            bulkInsertResponse.setKeyExceptionPackage(keyExc);
            ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setBulkInsert(bulkInsertResponse.build()).setRequestId(Long.parseLong(cmdInfo.RequestId)).setResponseType(ResponseProtocol.Response.Type.INSERT_BULK).setIntendedRecipient(cmdInfo.IntendedRecipient).build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (Exception exc) {
            this._insertBulkResult = OperationResult.Failure;
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"BulkInsCmd.Exec", (String)"cmd executed on cache");
        }
    }
}

