/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Persistence;

import Alachisoft.NCache.Caching.CallbackInfo;
import Alachisoft.NCache.Caching.EventStatus;
import Alachisoft.NCache.Common.DataStructures.SlidingIndex;
import Alachisoft.NCache.Persistence.Event;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class PersistenceManager {
    private SlidingIndex<Event> _index = new SlidingIndex(30);
    private Date _startTime = new Date(0L);
    private Date _finalTime = new Date(0L);

    public PersistenceManager(int perInterval) {
        this._index = new SlidingIndex(perInterval);
        this._startTime = new Date();
    }

    public final boolean HasCompleteData() throws IllegalArgumentException {
        this._finalTime = new Date();
        TimeSpan timeElapsed = TimeSpan.subtract((Date)this._startTime, (Date)this._finalTime);
        return timeElapsed.getTotalSeconds() >= (double)this._index.GetInterval();
    }

    public final void AddToPersistedEvent(Event evt) {
        if (evt != null) {
            this._index.AddToIndex((Object)evt);
        }
    }

    public final ArrayList<Event> GetFilteredEventsList(String clientID, HashMap events, EventStatus registeredEventStatus) {
        Iterator en = this._index.GetCurrentData();
        ArrayList<Event> filteredEvents = new ArrayList<Event>();
        block8: while (en.hasNext()) {
            Event evt = (Event)en.next();
            if (events.containsKey(evt.getPersistedEventId())) continue;
            switch (evt.getPersistedEventId().getEventType()) {
                case CACHE_CLEARED_EVENT: {
                    if (!registeredEventStatus.getIsCacheClearedEvent()) break;
                    filteredEvents.add(evt);
                    break;
                }
                case ITEM_REMOVED_EVENT: {
                    if (!registeredEventStatus.getIsItemRemovedEvent()) break;
                    filteredEvents.add(evt);
                    break;
                }
                case ITEM_ADDED_EVENT: {
                    if (!registeredEventStatus.getIsItemAddedEvent()) break;
                    filteredEvents.add(evt);
                    break;
                }
                case ITEM_UPDATED_EVENT: {
                    if (!registeredEventStatus.getIsItemUpdatedEvent()) break;
                    filteredEvents.add(evt);
                    break;
                }
                case ITEM_REMOVED_CALLBACK: 
                case ITEM_UPDATED_CALLBACK: {
                    for (CallbackInfo cbInfo : evt.getPersistedEventInfo().getCallBackInfoList()) {
                        if (cbInfo == null || cbInfo.getClient() == null || !cbInfo.getClient().equals(clientID) || filteredEvents.contains(evt)) continue;
                        filteredEvents.add(evt);
                    }
                    continue block8;
                }
                case CQ_CALLBACK: {
                    for (String clientId : evt.getPersistedEventInfo().getClientIds()) {
                        if (clientId == null || !clientId.equals(clientID) || filteredEvents.contains(evt)) continue;
                        filteredEvents.add(evt);
                    }
                    break;
                }
            }
        }
        return filteredEvents;
    }

    public final void dispose() {
        this._index = null;
    }
}

