/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config;

import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import Alachisoft.NCache.Config.ConfigReader;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.Dom.ConfigConverter;
import Alachisoft.NCache.Config.NewDom.DomHelper;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tangible.RefObject;

public class XmlConfigReader
extends ConfigReader {
    private static final char[] _trimChars = new char[]{' ', '\t', '\r', '\n', '\'', '\"'};
    private String _cacheId = "";
    private String _configFileName;
    private String _configSection;

    public XmlConfigReader(String configFileName, String configSection) {
        this._configFileName = configFileName;
        this._configSection = configSection;
    }

    private static CacheServerConfig[] LoadConfig(String fileName) throws ConfigurationException, Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder(fileName);
        try {
            builder.RegisterRootConfigurationObject(Alachisoft.NCache.Config.NewDom.CacheServerConfig.class);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.getMessage(), (Throwable)exception);
        }
        try {
            builder.ReadConfiguration();
        }
        catch (Exception exc) {
            throw new ConfigurationException(exc.getMessage(), exc.getCause());
        }
        Alachisoft.NCache.Config.NewDom.CacheServerConfig[] caches = new Alachisoft.NCache.Config.NewDom.CacheServerConfig[builder.getConfiguration().length];
        System.arraycopy(builder.getConfiguration(), 0, caches, 0, builder.getConfiguration().length);
        return XmlConfigReader.convertToOldDom(caches);
    }

    private static CacheServerConfig[] convertToOldDom(Alachisoft.NCache.Config.NewDom.CacheServerConfig[] newCacheConfigsList) throws Exception {
        CacheServerConfig[] oldCacheConfigsList = new CacheServerConfig[newCacheConfigsList.length];
        for (int index = 0; index < newCacheConfigsList.length; ++index) {
            oldCacheConfigsList[index] = DomHelper.convertToOldDom(newCacheConfigsList[index]);
        }
        return oldCacheConfigsList;
    }

    private static void LoadConfig(String fileName, RefObject<HashMap> properties) throws ConfigurationException, Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder(fileName);
        try {
            builder.RegisterRootConfigurationObject(Alachisoft.NCache.Config.NewDom.CacheServerConfig.class);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.getMessage(), (Throwable)exception);
        }
        try {
            builder.ReadConfiguration();
        }
        catch (Exception exc) {
            throw new ConfigurationException(exc.getMessage(), exc.getCause());
        }
        Alachisoft.NCache.Config.NewDom.CacheServerConfig[] caches = new Alachisoft.NCache.Config.NewDom.CacheServerConfig[builder.getConfiguration().length];
        System.arraycopy(builder.getConfiguration(), 0, caches, 0, builder.getConfiguration().length);
        properties.argvalue = ConfigConverter.ToHashMap(XmlConfigReader.convertToOldDom(caches));
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getElementsByTagName(sTag).item(0).getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue();
    }

    public final String getConfigFileName() {
        return this._configFileName;
    }

    public final String getConfigSection() {
        return this._configSection;
    }

    @Override
    public HashMap getProperties() {
        try {
            return this.GetProperties(this._configFileName, this._configSection);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final ArrayList getPropertiesList() throws ConfigurationException {
        return this.GetAllProperties(this._configFileName, this._configSection);
    }

    public final String ToPropertiesString() {
        return ConfigReader.ToPropertiesString(this.getProperties());
    }

    protected final Hashtable GetAttributesOfNode(Node navigator) {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        for (int i = 0; i < navigator.getAttributes().getLength(); ++i) {
            attributes.put(navigator.getAttributes().item(i).getNodeName(), navigator.getAttributes().item(i).getNodeValue());
        }
        return attributes;
    }

    protected Hashtable BuildHashtable(Hashtable properties, Node navigator) {
        String name = navigator.getNodeName().toLowerCase();
        NodeList childNavigator = navigator.getChildNodes();
        if (childNavigator.getLength() <= 0 && navigator.getNodeType() == 1) {
            properties.put(name, navigator.getNodeValue().trim());
        }
        for (int i = 0; i < childNavigator.getLength(); ++i) {
            Hashtable attributes = this.GetAttributesOfNode(childNavigator.item(i));
            Hashtable subproperties = this.BuildHashtable(new Hashtable(), childNavigator.item(0));
            if (attributes.containsKey("id")) {
                String id = attributes.get("id").toString();
                subproperties.put("id", id);
                subproperties.put("type", name);
                name = id.toLowerCase();
            }
            properties.put(name, subproperties);
        }
        return properties;
    }

    protected Hashtable BuildHashtable2(Hashtable properties, Node navigator) {
        int count = 0;
        do {
            String name = navigator.getNodeName().toLowerCase();
            NodeList childNavigator = navigator.getChildNodes();
            Hashtable attributes = this.GetAttributesOfNode(childNavigator.item(0));
            Hashtable subprops = new Hashtable();
            for (Map.Entry pair : attributes.entrySet()) {
                subprops.put(pair.getKey(), pair.getValue());
            }
            if (attributes.containsKey("id")) {
                String id = attributes.get("id").toString();
                subprops.put("type", name);
                if (!id.equals("internal-cache")) {
                    this._cacheId = id;
                }
                name = id.toLowerCase();
            }
            if (childNavigator.getLength() > count) {
                Hashtable subproperties = this.BuildHashtable2(subprops, childNavigator.item(++count));
                if (name.toLowerCase().equals("cache")) {
                    subproperties.put("class", this._cacheId);
                    subproperties.put("name", this._cacheId);
                }
                if (name.equals("")) continue;
                properties.put(name, subproperties);
                continue;
            }
            if (name.equals("")) continue;
            properties.put(name, subprops);
        } while (navigator.hasAttributes());
        navigator = navigator.getParentNode();
        return properties;
    }

    public final HashMap GetProperties(String fileName, String configSection) throws ConfigurationException {
        HashMap properties = new HashMap();
        try {
            RefObject tempRef_properties = new RefObject(properties);
            XmlConfigReader.LoadConfig(fileName, (RefObject<HashMap>)tempRef_properties);
            properties = (HashMap)tempRef_properties.argvalue;
            return (HashMap)properties.get(configSection);
        }
        catch (Exception e) {
            throw new ConfigurationException("Specified config section '" + configSection + "' not found in file '" + fileName + "'. If it is a cache, it must be registered properly on this machine. --- " + e.toString());
        }
    }

    public final Hashtable GetProperties(String fileName, String configSection, String partId) throws ConfigurationException {
        HashMap properties = new HashMap();
        try {
            RefObject tempRef_properties = new RefObject(properties);
            XmlConfigReader.LoadConfig(fileName, (RefObject<HashMap>)tempRef_properties);
            properties = (HashMap)tempRef_properties.argvalue;
            return (Hashtable)properties.get(configSection);
        }
        catch (Exception e) {
            throw new ConfigurationException("Specified config section '" + configSection + "' not found in file '" + fileName + "'. If it is a cache, it must be registered properly on this machine. --- " + e.toString());
        }
    }

    public final Hashtable GetProperties2(String fileName, String configSection, String partId) throws ConfigurationException {
        Hashtable properties = new Hashtable();
        try {
            File fXmlFile = new File("c:\\file.xml");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            Node i = (Node)((Object)doc.getElementsByTagName("/configuration/cache-config"));
            while (i.hasChildNodes()) {
                Element element;
                String name;
                if (i.getNodeType() != 1 || (name = XmlConfigReader.getTagValue("name", element = (Element)i).toLowerCase()).compareTo(configSection.toLowerCase()) != 0 || !i.hasChildNodes()) continue;
                Hashtable<String, String> section = new Hashtable<String, String>();
                this.BuildHashtable2(section, i.getNextSibling());
                section.put("name", XmlConfigReader.getTagValue("name", element));
                section.put("inproc", XmlConfigReader.getTagValue("inproc", element));
                properties.put(XmlConfigReader.getTagValue("name", element).toLowerCase(), section);
            }
            return properties;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error occured while reading configuration", (Throwable)e);
        }
    }

    public final CacheServerConfig GetConfigDom() throws ConfigurationException {
        try {
            CacheServerConfig[] configs = XmlConfigReader.LoadConfig(this._configFileName);
            CacheServerConfig configDom = null;
            if (configs != null) {
                for (CacheServerConfig config : configs) {
                    if (config.getName() == null || !config.getName().toLowerCase().equals(this._configSection.toLowerCase())) continue;
                    configDom = config;
                    break;
                }
            }
            if (configDom != null) {
                return configDom;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Error occured while reading configuration", (Throwable)e);
        }
        throw new ConfigurationException("Specified config section '" + this._configSection + "' not found in file '" + this._configFileName + "'. If it is a cache, it must be registered properly on this machine.");
    }

    public final ArrayList GetAllProperties(String fileName, String configSection) throws ConfigurationException {
        ArrayList propsList = new ArrayList();
        HashMap properties = new HashMap();
        try {
            RefObject tempRef_properties = new RefObject(properties);
            XmlConfigReader.LoadConfig(fileName, (RefObject<HashMap>)tempRef_properties);
            properties = (HashMap)tempRef_properties.argvalue;
            if (properties.containsKey(configSection.toLowerCase())) {
                propsList.add(properties.get(configSection.toLowerCase()));
            }
            return propsList;
        }
        catch (Exception e) {
            throw new ConfigurationException("Specified config section '" + configSection + "' not found in file '" + fileName + "'. If it is a cache, it must be registered properly on this machine. --- " + e.toString());
        }
    }

    public final ArrayList GetAllProperties2(String fileName, String configSection) throws ConfigurationException {
        ArrayList<Hashtable> propsList = new ArrayList<Hashtable>();
        Hashtable properties = new Hashtable();
        try {
            File fXmlFile = new File("c:\\file.xml");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            Node i = (Node)((Object)doc.getElementsByTagName("/configuration/cache-config"));
            while (i.hasAttributes()) {
                String name;
                Element element;
                if (i.getNodeType() != 1 || XmlConfigReader.getTagValue("name", element = (Element)i) == null || (name = XmlConfigReader.getTagValue("name", element).toLowerCase()).compareTo(configSection.toLowerCase()) != 0 || !i.hasChildNodes()) continue;
                Hashtable<String, String> section = new Hashtable<String, String>();
                this.BuildHashtable2(section, i.getNextSibling());
                section.put("name", XmlConfigReader.getTagValue("name", element));
                section.put("inproc", XmlConfigReader.getTagValue("inproc", element));
                Object tempVar = section.clone();
                propsList.add((Hashtable)(tempVar instanceof Hashtable ? tempVar : null));
            }
            return propsList;
        }
        catch (Exception e) {
            throw new ConfigurationException("Specified config section '" + configSection + "' not found in file '" + fileName + "'. If it is a cache, it must be registered properly on this machine. --- " + e.toString());
        }
    }

    public final Map GetProperties(String fileName) throws ConfigurationException {
        HashMap properties = new HashMap();
        try {
            RefObject tempRef_properties = new RefObject(properties);
            XmlConfigReader.LoadConfig(fileName, (RefObject<HashMap>)tempRef_properties);
            properties = (HashMap)tempRef_properties.argvalue;
            return properties;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error occured while reading configuration", (Throwable)e);
        }
    }

    public final Map GetProperties2(String fileName) throws ConfigurationException {
        Hashtable properties = new Hashtable();
        try {
            File fXmlFile = new File("c:\\file.xml");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            Node i = (Node)((Object)doc.getElementsByTagName("/configuration/cache-config"));
            while (i.hasChildNodes()) {
                if (i.getNodeType() != 1) continue;
                Element element = (Element)i;
                if (!i.hasChildNodes()) continue;
                Hashtable<String, String> section = new Hashtable<String, String>();
                this.BuildHashtable2(section, i.getNextSibling());
                section.put("name", XmlConfigReader.getTagValue("name", element));
                section.put("inproc", XmlConfigReader.getTagValue("inproc", element));
                properties.put(XmlConfigReader.getTagValue("name", element).toLowerCase(), section);
            }
            return properties;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error occured while reading configuration", (Throwable)e);
        }
    }
}

