/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Util;

import Alachisoft.NCache.Caching.AutoExpiration.AggregateExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExtensibleDependency;
import Alachisoft.NCache.Caching.AutoExpiration.FileDependency;
import Alachisoft.NCache.Caching.AutoExpiration.FixedExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.IdleExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.KeyDependency;
import Alachisoft.NCache.Caching.AutoExpiration.OleDbCacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.OracleCacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.OracleCommandParams;
import Alachisoft.NCache.Caching.AutoExpiration.Sql7CacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.SqlYukonCacheDependency;
import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import Alachisoft.NCache.Common.Util.JavaClrTypeMapping;
import com.alachisoft.ncache.common.protobuf.DependencyProtocol;
import com.alachisoft.ncache.common.protobuf.NamedTagInfoProtocol;
import com.alachisoft.ncache.common.protobuf.QueryInfoProtocol;
import com.alachisoft.ncache.common.protobuf.TagInfoProtocol;
import com.alachisoft.ncache.runtime.dependencies.CommandType;
import com.alachisoft.ncache.runtime.dependencies.OracleCmdParamsType;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public final class ProtobufHelper {
    public static HashMap GetHashtableFromQueryInfoObj(QueryInfoProtocol.QueryInfo queryInfo) {
        HashMap queryInfoTable = new HashMap();
        if (queryInfo == null || queryInfo.getAttributesCount() < 1) {
            return null;
        }
        ArrayList<String> queryInfoCopy = new ArrayList<String>();
        for (int i = 0; i < queryInfo.getAttributesCount(); ++i) {
            queryInfoCopy.add(i, (String)queryInfo.getAttributesList().get(i));
        }
        int nullIndex = 0;
        String[] queryAttribValues = new String[queryInfo.getAttributesList().size()];
        queryInfo.getAttributesList().toArray(queryAttribValues);
        for (String attrib : queryAttribValues) {
            if (attrib.equals("NCNULL")) {
                queryInfoCopy.add(nullIndex, null);
                queryInfoCopy.remove(nullIndex + 1);
            }
            ++nullIndex;
        }
        ArrayList<String> attributes = new ArrayList<String>();
        for (String attrib : queryInfoCopy) {
            attributes.add(attrib);
        }
        queryInfoTable.put(queryInfo.getHandleId(), attributes);
        return queryInfoTable;
    }

    public static QueryInfoProtocol.QueryInfo GetQueryInfoObj(HashMap queryInfoDic) {
        if (queryInfoDic == null) {
            return null;
        }
        if (queryInfoDic.isEmpty()) {
            return null;
        }
        QueryInfoProtocol.QueryInfo.Builder queryInfo = QueryInfoProtocol.QueryInfo.newBuilder();
        for (Map.Entry pair : queryInfoDic.entrySet()) {
            queryInfo.setHandleId(((Integer)pair.getKey()).intValue());
            Iterator valuesEnum = ((ArrayList)pair.getValue()).iterator();
            while (valuesEnum.hasNext()) {
                String value = null;
                if (valuesEnum.next() != null) {
                    if (valuesEnum.next() instanceof Date) {
                        try {
                            value = new Long(new NCDateTime((Date)valuesEnum.next()).getTicks()).toString();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else {
                        value = valuesEnum.next().toString();
                    }
                } else {
                    value = "NCNULL";
                }
                queryInfo.getAttributesList().add(value);
            }
        }
        return queryInfo.build();
    }

    public static HashMap GetHashtableFromTagInfoObj(TagInfoProtocol.TagInfo tagInfo) {
        HashMap<String, Object> tagInfoTable = new HashMap<String, Object>();
        if (tagInfo == null || tagInfo.getTagsCount() < 1) {
            return null;
        }
        tagInfoTable.put("type", tagInfo.getType());
        tagInfoTable.put("tags-list", new ArrayList(tagInfo.getTagsList()));
        return tagInfoTable;
    }

    public static TagInfoProtocol.TagInfo GetTagInfoObj(HashMap tagInfoDic) {
        if (tagInfoDic == null) {
            return null;
        }
        if (tagInfoDic.isEmpty()) {
            return null;
        }
        TagInfoProtocol.TagInfo.Builder build = TagInfoProtocol.TagInfo.newBuilder();
        build.setType((String)tagInfoDic.get("type"));
        for (Object obj : (ArrayList)tagInfoDic.get("tags-list")) {
            if (obj != null) {
                build.addTags(obj.toString());
                continue;
            }
            build.addTags(null);
        }
        return build.build();
    }

    public static NamedTagInfoProtocol.NamedTagInfo GetNamedTagInfoObj(HashMap namedTagInfoDic, boolean isDotNetClient) throws IllegalArgumentException {
        NamedTagInfoProtocol.NamedTagInfo.Builder build = NamedTagInfoProtocol.NamedTagInfo.newBuilder();
        build.setType((String)namedTagInfoDic.get("type"));
        HashMap hash = (HashMap)namedTagInfoDic.get("named-tags-list");
        for (Map.Entry entry : hash.entrySet()) {
            build.addNames(entry.getKey().toString());
            if (!isDotNetClient) {
                build.addTypes(entry.getValue().getClass().getName());
            } else {
                build.addTypes(JavaClrTypeMapping.JavaToClr((String)entry.getValue().getClass().getName()));
            }
            if (entry.getValue().getClass() == Date.class) {
                build.addVals(Long.toString(new NCDateTime((Date)entry.getValue()).getTicks()));
                continue;
            }
            build.addVals(entry.getValue().toString());
        }
        return build.build();
    }

    public static HashMap GetHashtableFromNamedTagInfoObjFromDotNet(NamedTagInfoProtocol.NamedTagInfo tagInfo) throws OperationFailedException {
        if (tagInfo == null || tagInfo.getNamesCount() < 1) {
            return null;
        }
        try {
            return ProtobufHelper.GetHashtableFromNamedTagInfoObj(tagInfo);
        }
        catch (ClassNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static HashMap GetHashtableFromNamedTagInfoObjDotNet(String type, List<String> namesList, List<String> typesList, List<String> valuesList) throws ClassNotFoundException {
        HashMap<String, Object> tagInfoTable = new HashMap<String, Object>();
        tagInfoTable.put("type", type);
        HashMap<String, Object> tagList = new HashMap<String, Object>();
        for (int i = 0; i < namesList.size(); ++i) {
            Object obj = null;
            Class<?> t1 = Class.forName(typesList.get(i));
            obj = t1 == Date.class ? HelperFxn.getDateFromTicks((long)Long.parseLong(valuesList.get(i))) : new ConfigurationBuilder().ConvertToPrimitive(t1, valuesList.get(i), "");
            tagList.put(namesList.get(i), obj);
        }
        tagInfoTable.put("named-tags-list", tagList);
        return tagInfoTable;
    }

    private static HashMap GetHashtableFromNamedTagInfoObj(NamedTagInfoProtocol.NamedTagInfo tagInfo) throws ClassNotFoundException {
        HashMap<String, Object> tagInfoTable = new HashMap<String, Object>();
        tagInfoTable.put("type", tagInfo.getType());
        HashMap tagList = new HashMap();
        HashMap tagTypeList = new HashMap();
        for (int i = 0; i < tagInfo.getNamesList().size(); ++i) {
            Object obj = null;
            Class<?> t1 = Class.forName((String)tagInfo.getTypesList().get(i));
            obj = t1 == Date.class ? HelperFxn.getDateFromTicks((long)Long.parseLong((String)tagInfo.getValsList().get(i))) : new ConfigurationBuilder().ConvertToPrimitive(t1, (String)tagInfo.getValsList().get(i), "");
            tagList.put(tagInfo.getNamesList().get(i), obj);
            tagTypeList.put(tagInfo.getNamesList().get(i), t1.getCanonicalName());
        }
        tagInfoTable.put("named-tags-list", tagList);
        tagInfoTable.put("named-tags-types-list", tagList);
        return tagInfoTable;
    }

    public static HashMap GetHashtableFromNamedTagInfoObjFromJava(NamedTagInfoProtocol.NamedTagInfo tagInfo) throws ClassNotFoundException {
        if (tagInfo == null || tagInfo.getNamesCount() < 1) {
            return null;
        }
        return ProtobufHelper.GetHashtableFromNamedTagInfoObj(tagInfo);
    }

    public static ExpirationHint GetExpirationHintObj(DependencyProtocol.Dependency dependency, long absoluteExpiration, long slidingExpiration, boolean resyncOnExpiration, String serializationContext, String itemKey) throws OperationFailedException {
        ExpirationHint hint = null;
        if (absoluteExpiration != 0L && absoluteExpiration != Long.MAX_VALUE) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.clear();
            cal.set(14, 0);
            NCDateTime ncd = new NCDateTime(absoluteExpiration);
            cal.setTime(ncd.getLocalizedDate());
            hint = new FixedExpiration(cal.getTime(), absoluteExpiration);
        }
        if (slidingExpiration != 0L) {
            hint = new IdleExpiration(new TimeSpan(slidingExpiration));
        }
        ExpirationHint depHint = ProtobufHelper.GetExpirationHintObj(dependency, false, serializationContext, itemKey);
        if (hint != null && depHint != null) {
            hint = new AggregateExpirationHint(hint, depHint);
        } else if (depHint != null) {
            hint = depHint;
        }
        if (hint != null && resyncOnExpiration) {
            hint.SetBit(2);
        }
        return hint;
    }

    public static ExpirationHint GetExpirationHintObj(DependencyProtocol.Dependency dependency, boolean resyncOnExpiration, String serializationContext, String itemKey) throws OperationFailedException {
        ExpirationHint[] expHints;
        int i;
        AggregateExpirationHint hints = new AggregateExpirationHint();
        if (dependency != null && dependency.getKeyDepList() != null && dependency.getKeyDepList().size() > 0) {
            for (i = 0; i < dependency.getKeyDepList().size(); ++i) {
                KeyDependency keyDep = new KeyDependency(((DependencyProtocol.KeyDependency)dependency.getKeyDepList().get(i)).getKeysList().toArray(new String[0]), new NCDateTime(((DependencyProtocol.KeyDependency)dependency.getKeyDepList().get(i)).getStartAfter()).getDate());
                hints.Add(keyDep);
            }
        }
        if (dependency != null && dependency.getFileDepList() != null && dependency.getFileDepList().size() > 0) {
            for (i = 0; i < dependency.getFileDepList().size(); ++i) {
                FileDependency fileDep = new FileDependency(((DependencyProtocol.FileDependency)dependency.getFileDepList().get(i)).getFilePathsList().toArray(new String[0]), new NCDateTime(((DependencyProtocol.FileDependency)dependency.getFileDepList().get(i)).getStartAfter()).getDate());
                hints.Add(fileDep);
            }
        }
        if (dependency != null && dependency.getOleDbDepList() != null && dependency.getOleDbDepList().size() > 0) {
            for (i = 0; i < dependency.getOleDbDepList().size(); ++i) {
                OleDbCacheDependency oleDb = new OleDbCacheDependency(((DependencyProtocol.OleDbDependency)dependency.getOleDbDepList().get(i)).getConnectionString(), ((DependencyProtocol.OleDbDependency)dependency.getOleDbDepList().get(i)).getDbCacheKey());
                hints.Add(oleDb);
            }
        }
        if (dependency != null && dependency.getSql7DepList() != null && dependency.getSql7DepList().size() > 0) {
            for (i = 0; i < dependency.getSql7DepList().size(); ++i) {
                Sql7CacheDependency sql7Dep = new Sql7CacheDependency(((DependencyProtocol.Sql7Dependency)dependency.getSql7DepList().get(i)).getConnectionString(), ((DependencyProtocol.Sql7Dependency)dependency.getSql7DepList().get(i)).getDbCacheKey());
                hints.Add(sql7Dep);
            }
        }
        if (dependency != null && dependency.getXtDepList() != null && dependency.getXtDepList().size() > 0) {
            for (i = 0; i < dependency.getXtDepList().size(); ++i) {
                byte[] buffer = ((DependencyProtocol.ExtensibleDependency)dependency.getXtDepList().get(i)).getData().toByteArray();
                Object tempVar = null;
                ObjectInputStream objectInputStream = null;
                Object obj = null;
                try {
                    objectInputStream = new ObjectInputStream(new ByteArrayInputStream(buffer));
                    obj = objectInputStream.readObject();
                    objectInputStream.close();
                }
                catch (ClassNotFoundException cls) {
                    throw new OperationFailedException(cls.toString());
                }
                catch (IOException e) {
                    throw new OperationFailedException(e.getMessage());
                }
                finally {
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                ExtensibleDependency xtDep = new ExtensibleDependency((com.alachisoft.ncache.runtime.dependencies.ExtensibleDependency)obj);
                hints.Add(xtDep);
            }
        }
        if (dependency != null && dependency.getOracleDepList() != null && dependency.getOracleDepList().size() > 0) {
            for (i = 0; i < dependency.getOracleDepList().size(); ++i) {
                try {
                    LinkedHashMap<String, OracleCommandParams> parameters = new LinkedHashMap<String, OracleCommandParams>();
                    for (int pc = 0; pc < ((DependencyProtocol.OracleDependency)dependency.getOracleDepList().get(i)).getParamCount(); ++pc) {
                        OracleCommandParams commandParam = new OracleCommandParams(OracleCmdParamsType.getOracleCmdParamsType((int)((DependencyProtocol.OracleParam)((DependencyProtocol.OracleDependency)dependency.getOracleDepList().get(i)).getParamList().get(pc)).getCmdParam().getDbType()), ((DependencyProtocol.OracleParam)((DependencyProtocol.OracleDependency)dependency.getOracleDepList().get(i)).getParamList().get(pc)).getCmdParam().getValue(), ((DependencyProtocol.OracleParam)((DependencyProtocol.OracleDependency)dependency.getOracleDepList().get(i)).getParamList().get(pc)).getCmdParam().getDirection());
                        parameters.put(((DependencyProtocol.OracleParam)((DependencyProtocol.OracleDependency)dependency.getOracleDepList().get(i)).getParamList().get(pc)).getKey(), commandParam);
                    }
                    OracleCacheDependency oraDep = new OracleCacheDependency(((DependencyProtocol.OracleDependency)dependency.getOracleDepList().get(i)).getConnectionString(), ((DependencyProtocol.OracleDependency)dependency.getOracleDepList().get(i)).getQuery(), CommandType.forValue((int)((DependencyProtocol.OracleDependency)dependency.getOracleDepList().get(i)).getCommandType()), parameters);
                    hints.Add(oraDep);
                    continue;
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getMessage());
                }
            }
        }
        if (resyncOnExpiration) {
            hints.SetBit(2);
        }
        if ((expHints = hints.getHints()).length == 0) {
            return null;
        }
        if (expHints.length == 1) {
            return expHints[0];
        }
        return hints;
    }

    public static DependencyProtocol.Dependency GetDependencyObj(ExpirationHint internalHint) {
        if (internalHint == null) {
            return null;
        }
        DependencyProtocol.Dependency.Builder build = DependencyProtocol.Dependency.newBuilder();
        if (internalHint instanceof AggregateExpirationHint) {
            AggregateExpirationHint hint = (AggregateExpirationHint)internalHint;
            for (int i = 0; i < hint.getHints().length; ++i) {
                ProtobufHelper.AddHintToDependency(build, hint.getHints()[i]);
            }
        } else {
            ProtobufHelper.AddHintToDependency(build, internalHint);
        }
        return build.build();
    }

    private static void AddHintToDependency(DependencyProtocol.Dependency.Builder build, ExpirationHint hint) {
        if (hint instanceof KeyDependency) {
            build.addKeyDep(ProtobufHelper.GetKeyDependency((KeyDependency)hint));
        } else if (hint instanceof FileDependency) {
            build.addFileDep(ProtobufHelper.GetFileDependency((FileDependency)hint));
        } else if (hint instanceof OleDbCacheDependency) {
            build.addOleDbDep(ProtobufHelper.GetOleDbDependency((OleDbCacheDependency)hint));
        } else if (hint instanceof Sql7CacheDependency) {
            build.addSql7Dep(ProtobufHelper.GetSql7Dependency((Sql7CacheDependency)hint));
        } else if (hint instanceof OracleCacheDependency) {
            build.addOracleDep(ProtobufHelper.GetOracleDependency((OracleCacheDependency)hint));
        }
    }

    private static DependencyProtocol.KeyDependency GetKeyDependency(KeyDependency keyDep) {
        DependencyProtocol.KeyDependency.Builder builder = DependencyProtocol.KeyDependency.newBuilder();
        for (int i = 0; i < keyDep.getCacheKeys().length; ++i) {
            builder.addKeys(keyDep.getCacheKeys()[i]);
        }
        builder.setStartAfter(keyDep.getStartAfterTicks());
        return builder.build();
    }

    private static DependencyProtocol.FileDependency GetFileDependency(FileDependency fileDep) {
        DependencyProtocol.FileDependency.Builder builder = DependencyProtocol.FileDependency.newBuilder();
        for (int i = 0; i < fileDep.getfileNames().length; ++i) {
            builder.addFilePaths(fileDep.getfileNames()[i]);
        }
        builder.setStartAfter(fileDep.getStartAfterTicks());
        return builder.build();
    }

    private static DependencyProtocol.OleDbDependency GetOleDbDependency(OleDbCacheDependency oleDbDep) {
        DependencyProtocol.OleDbDependency.Builder protoOleDb = DependencyProtocol.OleDbDependency.newBuilder();
        protoOleDb.setConnectionString(oleDbDep.getConnectionString());
        protoOleDb.setDbCacheKey(oleDbDep.getDbCacheKey());
        return protoOleDb.build();
    }

    private static DependencyProtocol.Sql7Dependency GetSql7Dependency(Sql7CacheDependency sql7Dep) {
        DependencyProtocol.Sql7Dependency.Builder protoSql7Dep = DependencyProtocol.Sql7Dependency.newBuilder();
        protoSql7Dep.setConnectionString(sql7Dep.getConnectionString());
        protoSql7Dep.setDbCacheKey(sql7Dep.getDbCacheKey());
        return protoSql7Dep.build();
    }

    private static DependencyProtocol.OracleDependency GetOracleDependency(OracleCacheDependency oracleDep) {
        DependencyProtocol.OracleDependency.Builder protoOraDep = DependencyProtocol.OracleDependency.newBuilder();
        protoOraDep.setCommandType(oracleDep.getCommandType().getValue());
        protoOraDep.setConnectionString(oracleDep.getConnectionString());
        protoOraDep.setQuery(oracleDep.getQueryString());
        for (Map.Entry pair : oracleDep.getCommandParams().entrySet()) {
            OracleCommandParams oracleCommandParams = (OracleCommandParams)pair.getValue();
            DependencyProtocol.OracleParam.Builder param = DependencyProtocol.OracleParam.newBuilder();
            param.setKey((String)pair.getKey());
            DependencyProtocol.OracleCommandParam.Builder orclaParam = DependencyProtocol.OracleCommandParam.newBuilder();
            orclaParam.setDbType(oracleCommandParams.getType().ordinal());
            orclaParam.setDirection(oracleCommandParams.getDirection());
            orclaParam.setValue(oracleCommandParams.getValue().toString());
            param.setCmdParam(orclaParam.build());
            protoOraDep.addParam(param.build());
        }
        return protoOraDep.build();
    }

    private static DependencyProtocol.YukonDependency GetYukonDependency(SqlYukonCacheDependency yukonDep) {
        return null;
    }
}

