/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Util;

import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.ResourcePool;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleDriver;

public class OleDbConnectionPool
extends ResourcePool {
    private ILogger _ncacheLog;

    public OleDbConnectionPool(ILogger NCacheLog) {
        this._ncacheLog = NCacheLog;
    }

    private ILogger getNCacheLog() {
        return this._ncacheLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection PoolConnection(String connString, Connection connection) throws SQLException {
        OleDbConnectionPool oleDbConnectionPool = this;
        synchronized (oleDbConnectionPool) {
            String connKey = connString.toLowerCase();
            SqlDbResourceInfo connInfo = (SqlDbResourceInfo)this.GetResource(connKey);
            if (connInfo == null) {
                if (connString.startsWith("jdbc:sqlserver")) {
                    DriverManager.registerDriver((Driver)new SQLServerDriver());
                    connection = DriverManager.getConnection(connString);
                } else if (connString.startsWith("jdbc:oracle")) {
                    DriverManager.registerDriver((Driver)new OracleDriver());
                    connection = DriverManager.getConnection(connString);
                } else if (!connString.startsWith("jdbc:db2")) {
                    this.getNCacheLog().Error("Unsuported connection string:" + connString);
                    throw new SQLException("Unsuported connection string:" + connString);
                }
                connInfo = new SqlDbResourceInfo(connection, connString);
                this.AddResource(connKey, connInfo);
            } else {
                this.AddResource(connKey, null);
            }
            return connInfo.getConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveConnection(String connString) {
        OleDbConnectionPool oleDbConnectionPool = this;
        synchronized (oleDbConnectionPool) {
            this.RemoveResource(connString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection GetConnection(String connString) throws SQLException {
        OleDbConnectionPool oleDbConnectionPool = this;
        synchronized (oleDbConnectionPool) {
            SqlDbResourceInfo connInfo = (SqlDbResourceInfo)this.GetResource(connString);
            if (connInfo != null) {
                return connInfo.getConnection();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map GetResourceSyncInfo(String connString) {
        OleDbConnectionPool oleDbConnectionPool = this;
        synchronized (oleDbConnectionPool) {
            SqlDbResourceInfo connInfo = (SqlDbResourceInfo)this.GetResource(connString);
            if (connInfo != null) {
                return connInfo.getDbSyncInfo();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AcquireSyncData(String syncTable, String cacheName) throws SQLException {
        OleDbConnectionPool oleDbConnectionPool = this;
        synchronized (oleDbConnectionPool) {
            Iterator em = this.getKeys().iterator();
            while (em.hasNext()) {
                SqlDbResourceInfo connInfo = (SqlDbResourceInfo)this.GetResource((String)em.next());
                HashMap dbSyncInfo = this.LoadTableData(syncTable, cacheName, connInfo.getConnection());
                connInfo.setDbSyncInfo(dbSyncInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveSyncData(String syncTable, String cacheName) throws SQLException {
        OleDbConnectionPool oleDbConnectionPool = this;
        synchronized (oleDbConnectionPool) {
            Iterator em = this.getKeys().iterator();
            while (em.hasNext()) {
                SqlDbResourceInfo connInfo = (SqlDbResourceInfo)this.GetResource((String)em.next());
                this.RemoveTableData(syncTable, cacheName, connInfo.getConnection());
                connInfo.setDbSyncInfo(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void FlushSyncData() {
        OleDbConnectionPool oleDbConnectionPool = this;
        synchronized (oleDbConnectionPool) {
            Iterator em = this.getKeys().iterator();
            while (em.hasNext()) {
                SqlDbResourceInfo connInfo = (SqlDbResourceInfo)this.GetResource((String)em.next());
                connInfo.setDbSyncInfo(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap LoadTableData(String syncTable, String cacheName, Connection connection) {
        Object[] tableInfo = new Object[]{syncTable, cacheName};
        HashMap<String, Boolean> tableData = new HashMap<String, Boolean>();
        ResultSet reader = null;
        Statement command = null;
        String cacheKey = "";
        boolean modified = false;
        boolean hasRows = false;
        boolean oldAutoCommit = false;
        Connection connection2 = connection;
        synchronized (connection2) {
            String sql;
            try {
                oldAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                command = connection.createStatement();
                sql = String.format("UPDATE %1$s SET WORK_IN_PROGRESS = 1 WHERE CACHE_ID = '%2$s' AND MODIFIED = 1", tableInfo);
                command.executeUpdate(sql);
                connection.commit();
            }
            catch (Exception ex) {
                this.getNCacheLog().Error(cacheName, ex.toString());
                try {
                    connection.rollback();
                }
                catch (SQLException ex1) {
                    Logger.getLogger(OleDbConnectionPool.class.getName()).log(Level.SEVERE, null, ex1);
                }
                HashMap ex1 = null;
                return ex1;
            }
            finally {
                if (command != null) {
                    try {
                        command.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(OleDbConnectionPool.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    command = null;
                }
            }
            try {
                command = connection.createStatement();
                sql = String.format("SELECT CACHE_KEY, MODIFIED FROM %1$s WHERE CACHE_ID = '%2$s' AND WORK_IN_PROGRESS = 1", tableInfo);
                reader = command.executeQuery(sql);
                connection.commit();
                while (reader.next()) {
                    cacheKey = reader.getString("CACHE_KEY");
                    modified = reader.getBoolean("MODIFIED");
                    tableData.put(cacheKey, modified);
                }
            }
            catch (Exception ex) {
                this.getNCacheLog().Error(cacheName, ex.toString());
                try {
                    connection.rollback();
                }
                catch (SQLException ex1) {
                    Logger.getLogger(OleDbConnectionPool.class.getName()).log(Level.SEVERE, null, ex1);
                }
                HashMap hashMap = null;
                return hashMap;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(OleDbConnectionPool.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    reader = null;
                }
                if (command != null) {
                    try {
                        command.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(OleDbConnectionPool.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    command = null;
                }
            }
            try {
                connection.commit();
            }
            catch (SQLException ex) {
                Logger.getLogger(OleDbConnectionPool.class.getName()).log(Level.SEVERE, null, ex);
            }
            return tableData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean RemoveTableData(String syncTable, String cacheName, Connection connection) {
        Object[] tableInfo = new Object[]{syncTable, cacheName};
        Statement command = null;
        Connection connection2 = connection;
        synchronized (connection2) {
            try {
                command = connection.createStatement();
                String sql = String.format("DELETE FROM %1$s WHERE CACHE_ID = '%2$s' AND WORK_IN_PROGRESS = 1", tableInfo);
                command.executeUpdate(sql);
                this.getNCacheLog().DevTrace("Deleting modified records");
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                this.getNCacheLog().Error(cacheName, ex.toString());
                boolean bl2 = false;
                return bl2;
            }
            finally {
                if (command != null) {
                    try {
                        command.close();
                    }
                    catch (SQLException ex3) {
                        Logger.getLogger(OleDbConnectionPool.class.getName()).log(Level.SEVERE, null, ex3);
                    }
                    command = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList GetExpiredKeys() {
        ArrayList keys = new ArrayList();
        OleDbConnectionPool oleDbConnectionPool = this;
        synchronized (oleDbConnectionPool) {
            Iterator em = this.getKeys().iterator();
            while (em.hasNext()) {
                SqlDbResourceInfo connInfo = (SqlDbResourceInfo)this.GetResource((String)em.next());
                if (connInfo == null || connInfo.getDbSyncInfo() == null) continue;
                keys.addAll(connInfo.getDbSyncInfo().keySet());
                connInfo.setDbSyncInfo(null);
            }
        }
        return keys;
    }

    public static class SqlDbResourceInfo
    implements IDisposable {
        private Connection _conn;
        private Map _syncData;
        private String _connString;

        public SqlDbResourceInfo(Connection conn, String connString) {
            this._conn = conn;
            this._connString = connString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            if (this._conn != null) {
                Connection connection = this._conn;
                synchronized (connection) {
                    try {
                        this._conn.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(OleDbConnectionPool.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this._conn = null;
                }
            }
        }

        public final Connection getConnection() throws SQLException {
            if (this._conn != null && !this._conn.isClosed()) {
                return this._conn;
            }
            if (this._connString.startsWith("jdbc:sqlserver")) {
                DriverManager.registerDriver((Driver)new SQLServerDriver());
                this._conn = DriverManager.getConnection(this._connString);
            } else if (this._connString.startsWith("jdbc:oracle")) {
                DriverManager.registerDriver((Driver)new OracleDriver());
                this._conn = DriverManager.getConnection(this._connString);
            }
            return this._conn;
        }

        public final void setConnection(Connection value) {
            this._conn = value;
        }

        public final Map getDbSyncInfo() {
            return this._syncData;
        }

        public final void setDbSyncInfo(Map value) {
            this._syncData = value;
        }
    }
}

