/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Util;

import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Common.Exceptions.SuspectedException;
import Alachisoft.NCache.Common.Exceptions.TimeoutException;
import Alachisoft.NCache.Common.ResetableIterator;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.LockingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class LazyKeysetEnumerator
implements ResetableIterator {
    protected CacheBase _cache = null;
    protected Object[] _keyList = null;
    protected int _current = 0;
    protected boolean _bvalid = false;
    protected boolean _bAllowNulls = false;
    protected Map.Entry _de;

    public LazyKeysetEnumerator(CacheBase cache, Object[] keyList, boolean bAllowNulls) {
        this._cache = cache;
        this._keyList = keyList;
        this._bAllowNulls = bAllowNulls;
        this.reset();
    }

    public void reset() {
        this._bvalid = false;
        this._current = 0;
    }

    private boolean MoveNext() {
        boolean bl = this._bvalid = this._keyList != null && this._current < this._keyList.length;
        if (this._bvalid) {
            this._de = new AbstractMap.SimpleEntry(this._keyList[this._current++], null){};
        }
        return this._bvalid;
    }

    private Object getCurrent() throws TimeoutException, CacheException {
        if (!this._bvalid) {
            throw new UnsupportedOperationException();
        }
        if (this._de.getValue() == null) {
            try {
                this._de.setValue(this.FetchObject(this._de.getKey(), new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation)));
            }
            catch (Exception e) {
                this._cache.getNCacheLog().Error("LazyKeysetEnumerator.Current", e.getMessage());
            }
            if (!this._bAllowNulls && this._de.getValue() == null) {
                throw new UnsupportedOperationException();
            }
        }
        return this._de;
    }

    private Map.Entry getEntry() {
        if (!this._bvalid) {
            throw new UnsupportedOperationException();
        }
        return this._de;
    }

    private Object getKey() {
        if (!this._bvalid) {
            throw new UnsupportedOperationException();
        }
        return this._de.getKey();
    }

    private Object getValue() {
        if (!this._bvalid) {
            throw new UnsupportedOperationException();
        }
        if (this._de.getValue() == null) {
            try {
                this._de.setValue(this.FetchObject(this._de.getKey(), new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation)));
            }
            catch (Exception e) {
                this._cache.getNCacheLog().Error("LazyKeysetEnumerator.Value", e.toString());
            }
            if (!this._bAllowNulls && this._de.getValue() == null) {
                throw new UnsupportedOperationException();
            }
        }
        return this._de.getValue();
    }

    protected Object FetchObject(Object key, OperationContext operationContext) throws TimeoutException, CacheException, OperationFailedException, LockingException, SuspectedException {
        operationContext.Add(OperationContextFieldName.GenerateQueryInfo, true);
        return this._cache.Get(key, operationContext);
    }

    protected Object LoadValue(Object key) throws TimeoutException, CacheException, OperationFailedException, LockingException, SuspectedException {
        return this.FetchObject(key, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
    }

    public boolean hasNext() {
        this._bvalid = this._keyList != null && this._current < this._keyList.length;
        return this._bvalid;
    }

    public Object next() {
        try {
            if (this._bvalid) {
                this._de = new LazyLoadedEntry(this, this._keyList[this._current]);
                ++this._current;
                return this._de;
            }
            throw new NoSuchElementException("Item does not exist");
        }
        catch (Exception cacheException) {
            throw new NoSuchElementException(cacheException.getMessage());
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    class LazyLoadedEntry
    implements Map.Entry {
        private Object _key;
        private Object _value;
        private boolean _loaded;
        private LazyKeysetEnumerator _loader;

        public LazyLoadedEntry(LazyKeysetEnumerator loader) {
            this._loader = loader;
        }

        public LazyLoadedEntry(LazyKeysetEnumerator loader, Object key) {
            this(loader);
            this._key = key;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            if (!this._loaded) {
                try {
                    this._value = this._loader.LoadValue(this._key);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._loaded = true;
            }
            return this._value;
        }

        public Object setValue(Object value) {
            Object oldValue = this._value;
            this._value = value;
            return oldValue;
        }
    }
}

