/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Util;

import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.runtime.JSON.JsonValueType;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationFailedRuntimeException;
import com.alachisoft.ncache.serialization.JSON.JsonBinaryFormatter;
import com.fasterxml.jackson.core.JsonProcessingException;

public class CollectionUtil {
    public static <T> T getValueFromJsonValueBase(ExtendedJsonValueBase jsonValue) throws OperationFailedException {
        if (jsonValue != null && jsonValue.getValue() != null) {
            if (jsonValue.getJsonType() == JsonValueType.Object) {
                return (T)jsonValue.getValue();
            }
            try {
                return (T)JsonBinaryFormatter.deserializeObject((String)jsonValue.toJson(), null);
            }
            catch (JsonProcessingException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        return null;
    }

    public static void verifyCollection(Iterable collection) {
        for (Object item : collection) {
            if (item != null) continue;
            throw new IllegalArgumentException("Some items in collection are null");
        }
    }

    public static boolean validateCopyToParams(int arrayIndex, int arrayLength, int count) {
        if (arrayIndex < 0) {
            throw new IllegalArgumentException("Specified index is a negative number." + System.lineSeparator() + "Parameter name: arrayIndex");
        }
        if (arrayIndex > arrayLength) {
            throw new IllegalArgumentException("Specified index does not lie in the array's bounds." + System.lineSeparator() + "Parameter name: arrayIndex");
        }
        if (arrayIndex + count > arrayLength) {
            throw new IllegalArgumentException("Target array starting from the index specified is not big enough to hold data structure's items." + System.lineSeparator() + "Parameter name: arrayIndex");
        }
        return count != 0;
    }

    public static void validateTypeForHashSet(Class type) {
        Class[] types = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class};
        if (type.isPrimitive()) {
            return;
        }
        for (Class allowedType : types) {
            if (allowedType != type) continue;
            return;
        }
        throw new OperationFailedRuntimeException(45013, ErrorMessages.getErrorMessage((int)45013, (String[])new String[0]));
    }

    public static void validateTypeForHashSetOnCreation(Class type) {
        Class[] types = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Object.class};
        if (type.isPrimitive()) {
            return;
        }
        for (Class allowedType : types) {
            if (allowedType != type) continue;
            return;
        }
        throw new OperationFailedRuntimeException(45013, ErrorMessages.getErrorMessage((int)45013, (String[])new String[0]));
    }
}

