/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Util;

import Alachisoft.NCache.Caching.AsyncOpCode;
import Alachisoft.NCache.Caching.AsyncOpResult;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Threading.AsyncProcessor;
import java.util.HashMap;

public class AsyncInsert
implements AsyncProcessor.IAsyncTask {
    private Cache _cache;
    private Object _key;
    private Object _value;
    private ExpirationHint _expiryHint;
    private EvictionHint _evictionHint;
    private String _group;
    private String _subGroup;
    private BitSet _flag;
    private HashMap _queryInfo;
    private OperationContext _operationContext;
    private CacheSyncDependency _syncDependency;
    private String _providerName;
    private String _resyncProviderName;

    public AsyncInsert(Cache cache, Object key, Object value, ExpirationHint expiryHint, CacheSyncDependency syncDependency, EvictionHint evictionHint, String group, String subGroup, BitSet Flag, HashMap queryInfo, String providerName, String resyncProviderName, OperationContext operationContext) {
        this._cache = cache;
        this._key = key;
        this._value = value;
        this._expiryHint = expiryHint;
        this._syncDependency = syncDependency;
        this._evictionHint = evictionHint;
        this._group = group;
        this._subGroup = subGroup;
        this._flag = Flag;
        this._queryInfo = queryInfo;
        this._providerName = providerName;
        this._resyncProviderName = resyncProviderName;
        this._operationContext = operationContext;
    }

    private ILogger getNCacheLog() {
        return this._cache.getNCacheLog();
    }

    public void Process() {
        Object result = null;
        try {
            this._operationContext.Add(OperationContextFieldName.NoGracefulBlock, true);
            this._cache.Insert(this._key, this._value, this._expiryHint, this._syncDependency, this._evictionHint, this._group, this._subGroup, this._queryInfo, this._flag, null, 0L, LockAccessType.IGNORE_LOCK, this._providerName, this._resyncProviderName, this._operationContext);
            result = AsyncOpResult.Success;
        }
        catch (Exception e) {
            try {
                if (this.getNCacheLog() != null) {
                    this.getNCacheLog().Error("AsyncInsert.Process()", e.getMessage());
                }
                result = e;
            }
            catch (Throwable throwable) {
                CallbackEntry cbEntry = (CallbackEntry)(this._value instanceof CallbackEntry ? this._value : null);
                if (cbEntry != null && cbEntry.getAsyncOperationCompleteCallback() != null) {
                    this._cache.OnAsyncOperationCompleted(AsyncOpCode.Update, new Object[]{this._key, cbEntry.getAsyncOperationCompleteCallback(), result});
                }
                throw throwable;
            }
            CallbackEntry cbEntry = (CallbackEntry)(this._value instanceof CallbackEntry ? this._value : null);
            if (cbEntry != null && cbEntry.getAsyncOperationCompleteCallback() != null) {
                this._cache.OnAsyncOperationCompleted(AsyncOpCode.Update, new Object[]{this._key, cbEntry.getAsyncOperationCompleteCallback(), result});
            }
        }
        CallbackEntry cbEntry = (CallbackEntry)(this._value instanceof CallbackEntry ? this._value : null);
        if (cbEntry != null && cbEntry.getAsyncOperationCompleteCallback() != null) {
            this._cache.OnAsyncOperationCompleted(AsyncOpCode.Update, new Object[]{this._key, cbEntry.getAsyncOperationCompleteCallback(), result});
        }
    }
}

