/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Topologies.Local;

import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.Topologies.Local.LogMode;
import Alachisoft.NCache.Caching.Topologies.Local.OperationInfo;
import Alachisoft.NCache.Caching.Topologies.OperationType;
import Alachisoft.NCache.Common.DataStructures.RedBlack;
import Alachisoft.NCache.Common.DataStructures.RedBlackEnumerator;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import Alachisoft.NCache.Common.Stats.HPTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OperationLogger {
    private LogMode _loggingMode = LogMode.values()[0];
    private int _bucketId;
    private HashMap _logTbl;
    private boolean _bucketTransfered = false;
    private RedBlack _opIndex;

    public OperationLogger(int bucketId, LogMode loggingMode) {
        this._bucketId = bucketId;
        this._opIndex = new RedBlack();
        this._loggingMode = loggingMode;
    }

    public final LogMode getLoggingMode() {
        return this._loggingMode;
    }

    public final void setLoggingMode(LogMode value) {
        this._loggingMode = value;
    }

    public final boolean getBucketTransfered() {
        return this._bucketTransfered;
    }

    public final void setBucketTransfered(boolean value) {
        this._bucketTransfered = value;
    }

    public final HashMap getLoggedEnteries() {
        HashMap updatedKeys = null;
        HashMap removedKeys = null;
        if (this._logTbl == null) {
            this._logTbl = new HashMap();
        }
        this._logTbl.put("updated", new HashMap());
        this._logTbl.put("removed", new HashMap());
        if (this._logTbl.containsKey("updated")) {
            updatedKeys = (HashMap)this._logTbl.get("updated");
        }
        if (this._logTbl.containsKey("removed")) {
            removedKeys = (HashMap)this._logTbl.get("removed");
        }
        RedBlackEnumerator rbe = this._opIndex.GetEnumerator();
        while (rbe.hasNext()) {
            Iterator ide;
            RedBlackEnumerator KeyValue1 = rbe;
            Object Value = KeyValue1.getValue();
            HashMap tbl = (HashMap)(Value instanceof HashMap ? Value : null);
            OperationInfo info = null;
            if (tbl != null && (ide = tbl.entrySet().iterator()).hasNext()) {
                Map.Entry KeyValue2 = ide.next();
                Object Key2 = KeyValue2.getKey();
                info = (OperationInfo)Key2;
            }
            OperationType opType = (OperationType)((Object)info.getOpType());
            switch (opType) {
                case Add: {
                    removedKeys.remove(info.getKey());
                    updatedKeys.put(info.getKey(), info.getEntry());
                    break;
                }
                case Insert: {
                    removedKeys.remove(info.getKey());
                    updatedKeys.put(info.getKey(), info.getEntry());
                    break;
                }
                case Delete: {
                    updatedKeys.remove(info.getKey());
                    removedKeys.put(info.getKey(), info.getEntry());
                }
            }
        }
        return this._logTbl;
    }

    public final HashMap getLoggedKeys() {
        ArrayList updatedKeys = null;
        ArrayList removedKeys = null;
        if (this._logTbl == null) {
            this._logTbl = new HashMap();
        }
        this._logTbl.put("updated", new ArrayList());
        this._logTbl.put("removed", new ArrayList());
        if (this._logTbl.containsKey("updated")) {
            updatedKeys = (ArrayList)this._logTbl.get("updated");
        }
        if (this._logTbl.containsKey("removed")) {
            removedKeys = (ArrayList)this._logTbl.get("removed");
        }
        RedBlackEnumerator rbe = this._opIndex.GetEnumerator();
        while (rbe.hasNext()) {
            Iterator ide;
            RedBlackEnumerator KeyValue1 = rbe;
            Object Value = KeyValue1.getValue();
            HashMap tbl = (HashMap)(Value instanceof HashMap ? Value : null);
            OperationInfo info = null;
            if (tbl != null && (ide = tbl.entrySet().iterator()).hasNext()) {
                Map.Entry KeyValue2 = ide.next();
                Object Key = KeyValue2.getKey();
                info = (OperationInfo)Key;
            }
            OperationType opType = (OperationType)((Object)info.getOpType());
            switch (opType) {
                case Add: {
                    removedKeys.remove(info.getKey());
                    updatedKeys.add(info.getKey());
                    break;
                }
                case Insert: {
                    removedKeys.remove(info.getKey());
                    updatedKeys.add(info.getKey());
                    break;
                }
                case Delete: {
                    updatedKeys.remove(info.getKey());
                    removedKeys.add(info.getKey());
                }
            }
        }
        return this._logTbl;
    }

    public final void Clear() {
        if (this._opIndex != null) {
            this._opIndex.Clear();
        }
    }

    public final void LogOperation(Object key, CacheEntry entry, OperationType type) {
        if (this._opIndex != null) {
            try {
                this._opIndex.Add((Comparable)HPTime.getNow(), (Object)new OperationInfo(key, entry, type));
            }
            catch (RedBlackException redBlackException) {
                // empty catch block
            }
        }
    }
}

