/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Topologies.Local;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.LockExpiration;
import Alachisoft.NCache.Caching.Bridge.BridgeConflictResolutionMgr;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.CallbackInfo;
import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Caching.DataGrouping.GroupInfo;
import Alachisoft.NCache.Caching.DataSourceUpdateOptions;
import Alachisoft.NCache.Caching.EventCacheEntry;
import Alachisoft.NCache.Caching.EventContext;
import Alachisoft.NCache.Caching.EventContextFieldName;
import Alachisoft.NCache.Caching.EventId;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.Exceptions.StateTransferException;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.MetaInformation;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.OperationID;
import Alachisoft.NCache.Caching.Queries.ActiveQueryAnalyzer;
import Alachisoft.NCache.Caching.Queries.Continuous.ContinuousQueryStateInfo;
import Alachisoft.NCache.Caching.Queries.ContinuousQuery;
import Alachisoft.NCache.Caching.Queries.DeleteQueryResultSet;
import Alachisoft.NCache.Caching.Queries.Filters.Predicate;
import Alachisoft.NCache.Caching.Queries.PredicateHolder;
import Alachisoft.NCache.Caching.Queries.QueryContext;
import Alachisoft.NCache.Caching.Queries.QueryResultSet;
import Alachisoft.NCache.Caching.Queries.QueryType;
import Alachisoft.NCache.Caching.Statistics.CacheStatistics;
import Alachisoft.NCache.Caching.TagComparisonType;
import Alachisoft.NCache.Caching.Topologies.CacheAddResult;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Caching.Topologies.CacheInsResult;
import Alachisoft.NCache.Caching.Topologies.CacheInsResultWithEntry;
import Alachisoft.NCache.Caching.Topologies.CacheSyncWrapper;
import Alachisoft.NCache.Caching.Topologies.ICacheEventsListener;
import Alachisoft.NCache.Caching.Util.CacheHelper;
import Alachisoft.NCache.Caching.Util.ParserHelper;
import Alachisoft.NCache.Caching.Util.QueryIdentifier;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import Alachisoft.NCache.Common.DataStructures.VirtualArray;
import Alachisoft.NCache.Common.LockOptions;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Locking.LockMode;
import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Common.Stats.HPTime;
import Alachisoft.NCache.Common.StreamModes;
import Alachisoft.NCache.Parser.AttributeIndexNotDefined;
import Alachisoft.NCache.Parser.ParseMessage;
import Alachisoft.NCache.Parser.ParserException;
import Alachisoft.NCache.Parser.Reduction;
import Alachisoft.NCache.Parser.TypeIndexNotDefined;
import Alachisoft.NCache.Persistence.EventType;
import Alachisoft.NCache.Util.MiscUtil;
import com.alachisoft.ncache.runtime.bridge.BridgeItemOpCodes;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LockingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.StreamAlreadyLockedException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import com.alachisoft.ncache.runtime.exceptions.StreamInvalidLockException;
import com.alachisoft.ncache.runtime.exceptions.StreamNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tangible.DotNetToJavaStringHelper;
import tangible.RefObject;

public class LocalCacheBase
extends CacheBase {
    public boolean _allowAsyncEviction = true;
    protected CacheStatistics _stats;
    protected CacheBase _parentCache;
    protected ActiveQueryAnalyzer _activeQueryAnalyzer;
    int insertCounter = 0;
    int removeCounter = 0;
    private HashMap _preparedQueryTable = new HashMap();
    private int _preparedQueryTableSize = 1000;
    private int _preparedQueryEvictionPercentage = 10;
    private HashMap _stateTransferKeyList;

    public LocalCacheBase(Map properties, CacheBase parentCache, ICacheEventsListener listener, CacheRuntimeContext context, ActiveQueryAnalyzer activeQueryAnalyzer) {
        super(properties, listener, context);
        if (ServicePropValues.preparedQueryTableSize != null) {
            this._preparedQueryTableSize = Integer.decode(ServicePropValues.preparedQueryTableSize);
        }
        if (ServicePropValues.preparedQueryEvictionPercentage != null) {
            this._preparedQueryEvictionPercentage = Integer.decode(ServicePropValues.preparedQueryEvictionPercentage);
        }
        this._activeQueryAnalyzer = activeQueryAnalyzer;
        this._stats = new CacheStatistics();
        this._parentCache = parentCache;
    }

    public LocalCacheBase() {
    }

    @Override
    public void dispose() {
        this._stats = null;
        if (this._activeQueryAnalyzer != null) {
            this._activeQueryAnalyzer.dispose();
            this._activeQueryAnalyzer = null;
        }
        super.dispose();
    }

    @Override
    public CacheStatistics getStatistics() {
        Object tempVar = this._stats.clone();
        return (CacheStatistics)(tempVar instanceof CacheStatistics ? tempVar : null);
    }

    @Override
    public CacheStatistics getActualStats() {
        return this._stats;
    }

    @Override
    public ActiveQueryAnalyzer getQueryAnalyzer() {
        return this._activeQueryAnalyzer;
    }

    @Override
    public CacheBase getInternalCache() {
        return this;
    }

    protected final boolean getIsSelfInternal() {
        if (this._context.getCacheInternal() instanceof CacheSyncWrapper) {
            return this.equals(((CacheSyncWrapper)this._context.getCacheInternal()).getInternal());
        }
        return this.equals(this._context.getCacheInternal());
    }

    public final HashMap getPreparedQueryTable() {
        return this._preparedQueryTable;
    }

    @Override
    public final void Clear(CallbackEntry cbEntry, DataSourceUpdateOptions updateOptions, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        this.ClearInternal();
        this._context.getSyncManager().Clear();
        EventContext eventContext = null;
        EventId eventId = null;
        if (this._activeQueryAnalyzer != null) {
            eventContext = new EventContext();
            eventId = EventId.CreateEventId(operationContext.getOperatoinID());
            eventId.setEventType(EventType.CQ_CALLBACK);
            eventContext.Add(EventContextFieldName.EventID, eventId);
            this._activeQueryAnalyzer.Clear(operationContext, eventContext);
        }
        if (this.getIsSelfInternal()) {
            this._context.ExpiryMgr.Clear();
            this._context.PerfStatsColl.setCountStats(this.getCount());
            this._context.PerfStatsColl.setCacheSizeStats(this.getSize());
        }
        this._stats.UpdateCount(this.getCount());
        OperationID opId = operationContext.getOperatoinID();
        eventContext = new EventContext();
        eventId = EventId.CreateEventId(opId);
        eventId.setEventType(EventType.CACHE_CLEARED_EVENT);
        eventContext.Add(EventContextFieldName.EventID, eventId);
        this.NotifyCacheCleared(false, operationContext, eventContext);
    }

    @Override
    public final boolean Contains(Object key, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        try {
            if (this.ContainsInternal(key)) {
                CacheEntry e = this.GetInternal(key, true, operationContext);
                if (e == null) {
                    return false;
                }
                if (e.getExpirationHint() != null && e.getExpirationHint().CheckExpired(this._context)) {
                    this.Remove(key, ItemRemoveReason.Expired, true, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (StateTransferException se) {
            throw new OperationFailedException((Throwable)((Object)se));
        }
    }

    @Override
    public LockOptions Lock(Object key, LockExpiration lockExpiration, RefObject<Object> lockId, RefObject<Date> lockDate, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        LockOptions lockInfo = new LockOptions();
        CacheEntry e = null;
        e = this.GetInternal(key, false, operationContext);
        if (e != null) {
            e.Lock(lockExpiration, lockId, lockDate);
            lockInfo.setLockDate((Date)lockDate.argvalue);
            lockInfo.setLockId(lockId.argvalue);
            return lockInfo;
        }
        lockId.argvalue = null;
        lockInfo.setLockId(null);
        return lockInfo;
    }

    @Override
    public LockOptions IsLocked(Object key, RefObject<Object> lockId, RefObject<Date> lockDate, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        LockOptions lockInfo = new LockOptions();
        CacheEntry e = null;
        e = this.GetInternal(key, false, operationContext);
        if (e != null) {
            e.IsLocked(lockId, lockDate);
            lockInfo.setLockDate((Date)lockDate.argvalue);
            lockInfo.setLockId(lockId.argvalue);
            return lockInfo;
        }
        lockId.argvalue = null;
        return lockInfo;
    }

    @Override
    public void UnLock(Object key, Object lockId, boolean isPreemptive, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        Object tmpLockId = null;
        Date tmpLockDate = new Date();
        CacheEntry e = null;
        e = this.GetInternal(key, false, operationContext);
        if (e != null) {
            if (isPreemptive) {
                e.ReleaseLock();
            } else if (e.CompareLock(lockId)) {
                e.ReleaseLock();
            }
        }
    }

    @Override
    public void UpdateLockInfo(Object key, Object lockId, Date lockDate, LockExpiration lockExpiration, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        CacheEntry entry = null;
        entry = this.GetInternal(key, false, operationContext);
        if (entry != null) {
            entry.CopyLock(lockId, lockDate, lockExpiration);
        }
    }

    @Override
    public final CacheEntry Get(Object key, RefObject<Long> version, RefObject<Object> lockId, RefObject<Date> lockDate, LockExpiration lockExpiration, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.Get(key, true, version, lockId, lockDate, lockExpiration, accessType, operationContext);
    }

    @Override
    public HashMap GetGroupData(String group, String subGroup, OperationContext operationContext) throws OperationFailedException, GeneralFailureException, StateTransferException, CacheException, LockingException, GeneralFailureException {
        return this.GetFromCache(this.GetGroupKeys(group, subGroup, operationContext), operationContext);
    }

    @Override
    public HashMap GetTagData(String[] tags, TagComparisonType comparisonType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException, LockingException, GeneralFailureException {
        return this.GetFromCache(this.GetTagKeys(tags, comparisonType, operationContext), operationContext);
    }

    private HashMap GetFromCache(ArrayList keys, OperationContext operationContext) throws OperationFailedException {
        if (keys == null) {
            return null;
        }
        return this.GetEntries(keys.toArray(new Object[0]), operationContext);
    }

    @Override
    public HashMap Remove(String[] tags, TagComparisonType tagComparisonType, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.RemoveFromCache(this.GetTagKeys(tags, tagComparisonType, operationContext), notify, operationContext);
    }

    private HashMap RemoveFromCache(ArrayList keys, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (keys == null) {
            return null;
        }
        return this.Remove(keys.toArray(new Object[0]), ItemRemoveReason.Removed, notify, operationContext);
    }

    @Override
    public final CacheEntry Get(Object key, boolean isUserOperation, RefObject<Long> version, RefObject<Object> lockId, RefObject<Date> lockDate, LockExpiration lockExpiration, LockAccessType accessType, OperationContext operationContext) throws LockingException, OperationFailedException, GeneralFailureException, CacheException {
        ExpirationHint exh;
        CacheEntry e = null;
        e = this.GetInternal(key, isUserOperation, operationContext);
        if (accessType != LockAccessType.IGNORE_LOCK) {
            if (e != null) {
                if (accessType == LockAccessType.DONT_ACQUIRE) {
                    boolean success = e.CompareLock(lockId.argvalue);
                    if (success) {
                        lockDate.argvalue = e.getLockDate();
                    } else {
                        boolean bl = success = !e.IsLocked(lockId, lockDate);
                    }
                    if (!success) {
                        e = null;
                    }
                } else if (accessType == LockAccessType.ACQUIRE && !e.Lock(lockExpiration, lockId, lockDate)) {
                    e = null;
                } else if (accessType == LockAccessType.GET_VERSION) {
                    version.argvalue = e.getVersion();
                } else if (accessType == LockAccessType.COMPARE_VERSION) {
                    if (e.IsNewer((Long)version.argvalue)) {
                        version.argvalue = e.getVersion();
                    } else {
                        version.argvalue = 0L;
                        e = null;
                    }
                } else if (accessType == LockAccessType.MATCH_VERSION && !e.CompareVersion((Long)version.argvalue)) {
                    e = null;
                }
            } else {
                lockId.argvalue = null;
            }
        }
        ExpirationHint expirationHint = exh = e == null ? null : e.getExpirationHint();
        if (exh != null) {
            if (exh.CheckExpired(this._context) && !exh.getNeedsReSync()) {
                this.Remove(key, ItemRemoveReason.Expired, true, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
                e = null;
            }
            if (exh.getIsVariant() && isUserOperation) {
                try {
                    this._context.ExpiryMgr.ResetVariant(exh);
                }
                catch (Exception ex) {
                    this.RemoveInternal(key, ItemRemoveReason.Removed, false, operationContext);
                    throw new OperationFailedException((Throwable)ex);
                }
            }
        }
        this._stats.UpdateCount(this.getCount());
        if (e != null) {
            this._stats.BumpHitCount();
        } else {
            this._stats.BumpMissCount();
        }
        return e;
    }

    @Override
    public int GetItemSize(Object key) {
        return 0;
    }

    @Override
    public final CacheAddResult Add(Object key, CacheEntry cacheEntry, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.Add(key, cacheEntry, notify, true, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CacheAddResult Add(Object key, CacheEntry cacheEntry, boolean notify, boolean isUserOperation, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException, StateTransferException {
        CacheAddResult result = CacheAddResult.Failure;
        try {
            if (this._stateTransferKeyList != null && this._stateTransferKeyList.containsKey(key) && notify) {
                CacheAddResult cacheAddResult = CacheAddResult.KeyExists;
                return cacheAddResult;
            }
            if (!this.IsDoOperation(key, this.getContext().getBridgeConflictMgr(), operationContext, BridgeItemOpCodes.Update, cacheEntry, null)) {
                CacheAddResult cacheAddResult = CacheAddResult.Success;
                return cacheAddResult;
            }
            if (cacheEntry.getSyncDependency() != null) {
                this._context.getSyncManager().AddDependency(key, cacheEntry.getSyncDependency());
            }
            if ((result = this.AddInternal(key, cacheEntry, isUserOperation)) == CacheAddResult.Failure && cacheEntry.getSyncDependency() != null) {
                this._context.getSyncManager().RemoveDependency(key, cacheEntry.getSyncDependency());
            }
            if (result == CacheAddResult.NeedsEviction || result == CacheAddResult.SuccessNearEviction) {
                if (!this._context.getIsBridgeTargetCache()) {
                    this.Evict();
                }
                if (result == CacheAddResult.SuccessNearEviction) {
                    result = CacheAddResult.Success;
                }
            }
            if (result == CacheAddResult.KeyExists) {
                if (cacheEntry.getSyncDependency() != null) {
                    this._context.getSyncManager().RemoveDependency(key, cacheEntry.getSyncDependency());
                }
                CacheEntry e = null;
                e = this.GetInternal(key, isUserOperation, operationContext);
                if (e.getExpirationHint() != null && e.getExpirationHint().CheckExpired(this._context)) {
                    this.Remove(key, ItemRemoveReason.Expired, true, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
                }
            }
            if (result == CacheAddResult.Success) {
                if (cacheEntry.getExpirationHint() != null) {
                    cacheEntry.getExpirationHint().setCacheKey((String)key);
                    try {
                        this._context.ExpiryMgr.ResetHint(null, cacheEntry.getExpirationHint());
                    }
                    catch (Exception e) {
                        this.RemoveInternal(key, ItemRemoveReason.Removed, false, operationContext);
                        throw new OperationFailedException((Throwable)e);
                    }
                    this._context.ExpiryMgr.UpdateIndex(key, cacheEntry);
                }
                if (this.getIsSelfInternal()) {
                    this._context.PerfStatsColl.setCountStats(this.getCount());
                    this._context.PerfStatsColl.setCacheSizeStats(this.getSize());
                }
                EventId eventId = null;
                EventContext eventContext = null;
                OperationID opId = operationContext.getOperatoinID();
                if (notify) {
                    if (operationContext != null) {
                        eventId = !operationContext.Contains(OperationContextFieldName.EventContext) ? EventId.CreateEventId(opId) : ((EventContext)operationContext.GetValueByField(OperationContextFieldName.EventContext)).getEventID();
                        eventId.setEventType(EventType.ITEM_ADDED_EVENT);
                        eventContext = new EventContext();
                        eventContext.Add(EventContextFieldName.EventID, eventId);
                        eventContext.setItem(CacheHelper.CreateCacheEventEntry(EventDataFilter.DataWithMetadata, cacheEntry));
                    }
                    this.NotifyItemAdded(key, false, (OperationContext)operationContext.clone(), eventContext);
                }
                if (operationContext.Contains(OperationContextFieldName.RaiseCQNotification)) {
                    try {
                        eventId = !operationContext.Contains(OperationContextFieldName.EventContext) ? EventId.CreateEventId(opId) : ((EventContext)operationContext.GetValueByField(OperationContextFieldName.EventContext)).getEventID();
                        eventId.setEventType(EventType.CQ_CALLBACK);
                        eventContext = new EventContext();
                        eventContext.Add(EventContextFieldName.EventID, eventId);
                        eventContext.setItem(CacheHelper.CreateCacheEventEntry(EventDataFilter.DataWithMetadata, cacheEntry));
                        this._activeQueryAnalyzer.OnItemAdded(key, cacheEntry.getMetaInformation(), this, this._context.getCacheRoot().getName(), (Boolean)operationContext.GetValueByField(OperationContextFieldName.RaiseCQNotification), operationContext, eventContext);
                    }
                    catch (RedBlackException redBlackException) {
                        this._context.getNCacheLog().Error("LocalCacheBase.Add", "RaiseCQNoti - " + redBlackException.getMessage());
                    }
                } else {
                    try {
                        eventContext = null;
                        this._activeQueryAnalyzer.OnItemAdded(key, cacheEntry.getMetaInformation(), this, this._context.getCacheRoot().getName(), false, operationContext, eventContext);
                    }
                    catch (RedBlackException redBlackException) {
                        this._context.getNCacheLog().Error("LocalCacheBase.Add", "Else RaiseCQNoti - " + redBlackException.getMessage());
                    }
                }
            }
            this._stats.UpdateCount(this.getCount());
            if (result == CacheAddResult.NeedsEviction && cacheEntry.getSyncDependency() != null) {
                this._context.getSyncManager().RemoveDependency(key, cacheEntry.getSyncDependency());
            }
        }
        finally {
            cacheEntry.setMetaInformation(null);
        }
        return result;
    }

    @Override
    public final boolean Add(Object key, ExpirationHint eh, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException, StateTransferException {
        if (eh == null) {
            return false;
        }
        boolean result = false;
        CacheEntry entry = null;
        entry = this.GetInternal(key, false, operationContext);
        try {
            result = this.AddInternal(key, eh, operationContext);
        }
        catch (ClassNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
        if (result) {
            eh.setCacheKey((String)key);
            if (!eh.Reset(this._context)) {
                this.RemoveInternal(key, eh);
                throw new OperationFailedException("Unable to initialize expiration hint");
            }
            boolean hasDependentKeys = entry.getKeysDependingOnMe() != null && entry.getKeysDependingOnMe().size() > 0;
            this._context.ExpiryMgr.UpdateIndex(key, entry.getExpirationHint(), hasDependentKeys);
        }
        return result;
    }

    @Override
    public final boolean Add(Object key, CacheSyncDependency syncDependency, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        this._context.getSyncManager().AddDependency(key, syncDependency);
        boolean result = false;
        result = this.AddInternal(key, syncDependency);
        if (!result) {
            this._context.getSyncManager().RemoveDependency(key, syncDependency);
        }
        return result;
    }

    @Override
    public final CacheInsResultWithEntry Insert(Object key, CacheEntry cacheEntry, boolean notify, Object lockId, long version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.Insert(key, cacheEntry, notify, true, lockId, version, accessType, operationContext);
    }

    @Override
    public void SetStateTransferKeyList(HashMap keylist) {
        this._stateTransferKeyList = keylist;
    }

    @Override
    public void UnSetStateTransferKeyList() {
        this._stateTransferKeyList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final CacheInsResultWithEntry Insert(Object key, CacheEntry cacheEntry, boolean notify, boolean isUserOperation, Object lockId, long version, LockAccessType access, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException, StateTransferException {
        CacheInsResultWithEntry result = new CacheInsResultWithEntry();
        try {
            ExpirationHint peExh;
            int maxEvict = 3;
            CacheEntry pe = null;
            CallbackEntry cbEtnry = null;
            OperationID opId = operationContext.getOperatoinID();
            EventId eventId = null;
            EventContext eventContext = null;
            pe = this.GetInternal(key, false, operationContext);
            result.setEntry(pe);
            if (!this.IsDoOperation(key, this.getContext().getBridgeConflictMgr(), operationContext, BridgeItemOpCodes.Update, cacheEntry, pe)) {
                result.setResult(CacheInsResult.Success);
                result.setEntry(null);
                CacheInsResultWithEntry cacheInsResultWithEntry = result;
                return cacheInsResultWithEntry;
            }
            if (pe != null && access != LockAccessType.IGNORE_LOCK) {
                if (access == LockAccessType.COMPARE_VERSION) {
                    if (!pe.CompareVersion(version)) {
                        result.setResult(CacheInsResult.VersionMismatch);
                        result.setEntry(null);
                        CacheInsResultWithEntry cacheInsResultWithEntry = result;
                        return cacheInsResultWithEntry;
                    }
                } else {
                    if ((access == LockAccessType.RELEASE || access == LockAccessType.DONT_RELEASE) && pe.IsItemLocked() && !pe.CompareLock(lockId)) {
                        result.setResult(CacheInsResult.ItemLocked);
                        result.setEntry(null);
                        CacheInsResultWithEntry cacheInsResultWithEntry = result;
                        return cacheInsResultWithEntry;
                    }
                    if (access == LockAccessType.DONT_RELEASE) {
                        cacheEntry.CopyLock(pe.getLockId(), pe.getLockDate(), pe.getLockExpiration());
                    } else {
                        cacheEntry.ReleaseLock();
                    }
                }
            }
            ExpirationHint expirationHint = peExh = pe == null ? null : pe.getExpirationHint();
            if (pe != null && pe.getValue() instanceof CallbackEntry) {
                Object tempVar = pe.getValue();
                cbEtnry = (CallbackEntry)(tempVar instanceof CallbackEntry ? tempVar : null);
                cacheEntry = CacheHelper.MergeEntries(pe, cacheEntry);
            }
            if (cacheEntry.getSyncDependency() != null) {
                this._context.getSyncManager().AddDependency(key, cacheEntry.getSyncDependency());
            }
            if (access == LockAccessType.PRESERVE_VERSION) {
                cacheEntry.setVersion(version);
                isUserOperation = false;
            }
            try {
                result.setResult(this.InsertInternal(key, cacheEntry, isUserOperation, pe, operationContext));
                if ((result.getResult() == CacheInsResult.Success || result.getResult() == CacheInsResult.SuccessNearEvicition) && this._stateTransferKeyList != null && this._stateTransferKeyList.containsKey(key)) {
                    result.setResult(result.getResult() == CacheInsResult.Success ? CacheInsResult.SuccessOverwrite : CacheInsResult.SuccessOverwriteNearEviction);
                }
            }
            catch (ClassNotFoundException classNotFoundExcepton) {
                throw new OperationFailedException((Throwable)classNotFoundExcepton);
            }
            if ((result.getResult() == CacheInsResult.Failure || result.getResult() == CacheInsResult.IncompatibleGroup) && cacheEntry.getSyncDependency() != null) {
                this._context.getSyncManager().RemoveDependency(key, cacheEntry.getSyncDependency());
            }
            if (result.getResult() == CacheInsResult.NeedsEviction || result.getResult() == CacheInsResult.SuccessNearEvicition || result.getResult() == CacheInsResult.SuccessOverwriteNearEviction) {
                if (!this._context.getIsBridgeTargetCache()) {
                    this.Evict();
                }
                if (result.getResult() == CacheInsResult.SuccessNearEvicition) {
                    result.setResult(CacheInsResult.Success);
                }
                if (result.getResult() == CacheInsResult.SuccessOverwriteNearEviction) {
                    result.setResult(CacheInsResult.SuccessOverwrite);
                }
            }
            if (result.getResult() == CacheInsResult.Success || result.getResult() == CacheInsResult.SuccessOverwrite) {
                if (peExh != null) {
                    this._context.ExpiryMgr.RemoveFromIndex(key);
                    peExh.dispose();
                }
                if (cacheEntry.getExpirationHint() != null) {
                    cacheEntry.getExpirationHint().setCacheKey((String)key);
                    if (isUserOperation) {
                        try {
                            this._context.ExpiryMgr.ResetHint(peExh, cacheEntry.getExpirationHint());
                        }
                        catch (Exception e) {
                            this.RemoveInternal(key, ItemRemoveReason.Removed, false, operationContext);
                            throw new OperationFailedException((Throwable)e);
                        }
                    } else {
                        cacheEntry.getExpirationHint().ReInitializeHint(this.getContext());
                    }
                    this._context.ExpiryMgr.UpdateIndex(key, cacheEntry);
                }
                if (this.getIsSelfInternal()) {
                    this._context.PerfStatsColl.setCountStats(this.getCount());
                    this._context.PerfStatsColl.setCacheSizeStats(this.getSize());
                }
                if (operationContext.Contains(OperationContextFieldName.RaiseCQNotification)) {
                    try {
                        eventId = operationContext.Contains(OperationContextFieldName.EventContext) ? ((EventContext)operationContext.GetValueByField(OperationContextFieldName.EventContext)).getEventID() : EventId.CreateEventId(opId);
                        eventContext = new EventContext();
                        eventId.setEventType(EventType.CQ_CALLBACK);
                        eventContext.Add(EventContextFieldName.EventID, eventId);
                        eventContext.setItem(CacheHelper.CreateCacheEventEntry(EventDataFilter.DataWithMetadata, cacheEntry));
                        eventContext.setOldItem(CacheHelper.CreateCacheEventEntry(EventDataFilter.DataWithMetadata, pe));
                        this._activeQueryAnalyzer.OnItemUpdated(key, cacheEntry.getMetaInformation(), this, this._context.getCacheRoot().getName(), (Boolean)operationContext.GetValueByField(OperationContextFieldName.RaiseCQNotification), operationContext, eventContext);
                    }
                    catch (RedBlackException redBlackException) {
                        this._context.getNCacheLog().Error("LocalCacheBase.Add", "RaiseCQNoti - " + redBlackException.getMessage());
                    }
                } else {
                    try {
                        this._activeQueryAnalyzer.OnItemUpdated(key, cacheEntry.getMetaInformation(), this, this._context.getCacheRoot().getName(), false, operationContext, null);
                    }
                    catch (RedBlackException redBlackException) {
                        this._context.getNCacheLog().Error("LocalCacheBase.Add", "RaiseCQNoti - " + redBlackException.getMessage());
                    }
                }
            }
            if ((result.getResult() == CacheInsResult.NeedsEviction || result.getResult() == CacheInsResult.NeedsEvictionNotRemove) && cacheEntry.getSyncDependency() != null) {
                this._context.getSyncManager().AddDependency(key, cacheEntry.getSyncDependency());
            }
            EventCacheEntry eventCacheEntry = null;
            EventCacheEntry oldEventCacheEntry = null;
            this._stats.UpdateCount(this.getCount());
            switch (result.getResult()) {
                case Success: {
                    if (!notify) return result;
                    if (!operationContext.Contains(OperationContextFieldName.EventContext)) {
                        eventId = EventId.CreateEventId(opId);
                        eventContext = new EventContext();
                    } else {
                        eventId = ((EventContext)operationContext.GetValueByField(OperationContextFieldName.EventContext)).getEventID();
                    }
                    eventContext = new EventContext();
                    eventId.setEventType(EventType.ITEM_ADDED_EVENT);
                    eventContext.Add(EventContextFieldName.EventID, eventId);
                    eventContext.setItem(CacheHelper.CreateCacheEventEntry(EventDataFilter.DataWithMetadata, cacheEntry));
                    this.NotifyItemAdded(key, false, (OperationContext)operationContext.clone(), eventContext);
                    return result;
                }
                case SuccessOverwrite: {
                    if (!notify) return result;
                    eventCacheEntry = CacheHelper.CreateCacheEventEntry(EventDataFilter.DataWithMetadata, cacheEntry);
                    oldEventCacheEntry = CacheHelper.CreateCacheEventEntry(EventDataFilter.DataWithMetadata, pe);
                    if (cbEtnry != null && cbEtnry.getItemUpdateCallbackListener() != null && cbEtnry.getItemUpdateCallbackListener().size() > 0) {
                        if (!operationContext.Contains(OperationContextFieldName.EventContext)) {
                            eventId = EventId.CreateEventId(opId);
                            eventContext = new EventContext();
                        } else {
                            eventId = ((EventContext)operationContext.GetValueByField(OperationContextFieldName.EventContext)).getEventID();
                        }
                        eventContext = new EventContext();
                        eventId.setEventType(EventType.ITEM_UPDATED_CALLBACK);
                        eventContext.Add(EventContextFieldName.EventID, eventId);
                        eventContext.setItem(eventCacheEntry);
                        eventContext.setOldItem(oldEventCacheEntry);
                        this.NotifyCustomUpdateCallback(key, cbEtnry.getItemUpdateCallbackListener(), false, (OperationContext)operationContext.clone(), eventContext);
                    }
                    if (!operationContext.Contains(OperationContextFieldName.EventContext)) {
                        eventId = EventId.CreateEventId(opId);
                        eventContext = new EventContext();
                    } else {
                        eventId = ((EventContext)operationContext.GetValueByField(OperationContextFieldName.EventContext)).getEventID();
                    }
                    eventContext = new EventContext();
                    eventId.setEventType(EventType.ITEM_UPDATED_EVENT);
                    eventContext.Add(EventContextFieldName.EventID, eventId);
                    eventContext.setItem(eventCacheEntry);
                    eventContext.setOldItem(oldEventCacheEntry);
                    this.NotifyItemUpdated(key, false, (OperationContext)operationContext.clone(), eventContext);
                    return result;
                }
            }
            return result;
        }
        finally {
            cacheEntry.setMetaInformation(null);
        }
    }

    @Override
    public final CacheEntry Remove(Object key, ItemRemoveReason removalReason, boolean notify, Object lockId, long version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.Remove(key, removalReason, notify, true, lockId, version, accessType, operationContext);
    }

    @Override
    public CacheEntry Remove(Object key, ItemRemoveReason removalReason, boolean notify, boolean isUserOperation, Object lockId, long version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        CacheEntry e = null;
        CacheEntry pe = null;
        Object actualKey = key;
        if (key instanceof Object[]) {
            actualKey = ((Object[])key)[0];
        }
        if (accessType == LockAccessType.COMPARE_VERSION) {
            pe = this.GetInternal(actualKey, false, operationContext);
            if (!pe.CompareVersion(version)) {
                throw new LockingException("Item in the cache does not exist at the specified version.");
            }
        } else if (accessType != LockAccessType.IGNORE_LOCK && (pe = this.GetInternal(actualKey, false, operationContext)) != null && pe.IsItemLocked() && !pe.CompareLock(lockId)) {
            throw new LockingException("Item is locked.");
        }
        if (pe != null && !this.IsDoOperation(key, this.getContext().getBridgeConflictMgr(), operationContext, BridgeItemOpCodes.Remove, pe)) {
            return null;
        }
        e = this.RemoveInternal(actualKey, removalReason, isUserOperation, operationContext);
        boolean resyncExpiredItems = false;
        if (e != null && e.getExpirationHint() != null) {
            resyncExpiredItems = e.getExpirationHint().getNeedsReSync();
        }
        EventId eventId = null;
        EventContext eventContext = null;
        OperationID opId = operationContext.getOperatoinID();
        if (e != null) {
            if (this._stateTransferKeyList != null && this._stateTransferKeyList.containsKey(key)) {
                this._stateTransferKeyList.remove(key);
            }
            try {
                this._context.ExpiryMgr.ResetHint(e.getExpirationHint(), null);
                if (e.getExpirationHint() != null) {
                    this._context.ExpiryMgr.RemoveFromIndex(key);
                }
            }
            catch (Exception ex) {
                this.getNCacheLog().Error("LocalCacheBase.Remove(object, ItemRemovedReason, bool):", ex.toString());
            }
            if (e.getSyncDependency() != null) {
                this._context.getSyncManager().RemoveDependency(actualKey, e.getSyncDependency());
            }
            if (this.getIsSelfInternal()) {
                e.dispose();
                if (!(this._context.getIsDbSyncCoordinator() || removalReason != ItemRemoveReason.Expired && removalReason != ItemRemoveReason.DependencyChanged)) {
                    this._context.PerfStatsColl.incrementExpiryPerSecStats();
                } else if (!this._context.getCacheImpl().getIsEvictionAllowed() && removalReason == ItemRemoveReason.Underused) {
                    this._context.PerfStatsColl.incrementEvictPerSecStats();
                }
                this._context.PerfStatsColl.setCountStats(this.getCount());
                this._context.PerfStatsColl.setCacheSizeStats(this.getSize());
            }
            if (notify) {
                Object tempVar = e.getValue();
                CallbackEntry cbEtnry = (CallbackEntry)(tempVar instanceof CallbackEntry ? tempVar : null);
                if (cbEtnry != null && cbEtnry.getItemRemoveCallbackListener() != null && cbEtnry.getItemRemoveCallbackListener().size() > 0) {
                    try {
                        eventId = !operationContext.Contains(OperationContextFieldName.EventContext) ? EventId.CreateEventId(opId) : ((EventContext)operationContext.GetValueByField(OperationContextFieldName.EventContext)).getEventID();
                        eventId.setEventType(EventType.ITEM_REMOVED_CALLBACK);
                        eventContext = new EventContext();
                        eventContext.Add(EventContextFieldName.EventID, eventId);
                        EventCacheEntry eventCacheEntry = CacheHelper.CreateCacheEventEntry(cbEtnry.getItemRemoveCallbackListener(), e);
                        if (eventCacheEntry != null) {
                            eventCacheEntry.setReSyncExpiredItems(resyncExpiredItems);
                        }
                        eventContext.setItem(eventCacheEntry);
                        eventContext.Add(EventContextFieldName.ItemRemoveCallbackList, new ArrayList(cbEtnry.getItemRemoveCallbackListener()));
                        this.NotifyCustomRemoveCallback(actualKey, e, removalReason, false, (OperationContext)operationContext.clone(), eventContext);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new OperationFailedException((Throwable)classNotFoundException);
                    }
                }
                eventId = !operationContext.Contains(OperationContextFieldName.EventContext) ? EventId.CreateEventId(opId) : ((EventContext)operationContext.GetValueByField(OperationContextFieldName.EventContext)).getEventID();
                eventId.setEventType(EventType.ITEM_REMOVED_EVENT);
                eventContext = new EventContext();
                eventContext.Add(EventContextFieldName.EventID, eventId);
                eventContext.Add(EventContextFieldName.EventID, eventId);
                eventContext.setItem(CacheHelper.CreateCacheEventEntry(EventDataFilter.DataWithMetadata, e));
                this.NotifyItemRemoved(actualKey, e, removalReason, false, (OperationContext)operationContext.clone(), eventContext);
            }
            MetaInformation metaInfo = new MetaInformation(null);
            metaInfo.setType(e.getObjectType());
            if (operationContext.Contains(OperationContextFieldName.RaiseCQNotification)) {
                try {
                    eventId = !operationContext.Contains(OperationContextFieldName.EventContext) ? EventId.CreateEventId(opId) : ((EventContext)operationContext.GetValueByField(OperationContextFieldName.EventContext)).getEventID();
                    eventId.setEventType(EventType.CQ_CALLBACK);
                    eventContext = new EventContext();
                    eventContext.Add(EventContextFieldName.EventID, eventId);
                    eventContext.setItem(CacheHelper.CreateCacheEventEntry(EventDataFilter.DataWithMetadata, e));
                    this._activeQueryAnalyzer.OnItemRemoved(key, metaInfo, this, this._context.getCacheRoot().getName(), (Boolean)operationContext.GetValueByField(OperationContextFieldName.RaiseCQNotification), operationContext, eventContext);
                }
                catch (RedBlackException redBlackException) {
                    this._context.getNCacheLog().Error("LocalCacheBase.Add", "RaiseCQNoti - " + redBlackException.getMessage());
                }
            } else {
                try {
                    this._activeQueryAnalyzer.OnItemRemoved(key, metaInfo, this, this._context.getCacheRoot().getName(), false, operationContext, null);
                }
                catch (RedBlackException redBlackException) {
                    this._context.getNCacheLog().Error("LocalCacheBase.Add", "RaiseCQNoti - " + redBlackException.getMessage());
                }
            }
        } else if (this._stateTransferKeyList != null && this._stateTransferKeyList.containsKey(key)) {
            try {
                this._stateTransferKeyList.remove(key);
                if (operationContext.Contains(OperationContextFieldName.RaiseCQNotification)) {
                    eventId = !operationContext.Contains(OperationContextFieldName.EventContext) ? EventId.CreateEventId(opId) : ((EventContext)operationContext.GetValueByField(OperationContextFieldName.EventContext)).getEventID();
                    eventId.setEventType(EventType.CQ_CALLBACK);
                    eventContext = new EventContext();
                    eventContext.Add(EventContextFieldName.EventID, eventId);
                    eventContext.setItem(CacheHelper.CreateCacheEventEntry(EventDataFilter.DataWithMetadata, e));
                    this._activeQueryAnalyzer.OnItemRemoved(key, null, this, this._context.getCacheRoot().getName(), (Boolean)operationContext.GetValueByField(OperationContextFieldName.RaiseCQNotification), operationContext, eventContext);
                } else {
                    this._activeQueryAnalyzer.OnItemRemoved(key, null, this, this._context.getCacheRoot().getName(), false, operationContext, null);
                }
            }
            catch (RedBlackException redBlackException) {
                this._context.getNCacheLog().Error("LocalCacheBase.Add", "RaiseCQNoti - " + redBlackException.getMessage());
            }
        }
        this._stats.UpdateCount(this.getCount());
        return e;
    }

    @Override
    public Object RemoveSync(Object[] keys, ItemRemoveReason reason, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (this._parentCache != null) {
            return this._parentCache.RemoveSync(keys, reason, notify, operationContext);
        }
        return null;
    }

    @Override
    public final void SendNotification(Object notifId, Object data) {
        super.NotifyCustomEvent(notifId, data, false, null, null);
    }

    @Override
    public final QueryResultSet Search(String query, Map values, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        try {
            QueryContext queryContext = this.PrepareSearch(query, values);
            switch (queryContext.getResultSet().getType()) {
                case AggregateFunction: {
                    break;
                }
                default: {
                    queryContext.getTree().Reduce();
                    queryContext.setCacheContext(this._context.getSerializationContext());
                    queryContext.getResultSet().setSearchKeysResult(queryContext.getTree().getLeftList());
                }
            }
            return queryContext.getResultSet();
        }
        catch (com.alachisoft.ncache.runtime.exceptions.ParserException pe) {
            this.RemoveReduction(query);
            throw new OperationFailedException(pe.getMessage(), (Throwable)pe);
        }
        catch (Exception ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    @Override
    public final QueryResultSet SearchCQ(ContinuousQuery query, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        try {
            Reduction currentQueryReduction = null;
            currentQueryReduction = this.GetPreparedReduction(query.getCommandText());
            Object tempVar = currentQueryReduction.getTag();
            QueryContext queryContext = this.SearchInternal((Predicate)(tempVar instanceof Predicate ? tempVar : null), MiscUtil.DeepClone(query.getAttributeValues()));
            switch (queryContext.getResultSet().getType()) {
                case AggregateFunction: {
                    break;
                }
                default: {
                    queryContext.getTree().Reduce();
                    queryContext.setCacheContext(this._context.getSerializationContext());
                    queryContext.getResultSet().setSearchKeysResult(queryContext.getTree().getLeftList());
                }
            }
            if (!query.getUniqueId().equals("-1")) {
                Object tempVar2 = currentQueryReduction.getTag();
                this._activeQueryAnalyzer.RegisterPredicate(queryContext.getTypeName(), query.getCommandText(), MiscUtil.DeepClone(query.getAttributeValues()), (Predicate)(tempVar2 instanceof Predicate ? tempVar2 : null), query.getUniqueId(), queryContext.getTree().getLeftList());
            }
            return queryContext.getResultSet();
        }
        catch (AttributeIndexNotDefined e) {
            this.RemoveReduction(query.getCommandText());
            throw new OperationFailedException((Throwable)e);
        }
        catch (TypeIndexNotDefined e) {
            this.RemoveReduction(query.getCommandText());
            throw new OperationFailedException((Throwable)e);
        }
        catch (ParserException pe) {
            this.RemoveReduction(query.getCommandText());
            throw new OperationFailedException((Throwable)pe);
        }
        catch (Exception ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    @Override
    public final QueryResultSet SearchCQ(String queryId, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        QueryResultSet resultSet = new QueryResultSet();
        resultSet.setSearchKeysResult(this._activeQueryAnalyzer.Search(queryId));
        return resultSet;
    }

    @Override
    public final QueryResultSet SearchEntries(String query, Map values, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        try {
            QueryContext queryContext = this.PrepareSearch(query, values);
            switch (queryContext.getResultSet().getType()) {
                case AggregateFunction: {
                    break;
                }
                case GroupByAggregateFunction: {
                    break;
                }
                default: {
                    HashMap result = new HashMap();
                    ArrayList keyList = null;
                    ArrayList updatekeys = null;
                    queryContext.getTree().Reduce();
                    queryContext.setCacheContext(this._context.getSerializationContext());
                    if (queryContext.getTree().getLeftList().size() > 0) {
                        keyList = queryContext.getTree().getLeftList();
                    }
                    if (keyList != null && keyList.size() > 0) {
                        Object[] keys = new Object[keyList.size()];
                        keyList.toArray(keys);
                        HashMap tmp = this.GetEntries(keys, operationContext);
                        Iterator ide = tmp.entrySet().iterator();
                        CompressedValueEntry cmpEntry = null;
                        while (ide.hasNext()) {
                            Map.Entry KeyValue = ide.next();
                            Object Key = KeyValue.getKey();
                            Object Value = KeyValue.getValue();
                            CacheEntry entry = (CacheEntry)(Value instanceof CacheEntry ? Value : null);
                            if (entry == null) continue;
                            cmpEntry = new CompressedValueEntry();
                            cmpEntry.setValue(entry.getValue());
                            if (cmpEntry.getValue() instanceof CallbackEntry) {
                                cmpEntry.setValue(((CallbackEntry)cmpEntry.getValue()).getValue());
                            }
                            cmpEntry.setFlag(((CacheEntry)Value).getFlag());
                            result.put(Key, cmpEntry);
                            if (entry.getExpirationHint() == null || !entry.getExpirationHint().getIsVariant()) continue;
                            if (updatekeys == null) {
                                updatekeys = new ArrayList();
                            }
                            updatekeys.add(Key);
                        }
                    }
                    queryContext.getResultSet().setType(QueryType.SearchEntries);
                    queryContext.getResultSet().setSearchEntriesResult(result);
                    queryContext.getResultSet().setUpdateIndicesKeys(updatekeys);
                }
            }
            return queryContext.getResultSet();
        }
        catch (com.alachisoft.ncache.runtime.exceptions.ParserException pe) {
            this.RemoveReduction(query);
            throw new OperationFailedException(pe.getMessage(), (Throwable)pe);
        }
        catch (Exception ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    @Override
    public final QueryResultSet SearchEntriesCQ(ContinuousQuery query, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        try {
            Reduction currentQueryReduction = null;
            currentQueryReduction = this.GetPreparedReduction(query.getCommandText());
            Object tempVar = currentQueryReduction.getTag();
            QueryContext queryContext = this.SearchInternal((Predicate)(tempVar instanceof Predicate ? tempVar : null), MiscUtil.DeepClone(query.getAttributeValues()));
            switch (queryContext.getResultSet().getType()) {
                case AggregateFunction: {
                    break;
                }
                default: {
                    HashMap result = new HashMap();
                    ArrayList keyList = null;
                    queryContext.getTree().Reduce();
                    queryContext.setCacheContext(this._context.getSerializationContext());
                    if (queryContext.getTree().getLeftList().size() > 0) {
                        keyList = queryContext.getTree().getLeftList();
                    }
                    if (keyList != null && keyList.size() > 0) {
                        HashMap tmp = this.GetEntries(keyList.toArray(new Object[0]), operationContext);
                        Iterator ide = tmp.entrySet().iterator();
                        CompressedValueEntry cmpEntry = null;
                        while (ide.hasNext()) {
                            Map.Entry KeyValue = ide.next();
                            Object Key = KeyValue.getKey();
                            Object Value = KeyValue.getValue();
                            CacheEntry entry = (CacheEntry)(Value instanceof CacheEntry ? Value : null);
                            if (entry == null) continue;
                            cmpEntry = new CompressedValueEntry();
                            cmpEntry.setValue(entry.getValue());
                            if (cmpEntry.getValue() instanceof CallbackEntry) {
                                cmpEntry.setValue(((CallbackEntry)cmpEntry.getValue()).getValue());
                            }
                            cmpEntry.setFlag(((CacheEntry)Value).getFlag());
                            result.put(Key, cmpEntry);
                        }
                    }
                    queryContext.getResultSet().setType(QueryType.SearchEntries);
                    queryContext.getResultSet().setSearchEntriesResult(result);
                }
            }
            Object tempVar2 = currentQueryReduction.getTag();
            this._activeQueryAnalyzer.RegisterPredicate(queryContext.getTypeName(), query.getCommandText(), MiscUtil.DeepClone(query.getAttributeValues()), (Predicate)(tempVar2 instanceof Predicate ? tempVar2 : null), query.getUniqueId(), queryContext.getTree().getLeftList());
            return queryContext.getResultSet();
        }
        catch (com.alachisoft.ncache.runtime.exceptions.ParserException pe) {
            this.RemoveReduction(query.getCommandText());
            throw new OperationFailedException(pe.getMessage(), (Throwable)pe);
        }
        catch (Exception ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    @Override
    public final QueryResultSet SearchEntriesCQ(String queryId, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        HashMap result = new HashMap();
        QueryResultSet resultSet = new QueryResultSet();
        ArrayList keys = this._activeQueryAnalyzer.Search(queryId);
        HashMap tmp = this.GetEntries(keys.toArray(new Object[0]), operationContext);
        Iterator ide = tmp.entrySet().iterator();
        CompressedValueEntry cmpEntry = null;
        while (ide.hasNext()) {
            Map.Entry KeyValue = ide.next();
            Object Key = KeyValue.getKey();
            Object Value = KeyValue.getValue();
            CacheEntry entry = (CacheEntry)(Value instanceof CacheEntry ? Value : null);
            if (entry == null) continue;
            cmpEntry = new CompressedValueEntry();
            cmpEntry.setValue(entry.getValue());
            if (cmpEntry.getValue() instanceof CallbackEntry) {
                cmpEntry.setValue(((CallbackEntry)cmpEntry.getValue()).getValue());
            }
            cmpEntry.setFlag(((CacheEntry)Value).getFlag());
            result.put(Key, cmpEntry);
        }
        resultSet.setType(QueryType.SearchEntries);
        resultSet.setSearchEntriesResult(result);
        return resultSet;
    }

    private QueryContext PrepareSearch(String query, Map values) throws Exception {
        Reduction currentQueryReduction = null;
        try {
            currentQueryReduction = this.GetPreparedReduction(query);
            ArrayList temp = currentQueryReduction.getTokens();
            String val = temp.get(0).toString();
            String v = val.toLowerCase();
            val = v.trim();
            val = this.RemoveNullCharacters(val);
            if (!val.equals("select")) {
                throw new com.alachisoft.ncache.runtime.exceptions.ParserException("Only select query is supported");
            }
            Object tempVar = currentQueryReduction.getTag();
            return this.SearchInternal((Predicate)(tempVar instanceof Predicate ? tempVar : null), values);
        }
        catch (com.alachisoft.ncache.runtime.exceptions.ParserException pe) {
            this.RemoveReduction(query);
            throw new com.alachisoft.ncache.runtime.exceptions.ParserException(pe.getMessage(), (Throwable)pe);
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    private String RemoveNullCharacters(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\u0000') continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public final DeleteQueryResultSet DeleteQuery(String query, Map values, boolean notify, boolean isUserOperation, ItemRemoveReason ir, OperationContext operationContext) throws Exception, com.alachisoft.ncache.runtime.exceptions.ParserException {
        HashMap result = new HashMap();
        try {
            QueryContext queryContext = this.PrepareDeleteQuery(query, values);
            queryContext.getTree().Reduce();
            queryContext.setCacheContext(this._context.getSerializationContext());
            ArrayList keysToBeRemoved = queryContext.getTree().getLeftList();
            result = this.Remove(keysToBeRemoved.toArray(new Object[0]), ir, notify, isUserOperation, operationContext);
            DeleteQueryResultSet resultSet = new DeleteQueryResultSet();
            resultSet.setKeysDependingOnMe(this.ExtractDependentKeys(result));
            resultSet.setKeysEffectedCount(result.size());
            resultSet.setKeysEffected(result);
            return resultSet;
        }
        catch (com.alachisoft.ncache.runtime.exceptions.ParserException pe) {
            this.RemoveReduction(query);
            throw new com.alachisoft.ncache.runtime.exceptions.ParserException(pe.getMessage(), (Throwable)pe);
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    private QueryContext PrepareDeleteQuery(String query, Map values) throws com.alachisoft.ncache.runtime.exceptions.ParserException, Exception {
        Reduction currentQueryReduction = null;
        try {
            currentQueryReduction = this.GetPreparedReduction(query);
            Object tempVar = currentQueryReduction.getTag();
            ArrayList temp = currentQueryReduction.getTokens();
            String val = temp.get(0).toString();
            currentQueryReduction = this.GetPreparedReduction(query);
            String v = val.toLowerCase();
            val = v.trim();
            val = this.RemoveNullCharacters(val);
            if (!val.toLowerCase().equals("delete")) {
                throw new com.alachisoft.ncache.runtime.exceptions.ParserException("Execute Non Query only supports delete query");
            }
            return this.DeleteQueryInternal((Predicate)(tempVar instanceof Predicate ? tempVar : null), values);
        }
        catch (com.alachisoft.ncache.runtime.exceptions.ParserException pe) {
            this.RemoveReduction(query);
            throw new com.alachisoft.ncache.runtime.exceptions.ParserException(pe.getMessage(), (Throwable)pe);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
    }

    @Override
    public HashMap AddDepKeyList(HashMap table, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        HashMap retVal = new HashMap();
        Iterator en = table.entrySet().iterator();
        while (en.hasNext()) {
            operationContext.Add(OperationContextFieldName.GenerateQueryInfo, true);
            Map.Entry KeyValue = en.next();
            Object Key = KeyValue.getKey();
            Object Value = KeyValue.getValue();
            CacheEntry entry = this.Get(Key, operationContext);
            if (entry == null) {
                retVal.put(Key, false);
                continue;
            }
            if (entry.getKeysDependingOnMe() == null) {
                entry.setKeysDependingOnMe(new HashMap());
            }
            ArrayList keys = (ArrayList)Value;
            for (int i = 0; i < keys.size(); ++i) {
                if (entry.getKeysDependingOnMe().containsKey(keys.get(i))) continue;
                entry.getKeysDependingOnMe().put(keys.get(i), null);
            }
            try {
                if (this.InsertInternal(Key, entry, false, entry, operationContext) != CacheInsResult.SuccessOverwrite) {
                    retVal.put(Key, false);
                    continue;
                }
                retVal.put(Key, true);
                this._context.ExpiryMgr.UpdateIndex(Key, entry);
            }
            catch (Exception e) {
                retVal.put(Key, e);
            }
        }
        operationContext.RemoveValueByField(OperationContextFieldName.GenerateQueryInfo);
        return retVal;
    }

    @Override
    public HashMap RemoveDepKeyList(HashMap table, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException {
        HashMap retVal = new HashMap();
        if (table == null) {
            return null;
        }
        for (Map.Entry KeyValue : table.entrySet()) {
            Object Key = KeyValue.getKey();
            Object Value = KeyValue.getValue();
            try {
                CacheEntry pe = this.GetInternal(Key, true, operationContext);
                if (pe != null) {
                    CacheInsResult res;
                    if (pe.getKeysDependingOnMe() != null) {
                        ArrayList list = (ArrayList)Value;
                        for (int i = 0; i < list.size(); ++i) {
                            pe.getKeysDependingOnMe().remove(list.get(i));
                        }
                    }
                    if ((res = this.InsertInternal(Key, pe, false, pe, operationContext)) != CacheInsResult.SuccessOverwrite) {
                        retVal.put(Key, false);
                        continue;
                    }
                    retVal.put(Key, true);
                    this._context.ExpiryMgr.UpdateIndex(Key, pe);
                    continue;
                }
                retVal.put(Key, false);
            }
            catch (Exception e) {
                retVal.put(Key, e);
            }
        }
        return retVal;
    }

    @Override
    public final HashMap Contains(Object[] keys, OperationContext operationContext) throws LockingException, OperationFailedException, CacheException, GeneralFailureException {
        HashMap tbl = new HashMap();
        ArrayList<Object> successfulKeys = new ArrayList<Object>();
        ArrayList<Object> failedKeys = new ArrayList<Object>();
        for (int i = 0; i < keys.length; ++i) {
            try {
                boolean result = this.Contains(keys[i], operationContext);
                if (!result) continue;
                successfulKeys.add(keys[i]);
                continue;
            }
            catch (StateTransferException se) {
                failedKeys.add(keys[i]);
            }
        }
        if (successfulKeys.size() > 0) {
            tbl.put("items-found", successfulKeys);
        }
        if (failedKeys.size() > 0) {
            tbl.put("items-transfered", failedKeys);
        }
        return tbl;
    }

    @Override
    public final HashMap Get(Object[] keys, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        HashMap<Object, Serializable> entries = new HashMap<Object, Serializable>();
        CacheEntry e = null;
        for (int i = 0; i < keys.length; ++i) {
            try {
                if (operationContext != null) {
                    operationContext.RemoveValueByField(OperationContextFieldName.EventContext);
                    OperationID opId = operationContext.getOperatoinID();
                    EventId eventId = EventId.CreateEventId(opId);
                    eventId.setEventUniqueID(opId.getOperationId());
                    eventId.setOperationCounter(opId.getOpCounter());
                    eventId.setEventCounter(i);
                    EventContext eventContext = new EventContext();
                    eventContext.Add(EventContextFieldName.EventID, eventId);
                    operationContext.Add(OperationContextFieldName.EventContext, eventContext);
                }
                if ((e = this.Get(keys[i], operationContext)) == null) continue;
                entries.put(keys[i], e);
                continue;
            }
            catch (StateTransferException se) {
                entries.put(keys[i], se);
            }
        }
        return entries;
    }

    private HashMap GetEntries(Object[] keys, OperationContext operationContext) throws OperationFailedException {
        HashMap<Object, Serializable> entries = new HashMap<Object, Serializable>();
        CacheEntry e = null;
        for (int i = 0; i < keys.length; ++i) {
            try {
                e = this.GetEntryInternal(keys[i], true);
                if (e == null) continue;
                ExpirationHint exh = e.getExpirationHint();
                if (exh != null) {
                    if (exh.CheckExpired(this._context) && !exh.getNeedsReSync()) {
                        this.Remove(keys[i], ItemRemoveReason.Expired, true, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
                        e = null;
                    }
                    if (exh.getIsVariant()) {
                        try {
                            this._context.ExpiryMgr.ResetVariant(exh);
                        }
                        catch (Exception ex) {
                            this.RemoveInternal(keys[i], ItemRemoveReason.Removed, false, operationContext);
                            throw ex;
                        }
                    }
                }
                entries.put(keys[i], e);
                continue;
            }
            catch (Exception ex) {
                entries.put(keys[i], ex);
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final HashMap Add(Object[] keys, CacheEntry[] cacheEntries, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException {
        HashMap<Object, Object> table = new HashMap<Object, Object>();
        EventContext eventContext = null;
        EventId eventId = null;
        OperationID opId = operationContext.getOperatoinID();
        for (int i = 0; i < keys.length; ++i) {
            try {
                operationContext.RemoveValueByField(OperationContextFieldName.EventContext);
                if (notify) {
                    eventId = new EventId();
                    eventId.setEventUniqueID(opId.getOperationId());
                    eventId.setOperationCounter(opId.getOpCounter());
                    eventId.setEventCounter(i);
                    eventContext = new EventContext();
                    eventContext.Add(EventContextFieldName.EventID, eventId);
                    operationContext.Add(OperationContextFieldName.EventContext, eventContext);
                }
                CacheAddResult result = this.Add(keys[i], cacheEntries[i], notify, operationContext);
                table.put(keys[i], (Object)result);
                continue;
            }
            catch (StateTransferException se) {
                table.put(keys[i], se);
                continue;
            }
            catch (Exception inner) {
                table.put(keys[i], (Object)new OperationFailedException(inner.getMessage(), (Throwable)inner));
                continue;
            }
            finally {
                operationContext.RemoveValueByField(OperationContextFieldName.EventContext);
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final HashMap Insert(Object[] keys, CacheEntry[] cacheEntries, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException {
        HashMap<Object, Serializable> table = new HashMap<Object, Serializable>();
        EventContext eventContext = null;
        EventId eventId = null;
        OperationID opId = operationContext.getOperatoinID();
        for (int i = 0; i < keys.length; ++i) {
            try {
                operationContext.RemoveValueByField(OperationContextFieldName.EventContext);
                if (notify) {
                    eventId = new EventId();
                    eventId.setEventUniqueID(opId.getOperationId());
                    eventId.setOperationCounter(opId.getOpCounter());
                    eventId.setEventCounter(i);
                    eventContext = new EventContext();
                    eventContext.Add(EventContextFieldName.EventID, eventId);
                    operationContext.Add(OperationContextFieldName.EventContext, eventContext);
                }
                CacheInsResultWithEntry result = this.Insert(keys[i], cacheEntries[i], notify, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
                table.put(keys[i], result);
                continue;
            }
            catch (Exception e) {
                table.put(keys[i], e);
                continue;
            }
            finally {
                operationContext.RemoveValueByField(OperationContextFieldName.EventContext);
            }
        }
        return table;
    }

    @Override
    public final HashMap Remove(Object[] keys, ItemRemoveReason removalReason, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.Remove(keys, removalReason, notify, true, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap Remove(Object[] keys, ItemRemoveReason removalReason, boolean notify, boolean isUserOperation, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        HashMap<Object, Serializable> table = new HashMap<Object, Serializable>();
        EventContext eventContext = null;
        EventId eventId = null;
        OperationID opId = operationContext.getOperatoinID();
        for (int i = 0; i < keys.length; ++i) {
            try {
                CacheEntry e;
                operationContext.RemoveValueByField(OperationContextFieldName.EventContext);
                if (notify) {
                    eventId = new EventId();
                    eventId.setEventUniqueID(opId.getOperationId());
                    eventId.setOperationCounter(opId.getOpCounter());
                    eventId.setEventCounter(i);
                    eventContext = new EventContext();
                    eventContext.Add(EventContextFieldName.EventID, eventId);
                    operationContext.Add(OperationContextFieldName.EventContext, eventContext);
                }
                if ((e = this.Remove(keys[i], removalReason, notify, null, 0L, LockAccessType.IGNORE_LOCK, operationContext)) == null) continue;
                table.put(keys[i], e);
                continue;
            }
            catch (StateTransferException e) {
                table.put(keys[i], e);
                continue;
            }
            finally {
                operationContext.RemoveValueByField(OperationContextFieldName.EventContext);
            }
        }
        return table;
    }

    public void ClearInternal() {
    }

    public boolean ContainsInternal(Object key) throws CacheException {
        return false;
    }

    public CacheEntry GetInternal(Object key, boolean isUserOperation, OperationContext operationContext) throws CacheException, OperationFailedException, LockingException {
        return null;
    }

    public CacheAddResult AddInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation) throws CacheException, CacheException {
        return CacheAddResult.Failure;
    }

    public boolean AddInternal(Object key, ExpirationHint eh, OperationContext operationContext) throws CacheException, LockingException, ClassNotFoundException, OperationFailedException {
        return false;
    }

    public boolean RemoveInternal(Object key, ExpirationHint eh) throws OperationFailedException, CacheException, LockingException, GeneralFailureException, StateTransferException {
        return false;
    }

    public boolean AddInternal(Object key, CacheSyncDependency syncDependency) throws CacheException {
        return false;
    }

    public CacheInsResult InsertInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation, CacheEntry oldEntry, OperationContext operationContext) throws CacheException, LockingException, ClassNotFoundException, OperationFailedException, CacheException {
        return CacheInsResult.Failure;
    }

    public CacheEntry RemoveInternal(Object key, ItemRemoveReason removalReason, boolean isUserOperation, OperationContext operationContext) throws OperationFailedException, CacheException, LockingException, GeneralFailureException, StateTransferException {
        return null;
    }

    public QueryContext SearchInternal(Predicate pred, Map values) throws CacheException {
        return null;
    }

    public Map SearchEntriesInternal(Predicate pred, Map values) {
        return null;
    }

    public QueryContext DeleteQueryInternal(Predicate pred, Map values) throws Exception {
        return null;
    }

    public CacheEntry GetEntryInternal(Object key, boolean isUserOperation) throws CacheException {
        return null;
    }

    public void Evict() {
    }

    @Override
    public void RegisterKeyNotification(String[] keys, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException, CacheException, LockingException, GeneralFailureException {
        if (keys != null) {
            for (String key : keys) {
                if (key == null) continue;
                this.RegisterKeyNotification(key, updateCallback, removeCallback, operationContext);
            }
        }
    }

    @Override
    public void RegisterKeyNotification(String key, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException, CacheException, LockingException, GeneralFailureException {
        CacheEntry entry = this.Get(key, operationContext);
        if (entry != null) {
            if (!this.IsDoOperation(key, this.getContext().getBridgeConflictMgr(), operationContext, BridgeItemOpCodes.RegisterKeyNotification, entry)) {
                return;
            }
            entry.AddCallbackInfo(updateCallback, removeCallback);
        }
    }

    @Override
    public void UnregisterKeyNotification(String[] keys, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (keys != null) {
            for (String key : keys) {
                this.UnregisterKeyNotification(key, updateCallback, removeCallback, operationContext);
            }
        }
    }

    @Override
    public void UnregisterKeyNotification(String key, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        try {
            CacheEntry entry = this.Get(key, operationContext);
            if (entry != null) {
                if (!this.IsDoOperation(key, this.getContext().getBridgeConflictMgr(), operationContext, BridgeItemOpCodes.UnregisterKeyNotification, entry)) {
                    return;
                }
                entry.RemoveCallbackInfo(updateCallback, removeCallback);
            }
        }
        catch (StateTransferException stateTransferException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Reduction GetPreparedReduction(String query) throws com.alachisoft.ncache.runtime.exceptions.ParserException {
        Reduction reduction = null;
        HashMap hashMap = this._preparedQueryTable;
        synchronized (hashMap) {
            if (this._preparedQueryTable.containsKey(query)) return (Reduction)this._preparedQueryTable.get(query);
            ParserHelper parser = new ParserHelper(this.getInternalCache().getNCacheLog());
            if (parser.Parse(query) != ParseMessage.Accept) throw new com.alachisoft.ncache.runtime.exceptions.ParserException("Incorrect query format");
            reduction = parser.getCurrentReduction();
            this.AddPreparedReduction(query, reduction);
            return reduction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RemoveReduction(String query) {
        HashMap hashMap = this._preparedQueryTable;
        synchronized (hashMap) {
            this._preparedQueryTable.remove(query);
        }
    }

    private void AddPreparedReduction(String query, Reduction currentReduction) {
        this._preparedQueryTable.put(new QueryIdentifier(query), currentReduction);
        if (this._preparedQueryTable.size() > this._preparedQueryTableSize) {
            ArrayList list = new ArrayList(this._preparedQueryTable.keySet());
            Collections.sort(list);
            int evictCount = this._preparedQueryTable.size() * this._preparedQueryEvictionPercentage / 100;
            for (int i = 0; i < evictCount; ++i) {
                this._preparedQueryTable.remove(list.get(i));
            }
        }
    }

    @Override
    public boolean OpenStream(String key, String lockHandle, StreamModes mode, String group, String subGroup, ExpirationHint hint, EvictionHint evictinHint, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StreamException, CacheException {
        boolean lockAcquired = false;
        CacheEntry entry = null;
        entry = this.GetInternal(key, false, operationContext);
        if (entry != null) {
            if (!CacheHelper.CheckDataGroupsCompatibility(new GroupInfo(group, subGroup), entry.getGroupInfo())) {
                throw new OperationFailedException("Data group of the stream does not match the existing stream's data group");
            }
            if (!this.IsDoOperation(key, this.getContext().getBridgeConflictMgr(), operationContext, BridgeItemOpCodes.OpenStream, entry)) {
                return false;
            }
        }
        switch (mode) {
            case Read: {
                if (entry == null) {
                    throw new StreamNotFoundException("Stream not found in the cache.");
                }
                lockAcquired = entry.getRWLockManager().AcquireReaderLock(lockHandle);
                break;
            }
            case ReadWithoutLock: {
                if (entry == null) {
                    throw new StreamNotFoundException("Stream not found in the cache.");
                }
                lockAcquired = true;
                break;
            }
            case Write: {
                if (entry == null) {
                    entry = new CacheEntry(new byte[0], hint, evictinHint);
                    if (operationContext.Contains(OperationContextFieldName.BridgeOpTimeStamp)) {
                        entry.setBridgeOpTimeStamp((HPTime)operationContext.GetValueByField(OperationContextFieldName.BridgeOpTimeStamp));
                    }
                    entry.setGroupInfo(new GroupInfo(group, subGroup));
                    lockAcquired = entry.getRWLockManager().AcquireWriterLock(lockHandle);
                    if (lockAcquired) {
                        this.Insert((Object)key, entry, true, true, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
                    }
                    return lockAcquired;
                }
                lockAcquired = entry.getRWLockManager().AcquireWriterLock(lockHandle);
            }
        }
        if (!lockAcquired) {
            throw new StreamAlreadyLockedException("Stream is already locked.");
        }
        return lockAcquired;
    }

    @Override
    public void CloseStream(String key, String lockHandle, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StreamException, StateTransferException, CacheException {
        CacheEntry entry = null;
        entry = this.GetInternal(key, false, operationContext);
        if (entry != null) {
            if (!this.IsDoOperation(key, this.getContext().getBridgeConflictMgr(), operationContext, BridgeItemOpCodes.CloseStream, entry)) {
                return;
            }
            LockMode mode = entry.getRWLockManager().getMode();
            switch (mode) {
                case Reader: {
                    if (lockHandle != null && !entry.getRWLockManager().ValidateLock(LockMode.Reader, lockHandle)) {
                        throw new StreamInvalidLockException();
                    }
                    entry.getRWLockManager().ReleaseReaderLock(lockHandle);
                    break;
                }
                case Write: {
                    if (lockHandle != null && !entry.getRWLockManager().ValidateLock(LockMode.Write, lockHandle)) {
                        throw new StreamInvalidLockException();
                    }
                    entry.getRWLockManager().ReleaseWriterLock(lockHandle);
                }
            }
        }
    }

    @Override
    public int ReadFromStream(RefObject<VirtualArray> vBuffer, String key, String lockHandle, int offset, int length, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StreamException, CacheException {
        CacheEntry entry = this.Get(key, true, operationContext);
        if (entry != null) {
            if (!DotNetToJavaStringHelper.isNullOrEmpty((String)lockHandle) && !entry.getRWLockManager().ValidateLock(LockMode.Reader, lockHandle)) {
                throw new StreamInvalidLockException();
            }
        } else {
            throw new StreamNotFoundException();
        }
        vBuffer.argvalue = entry.Read(offset, length);
        return (int)((VirtualArray)vBuffer.argvalue).getSize();
    }

    @Override
    public void WriteToStream(String key, String lockHandle, VirtualArray vBuffer, int srcOffset, int dstOffset, int length, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StreamException, CacheException {
        CacheEntry entry = null;
        entry = this.GetInternal(key, false, operationContext);
        if (entry != null) {
            if (lockHandle == null || !entry.getRWLockManager().ValidateLock(LockMode.Write, lockHandle)) {
                throw new StreamInvalidLockException();
            }
            Object tempVar = entry.clone();
            CacheEntry cloneEntry = (CacheEntry)(tempVar instanceof CacheEntry ? tempVar : null);
            this.Remove(key, ItemRemoveReason.Removed, false, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
            cloneEntry.Write(vBuffer, srcOffset, dstOffset, length);
            cloneEntry.setBridgeOpTimeStamp((HPTime)operationContext.GetValueByField(OperationContextFieldName.BridgeOpTimeStamp));
            CacheInsResultWithEntry result = this.Insert(key, cloneEntry, false, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
            if (result != null && result.getResult() == CacheInsResult.NeedsEviction) {
                throw new CacheException("The cache is full and not enough items could be evicted.");
            }
        } else {
            throw new StreamNotFoundException();
        }
    }

    @Override
    public long GetStreamLength(String key, String lockHandle, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StreamException, StateTransferException, CacheException {
        CacheEntry entry = null;
        entry = this.GetInternal(key, false, operationContext);
        if (entry != null) {
            if (!DotNetToJavaStringHelper.isNullOrEmpty((String)lockHandle) && !entry.getRWLockManager().ValidateLock(lockHandle)) {
                throw new StreamInvalidLockException();
            }
            return entry.getLength();
        }
        throw new StreamException((Throwable)new StreamNotFoundException());
    }

    private boolean IsSameTimeStampOperation(Object key, HPTime bridgeOpTimeStamp) {
        return false;
    }

    private boolean IsDoOperation(Object key, BridgeConflictResolutionMgr conflictMgr, OperationContext operationContext, BridgeItemOpCodes bridgeOpCode, CacheEntry entry) throws OperationFailedException {
        Object tempVar;
        if (operationContext.Contains(OperationContextFieldName.OperationType) && operationContext.Contains(OperationContextFieldName.BridgeOpTimeStamp) && (OperationContextOperationType)((Object)operationContext.GetValueByField(OperationContextFieldName.OperationType)) == OperationContextOperationType.BridgeOperation) {
            CacheEntry newEntry = new CacheEntry();
            newEntry.setBridgeOpTimeStamp((HPTime)operationContext.GetValueByField(OperationContextFieldName.BridgeOpTimeStamp));
        }
        entry.setBridgeOpTimeStamp((HPTime)((tempVar = operationContext.GetValueByField(OperationContextFieldName.BridgeOpTimeStamp)) instanceof HPTime ? tempVar : null));
        return true;
    }

    private boolean IsDoOperation(Object key, BridgeConflictResolutionMgr conflictMgr, OperationContext operationContext, BridgeItemOpCodes bridgeOpCode, CacheEntry NewEntry, CacheEntry previousEntry) throws OperationFailedException {
        if (operationContext.Contains(OperationContextFieldName.OperationType) && (OperationContextOperationType)((Object)operationContext.GetValueByField(OperationContextFieldName.OperationType)) == OperationContextOperationType.BridgeOperation && previousEntry == null) {
            return true;
        }
        return true;
    }

    @Override
    public ContinuousQueryStateInfo GetContinuousQueryStateInfo() throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        ContinuousQueryStateInfo result = null;
        if (this._activeQueryAnalyzer != null) {
            result = this._activeQueryAnalyzer.GetStateInfo();
        }
        return result;
    }

    @Override
    public ArrayList<PredicateHolder> GetContinuousQueryRegisteredPredicates(String type) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        ArrayList<PredicateHolder> result = null;
        if (this._activeQueryAnalyzer != null) {
            result = this._activeQueryAnalyzer.GetPredicatesForType(type);
        }
        return result;
    }

    @Override
    public final void UnRegisterCQ(String queryId) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        this._activeQueryAnalyzer.UnRegisterPredicate(queryId);
    }

    @Override
    public final void RegisterCQ(ContinuousQuery query, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        this.SearchCQ(query, operationContext);
    }
}

