/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Topologies.Local;

import Alachisoft.NCache.Caching.AutoExpiration.AggregateExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.FixedExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.IdleExpiration;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionPolicyFactory;
import Alachisoft.NCache.Caching.EvictionPolicies.IEvictionPolicy;
import Alachisoft.NCache.Caching.EvictionPolicies.PriorityEvictionHint;
import Alachisoft.NCache.Caching.Exceptions.StateTransferException;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.Queries.ActiveQueryAnalyzer;
import Alachisoft.NCache.Caching.Topologies.CacheAddResult;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Caching.Topologies.CacheInsResult;
import Alachisoft.NCache.Caching.Topologies.ICacheEventsListener;
import Alachisoft.NCache.Caching.Topologies.Local.LocalCacheBase;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.Propagator.IAlertPropagator;
import Alachisoft.NCache.Common.ResetableIterator;
import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Storage.CacheStorageFactory;
import Alachisoft.NCache.Storage.ICacheStorage;
import Alachisoft.NCache.Storage.StoreAddResult;
import Alachisoft.NCache.Storage.StoreInsResult;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LockingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.net.InetAddress;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class LocalCache
extends LocalCacheBase
implements Runnable {
    private ICacheStorage _cacheStore;
    private IEvictionPolicy _evictionPolicy;
    private Thread _evictionThread;
    private Object _eviction_sync_mutex = new Object();
    private boolean _allowExplicitGCCollection = true;
    private boolean _notifyCacheFull = false;

    public LocalCache(Map cacheClasses, CacheBase parentCache, Map properties, ICacheEventsListener listener, CacheRuntimeContext context, ActiveQueryAnalyzer activeQueryAnalyzer) throws ConfigurationException {
        super(properties, parentCache, listener, context, activeQueryAnalyzer);
        this._stats.setClassName("local-cache");
        this.Initialize(cacheClasses, properties);
    }

    @Override
    public void dispose() {
        if (this._cacheStore != null) {
            this._cacheStore.dispose();
            this._cacheStore = null;
        }
        super.dispose();
    }

    @Override
    public void run() {
        this.EvictAysnc();
    }

    @Override
    public long getCount() {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"LocalCache.Count", (String)"");
        }
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        return this._cacheStore.getCount();
    }

    @Override
    public long getSessionCount() {
        return this._stats.getSessionCount();
    }

    @Override
    public InetAddress getServerJustLeft() {
        return null;
    }

    @Override
    public void setServerJustLeft(InetAddress value) {
    }

    @Override
    public int getServersCount() {
        return 1;
    }

    @Override
    public boolean IsServerNodeIp(Address clientAddress) {
        return false;
    }

    @Override
    public long getSize() {
        if (this._cacheStore != null) {
            return this._cacheStore.getSize();
        }
        return 0L;
    }

    @Override
    public float getEvictRatio() {
        if (this._evictionPolicy != null) {
            return this._evictionPolicy.getEvictRatio();
        }
        return 0.0f;
    }

    @Override
    public void setEvictRatio(float value) {
        if (this._evictionPolicy != null) {
            this._evictionPolicy.setEvictRatio(value);
        }
    }

    @Override
    public long getMaxSize() {
        if (this._cacheStore != null) {
            return this._cacheStore.getMaxSize();
        }
        return 0L;
    }

    @Override
    public void setMaxSize(long value) throws CacheException {
        if (this._cacheStore != null) {
            if (this._cacheStore.getSize() <= value) {
                this._cacheStore.setMaxSize(value);
                this._stats.setMaxSize(value);
            } else {
                throw new CacheException("You need to remove some data from cache before applying the new size");
            }
        }
    }

    @Override
    public boolean CanChangeCacheSize(long size) {
        return this._cacheStore.getSize() <= size;
    }

    @Override
    protected void Initialize(Map cacheClasses, Map properties) throws ConfigurationException {
        if (properties == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: properties");
        }
        try {
            super.Initialize(cacheClasses, properties);
            if (ServicePropValues.Cache_EnableGCCollection != null) {
                this._allowExplicitGCCollection = Boolean.parseBoolean(ServicePropValues.Cache_EnableGCCollection);
            }
            if (!properties.containsKey("storage")) {
                throw new ConfigurationException("Missing configuration option 'storage'");
            }
            if (properties.containsKey("scavenging-policy")) {
                Map evictionProps = properties.get("scavenging-policy") instanceof Map ? properties.get("scavenging-policy") : null;
                if (evictionProps.containsKey("eviction-enabled")) {
                    String evictionEnabled = evictionProps.get("eviction-enabled").toString();
                    String evictRatio = evictionProps.get("evict-ratio").toString();
                    Boolean createEvictionPolicy = false;
                    if (evictionEnabled != null) {
                        createEvictionPolicy = Boolean.parseBoolean(evictionEnabled);
                    }
                    if ((createEvictionPolicy = evictRatio != null && !evictRatio.toLowerCase().equals("null") ? Boolean.valueOf(createEvictionPolicy & Double.parseDouble(evictRatio) > 0.0) : Boolean.valueOf(false)).booleanValue()) {
                        this._evictionPolicy = EvictionPolicyFactory.CreateEvictionPolicy(evictionProps);
                    }
                }
            } else {
                this._evictionPolicy = EvictionPolicyFactory.CreateDefaultEvictionPolicy();
            }
            Map storageProps = properties.get("storage") instanceof Map ? properties.get("storage") : null;
            this._cacheStore = CacheStorageFactory.CreateStorageProvider((Map)storageProps, (String)this._context.getSerializationContext(), (this._evictionPolicy != null ? 1 : 0) != 0, (ILogger)this._context.getNCacheLog(), (IAlertPropagator)this._context.getEmailAlertNotifier());
            this._stats.setMaxCount(this._cacheStore.getMaxCount());
            this._stats.setMaxSize(this._cacheStore.getMaxSize());
        }
        catch (ConfigurationException e) {
            if (this._context != null) {
                this._context.getNCacheLog().Error("LocalCache.Initialize()", e.toString());
            }
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            if (this._context != null) {
                this._context.getNCacheLog().Error("LocalCache.Initialize()", e.toString());
            }
            this.dispose();
            throw new ConfigurationException("Configuration Error: " + e.toString(), (Throwable)e);
        }
    }

    @Override
    public void ClearInternal() {
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        this._cacheStore.Clear();
        if (this._evictionThread != null) {
            this.getNCacheLog().Flush();
            this._evictionThread.stop();
        }
        if (this._evictionPolicy != null) {
            this._evictionPolicy.Clear();
        }
    }

    @Override
    public boolean ContainsInternal(Object key) throws StateTransferException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"LocalCache.Cont", (String)"");
        }
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        return this._cacheStore.Contains(key);
    }

    @Override
    public CacheEntry GetInternal(Object key, boolean isUserOperation, OperationContext operationContext) throws StateTransferException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"LocalCache.Get", (String)"");
        }
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        CacheEntry e = (CacheEntry)this._cacheStore.Get(key);
        if (e != null) {
            EvictionHint evh = e.getEvictionHint();
            if (isUserOperation && this._evictionPolicy != null && evh != null && evh.getIsVariant()) {
                this._evictionPolicy.Notify(key, evh, null);
            }
        }
        return e;
    }

    @Override
    public CacheEntry GetEntryInternal(Object key, boolean isUserOperation) {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"LocalCache.GetInternal", (String)"");
        }
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        CacheEntry e = (CacheEntry)this._cacheStore.Get(key);
        if (e == null) {
            return e;
        }
        EvictionHint evh = e.getEvictionHint();
        if (isUserOperation && this._evictionPolicy != null && evh != null && evh.getIsVariant()) {
            this._evictionPolicy.Notify(key, evh, null);
        }
        return e;
    }

    @Override
    public int GetItemSize(Object key) {
        if (this._cacheStore == null) {
            return 0;
        }
        return this._cacheStore.GetItemSize(key);
    }

    @Override
    public CacheAddResult AddInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation) throws StateTransferException, CacheException {
        StoreAddResult result;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"LocalCache.Add_1", (String)"");
        }
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        if (this._evictionPolicy != null) {
            if (cacheEntry.getEvictionHint() instanceof PriorityEvictionHint) {
                cacheEntry.setPriority(((PriorityEvictionHint)cacheEntry.getEvictionHint()).getPriority());
            }
            cacheEntry.setEvictionHint(this._evictionPolicy.CompatibleHint(cacheEntry.getEvictionHint()));
        }
        if (((result = this._cacheStore.Add(key, (Object)cacheEntry)) == StoreAddResult.Success || result == StoreAddResult.SuccessNearEviction) && this._evictionPolicy != null) {
            this._evictionPolicy.Notify(key, null, cacheEntry.getEvictionHint());
        }
        if (result == StoreAddResult.NotEnoughSpace && !this._notifyCacheFull) {
            this._notifyCacheFull = true;
            this._context.getNCacheLog().Error("LocalCache.AddInternal", "The cache is full and not enough items could be evicted.");
        }
        switch (result) {
            case Success: {
                return CacheAddResult.Success;
            }
            case KeyExists: {
                return CacheAddResult.KeyExists;
            }
            case NotEnoughSpace: {
                return CacheAddResult.NeedsEviction;
            }
            case SuccessNearEviction: {
                return CacheAddResult.SuccessNearEviction;
            }
        }
        return CacheAddResult.Failure;
    }

    @Override
    public boolean AddInternal(Object key, ExpirationHint eh, OperationContext operationContext) throws StateTransferException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"LocalCache.Add_2", (String)"");
        }
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        CacheEntry e = (CacheEntry)this._cacheStore.Get(key);
        if (e == null) {
            return false;
        }
        if (e.getExpirationHint() instanceof IdleExpiration && eh instanceof FixedExpiration || e.getExpirationHint() instanceof FixedExpiration && eh instanceof IdleExpiration) {
            return false;
        }
        if (e.getExpirationHint() == null) {
            e.setExpirationHint(eh);
        } else if (e.getExpirationHint() instanceof AggregateExpirationHint) {
            ((AggregateExpirationHint)e.getExpirationHint()).Add(eh);
        } else {
            AggregateExpirationHint aeh = new AggregateExpirationHint();
            aeh.Add(e.getExpirationHint());
            aeh.Add(eh);
            e.setExpirationHint(aeh);
        }
        this._cacheStore.Insert(key, (Object)e);
        e.setLastModifiedTime(new Date());
        return true;
    }

    @Override
    public boolean RemoveInternal(Object key, ExpirationHint eh) throws StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"LocalCache.Remove", (String)"");
        }
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        CacheEntry e = (CacheEntry)this._cacheStore.Get(key);
        if (e == null || e.getExpirationHint() == null) {
            return false;
        }
        if (e.getExpirationHint() instanceof AggregateExpirationHint) {
            AggregateExpirationHint AggHint = new AggregateExpirationHint();
            AggregateExpirationHint entryExpHint = (AggregateExpirationHint)e.getExpirationHint();
            for (ExpirationHint exp : entryExpHint) {
                if (exp.equals(eh)) continue;
                AggHint.Add(exp);
            }
            e.setExpirationHint(AggHint);
        } else if (e.getExpirationHint().equals(eh)) {
            e.setExpirationHint(null);
        }
        if (this._notifyCacheFull) {
            this._notifyCacheFull = false;
        }
        this._cacheStore.Insert(key, (Object)e);
        e.setLastModifiedTime(new Date());
        return true;
    }

    @Override
    public boolean AddInternal(Object key, CacheSyncDependency syncDependency) throws StateTransferException {
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        CacheEntry e = (CacheEntry)this._cacheStore.Get(key);
        if (e == null) {
            return false;
        }
        e.setSyncDependency(syncDependency);
        this._cacheStore.Insert(key, (Object)e);
        e.setLastModifiedTime(new Date());
        return true;
    }

    @Override
    public CacheInsResult InsertInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation, CacheEntry oldEntry, OperationContext operationContext) throws StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"LocalCache.Insert", (String)"");
        }
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        if (cacheEntry.getEvictionHint() instanceof PriorityEvictionHint) {
            cacheEntry.setPriority(((PriorityEvictionHint)cacheEntry.getEvictionHint()).getPriority());
        }
        if (this._evictionPolicy != null) {
            cacheEntry.setEvictionHint(this._evictionPolicy.CompatibleHint(cacheEntry.getEvictionHint()));
        }
        EvictionHint peEvh = oldEntry == null ? null : oldEntry.getEvictionHint();
        StoreInsResult result = this._cacheStore.Insert(key, (Object)cacheEntry);
        if (result == StoreInsResult.Success || result == StoreInsResult.SuccessNearEviction) {
            if (this._evictionPolicy != null) {
                this._evictionPolicy.Notify(key, null, cacheEntry.getEvictionHint());
            }
        } else if (result == StoreInsResult.SuccessOverwrite || result == StoreInsResult.SuccessOverwriteNearEviction) {
            if (isUserOperation) {
                cacheEntry.UpdateVersion(oldEntry);
            }
            cacheEntry.UpdateLastModifiedTime(oldEntry);
            if (this._evictionPolicy != null) {
                this._evictionPolicy.Notify(key, peEvh, cacheEntry.getEvictionHint());
            }
        }
        if (result == StoreInsResult.NotEnoughSpace && !this._notifyCacheFull) {
            this._notifyCacheFull = true;
            this._context.getNCacheLog().Error("LocalCache.InsertInternal", "The cache is full and not enough items could be evicted.");
        }
        switch (result) {
            case Success: {
                return CacheInsResult.Success;
            }
            case SuccessOverwrite: {
                return CacheInsResult.SuccessOverwrite;
            }
            case NotEnoughSpace: {
                return CacheInsResult.NeedsEviction;
            }
            case SuccessNearEviction: {
                return CacheInsResult.SuccessNearEvicition;
            }
            case SuccessOverwriteNearEviction: {
                return CacheInsResult.SuccessOverwriteNearEviction;
            }
        }
        return CacheInsResult.Failure;
    }

    @Override
    public CacheEntry RemoveInternal(Object key, ItemRemoveReason removalReason, boolean isUserOperation, OperationContext operationContext) throws StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"LocalCache.Remove", (String)"");
        }
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        CacheEntry e = (CacheEntry)this._cacheStore.Remove(key);
        if (e != null) {
            if (this._evictionPolicy != null) {
                this._evictionPolicy.Remove(key, e.getEvictionHint());
            }
            if (this._notifyCacheFull) {
                this._notifyCacheFull = false;
            }
        }
        return e;
    }

    @Override
    public ResetableIterator GetEnumerator() throws OperationFailedException, LockingException, GeneralFailureException {
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        return new ResetableCacheStoreIterator(this._cacheStore);
    }

    @Override
    public Object[] getKeys() {
        if (this._cacheStore == null) {
            throw new UnsupportedOperationException();
        }
        return this._cacheStore.getKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Evict() {
        if (this._evictionPolicy == null) {
            return;
        }
        Object object = this._eviction_sync_mutex;
        synchronized (object) {
            if (this._parentCache.getIsEvictionAllowed()) {
                if (this._allowAsyncEviction) {
                    if (this._evictionThread == null) {
                        this._evictionThread = new Thread(this);
                        this._evictionThread.setDaemon(true);
                        this._evictionThread.start();
                    }
                } else {
                    this.DoEvict(this);
                }
            }
        }
    }

    private void DoEvict(CacheBase cache) {
        if (this._evictionPolicy != null) {
            this._evictionPolicy.Execute(cache, this._context, this.getSize());
            if (this._allowExplicitGCCollection) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void EvictAysnc() {
        try {
            if (!this.getIsSelfInternal()) {
                this.DoEvict(this._context.getCacheImpl());
            } else {
                this.DoEvict(this._context.getCacheInternal());
            }
        }
        catch (Exception e) {
            if (this._context != null) {
                this._context.getNCacheLog().Error("LocalCache._evictionRun", e.toString());
            }
        }
        finally {
            Object object = this._eviction_sync_mutex;
            synchronized (object) {
                this._evictionThread = null;
            }
        }
    }

    class ResetableCacheStoreIterator
    implements ResetableIterator {
        public ICacheStorage cacheStore;
        Iterator iter;

        public ResetableCacheStoreIterator(ICacheStorage cacheStore) {
            this.cacheStore = cacheStore;
            this.iter = cacheStore.GetEnumerator();
        }

        public void reset() {
            this.iter = this.cacheStore.GetEnumerator();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return this.iter.next();
        }

        public void remove() {
            this.iter.remove();
        }
    }
}

