/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Topologies.Local;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency;
import Alachisoft.NCache.Caching.Exceptions.StateTransferException;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.Queries.ActiveQueryAnalyzer;
import Alachisoft.NCache.Caching.Statistics.BucketStatistics;
import Alachisoft.NCache.Caching.Topologies.CacheAddResult;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Caching.Topologies.CacheInsResult;
import Alachisoft.NCache.Caching.Topologies.ICacheEventsListener;
import Alachisoft.NCache.Caching.Topologies.Local.IndexedOverflowCache;
import Alachisoft.NCache.Caching.Topologies.Local.LogMode;
import Alachisoft.NCache.Caching.Topologies.Local.OpLogManager;
import Alachisoft.NCache.Caching.Topologies.OperationType;
import Alachisoft.NCache.Common.AppUtil;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.LockingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tangible.RefObject;

public class HashedOverflowCache
extends IndexedOverflowCache {
    private int _bucketSize;
    private HashMap _keyList;
    private HashMap _operationLoggers;
    private OpLogManager _logMgr;
    private int _stopLoggingThreshhold = 50;
    private boolean _logEntries;

    public HashedOverflowCache(Map cacheClasses, CacheBase parentCache, Map properties, ICacheEventsListener listener, CacheRuntimeContext context, boolean logEntries, ActiveQueryAnalyzer activeQueryAnalyzer) throws ConfigurationException {
        super(cacheClasses, parentCache, properties, listener, context, activeQueryAnalyzer);
        this._logMgr = new OpLogManager(logEntries, context);
        this._logEntries = logEntries;
    }

    @Override
    public void setBucketSize(int value) {
        this._bucketSize = value;
    }

    @Override
    public ArrayList GetKeyList(int bucketId, boolean startLogging) {
        if (startLogging) {
            this._logMgr.StartLogging(bucketId, LogMode.LogBeforeAfterActualOperation);
        }
        if (this._keyList != null) {
            if (this._keyList.containsKey(bucketId)) {
                HashMap keyTbl = this._keyList.get(bucketId) instanceof HashMap ? this._keyList.get(bucketId) : null;
                return new ArrayList(keyTbl.keySet());
            }
            return null;
        }
        return null;
    }

    @Override
    public HashMap GetLogTable(ArrayList bucketIds, RefObject<Boolean> isLoggingStopped) {
        HashMap result = null;
        int logCount = 0;
        Iterator ie = bucketIds.iterator();
        while (ie.hasNext()) {
            HashMap tmp = this._logMgr.GetLogTable((Integer)ie.next());
            if (tmp == null) continue;
            if (result == null) {
                result = tmp;
                continue;
            }
            ArrayList removed = tmp.get("removed") instanceof ArrayList ? tmp.get("removed") : null;
            ArrayList updated = tmp.get("updated") instanceof ArrayList ? tmp.get("updated") : null;
            if (removed != null) {
                ((ArrayList)result.get("removed")).addAll(removed);
                logCount += removed.size();
            }
            if (updated == null) continue;
            ((ArrayList)result.get("updated")).addAll(updated);
            logCount += updated.size();
        }
        if (logCount < this._stopLoggingThreshhold) {
            isLoggingStopped.argvalue = true;
            this._logMgr.StopLogging(bucketIds);
        } else {
            isLoggingStopped.argvalue = false;
        }
        return result;
    }

    @Override
    public void RemoveFromLogTbl(int bucketId) {
        if (this._logMgr != null) {
            this._logMgr.RemoveLogger(bucketId);
        }
    }

    @Override
    public void RemoveBucket(int bucket) throws LockingException, StateTransferException, ClassNotFoundException, IOException, OperationFailedException {
        if (this.getContext().getNCacheLog().getIsInfoEnabled()) {
            this.getContext().getNCacheLog().Info("HashedCache.RemoveBucket", "removing bucket :" + bucket);
        }
        this.getLocalBuckets()[bucket] = null;
        this.RemoveBucketData(bucket);
        this.RemoveFromLogTbl(bucket);
    }

    @Override
    public void RemoveBucketData(int bucketId) throws LockingException, StateTransferException, OperationFailedException {
    }

    @Override
    public void UpdateLocalBuckets(ArrayList bucketIds) {
        Iterator ie = bucketIds.iterator();
        while (ie.hasNext()) {
            if (this.getLocalBuckets() == null) {
                this.setLocalBuckets(new BucketStatistics[1000]);
            }
            if (this.getLocalBuckets()[(Integer)ie.next()] != null) continue;
            this.getLocalBuckets()[((Integer)ie.next()).intValue()] = new BucketStatistics();
        }
    }

    @Override
    public void StartLogging(int bucketId) {
        if (this._logMgr != null) {
            this._logMgr.StartLogging(bucketId, LogMode.LogBeforeActualOperation);
        }
    }

    private void IncrementBucketStats(String key, int bucketId, long dataSize) {
        if (this._stats.getLocalBuckets()[bucketId] != null) {
            this._stats.getLocalBuckets()[bucketId].Increment(dataSize);
        }
        if (this._keyList == null) {
            this._keyList = new HashMap();
        }
        if (this._keyList.containsKey(bucketId)) {
            HashMap keys = (HashMap)this._keyList.get(bucketId);
            keys.put(key, null);
        } else {
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put(key, null);
            this._keyList.put(bucketId, keys);
        }
    }

    private void DecrementBucketStats(String key, int bucketId, long dataSize) {
        if (this._stats.getLocalBuckets()[bucketId] != null) {
            this._stats.getLocalBuckets()[bucketId].Decrement(dataSize);
        }
        if (this._keyList != null && this._keyList.containsKey(bucketId)) {
            HashMap keys = (HashMap)this._keyList.get(bucketId);
            keys.remove(key);
            if (keys.isEmpty()) {
                this._keyList.remove(bucketId);
            }
        }
    }

    private boolean IsBucketTransfered(int bucketId) {
        return !this._logMgr.IsOperationAllowed(bucketId);
    }

    private int GetBucketId(String key) {
        int hashCode = AppUtil.hashCode((String)key);
        int bucketId = hashCode / this._bucketSize;
        if (bucketId < 0) {
            bucketId *= -1;
        }
        return bucketId;
    }

    @Override
    public BucketStatistics[] getLocalBuckets() {
        return this._stats.getLocalBuckets();
    }

    @Override
    public void setLocalBuckets(BucketStatistics[] value) {
        this._stats.setLocalBuckets(value);
    }

    @Override
    public void AddLoggedData(ArrayList bucketIds) {
    }

    @Override
    public void dispose() {
        if (this._logMgr != null) {
            this._logMgr.dispose();
        }
        if (this._keyList != null) {
            this._keyList.clear();
        }
        super.dispose();
    }

    @Override
    public CacheAddResult AddInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation) throws StateTransferException, CacheException {
        int bucketId = this.GetBucketId((String)(key instanceof String ? key : null));
        if (this.IsBucketTransfered(bucketId)) {
            throw new StateTransferException("I am no more the owner of this bucket");
        }
        if (this._logMgr.IsLoggingEnbaled(bucketId, LogMode.LogBeforeActualOperation) && isUserOperation) {
            this._logMgr.LogOperation(bucketId, key, cacheEntry, OperationType.Add);
            return CacheAddResult.Success;
        }
        CacheAddResult result = super.AddInternal(key, cacheEntry, isUserOperation);
        if (result == CacheAddResult.Success || result == CacheAddResult.SuccessNearEviction) {
            this.IncrementBucketStats((String)(key instanceof String ? key : null), bucketId, cacheEntry.getDataSize());
            if (isUserOperation) {
                this._logMgr.LogOperation(bucketId, key, cacheEntry, OperationType.Add);
            }
        }
        return result;
    }

    @Override
    public boolean AddInternal(Object key, ExpirationHint eh, OperationContext operationContext) {
        return super.AddInternal(key, eh, operationContext);
    }

    @Override
    public boolean AddInternal(Object key, CacheSyncDependency syncDependency) throws StateTransferException, CacheException {
        int bucketId = this.GetBucketId((String)(key instanceof String ? key : null));
        if (this.IsBucketTransfered(bucketId)) {
            throw new StateTransferException("I am no more the owner of this bucket");
        }
        return super.AddInternal(key, syncDependency);
    }

    @Override
    public void ClearInternal() {
        super.ClearInternal();
        if (this._keyList != null) {
            this._keyList.clear();
        }
        if (this._logMgr != null) {
            this._logMgr.dispose();
        }
        for (int i = 0; i < this.getLocalBuckets().length; ++i) {
            BucketStatistics stats = this.getLocalBuckets()[i];
            if (stats == null) continue;
            stats.Clear();
        }
    }

    @Override
    public CacheInsResult InsertInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation, CacheEntry oldEntry, OperationContext operationContext) {
        return null;
    }

    @Override
    public CacheEntry RemoveInternal(Object key, ItemRemoveReason removalReason, boolean isUserOperation, OperationContext operationContext) {
        return null;
    }

    @Override
    public CacheEntry GetInternal(Object key, boolean isUserOperation, OperationContext operationContext) {
        return null;
    }

    @Override
    public boolean ContainsInternal(Object key) throws StateTransferException, CacheException {
        int bucketId = this.GetBucketId((String)(key instanceof String ? key : null));
        if (this.IsBucketTransfered(bucketId)) {
            throw new StateTransferException("I am no more the owner of this bucket");
        }
        return super.ContainsInternal(key);
    }
}

