/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Topologies.Local;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency;
import Alachisoft.NCache.Caching.Exceptions.StateTransferException;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Queries.ActiveQueryAnalyzer;
import Alachisoft.NCache.Caching.Statistics.BucketStatistics;
import Alachisoft.NCache.Caching.Topologies.CacheAddResult;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Caching.Topologies.CacheInsResult;
import Alachisoft.NCache.Caching.Topologies.ICacheEventsListener;
import Alachisoft.NCache.Caching.Topologies.Local.IndexedLocalCache;
import Alachisoft.NCache.Caching.Topologies.Local.LogMode;
import Alachisoft.NCache.Caching.Topologies.Local.OpLogManager;
import Alachisoft.NCache.Caching.Topologies.OperationType;
import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LockingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tangible.RefObject;

public class HashedLocalCache
extends IndexedLocalCache {
    private int _bucketSize;
    private HashMap _keyList;
    private int _stopLoggingThreshhold = 50;
    private OpLogManager _logMgr;

    public HashedLocalCache(Map cacheClasses, CacheBase parentCache, Map properties, ICacheEventsListener listener, CacheRuntimeContext context, boolean logEntries, ActiveQueryAnalyzer activeQueryAnalyzer) throws ConfigurationException {
        super(cacheClasses, parentCache, properties, listener, context, activeQueryAnalyzer);
        this._logMgr = new OpLogManager(logEntries, context);
        this._stats.setLocalBuckets(new BucketStatistics[1000]);
    }

    @Override
    public void setBucketSize(int value) {
        this._bucketSize = value;
    }

    @Override
    public BucketStatistics[] getLocalBuckets() {
        return this._stats.getLocalBuckets();
    }

    @Override
    public void setLocalBuckets(BucketStatistics[] value) {
        this._stats.setLocalBuckets(value);
    }

    @Override
    public ArrayList GetKeyList(int bucketId, boolean startLogging) {
        if (startLogging) {
            this._logMgr.StartLogging(bucketId, LogMode.LogBeforeAfterActualOperation);
        }
        if (this._keyList != null) {
            if (this._keyList.containsKey(bucketId)) {
                HashMap keyTbl = this._keyList.get(bucketId) instanceof HashMap ? this._keyList.get(bucketId) : null;
                return new ArrayList(keyTbl.keySet());
            }
            return null;
        }
        return null;
    }

    @Override
    public void StartLogging(int bucketId) {
        if (this._logMgr != null) {
            this._logMgr.StartLogging(bucketId, LogMode.LogBeforeActualOperation);
        }
    }

    @Override
    public HashMap GetLogTable(ArrayList bucketIds, RefObject<Boolean> isLoggingStopped) {
        HashMap result = null;
        int logCount = 0;
        Iterator ie = bucketIds.iterator();
        while (ie.hasNext()) {
            HashMap tmp = this._logMgr.GetLogTable((Integer)ie.next());
            if (tmp == null) continue;
            if (result == null) {
                result = tmp;
                continue;
            }
            ArrayList removed = tmp.get("removed") instanceof ArrayList ? tmp.get("removed") : null;
            ArrayList updated = tmp.get("updated") instanceof ArrayList ? tmp.get("updated") : null;
            if (removed != null) {
                ((ArrayList)result.get("removed")).addAll(removed);
                logCount += removed.size();
            }
            if (updated == null) continue;
            ((ArrayList)result.get("updated")).addAll(updated);
            logCount += updated.size();
        }
        if (logCount < this._stopLoggingThreshhold) {
            isLoggingStopped.argvalue = true;
            this._logMgr.StopLogging(bucketIds);
        } else {
            isLoggingStopped.argvalue = false;
        }
        return result;
    }

    private void IncrementBucketStats(String key, int bucketId, long dataSize) {
        if (this._stats.getLocalBuckets() != null && this._stats.getLocalBuckets()[bucketId] != null) {
            this._stats.getLocalBuckets()[bucketId].Increment(dataSize);
        }
        if (this._keyList == null) {
            this._keyList = new HashMap();
        }
        if (this._keyList.containsKey(bucketId)) {
            HashMap keys = (HashMap)this._keyList.get(bucketId);
            keys.put(key, null);
        } else {
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put(key, null);
            this._keyList.put(bucketId, keys);
        }
    }

    private void DecrementBucketStats(String key, int bucketId, long dataSize) {
        if (this._stats.getLocalBuckets() != null && this._stats.getLocalBuckets()[bucketId] != null) {
            this._stats.getLocalBuckets()[bucketId].Decrement(dataSize);
        }
        if (this._keyList != null && this._keyList.containsKey(bucketId)) {
            HashMap keys = (HashMap)this._keyList.get(bucketId);
            keys.remove(key);
            if (keys.isEmpty()) {
                this._keyList.remove(bucketId);
            }
        }
    }

    private int GetBucketId(String key) {
        int hashCode = AppUtil.hashCode((String)key);
        int bucketId = hashCode / this._bucketSize;
        if (bucketId < 0) {
            bucketId *= -1;
        }
        return bucketId;
    }

    @Override
    public void RemoveFromLogTbl(int bucketId) {
        if (this._logMgr != null) {
            this._logMgr.RemoveLogger(bucketId);
        }
    }

    @Override
    public void AddLoggedData(ArrayList bucketIds) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (bucketIds != null) {
            for (Object next : bucketIds) {
                if (this._logMgr == null) continue;
                HashMap loggedEnteries = this._logMgr.GetLoggedEnteries((Integer)next);
                if (loggedEnteries != null && loggedEnteries.size() > 0) {
                    Object Value;
                    Object Key;
                    HashMap removed = loggedEnteries.get("removed") instanceof HashMap ? loggedEnteries.get("removed") : null;
                    HashMap updated = loggedEnteries.get("updated") instanceof HashMap ? loggedEnteries.get("updated") : null;
                    if (removed != null && removed.size() > 0) {
                        for (Map.Entry KeyValue : removed.entrySet()) {
                            Key = KeyValue.getKey();
                            Value = KeyValue.getValue();
                            this.Remove(Key, ItemRemoveReason.Removed, false, null, 0L, LockAccessType.IGNORE_LOCK, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                        }
                    }
                    if (updated != null && updated.size() > 0) {
                        for (Map.Entry KeyValue : updated.entrySet()) {
                            Key = KeyValue.getKey();
                            Value = KeyValue.getValue();
                            CacheEntry entry = (CacheEntry)(Value instanceof CacheEntry ? Value : null);
                            if (entry == null) continue;
                            this.Add(Key, entry, false, false, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                        }
                    }
                }
                this._logMgr.RemoveLogger((Integer)next);
            }
        }
    }

    @Override
    public void RemoveBucketData(int bucketId) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        ArrayList keys = this.GetKeyList(bucketId, false);
        if (keys != null) {
            Object tempVar = keys.clone();
            keys = (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
            for (Object obj : keys) {
                if (obj == null) continue;
                this.Remove(obj, ItemRemoveReason.Removed, false, false, null, 0L, LockAccessType.IGNORE_LOCK, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
            }
            this._context.PerfStatsColl.incrementStateTxfrPerSecStatsBy(keys.size());
        }
    }

    @Override
    public void RemoveBucket(int bucket) throws LockingException, StateTransferException, OperationFailedException, GeneralFailureException, CacheException {
        if (this.getContext().getNCacheLog().getIsInfoEnabled()) {
            this.getContext().getNCacheLog().Info("HashedCache.RemoveBucket", "removing bucket :" + bucket);
        }
        if (this.getLocalBuckets() != null) {
            this.getLocalBuckets()[bucket] = null;
        }
        this.RemoveBucketData(bucket);
        this.RemoveFromLogTbl(bucket);
    }

    @Override
    public void RemoveExtraBuckets(ArrayList myBuckets) throws LockingException, StateTransferException, OperationFailedException, GeneralFailureException, CacheException {
        for (int i = 0; i < 1000; ++i) {
            if (myBuckets.contains(i)) continue;
            this.RemoveBucket(i);
        }
    }

    @Override
    public void UpdateLocalBuckets(ArrayList bucketIds) {
        for (int i = 0; i < bucketIds.size(); ++i) {
            if (this.getLocalBuckets() == null) {
                this.setLocalBuckets(new BucketStatistics[1000]);
            }
            if (this.getLocalBuckets()[(Integer)bucketIds.get(i)] != null) continue;
            this.getLocalBuckets()[((Integer)bucketIds.get((int)i)).intValue()] = new BucketStatistics();
        }
    }

    @Override
    public CacheAddResult AddInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation) throws StateTransferException, CacheException {
        int bucketId = this.GetBucketId((String)(key instanceof String ? key : null));
        if (this._logMgr.IsOperationAllowed(bucketId) && this.getLocalBuckets()[bucketId] != null) {
            if (this._logMgr.IsLoggingEnbaled(bucketId, LogMode.LogBeforeActualOperation) && isUserOperation) {
                this._logMgr.LogOperation(bucketId, key, cacheEntry, OperationType.Add);
                return CacheAddResult.Success;
            }
            CacheEntry clone = (CacheEntry)cacheEntry.clone();
            CacheAddResult result = super.AddInternal(key, cacheEntry, isUserOperation);
            if (result == CacheAddResult.Success || result == CacheAddResult.SuccessNearEviction) {
                this.IncrementBucketStats((String)(key instanceof String ? key : null), bucketId, clone.getDataSize());
                if (isUserOperation) {
                    this._logMgr.LogOperation(bucketId, key, clone, OperationType.Add);
                }
            }
            return result;
        }
        throw new StateTransferException("I am no more the owner of this bucket");
    }

    @Override
    public boolean AddInternal(Object key, ExpirationHint eh, OperationContext operationContext) throws StateTransferException {
        int bucketId = this.GetBucketId((String)(key instanceof String ? key : null));
        if (this._logMgr.IsOperationAllowed(bucketId) && this.getLocalBuckets()[bucketId] != null) {
            return super.AddInternal(key, eh, operationContext);
        }
        throw new StateTransferException("I am no more the owner of this bucket");
    }

    @Override
    public boolean RemoveInternal(Object key, ExpirationHint eh) throws StateTransferException, CacheException {
        int bucketId = this.GetBucketId((String)(key instanceof String ? key : null));
        if (this._logMgr.IsOperationAllowed(bucketId) && this.getLocalBuckets()[bucketId] != null) {
            return super.RemoveInternal(key, eh);
        }
        throw new StateTransferException("I am no more the owner of this bucket");
    }

    @Override
    public boolean AddInternal(Object key, CacheSyncDependency syncDependency) throws StateTransferException {
        int bucketId = this.GetBucketId((String)(key instanceof String ? key : null));
        if (this._logMgr.IsOperationAllowed(bucketId) && this.getLocalBuckets()[bucketId] != null) {
            return super.AddInternal(key, syncDependency);
        }
        throw new StateTransferException("I am no more the owner of this bucket");
    }

    @Override
    public CacheInsResult InsertInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation, CacheEntry oldEntry, OperationContext operationContext) throws StateTransferException, CacheException {
        int bucketId = this.GetBucketId((String)(key instanceof String ? key : null));
        Object opLogger = null;
        if (this._logMgr.IsOperationAllowed(bucketId) && this.getLocalBuckets()[bucketId] != null) {
            long oldEntrysize;
            long l = oldEntrysize = oldEntry == null ? 0L : oldEntry.getDataSize();
            if (this._logMgr.IsLoggingEnbaled(bucketId, LogMode.LogBeforeActualOperation) && isUserOperation) {
                this._logMgr.LogOperation(bucketId, key, cacheEntry, OperationType.Insert);
                return oldEntry != null ? CacheInsResult.SuccessOverwrite : CacheInsResult.Success;
            }
            CacheEntry clone = (CacheEntry)cacheEntry.clone();
            CacheInsResult result = super.InsertInternal(key, cacheEntry, isUserOperation, oldEntry, operationContext);
            switch (result) {
                case SuccessNearEvicition: 
                case Success: {
                    if (isUserOperation) {
                        this._logMgr.LogOperation(bucketId, key, clone, OperationType.Insert);
                    }
                    this.IncrementBucketStats((String)(key instanceof String ? key : null), bucketId, cacheEntry.getDataSize());
                    break;
                }
                case SuccessOverwriteNearEviction: 
                case SuccessOverwrite: {
                    if (isUserOperation) {
                        this._logMgr.LogOperation(bucketId, key, clone, OperationType.Insert);
                    }
                    this.DecrementBucketStats((String)(key instanceof String ? key : null), bucketId, oldEntrysize);
                    this.IncrementBucketStats((String)(key instanceof String ? key : null), bucketId, cacheEntry.getDataSize());
                }
            }
            return result;
        }
        throw new StateTransferException("I am no more the owner of this bucket");
    }

    @Override
    public CacheEntry RemoveInternal(Object key, ItemRemoveReason removalReason, boolean isUserOperation, OperationContext operationContext) throws OperationFailedException, CacheException {
        int bucketId = this.GetBucketId((String)(key instanceof String ? key : null));
        if (isUserOperation && (!this._logMgr.IsOperationAllowed(bucketId) || this.getLocalBuckets()[bucketId] == null)) {
            throw new StateTransferException("I am no more the owner of this bucket");
        }
        if (this._logMgr.IsLoggingEnbaled(bucketId, LogMode.LogBeforeActualOperation) && isUserOperation) {
            CacheEntry e = null;
            try {
                e = this.Get(key, operationContext);
            }
            catch (LockingException lockingException) {
                throw new OperationFailedException((Throwable)lockingException);
            }
            this._logMgr.LogOperation(bucketId, key, null, OperationType.Delete);
            return e;
        }
        CacheEntry entry = null;
        entry = super.RemoveInternal(key, removalReason, isUserOperation, operationContext);
        if (entry != null) {
            this.DecrementBucketStats((String)(key instanceof String ? key : null), bucketId, entry.getDataSize());
            if (isUserOperation) {
                this._logMgr.LogOperation(bucketId, key, null, OperationType.Delete);
            }
        }
        return entry;
    }

    @Override
    public CacheEntry GetInternal(Object key, boolean isUserOperation, OperationContext operationContext) throws StateTransferException {
        int bucketId = this.GetBucketId((String)(key instanceof String ? key : null));
        if (isUserOperation && !this._logMgr.IsOperationAllowed(bucketId)) {
            throw new StateTransferException("I am no more the owner of this bucket");
        }
        CacheEntry entry = super.GetInternal(key, isUserOperation, operationContext);
        if (entry == null && isUserOperation && this.getLocalBuckets()[bucketId] == null) {
            throw new StateTransferException("I am no more the owner of this bucket");
        }
        return entry;
    }

    @Override
    public boolean ContainsInternal(Object key) throws StateTransferException {
        int bucketId = this.GetBucketId((String)(key instanceof String ? key : null));
        if (this._logMgr.IsOperationAllowed(bucketId) && this.getLocalBuckets()[bucketId] != null) {
            return super.ContainsInternal(key);
        }
        throw new StateTransferException("I am no more the owner of this bucket");
    }

    @Override
    public void ClearInternal() {
        super.ClearInternal();
        if (this._keyList != null) {
            this._keyList.clear();
        }
        if (this._logMgr != null) {
            this._logMgr.dispose();
        }
        if (this.getLocalBuckets() == null) {
            return;
        }
        for (int i = 0; i < this.getLocalBuckets().length; ++i) {
            BucketStatistics stats = this.getLocalBuckets()[i];
            if (stats == null) continue;
            stats.Clear();
        }
    }

    @Override
    public void dispose() {
        if (this._logMgr != null) {
            this._logMgr.dispose();
        }
        if (this._keyList != null) {
            this._keyList.clear();
        }
        super.dispose();
    }
}

