/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.Queries.AttributeIndex;
import Alachisoft.NCache.Caching.Queries.ComparisonType;
import Alachisoft.NCache.Caching.Queries.IIndexStore;
import Alachisoft.NCache.Caching.Queries.IQueryIndex;
import Alachisoft.NCache.Caching.Queries.QueryIndexManager;
import Alachisoft.NCache.Caching.Topologies.Local.IndexedLocalCache;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import Alachisoft.NCache.Common.DataStructures.SRTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TagIndexManager
extends QueryIndexManager {
    public TagIndexManager(Map props, IndexedLocalCache cache, String cacheName, HashMap dataSharingKnownTypes) {
        super(props, cache, cacheName, dataSharingKnownTypes);
    }

    @Override
    public boolean Initialize() {
        if (super.Initialize()) {
            return true;
        }
        this._indexMap = new HashMap();
        return true;
    }

    private void AddTag(Object key, HashMap value) throws ClassNotFoundException, RedBlackException {
        if (value != null) {
            String type = value.get("type") instanceof String ? value.get("type") : null;
            ArrayList tagsList = value.get("tags-list") instanceof ArrayList ? value.get("tags-list") : null;
            if (!this._indexMap.containsKey(type)) {
                this._indexMap.put(type, new AttributeIndex(null, this._cacheName, type));
            }
            IQueryIndex index = this._indexMap.get(type) instanceof IQueryIndex ? this._indexMap.get(type) : null;
            for (String tag : tagsList) {
                HashMap<String, String> tmp = new HashMap<String, String>();
                tmp.put("$Tag$", tag);
                index.AddToIndex(key, tmp);
            }
        }
    }

    private void RemoveTag(Object key, HashMap value) throws RedBlackException {
        if (value != null) {
            String type = value.get("type") instanceof String ? value.get("type") : null;
            ArrayList tagsList = value.get("tags-list") instanceof ArrayList ? value.get("tags-list") : null;
            if (this._indexMap.containsKey(type)) {
                IQueryIndex index = this._indexMap.get(type) instanceof IQueryIndex ? this._indexMap.get(type) : null;
                for (String tag : tagsList) {
                    HashMap<String, String> tmp = new HashMap<String, String>();
                    tmp.put("$Tag$", tag.toLowerCase());
                    index.RemoveFromIndex(key, tmp);
                }
                if (((AttributeIndex)index).getSize() == 0) {
                    this._indexMap.remove(type);
                }
            }
        }
    }

    @Override
    public void AddToIndex(Object key, Object value) throws ClassNotFoundException, RedBlackException {
        CacheEntry entry = (CacheEntry)value;
        HashMap queryInfo = entry.getQueryInfo();
        if (queryInfo.containsKey("query-info")) {
            super.AddToIndex(key, entry);
        }
        if (queryInfo.containsKey("tag-info") && queryInfo.get("tag-info") instanceof HashMap) {
            this.AddTag(key, (HashMap)queryInfo.get("tag-info"));
            if (queryInfo.get("tag-info") != null) {
                entry.setObjectType(((HashMap)queryInfo.get("tag-info")).get("type").toString());
            }
        }
    }

    @Override
    public void RemoveFromIndex(Object key, Object value) throws RedBlackException, ClassNotFoundException {
        if (((HashMap)value).containsKey("query-info")) {
            super.RemoveFromIndex(key, ((HashMap)value).get("query-info"));
        }
        if (((HashMap)value).containsKey("tag-info") && ((HashMap)value).get("tag-info") instanceof HashMap) {
            this.RemoveTag(key, (HashMap)((HashMap)value).get("tag-info"));
        }
    }

    private ArrayList GetCombinedKeysFromEveryType(String tag) {
        if (this._indexMap == null) {
            return null;
        }
        ArrayList keys = null;
        HashMap finalTable = new HashMap();
        for (Map.Entry current : this._indexMap.entrySet()) {
            SRTree tree = new SRTree();
            AttributeIndex index = current.getValue() instanceof AttributeIndex ? current.getValue() : null;
            IIndexStore store = index.GetStore("$Tag$");
            if (store == null || (keys = store.GetData(tag.toLowerCase(), ComparisonType.EQUALS)) == null || keys.size() <= 0) continue;
            for (int i = 0; i < keys.size(); ++i) {
                finalTable.put(keys.get(i), null);
            }
        }
        return new ArrayList(finalTable.keySet());
    }

    public final ArrayList GetAllMatchingTags(String[] tags) {
        int i;
        HashMap finalTable = new HashMap();
        ArrayList keys = this.GetCombinedKeysFromEveryType(tags[0]);
        for (i = 0; i < keys.size(); ++i) {
            finalTable.put(keys.get(i), null);
        }
        for (i = 1; i < tags.length; ++i) {
            HashMap shiftTable = new HashMap();
            keys = this.GetCombinedKeysFromEveryType(tags[i]);
            if (keys != null) {
                for (int j = 0; j < keys.size(); ++j) {
                    Object key = keys.get(j);
                    if (!finalTable.containsKey(key)) continue;
                    shiftTable.put(key, null);
                }
            }
            finalTable = shiftTable;
        }
        return new ArrayList(finalTable.keySet());
    }

    public final ArrayList GetByTag(String tag) {
        return this.GetCombinedKeysFromEveryType(tag);
    }

    public final ArrayList GetAnyMatchingTag(String[] tags) {
        int i;
        ArrayList finalKeys = this.GetCombinedKeysFromEveryType(tags[0]);
        HashMap finalTable = new HashMap();
        for (i = 0; i < finalKeys.size(); ++i) {
            finalTable.put(finalKeys.get(i), null);
        }
        for (i = 1; i < tags.length; ++i) {
            ArrayList keys = this.GetCombinedKeysFromEveryType(tags[i]);
            if (keys == null || keys.size() <= 0) continue;
            for (int j = 0; j < keys.size(); ++j) {
                finalTable.put(keys.get(j), null);
            }
        }
        return new ArrayList(finalTable.keySet());
    }
}

