/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.Queries.HashStore;
import Alachisoft.NCache.Caching.Queries.IIndexStore;
import Alachisoft.NCache.Caching.Queries.IQueryIndex;
import Alachisoft.NCache.Caching.Queries.IndexInformation;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TagIndex
implements IQueryIndex {
    public static final String TAG_INDEX_KEY = "$Tag$";
    private HashMap _indexTable;

    public TagIndex() {
        this.Initialize();
    }

    public final int getSize() {
        if (this._indexTable != null) {
            return this._indexTable.size();
        }
        return 0;
    }

    private void Initialize() {
        this._indexTable = new HashMap();
        HashStore store = new HashStore();
        this._indexTable.put(TAG_INDEX_KEY, store);
    }

    @Override
    public void AddToIndex(Object key, Object value) throws RedBlackException {
        for (Map.Entry current : ((HashMap)value).entrySet()) {
            String indexKey = (String)current.getKey();
            IIndexStore store = this._indexTable.get(indexKey) instanceof IIndexStore ? this._indexTable.get(indexKey) : null;
            if (store == null && TAG_INDEX_KEY.equals(indexKey)) {
                store = new HashStore();
                this._indexTable.put(indexKey, store);
            }
            if (store == null) continue;
            Object val = current.getValue();
            if (val != null) {
                store.Add(val, key);
                continue;
            }
            store.Add("null", key);
        }
    }

    @Override
    public void RemoveFromIndex(Object key, Object value) throws RedBlackException {
        for (Map.Entry current : ((HashMap)value).entrySet()) {
            String indexKey = (String)current.getKey();
            if (!this._indexTable.containsKey(indexKey)) continue;
            IIndexStore store = this._indexTable.get(indexKey) instanceof IIndexStore ? this._indexTable.get(indexKey) : null;
            Object val = current.getValue();
            if (val != null) {
                store.Remove(val, key);
            } else {
                store.Remove("null", key);
            }
            if (store.getSize() != 0 || !TAG_INDEX_KEY.equals(indexKey)) continue;
            this._indexTable.remove(indexKey);
        }
    }

    public final IIndexStore GetIndex(String attrib) {
        if (this._indexTable.containsKey(attrib)) {
            return this._indexTable.get(attrib) instanceof IIndexStore ? this._indexTable.get(attrib) : null;
        }
        return null;
    }

    @Override
    public final void Clear() {
        for (Map.Entry current : this._indexTable.entrySet()) {
            IIndexStore index = current.getValue() instanceof IIndexStore ? current.getValue() : null;
            index.Clear();
        }
    }

    @Override
    public final Iterator GetEnumerator(String typeName, boolean forTag) {
        if (this._indexTable.containsKey(TAG_INDEX_KEY)) {
            IIndexStore store = this._indexTable.get(TAG_INDEX_KEY) instanceof IIndexStore ? this._indexTable.get(TAG_INDEX_KEY) : null;
            return store.GetEnumerator();
        }
        return null;
    }

    @Override
    public IndexInformation GetIndexInformation(Object key) {
        return null;
    }

    @Override
    public void RemoveFromIndex(Object key) {
    }
}

