/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.MetaInformation;
import Alachisoft.NCache.Caching.Queries.AttributeIndex;
import Alachisoft.NCache.Caching.Queries.IQueryIndex;
import Alachisoft.NCache.Caching.Queries.TagIndexManager;
import Alachisoft.NCache.Caching.Topologies.Local.IndexedLocalCache;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NamedTagIndexManager
extends TagIndexManager {
    public NamedTagIndexManager(Map props, IndexedLocalCache cache, String cacheName, HashMap dataSharingKnownTypes) {
        super(props, cache, cacheName, dataSharingKnownTypes);
    }

    @Override
    public boolean Initialize() {
        if (super.Initialize()) {
            return true;
        }
        this._indexMap = new HashMap();
        return true;
    }

    @Override
    public void AddToIndex(Object key, Object value) throws ClassNotFoundException, RedBlackException {
        super.AddToIndex(key, value);
        CacheEntry entry = (CacheEntry)value;
        HashMap queryInfo = entry.getQueryInfo();
        if (queryInfo.containsKey("named-tag-info")) {
            this.AddNamedTag(key, queryInfo.get("named-tag-info") instanceof HashMap ? queryInfo.get("named-tag-info") : null, entry);
        }
        entry.setQueryInfo(null);
    }

    @Override
    public void RemoveFromIndex(Object key, Object value) throws RedBlackException, ClassNotFoundException {
        super.RemoveFromIndex(key, value);
        if (((HashMap)value).containsKey("named-tag-info")) {
            this.RemoveNamedTag(key, ((HashMap)value).get("named-tag-info") instanceof HashMap ? ((HashMap)value).get("named-tag-info") : null);
        }
    }

    private void AddNamedTag(Object key, HashMap value, CacheEntry entry) throws ClassNotFoundException, RedBlackException {
        if (value != null) {
            String type = value.get("type") instanceof String ? value.get("type") : null;
            HashMap tagsList = (HashMap)value.get("named-tags-list");
            HashMap metaInfoAttribs = (HashMap)tagsList.clone();
            ArrayList modifiedKeys = new ArrayList();
            if (!this._indexMap.containsKey(type)) {
                if (this._sharedAttributeIndex != null && this._sharedAttributeIndex.containsKey(type)) {
                    AttributeIndex tempAttrib = (AttributeIndex)this._sharedAttributeIndex.get(type);
                    tempAttrib.Initialize(new ArrayList());
                    this._indexMap.put(type, tempAttrib);
                    if (tempAttrib._sharedTypes != null && tempAttrib._sharedTypes.size() > 0) {
                        for (AttributeIndex sharedAttrib : tempAttrib._sharedTypes) {
                            sharedAttrib.Initialize(new ArrayList());
                            this._indexMap.put(sharedAttrib._type, sharedAttrib);
                        }
                    }
                } else {
                    this._indexMap.put(type, new AttributeIndex(null, this._cacheName, type));
                }
            }
            IQueryIndex index = this._indexMap.get(type) instanceof IQueryIndex ? this._indexMap.get(type) : null;
            index.AddToIndex(key, tagsList);
            if (entry.getMetaInformation() != null) {
                entry.getMetaInformation().Add(metaInfoAttribs);
            } else {
                entry.setMetaInformation(new MetaInformation(metaInfoAttribs));
                entry.getMetaInformation().setCacheKey((String)(key instanceof String ? key : null));
                entry.getMetaInformation().setType(value.get("type") instanceof String ? value.get("type") : null);
                entry.setObjectType(value.get("type") instanceof String ? value.get("type") : null);
            }
        }
    }

    protected final void RemoveNamedTag(Object key, HashMap value) throws RedBlackException {
        if (value != null) {
            String type = value.get("type") instanceof String ? value.get("type") : null;
            HashMap tagsList = value.get("named-tags-list") instanceof HashMap ? value.get("named-tags-list") : null;
            ArrayList<String> modifiedKeys = new ArrayList<String>();
            for (String tagKey : tagsList.keySet()) {
                if (!(tagsList.get(tagKey) instanceof String)) continue;
                modifiedKeys.add(tagKey);
            }
            Iterator<Object> it = modifiedKeys.iterator();
            while (it.hasNext()) {
                String tagKey;
                tagsList.put(tagKey, ((String)(tagsList.get(tagKey = (String)it.next()) instanceof String ? tagsList.get(tagKey) : null)).toLowerCase());
            }
            if (this._indexMap.containsKey(type)) {
                IQueryIndex index = this._indexMap.get(type) instanceof IQueryIndex ? this._indexMap.get(type) : null;
                index.RemoveFromIndex(key, tagsList);
            }
        }
    }
}

