/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.Queries.NCQLParserRule;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Parser.ParseMessage;
import Alachisoft.NCache.Parser.Parser;
import Alachisoft.NCache.Parser.Reduction;
import Alachisoft.NCache.Parser.Token;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;

public class NCQLParser
extends Parser {
    NCQLParserRule _parserRule;
    private ILogger _ncacheLog;

    public NCQLParser(String resourceName, ILogger NCacheLog) throws IOException {
        this._ncacheLog = NCacheLog;
        this._parserRule = new NCQLParserRule(NCacheLog);
        URL resource = ((Object)((Object)this)).getClass().getResource(resourceName);
        InputStream in = resource.openStream();
        super.LoadGrammar(in);
    }

    private ILogger getNCacheLog() {
        return this._ncacheLog;
    }

    public final ParseMessage Parse(BufferedReader Source2, boolean GenerateContext) throws IOException {
        ParseMessage Response = null;
        boolean done = false;
        this.OpenStream(Source2);
        this.setTrimReductions(true);
        do {
            Response = this.Parse();
            switch (Response) {
                case LexicalError: {
                    done = true;
                    break;
                }
                case SyntaxError: {
                    Iterator ide = this.GetTokens().GetEnumerator();
                    while (ide.hasNext()) {
                        Token t = (Token)ide.next();
                        if (!this.getNCacheLog().getIsInfoEnabled()) continue;
                        this.getNCacheLog().Info(t.getName());
                    }
                    done = true;
                    break;
                }
                case Reduction: {
                    if (!GenerateContext) break;
                    this.setCurrentReduction(this.CreateNewObject(this.getCurrentReduction()));
                    break;
                }
                case Accept: {
                    done = true;
                    break;
                }
                case TokenRead: {
                    break;
                }
                case InternalError: {
                    done = true;
                    break;
                }
                case CommentError: {
                    done = true;
                }
            }
        } while (!done);
        this.CloseFile();
        return Response;
    }

    private Reduction CreateNewObject(Reduction reduction) {
        Reduction result = null;
        RuleConstants rule = RuleConstants.forValue(reduction.getParentRule().getTableIndex());
        switch (rule) {
            case RULE_QUERY_SELECT: {
                result = this._parserRule.CreateRULE_QUERY_SELECT(reduction);
                break;
            }
            case RULE_QUERY_SELECT_WHERE: {
                result = this._parserRule.CreateRULE_QUERY_SELECT_WHERE(reduction);
                break;
            }
            case RULE_QUERY_DELETE: {
                result = this._parserRule.CreateRULE_QUERY_DELETE(reduction);
                break;
            }
            case RULE_QUERY_DELETE_WHERE: {
                result = this._parserRule.CreateRULE_QUERY_DELETE_WHERE(reduction);
                break;
            }
            case RULE_QUERY_SELECT2: {
                result = this._parserRule.CreateRULE_QUERY_SELECT2(reduction);
                break;
            }
            case RULE_QUERY_SELECT_WHERE2: {
                result = this._parserRule.CreateRULE_QUERY_SELECT_WHERE2(reduction);
                break;
            }
            case RULE_QUERY_SELECT_GROUPBY: {
                result = this._parserRule.CreateRULE_QUERY_SELECT_GROUPBY(reduction);
                break;
            }
            case RULE_QUERY_SELECT_WHERE_GROUPBY: {
                result = this._parserRule.CreateRULE_QUERY_SELECT_WHERE_GROUPBY(reduction);
                break;
            }
            case RULE_QUERY_SELECT_GROUPBY2: {
                result = this._parserRule.CreateRULE_QUERY_SELECT_GROUPBY2(reduction);
                break;
            }
            case RULE_QUERY_SELECT_WHERE_GROUPBY2: {
                result = this._parserRule.CreateRULE_QUERY_SELECT_WHERE_GROUPBY2(reduction);
                break;
            }
            case RULE_EXPRESSION: {
                result = this._parserRule.CreateRULE_EXPRESSION(reduction);
                break;
            }
            case RULE_OREXPR_OR: {
                result = this._parserRule.CreateRULE_OREXPR_OR(reduction);
                break;
            }
            case RULE_OREXPR: {
                result = this._parserRule.CreateRULE_OREXPR(reduction);
                break;
            }
            case RULE_ANDEXPR_AND: {
                result = this._parserRule.CreateRULE_ANDEXPR_AND(reduction);
                break;
            }
            case RULE_ANDEXPR: {
                result = this._parserRule.CreateRULE_ANDEXPR(reduction);
                break;
            }
            case RULE_UNARYEXPR_NOT: {
                result = this._parserRule.CreateRULE_UNARYEXPR_NOT(reduction);
                break;
            }
            case RULE_UNARYEXPR: {
                result = this._parserRule.CreateRULE_UNARYEXPR(reduction);
                break;
            }
            case RULE_COMPAREEXPR_EQ: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_EQ(reduction);
                break;
            }
            case RULE_COMPAREEXPR_EXCLAMEQ: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_EXCLAMEQ(reduction);
                break;
            }
            case RULE_COMPAREEXPR_EQEQ: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_EQEQ(reduction);
                break;
            }
            case RULE_COMPAREEXPR_LTGT: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_LTGT(reduction);
                break;
            }
            case RULE_COMPAREEXPR_LT: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_LT(reduction);
                break;
            }
            case RULE_COMPAREEXPR_GT: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_GT(reduction);
                break;
            }
            case RULE_COMPAREEXPR_LTEQ: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_LTEQ(reduction);
                break;
            }
            case RULE_COMPAREEXPR_GTEQ: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_GTEQ(reduction);
                break;
            }
            case RULE_COMPAREEXPR_LIKE_STRINGLITERAL: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_LIKE_STRINGLITERAL(reduction);
                break;
            }
            case RULE_COMPAREEXPR_LIKE_QUESTION: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_LIKE_QUESTION(reduction);
                break;
            }
            case RULE_COMPAREEXPR_NOT_LIKE_STRINGLITERAL: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_NOT_LIKE_STRINGLITERAL(reduction);
                break;
            }
            case RULE_COMPAREEXPR_NOT_LIKE_QUESTION: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_NOT_LIKE_QUESTION(reduction);
                break;
            }
            case RULE_COMPAREEXPR_IN: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_IN(reduction);
                break;
            }
            case RULE_COMPAREEXPR_NOT_IN: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_NOT_IN(reduction);
                break;
            }
            case RULE_COMPAREEXPR_IS_NULL: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_IS_NULL(reduction);
                break;
            }
            case RULE_COMPAREEXPR_IS_NOT_NULL: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_IS_NOT_NULL(reduction);
                break;
            }
            case RULE_COMPAREEXPR_LPARAN_RPARAN: {
                result = this._parserRule.CreateRULE_COMPAREEXPR_LPARAN_RPARAN(reduction);
                break;
            }
            case RULE_ATRRIB: {
                result = this._parserRule.CreateRULE_ATRRIB(reduction);
                break;
            }
            case RULE_VALUE_MINUS: {
                result = this._parserRule.CreateRULE_VALUE_MINUS(reduction);
                break;
            }
            case RULE_VALUE: {
                result = this._parserRule.CreateRULE_VALUE(reduction);
                break;
            }
            case RULE_VALUE2: {
                result = this._parserRule.CreateRULE_VALUE2(reduction);
                break;
            }
            case RULE_VALUE_TRUE: {
                result = this._parserRule.CreateRULE_VALUE_TRUE(reduction);
                break;
            }
            case RULE_VALUE_FALSE: {
                result = this._parserRule.CreateRULE_VALUE_FALSE(reduction);
                break;
            }
            case RULE_VALUE3: {
                result = this._parserRule.CreateRULE_VALUE3(reduction);
                break;
            }
            case RULE_DATE_DATETIME_DOT_NOW: {
                result = this._parserRule.CreateRULE_DATE_DATETIME_DOT_NOW(reduction);
                break;
            }
            case RULE_DATE_DATETIME_LPARAN_STRINGLITERAL_RPARAN: {
                result = this._parserRule.CreateRULE_DATE_DATETIME_LPARAN_STRINGLITERAL_RPARAN(reduction);
                break;
            }
            case RULE_STRLITERAL_STRINGLITERAL: {
                result = this._parserRule.CreateRULE_STRLITERAL_STRINGLITERAL(reduction);
                break;
            }
            case RULE_STRLITERAL_NULL: {
                result = this._parserRule.CreateRULE_STRLITERAL_NULL(reduction);
                break;
            }
            case RULE_STRLITERAL_QUESTION: {
                result = this._parserRule.CreateRULE_STRLITERAL_QUESTION(reduction);
                break;
            }
            case RULE_NUMLITERAL_INTEGERLITERAL: {
                result = this._parserRule.CreateRULE_NUMLITERAL_INTEGERLITERAL(reduction);
                break;
            }
            case RULE_NUMLITERAL_REALLITERAL: {
                result = this._parserRule.CreateRULE_NUMLITERAL_REALLITERAL(reduction);
                break;
            }
            case RULE_OBJECTTYPE_TIMES: {
                result = this._parserRule.CreateRULE_OBJECTTYPE_TIMES(reduction);
                break;
            }
            case RULE_OBJECTTYPE_DOLLARTEXTDOLLAR: {
                result = this._parserRule.CreateRULE_OBJECTTYPE_DOLLARTEXTDOLLAR(reduction);
                break;
            }
            case RULE_OBJECTTYPE: {
                result = this._parserRule.CreateRULE_OBJECTTYPE(reduction);
                break;
            }
            case RULE_OBJECTATTRIBUTE_IDENTIFIER: {
                result = this._parserRule.CreateRULE_OBJECTATTRIBUTE_IDENTIFIER(reduction);
                break;
            }
            case RULE_DELETEPARAMS_DOLLARTEXTDOLLAR: {
                result = this._parserRule.CreateRULE_DELETEPARAMS_DOLLARTEXTDOLLAR(reduction);
                break;
            }
            case RULE_DELETEPARAMS: {
                result = this._parserRule.CreateRULE_DELETEPARAMS(reduction);
                break;
            }
            case RULE_PROPERTY_DOT_IDENTIFIER: {
                result = this._parserRule.CreateRULE_PROPERTY_DOT_IDENTIFIER(reduction);
                break;
            }
            case RULE_PROPERTY_IDENTIFIER: {
                result = this._parserRule.CreateRULE_PROPERTY_IDENTIFIER(reduction);
                break;
            }
            case RULE_TYPEPLUSATTRIBUTE_DOT: {
                result = this._parserRule.CreateRULE_TYPEPLUSATTRIBUTE_DOT(reduction);
                break;
            }
            case RULE_AGGREGATEFUNCTION: {
                result = this._parserRule.CreateRULE_AGGREGATEFUNCTION(reduction);
                break;
            }
            case RULE_AGGREGATEFUNCTION2: {
                result = this._parserRule.CreateRULE_AGGREGATEFUNCTION2(reduction);
                break;
            }
            case RULE_AGGREGATEFUNCTION3: {
                result = this._parserRule.CreateRULE_AGGREGATEFUNCTION3(reduction);
                break;
            }
            case RULE_AGGREGATEFUNCTION4: {
                result = this._parserRule.CreateRULE_AGGREGATEFUNCTION4(reduction);
                break;
            }
            case RULE_AGGREGATEFUNCTION5: {
                result = this._parserRule.CreateRULE_AGGREGATEFUNCTION5(reduction);
                break;
            }
            case RULE_SUMFUNCTION_SUMLPARAN_RPARAN: {
                result = this._parserRule.CreateRULE_SUMFUNCTION_SUMLPARAN_RPARAN(reduction);
                break;
            }
            case RULE_COUNTFUNCTION_COUNTLPARAN_RPARAN: {
                result = this._parserRule.CreateRULE_COUNTFUNCTION_COUNTLPARAN_RPARAN(reduction);
                break;
            }
            case RULE_MINFUNCTION_MINLPARAN_RPARAN: {
                result = this._parserRule.CreateRULE_MINFUNCTION_MINLPARAN_RPARAN(reduction);
                break;
            }
            case RULE_MAXFUNCTION_MAXLPARAN_RPARAN: {
                result = this._parserRule.CreateRULE_MAXFUNCTION_MAXLPARAN_RPARAN(reduction);
                break;
            }
            case RULE_AVERAGEFUNCTION_AVGLPARAN_RPARAN: {
                result = this._parserRule.CreateRULE_AVERAGEFUNCTION_AVGLPARAN_RPARAN(reduction);
                break;
            }
            case RULE_OBJECTATTRIBUTE_KEYWORD_DOT_IDENTIFIER: {
                result = this._parserRule.CreateRULE_OBJECTATTRIBUTE_KEYWORD_DOT_IDENTIFIER(reduction);
                break;
            }
            case RULE_OBJECTVALUE_KEYWORD_DOT_IDENTIFIER: {
                result = this._parserRule.CreateRULE_OBJECTVALUE_KEYWORD_DOT_IDENTIFIER(reduction);
                break;
            }
            case RULE_OBJECTVALUE_KEYWORD_DOT_TAG: {
                result = this._parserRule.CreateRULE_OBJECTVALUE_KEYWORD_DOT_TAG(reduction);
                break;
            }
            case RULE_INLIST_LPARAN_RPARAN: {
                result = this._parserRule.CreateRULE_INLIST_LPARAN_RPARAN(reduction);
                break;
            }
            case RULE_LISTTYPE: {
                result = this._parserRule.CreateRULE_LISTTYPE(reduction);
                break;
            }
            case RULE_LISTTYPE2: {
                result = this._parserRule.CreateRULE_LISTTYPE2(reduction);
                break;
            }
            case RULE_LISTTYPE3: {
                result = this._parserRule.CreateRULE_LISTTYPE3(reduction);
                break;
            }
            case RULE_NUMLITERALLIST_COMMA: {
                result = this._parserRule.CreateRULE_NUMLITERALLIST_COMMA(reduction);
                break;
            }
            case RULE_NUMLITERALLIST: {
                result = this._parserRule.CreateRULE_NUMLITERALLIST(reduction);
                break;
            }
            case RULE_STRLITERALLIST_COMMA: {
                result = this._parserRule.CreateRULE_STRLITERALLIST_COMMA(reduction);
                break;
            }
            case RULE_STRLITERALLIST: {
                result = this._parserRule.CreateRULE_STRLITERALLIST(reduction);
                break;
            }
            case RULE_DATELIST_COMMA: {
                result = this._parserRule.CreateRULE_DATELIST_COMMA(reduction);
                break;
            }
            case RULE_DATELIST: {
                result = this._parserRule.CreateRULE_DATELIST(reduction);
                break;
            }
            case RULE_GROUPBYVALUELIST_COMMA: {
                result = this._parserRule.CreateRULE_GROUPBYVALUELIST_COMMA(reduction);
                break;
            }
            case RULE_GROUPBYVALUELIST: {
                result = this._parserRule.CreateRULE_GROUPBYVALUELIST(reduction);
                break;
            }
            case RULE_AGGREGATEFUNCTIONLIST_COMMA: {
                result = this._parserRule.CreateRULE_AGGREGATEFUNCTIONLIST_COMMA(reduction);
                break;
            }
            case RULE_AGGREGATEFUNCTIONLIST: {
                result = this._parserRule.CreateRULE_AGGREGATEFUNCTIONLIST(reduction);
                break;
            }
            case RULE_OBJECTATTRIBUTELIST_COMMA: {
                result = this._parserRule.CreateRULE_OBJECTATTRIBUTELIST_COMMA(reduction);
                break;
            }
            case RULE_OBJECTATTRIBUTELIST: {
                result = this._parserRule.CreateRULE_OBJECTATTRIBUTELIST(reduction);
            }
        }
        if (result == null) {
            result = reduction;
        }
        return result;
    }

    public static enum RuleConstants {
        RULE_QUERY_SELECT(0),
        RULE_QUERY_SELECT_WHERE(1),
        RULE_QUERY_DELETE(2),
        RULE_QUERY_DELETE_WHERE(3),
        RULE_QUERY_SELECT2(4),
        RULE_QUERY_SELECT_WHERE2(5),
        RULE_QUERY_SELECT_GROUPBY(6),
        RULE_QUERY_SELECT_WHERE_GROUPBY(7),
        RULE_QUERY_SELECT_GROUPBY2(8),
        RULE_QUERY_SELECT_WHERE_GROUPBY2(9),
        RULE_EXPRESSION(10),
        RULE_OREXPR_OR(11),
        RULE_OREXPR(12),
        RULE_ANDEXPR_AND(13),
        RULE_ANDEXPR(14),
        RULE_UNARYEXPR_NOT(15),
        RULE_UNARYEXPR(16),
        RULE_COMPAREEXPR_EQ(17),
        RULE_COMPAREEXPR_EXCLAMEQ(18),
        RULE_COMPAREEXPR_EQEQ(19),
        RULE_COMPAREEXPR_LTGT(20),
        RULE_COMPAREEXPR_LT(21),
        RULE_COMPAREEXPR_GT(22),
        RULE_COMPAREEXPR_LTEQ(23),
        RULE_COMPAREEXPR_GTEQ(24),
        RULE_COMPAREEXPR_LIKE_STRINGLITERAL(25),
        RULE_COMPAREEXPR_LIKE_QUESTION(26),
        RULE_COMPAREEXPR_NOT_LIKE_STRINGLITERAL(27),
        RULE_COMPAREEXPR_NOT_LIKE_QUESTION(28),
        RULE_COMPAREEXPR_IN(29),
        RULE_COMPAREEXPR_NOT_IN(30),
        RULE_COMPAREEXPR_IS_NULL(31),
        RULE_COMPAREEXPR_IS_NOT_NULL(32),
        RULE_COMPAREEXPR_LPARAN_RPARAN(33),
        RULE_ATRRIB(34),
        RULE_VALUE_MINUS(35),
        RULE_VALUE(36),
        RULE_VALUE2(37),
        RULE_VALUE_TRUE(38),
        RULE_VALUE_FALSE(39),
        RULE_VALUE3(40),
        RULE_DATE_DATETIME_DOT_NOW(41),
        RULE_DATE_DATETIME_LPARAN_STRINGLITERAL_RPARAN(42),
        RULE_STRLITERAL_STRINGLITERAL(43),
        RULE_STRLITERAL_NULL(44),
        RULE_STRLITERAL_QUESTION(45),
        RULE_NUMLITERAL_INTEGERLITERAL(46),
        RULE_NUMLITERAL_REALLITERAL(47),
        RULE_OBJECTTYPE_TIMES(48),
        RULE_OBJECTTYPE_DOLLARTEXTDOLLAR(49),
        RULE_OBJECTTYPE(50),
        RULE_OBJECTATTRIBUTE_IDENTIFIER(51),
        RULE_DELETEPARAMS_DOLLARTEXTDOLLAR(52),
        RULE_DELETEPARAMS(53),
        RULE_PROPERTY_DOT_IDENTIFIER(54),
        RULE_PROPERTY_IDENTIFIER(55),
        RULE_TYPEPLUSATTRIBUTE_DOT(56),
        RULE_AGGREGATEFUNCTION(57),
        RULE_AGGREGATEFUNCTION2(58),
        RULE_AGGREGATEFUNCTION3(59),
        RULE_AGGREGATEFUNCTION4(60),
        RULE_AGGREGATEFUNCTION5(61),
        RULE_SUMFUNCTION_SUMLPARAN_RPARAN(62),
        RULE_COUNTFUNCTION_COUNTLPARAN_RPARAN(63),
        RULE_MINFUNCTION_MINLPARAN_RPARAN(64),
        RULE_MAXFUNCTION_MAXLPARAN_RPARAN(65),
        RULE_AVERAGEFUNCTION_AVGLPARAN_RPARAN(66),
        RULE_OBJECTATTRIBUTE_KEYWORD_DOT_IDENTIFIER(67),
        RULE_OBJECTVALUE_KEYWORD_DOT_IDENTIFIER(68),
        RULE_OBJECTVALUE_KEYWORD_DOT_TAG(69),
        RULE_INLIST_LPARAN_RPARAN(70),
        RULE_LISTTYPE(71),
        RULE_LISTTYPE2(72),
        RULE_LISTTYPE3(73),
        RULE_NUMLITERALLIST_COMMA(74),
        RULE_NUMLITERALLIST(75),
        RULE_STRLITERALLIST_COMMA(76),
        RULE_STRLITERALLIST(77),
        RULE_DATELIST_COMMA(78),
        RULE_DATELIST(79),
        RULE_GROUPBYVALUELIST_COMMA(80),
        RULE_GROUPBYVALUELIST(81),
        RULE_AGGREGATEFUNCTIONLIST_COMMA(82),
        RULE_AGGREGATEFUNCTIONLIST(83),
        RULE_OBJECTATTRIBUTELIST_COMMA(84),
        RULE_OBJECTATTRIBUTELIST(85);

        private static HashMap<Integer, RuleConstants> mappings;
        private int intValue;

        private RuleConstants(int value) {
            this.intValue = value;
            RuleConstants.getMappings().put(value, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static HashMap<Integer, RuleConstants> getMappings() {
            if (mappings != null) return mappings;
            Class<RuleConstants> clazz = RuleConstants.class;
            synchronized (RuleConstants.class) {
                if (mappings != null) return mappings;
                mappings = new HashMap();
                // ** MonitorExit[var0] (shouldn't be in output)
                return mappings;
            }
        }

        public static RuleConstants forValue(int value) {
            return RuleConstants.getMappings().get(value);
        }

        public int getValue() {
            return this.intValue;
        }
    }

    public static enum SymbolConstants {
        SYMBOL_EOF(0),
        SYMBOL_ERROR(1),
        SYMBOL_WHITESPACE(2),
        SYMBOL_MINUS(3),
        SYMBOL_EXCLAMEQ(4),
        SYMBOL_DOLLARTEXTDOLLAR(5),
        SYMBOL_LPARAN(6),
        SYMBOL_RPARAN(7),
        SYMBOL_TIMES(8),
        SYMBOL_COMMA(9),
        SYMBOL_DOT(10),
        SYMBOL_QUESTION(11),
        SYMBOL_LT(12),
        SYMBOL_LTEQ(13),
        SYMBOL_LTGT(14),
        SYMBOL_EQ(15),
        SYMBOL_EQEQ(16),
        SYMBOL_GT(17),
        SYMBOL_GTEQ(18),
        SYMBOL_AND(19),
        SYMBOL_AVGLPARAN(20),
        SYMBOL_COUNTLPARAN(21),
        SYMBOL_DATETIME(22),
        SYMBOL_DELETE(23),
        SYMBOL_FALSE(24),
        SYMBOL_GROUPBY(25),
        SYMBOL_IDENTIFIER(26),
        SYMBOL_IN(27),
        SYMBOL_INTEGERLITERAL(28),
        SYMBOL_IS(29),
        SYMBOL_KEYWORD(30),
        SYMBOL_LIKE(31),
        SYMBOL_MAXLPARAN(32),
        SYMBOL_MINLPARAN(33),
        SYMBOL_NOT(34),
        SYMBOL_NOW(35),
        SYMBOL_NULL(36),
        SYMBOL_OR(37),
        SYMBOL_REALLITERAL(38),
        SYMBOL_SELECT(39),
        SYMBOL_STRINGLITERAL(40),
        SYMBOL_SUMLPARAN(41),
        SYMBOL_TAG(42),
        SYMBOL_TRUE(43),
        SYMBOL_WHERE(44),
        SYMBOL_AGGREGATEFUNCTION(45),
        SYMBOL_AGGREGATEFUNCTIONLIST(46),
        SYMBOL_ANDEXPR(47),
        SYMBOL_ATRRIB(48),
        SYMBOL_AVERAGEFUNCTION(49),
        SYMBOL_COMPAREEXPR(50),
        SYMBOL_COUNTFUNCTION(51),
        SYMBOL_DATE(52),
        SYMBOL_DATELIST(53),
        SYMBOL_DELETEPARAMS(54),
        SYMBOL_EXPRESSION(55),
        SYMBOL_GROUPBYVALUELIST(56),
        SYMBOL_INLIST(57),
        SYMBOL_LISTTYPE(58),
        SYMBOL_MAXFUNCTION(59),
        SYMBOL_MINFUNCTION(60),
        SYMBOL_NUMLITERAL(61),
        SYMBOL_NUMLITERALLIST(62),
        SYMBOL_OBJECTATTRIBUTE(63),
        SYMBOL_OBJECTATTRIBUTELIST(64),
        SYMBOL_OBJECTTYPE(65),
        SYMBOL_OBJECTVALUE(66),
        SYMBOL_OREXPR(67),
        SYMBOL_PROPERTY(68),
        SYMBOL_QUERY(69),
        SYMBOL_STRLITERAL(70),
        SYMBOL_STRLITERALLIST(71),
        SYMBOL_SUMFUNCTION(72),
        SYMBOL_TYPEPLUSATTRIBUTE(73),
        SYMBOL_UNARYEXPR(74),
        SYMBOL_VALUE(75);

        private static HashMap<Integer, SymbolConstants> mappings;
        private int intValue;

        private SymbolConstants(int value) {
            this.intValue = value;
            SymbolConstants.getMappings().put(value, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static HashMap<Integer, SymbolConstants> getMappings() {
            if (mappings != null) return mappings;
            Class<SymbolConstants> clazz = SymbolConstants.class;
            synchronized (SymbolConstants.class) {
                if (mappings != null) return mappings;
                mappings = new HashMap();
                // ** MonitorExit[var0] (shouldn't be in output)
                return mappings;
            }
        }

        public static SymbolConstants forValue(int value) {
            return SymbolConstants.getMappings().get(value);
        }

        public int getValue() {
            return this.intValue;
        }
    }
}

