/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries.Filters;

import Alachisoft.NCache.Caching.Exceptions.StateTransferException;
import Alachisoft.NCache.Caching.Queries.AttributeIndex;
import Alachisoft.NCache.Caching.Queries.Filters.Predicate;
import Alachisoft.NCache.Caching.Queries.QueryContext;
import Alachisoft.NCache.Caching.Queries.QueryIndexManager;
import Alachisoft.NCache.Parser.ParserException;
import Alachisoft.NCache.Parser.TypeIndexNotDefined;

public class IsOfTypePredicate
extends Predicate
implements Comparable {
    private String typename;

    public IsOfTypePredicate(String name) {
        this.typename = name;
    }

    public final String getTypeName() {
        return this.typename;
    }

    public final void setTypeName(String value) {
        this.typename = value;
    }

    @Override
    public boolean ApplyPredicate(Object o) {
        if (this.typename.equals("*")) {
            throw new ParserException("Incorrect query format '*'.");
        }
        return this.typename.equals(o.getClass().getName());
    }

    @Override
    public void Execute(QueryContext queryContext, Predicate nextPredicate) throws StateTransferException, Exception {
        if (this.typename.equals("*")) {
            throw new ParserException("Incorrect query format. '*' is not supported.");
        }
        if (queryContext.getIndexManager() == null) {
            throw new TypeIndexNotDefined("Index is not defined for '" + this.typename.toString() + "'");
        }
        queryContext.setTypeName(this.typename);
        if (queryContext.getIndex() == null) {
            if (queryContext.getAttributeValues() != null && queryContext.getAttributeValues().size() == 1 && queryContext.getAttributeValues().containsKey("$Tag$")) {
                queryContext.setIndex(new AttributeIndex(null, queryContext.getCache().getContext().getCacheRoot().getName(), null));
                return;
            }
            if (QueryIndexManager.getDisableException()) {
                queryContext.setIndex(new AttributeIndex(null, queryContext.getCache().getContext().getCacheRoot().getName(), null));
                return;
            }
            throw new TypeIndexNotDefined("Index is not defined for '" + this.typename.toString() + "'");
        }
        if (nextPredicate == null && queryContext.getPopulateTree()) {
            queryContext.getTree().Populate(queryContext.getIndex().GetEnumerator(this.typename, false));
            queryContext.getTree().Populate(queryContext.getIndex().GetEnumerator(this.typename, true));
        } else {
            nextPredicate.Execute(queryContext, null);
        }
    }

    public String toString() {
        return "typeof(Value)" + (this.getInverse() ? " != " : " == ") + this.typename;
    }

    public final int compareTo(Object obj) {
        if (obj instanceof IsOfTypePredicate) {
            IsOfTypePredicate other = (IsOfTypePredicate)obj;
            if (this.getInverse() == other.getInverse()) {
                return this.typename.compareTo(other.typename);
            }
        }
        return -1;
    }
}

