/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries.Filters;

import Alachisoft.NCache.Caching.Queries.Filters.AlwaysFalsePredicate;
import Alachisoft.NCache.Caching.Queries.Filters.AlwaysTruePredicate;
import Alachisoft.NCache.Caching.Queries.Filters.AveragePredicate;
import Alachisoft.NCache.Caching.Queries.Filters.CountPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.FunctorEqualsFunctorPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.FunctorEqualsGeneratorPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.FunctorGreaterFunctorPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.FunctorGreaterGeneratorPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.FunctorLesserFunctorPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.FunctorLesserGeneratorPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.FunctorLikePatternPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.IFunctor;
import Alachisoft.NCache.Caching.Queries.Filters.IGenerator;
import Alachisoft.NCache.Caching.Queries.Filters.LogicalAndPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.MaxPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.MinPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.Predicate;
import Alachisoft.NCache.Caching.Queries.Filters.SumPredicate;

public class ExpressionBuilder {
    public static final Predicate TRUE_PREDICATE = new AlwaysTruePredicate();
    public static final Predicate FALSE_PREDICATE = new AlwaysFalsePredicate();

    public static Predicate CreateSumFunctionPredicate(String attributeName) {
        SumPredicate predicate = new SumPredicate();
        predicate.setAttributeName(attributeName);
        return predicate;
    }

    public static Predicate CreateCountFunctionPredicate() {
        CountPredicate predicate = new CountPredicate();
        return predicate;
    }

    public static Predicate CreateAverageFunctionPredicate(String attributeName) {
        AveragePredicate predicate = new AveragePredicate();
        predicate.setAttributeName(attributeName);
        return predicate;
    }

    public static Predicate CreateMinFunctionPredicate(String attributeName) {
        MinPredicate predicate = new MinPredicate();
        predicate.setAttributeName(attributeName);
        return predicate;
    }

    public static Predicate CreateMaxFunctionPredicate(String attributeName) {
        MaxPredicate predicate = new MaxPredicate();
        predicate.setAttributeName(attributeName);
        return predicate;
    }

    public static Predicate CreateLogicalAndPredicate(Predicate lhsPred, Predicate rhsPred) {
        if (lhsPred.equals(FALSE_PREDICATE) || rhsPred.equals(FALSE_PREDICATE)) {
            return FALSE_PREDICATE;
        }
        if (lhsPred.equals(TRUE_PREDICATE)) {
            return rhsPred;
        }
        if (rhsPred.equals(TRUE_PREDICATE)) {
            return lhsPred;
        }
        Predicate inc = null;
        if (lhsPred instanceof LogicalAndPredicate) {
            inc = (LogicalAndPredicate)(lhsPred instanceof LogicalAndPredicate ? lhsPred : null);
        }
        if (inc == null || inc.getInverse()) {
            inc = new LogicalAndPredicate();
            ((LogicalAndPredicate)inc).getChildren().add(lhsPred);
        }
        ((LogicalAndPredicate)inc).getChildren().add(rhsPred);
        return inc;
    }

    public static Predicate CreateLogicalOrPredicate(Predicate lhsPred, Predicate rhsPred) {
        if (lhsPred.equals(TRUE_PREDICATE) || rhsPred.equals(TRUE_PREDICATE)) {
            return TRUE_PREDICATE;
        }
        if (lhsPred.equals(FALSE_PREDICATE)) {
            return rhsPred;
        }
        if (rhsPred.equals(FALSE_PREDICATE)) {
            return lhsPred;
        }
        Predicate inc = null;
        if (lhsPred instanceof LogicalAndPredicate) {
            inc = (LogicalAndPredicate)(lhsPred instanceof LogicalAndPredicate ? lhsPred : null);
        }
        if (inc == null || !inc.getInverse()) {
            inc = new LogicalAndPredicate();
            ((LogicalAndPredicate)inc).Invert();
            ((LogicalAndPredicate)inc).getChildren().add(lhsPred);
        }
        ((LogicalAndPredicate)inc).getChildren().add(rhsPred);
        return inc;
    }

    public static Predicate CreateEqualsPredicate(Object o, Object v) {
        boolean lhsIsGen = o instanceof IGenerator;
        boolean rhsIsGen = v instanceof IGenerator;
        if (lhsIsGen || rhsIsGen) {
            if (lhsIsGen && rhsIsGen) {
                Object rhs;
                Object lhs = ((IGenerator)o).Evaluate();
                return lhs.equals(rhs = ((IGenerator)v).Evaluate()) ? TRUE_PREDICATE : FALSE_PREDICATE;
            }
            IFunctor func = lhsIsGen ? (IFunctor)v : (IFunctor)o;
            IGenerator gen = lhsIsGen ? (IGenerator)o : (IGenerator)v;
            return new FunctorEqualsGeneratorPredicate(func, gen);
        }
        return new FunctorEqualsFunctorPredicate((IFunctor)o, (IFunctor)v);
    }

    public static Predicate CreateNotEqualsPredicate(Object o, Object v) {
        Predicate pred = ExpressionBuilder.CreateEqualsPredicate(o, v);
        if (pred.equals(TRUE_PREDICATE)) {
            return FALSE_PREDICATE;
        }
        if (pred.equals(FALSE_PREDICATE)) {
            return TRUE_PREDICATE;
        }
        pred.Invert();
        return pred;
    }

    public static Predicate CreateGreaterPredicate(Object o, Object v) {
        boolean lhsIsGen = o instanceof IGenerator;
        boolean rhsIsGen = v instanceof IGenerator;
        if (lhsIsGen || rhsIsGen) {
            if (lhsIsGen && rhsIsGen) {
                Object lhs = ((IGenerator)o).Evaluate();
                Object rhs = ((IGenerator)v).Evaluate();
                return lhs.toString().compareTo(rhs.toString()) < 0 ? TRUE_PREDICATE : FALSE_PREDICATE;
            }
            IFunctor func = lhsIsGen ? (IFunctor)v : (IFunctor)o;
            IGenerator gen = lhsIsGen ? (IGenerator)o : (IGenerator)v;
            return new FunctorGreaterGeneratorPredicate(func, gen);
        }
        return new FunctorGreaterFunctorPredicate((IFunctor)o, (IFunctor)v);
    }

    public static Predicate CreateGreaterEqualsPredicate(Object o, Object v) {
        Predicate pred = ExpressionBuilder.CreateLesserPredicate(o, v);
        if (pred.equals(TRUE_PREDICATE)) {
            return FALSE_PREDICATE;
        }
        if (pred.equals(FALSE_PREDICATE)) {
            return TRUE_PREDICATE;
        }
        pred.Invert();
        return pred;
    }

    public static Predicate CreateLikePatternPredicate(Object o, Object pattern) {
        IFunctor functor = (IFunctor)(o instanceof IFunctor ? o : null);
        IGenerator generator = (IGenerator)(pattern instanceof IGenerator ? pattern : null);
        return new FunctorLikePatternPredicate(functor, generator);
    }

    public static Predicate CreateLesserPredicate(Object o, Object v) {
        boolean lhsIsGen = o instanceof IGenerator;
        boolean rhsIsGen = v instanceof IGenerator;
        if (lhsIsGen || rhsIsGen) {
            if (lhsIsGen && rhsIsGen) {
                Object lhs = ((IGenerator)o).Evaluate();
                Object rhs = ((IGenerator)v).Evaluate();
                return lhs.toString().compareTo(rhs.toString()) < 0 ? TRUE_PREDICATE : FALSE_PREDICATE;
            }
            IFunctor func = lhsIsGen ? (IFunctor)v : (IFunctor)o;
            IGenerator gen = lhsIsGen ? (IGenerator)o : (IGenerator)v;
            return new FunctorLesserGeneratorPredicate(func, gen);
        }
        return new FunctorLesserFunctorPredicate((IFunctor)o, (IFunctor)v);
    }

    public static Predicate CreateLesserEqualsPredicate(Object o, Object v) {
        Predicate pred = ExpressionBuilder.CreateGreaterPredicate(o, v);
        if (pred.equals(TRUE_PREDICATE)) {
            return FALSE_PREDICATE;
        }
        if (pred.equals(FALSE_PREDICATE)) {
            return TRUE_PREDICATE;
        }
        pred.Invert();
        return pred;
    }
}

