/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.Queries.ContinuousQuery;
import Alachisoft.NCache.Caching.Queries.ContinuousQueryManagerState;
import Alachisoft.NCache.Caching.Queries.QueryChangeType;
import Alachisoft.NCache.Caching.Queries.QueryDataFilters;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ContinuousQueryManager {
    private ArrayList<ContinuousQuery> registeredQueries = new ArrayList();
    private HashMap<String, HashMap<String, ArrayList<String>>> clientRefs = new HashMap();
    private HashMap<String, HashMap<String, ArrayList<String>>> addNotifications = new HashMap();
    private HashMap<String, HashMap<String, ArrayList<String>>> updateNotifications = new HashMap();
    private HashMap<String, HashMap<String, ArrayList<String>>> removeNotifications = new HashMap();
    private HashMap<String, HashMap<String, EventDataFilter>> maxAddDFAgainstCID = new HashMap();
    private HashMap<String, HashMap<String, EventDataFilter>> maxUpdateDFAgainstCID;
    private HashMap<String, HashMap<String, EventDataFilter>> maxRemoveDFAgainstCID;
    private HashMap<String, HashMap<String, EventDataFilter>> addDFAgainstCUniqueID = new HashMap();
    private HashMap<String, HashMap<String, EventDataFilter>> updateDFAgainstCUniqueID;
    private HashMap<String, HashMap<String, EventDataFilter>> removeDFAgainstCUniqueID;

    public ContinuousQueryManager() {
        this.maxUpdateDFAgainstCID = new HashMap();
        this.updateDFAgainstCUniqueID = new HashMap();
        this.maxRemoveDFAgainstCID = new HashMap();
        this.removeDFAgainstCUniqueID = new HashMap();
    }

    public final ContinuousQueryManagerState GetState() {
        ContinuousQueryManagerState state = new ContinuousQueryManagerState();
        state.setRegisteredQueries(this.registeredQueries);
        state.setClientRefs(this.clientRefs);
        state.setAddNotifications(this.addNotifications);
        state.setUpdateNotifications(this.updateNotifications);
        state.setRemoveNotifications(this.removeNotifications);
        state.setMaxAddDFAgainstCID(this.maxAddDFAgainstCID);
        state.setMaxUpdateDFAgainstCID(this.maxUpdateDFAgainstCID);
        state.setMaxRemoveDFAgainstCID(this.maxRemoveDFAgainstCID);
        state.setAddDFAgainstCUID(this.addDFAgainstCUniqueID);
        state.setUpdateDFAgainstCUID(this.updateDFAgainstCUniqueID);
        state.setRemoveDFAgainstCUID(this.removeDFAgainstCUniqueID);
        return state;
    }

    public final void SetState(ContinuousQueryManagerState state) {
        this.registeredQueries = state.getRegisteredQueries();
        this.clientRefs = state.getClientRefs();
        this.addNotifications = state.getAddNotifications();
        this.updateNotifications = state.getUpdateNotifications();
        this.removeNotifications = state.getRemoveNotifications();
        this.maxAddDFAgainstCID = state.getMaxAddDFAgainstCID();
        this.maxUpdateDFAgainstCID = state.getMaxUpdateDFAgainstCID();
        this.maxRemoveDFAgainstCID = state.getMaxRemoveDFAgainstCID();
        this.addDFAgainstCUniqueID = state.getAddDFAgainstCUID();
        this.updateDFAgainstCUniqueID = state.getUpdateDFAgainstCUID();
        this.removeDFAgainstCUniqueID = state.getRemoveDFAgainstCUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Register(ContinuousQuery query, String clientId, String clientUniqueId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove, QueryDataFilters datafilters) {
        ContinuousQueryManager continuousQueryManager = this;
        synchronized (continuousQueryManager) {
            if (!this.Exists(query)) {
                this.registeredQueries.add(query);
                HashMap refs = new HashMap();
                ArrayList<String> clientUniqueIds = new ArrayList<String>();
                clientUniqueIds.add(clientUniqueId);
                refs.put(clientId, clientUniqueIds);
                this.clientRefs.put(query.getUniqueId(), refs);
                this.RegisterNotifications(notifyAdd, clientId, query.getUniqueId(), clientUniqueId, this.addNotifications, datafilters.getAddDataFilter(), this.maxAddDFAgainstCID, this.addDFAgainstCUniqueID);
                this.RegisterNotifications(notifyUpdate, clientId, query.getUniqueId(), clientUniqueId, this.updateNotifications, datafilters.getUpdateDataFilter(), this.maxUpdateDFAgainstCID, this.updateDFAgainstCUniqueID);
                this.RegisterNotifications(notifyRemove, clientId, query.getUniqueId(), clientUniqueId, this.removeNotifications, datafilters.getRemoveDataFilter(), this.maxRemoveDFAgainstCID, this.removeDFAgainstCUniqueID);
            } else {
                this.Update(query, clientId, clientUniqueId, notifyAdd, notifyUpdate, notifyRemove, datafilters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Update(ContinuousQuery query, String clientId, String clientUniqueId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove, QueryDataFilters datafilters) {
        ContinuousQueryManager continuousQueryManager = this;
        synchronized (continuousQueryManager) {
            if (this.clientRefs.containsKey(query.getUniqueId())) {
                HashMap<String, ArrayList<String>> cRefs = this.clientRefs.get(query.getUniqueId());
                if (cRefs.containsKey(clientId)) {
                    ArrayList<String> refs = cRefs.get(clientId);
                    if (!refs.contains(clientUniqueId)) {
                        refs.add(clientUniqueId);
                    }
                } else {
                    ArrayList<String> clientUniqueIds = new ArrayList<String>();
                    clientUniqueIds.add(clientUniqueId);
                    cRefs.put(clientId, clientUniqueIds);
                }
                this.UpdateNotifications(notifyAdd, clientId, query.getUniqueId(), clientUniqueId, this.addNotifications, datafilters.getAddDataFilter(), this.maxAddDFAgainstCID, this.addDFAgainstCUniqueID);
                this.UpdateNotifications(notifyUpdate, clientId, query.getUniqueId(), clientUniqueId, this.updateNotifications, datafilters.getUpdateDataFilter(), this.maxUpdateDFAgainstCID, this.updateDFAgainstCUniqueID);
                this.UpdateNotifications(notifyRemove, clientId, query.getUniqueId(), clientUniqueId, this.removeNotifications, datafilters.getRemoveDataFilter(), this.maxRemoveDFAgainstCID, this.removeDFAgainstCUniqueID);
            }
        }
    }

    private void UpdateNotifications(boolean notify, String clientId, String serverUniqueId, String clientUniqueId, HashMap<String, HashMap<String, ArrayList<String>>> notifications, EventDataFilter datafilters, HashMap<String, HashMap<String, EventDataFilter>> CID, HashMap<String, HashMap<String, EventDataFilter>> CUID) {
        if (notify) {
            ArrayList<String> clientUniqueIds;
            HashMap<Object, Object> clients;
            if (notifications.containsKey(serverUniqueId)) {
                clients = notifications.get(serverUniqueId);
                if (clients.containsKey(clientId)) {
                    ArrayList clientQueries = (ArrayList)clients.get(clientId);
                    if (!clientQueries.contains(clientUniqueId)) {
                        clientQueries.add(clientUniqueId);
                    }
                } else {
                    clientUniqueIds = new ArrayList();
                    clientUniqueIds.add(clientUniqueId);
                    clients.put(clientId, clientUniqueIds);
                }
            } else {
                clients = new HashMap();
                clientUniqueIds = new ArrayList<String>();
                clientUniqueIds.add(clientUniqueId);
                clients.put(clientId, clientUniqueIds);
                notifications.put(serverUniqueId, clients);
            }
            HashMap<String, Object> clientUIDs = null;
            clientUIDs = CUID.get(clientId);
            if (clientUIDs == null) {
                clientUIDs = new HashMap();
                CUID.put(clientId, clientUIDs);
            }
            clientUIDs.put(clientUniqueId, datafilters);
            HashMap<String, Object> clientDF = null;
            clientDF = CID.get(serverUniqueId);
            if (clientDF == null) {
                clientDF = new HashMap();
                CID.put(serverUniqueId, clientDF);
            }
            EventDataFilter max = EventDataFilter.None;
            for (Map.Entry<String, Object> pair : clientUIDs.entrySet()) {
                if (((EventDataFilter)pair.getValue()).getValue() <= max.getValue()) continue;
                max = (EventDataFilter)pair.getValue();
            }
            if (!clientDF.containsKey(clientId) || ((EventDataFilter)clientDF.get(clientId)).getValue() < max.getValue()) {
                clientDF.put(clientId, max);
            }
        } else if (notifications.containsKey(serverUniqueId)) {
            ArrayList<String> clientQueries;
            HashMap<String, ArrayList<String>> clients = notifications.get(serverUniqueId);
            if (clients.containsKey(clientId) && (clientQueries = clients.get(clientId)).contains(clientUniqueId)) {
                clientQueries.remove(clientUniqueId);
                if (clientQueries.isEmpty()) {
                    clients.remove(clientId);
                }
            }
            this.UnregisterDataFilter(serverUniqueId, clientId, clientUniqueId, CID, CUID);
        }
    }

    private void RegisterNotifications(boolean notify, String clientId, String serverUniqueId, String clientUniqueId, HashMap<String, HashMap<String, ArrayList<String>>> notifications, EventDataFilter datafilter, HashMap<String, HashMap<String, EventDataFilter>> CID, HashMap<String, HashMap<String, EventDataFilter>> CUID) {
        if (notify) {
            HashMap clients = new HashMap();
            ArrayList<String> clientUniqueIds = new ArrayList<String>();
            clientUniqueIds.add(clientUniqueId);
            clients.put(clientId, clientUniqueIds);
            notifications.put(serverUniqueId, clients);
            CID.put(serverUniqueId, new HashMap());
            CID.get(serverUniqueId).put(clientId, datafilter);
            CUID.put(clientId, new HashMap());
            CUID.get(clientId).put(clientUniqueId, datafilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ContinuousQuery GetCQ(String commandText, Map values) {
        ContinuousQueryManager continuousQueryManager = this;
        synchronized (continuousQueryManager) {
            ContinuousQuery query = new ContinuousQuery(commandText, values);
            if (this.registeredQueries.contains(query)) {
                int qIndex = this.registeredQueries.indexOf(query);
                return this.registeredQueries.get(qIndex);
            }
            query.setUniqueId(this.GenerateUniqueId());
            return query;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean Exists(ContinuousQuery query) {
        ContinuousQueryManager continuousQueryManager = this;
        synchronized (continuousQueryManager) {
            return this.registeredQueries.contains(query);
            {
            }
        }
    }

    private String GenerateUniqueId() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList<String> GetClients(String queryId) {
        ContinuousQueryManager continuousQueryManager = this;
        synchronized (continuousQueryManager) {
            ArrayList<Object> clients = null;
            if (this.clientRefs.containsKey(queryId)) {
                HashMap<String, ArrayList<String>> cRefs = this.clientRefs.get(queryId);
                clients = cRefs != null && cRefs.size() > 0 ? new ArrayList<String>(cRefs.keySet()) : new ArrayList();
            }
            return clients;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean AllowNotification(String queryId, String clientId, QueryChangeType changeType) {
        ContinuousQueryManager continuousQueryManager = this;
        synchronized (continuousQueryManager) {
            HashMap<String, ArrayList<String>> clients;
            if (changeType == QueryChangeType.Add) {
                HashMap<String, ArrayList<String>> clients2;
                if (this.addNotifications.containsKey(queryId) && (clients2 = this.addNotifications.get(queryId)) != null && clients2.containsKey(clientId)) {
                    return true;
                }
            } else if (changeType == QueryChangeType.Update) {
                HashMap<String, ArrayList<String>> clients3;
                if (this.updateNotifications.containsKey(queryId) && (clients3 = this.updateNotifications.get(queryId)) != null && clients3.containsKey(clientId)) {
                    return true;
                }
            } else if (this.removeNotifications.containsKey(queryId) && (clients = this.removeNotifications.get(queryId)) != null && clients.containsKey(clientId)) {
                return true;
            }
            return false;
        }
    }

    public final EventDataFilter GetDataFilter(String serverUID, String clientID, QueryChangeType type) {
        HashMap<String, EventDataFilter> clientDF = null;
        EventDataFilter datafilter = EventDataFilter.None;
        if (type == QueryChangeType.Add) {
            clientDF = this.maxAddDFAgainstCID.get(serverUID);
            if (clientDF != null) {
                datafilter = clientDF.get(clientID);
                return datafilter;
            }
            return EventDataFilter.None;
        }
        if (type == QueryChangeType.Update) {
            clientDF = this.maxUpdateDFAgainstCID.get(serverUID);
            if (clientDF != null) {
                datafilter = clientDF.get(clientID);
                return datafilter;
            }
            return EventDataFilter.None;
        }
        clientDF = this.maxRemoveDFAgainstCID.get(serverUID);
        if (clientDF != null) {
            datafilter = clientDF.get(clientID);
            return datafilter;
        }
        return EventDataFilter.None;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean UnRegister(String serverUniqueId, String clientUniqueId, String clientId) {
        ContinuousQueryManager continuousQueryManager = this;
        synchronized (continuousQueryManager) {
            HashMap<String, ArrayList<String>> cRefs;
            if (this.clientRefs.containsKey(serverUniqueId) && (cRefs = this.clientRefs.get(serverUniqueId)).containsKey(clientId)) {
                ArrayList<String> refs = cRefs.get(clientId);
                if (refs.size() > 0) {
                    refs.remove(clientUniqueId);
                    this.UnRegisterNotifications(serverUniqueId, clientUniqueId, clientId, this.addNotifications, this.maxAddDFAgainstCID, this.addDFAgainstCUniqueID);
                    this.UnRegisterNotifications(serverUniqueId, clientUniqueId, clientId, this.updateNotifications, this.maxUpdateDFAgainstCID, this.updateDFAgainstCUniqueID);
                    this.UnRegisterNotifications(serverUniqueId, clientUniqueId, clientId, this.removeNotifications, this.maxRemoveDFAgainstCID, this.removeDFAgainstCUniqueID);
                    if (refs.isEmpty()) {
                        cRefs.remove(clientId);
                    }
                }
                if (cRefs.isEmpty()) {
                    int qIndex = -1;
                    for (ContinuousQuery query : this.registeredQueries) {
                        if (!query.getUniqueId().equals(serverUniqueId)) continue;
                        qIndex = this.registeredQueries.indexOf(query);
                        break;
                    }
                    if (qIndex != -1) {
                        this.registeredQueries.remove(qIndex);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private void UnRegisterNotifications(String serverUniqueId, String clientUniqueId, String clientId, HashMap<String, HashMap<String, ArrayList<String>>> notifications, HashMap<String, HashMap<String, EventDataFilter>> CID, HashMap<String, HashMap<String, EventDataFilter>> CUID) {
        ArrayList<String> clientQueries;
        HashMap<String, ArrayList<String>> clients;
        if (notifications.containsKey(serverUniqueId) && (clients = notifications.get(serverUniqueId)).containsKey(clientId) && (clientQueries = clients.get(clientId)).contains(clientUniqueId)) {
            clientQueries.remove(clientUniqueId);
            if (clientQueries.isEmpty()) {
                clients.remove(clientId);
            }
        }
        this.UnregisterDataFilter(serverUniqueId, clientId, clientUniqueId, CID, CUID);
    }

    private void UnregisterDataFilter(String serverUID, String clientID, String clientUID, HashMap<String, HashMap<String, EventDataFilter>> CID, HashMap<String, HashMap<String, EventDataFilter>> CUID) {
        HashMap<String, EventDataFilter> clientUIDs = null;
        clientUIDs = CUID.get(clientID);
        if (clientUIDs != null) {
            clientUIDs.remove(clientUID);
            if (clientUIDs.isEmpty()) {
                CUID.put(clientID, null);
                clientUIDs = CUID.get(clientID);
                CUID.remove(clientID);
            }
        }
        HashMap<String, EventDataFilter> clientDF = null;
        clientDF = CID.get(serverUID);
        if (clientDF != null) {
            EventDataFilter max = EventDataFilter.None;
            if (clientUIDs != null) {
                for (Map.Entry<String, EventDataFilter> pair : clientUIDs.entrySet()) {
                    if (pair.getValue().getValue() <= max.getValue()) continue;
                    max = pair.getValue();
                }
                if (!clientDF.containsKey(clientID) || clientDF.get(clientID).getValue() < max.getValue()) {
                    clientDF.put(clientID, max);
                }
            } else {
                CID.get(serverUID).remove(clientID);
                if (CID.get(serverUID).isEmpty()) {
                    CID.remove(serverUID);
                }
            }
        }
    }

    public final void dispose() {
        this.Clear();
        if (this.registeredQueries != null) {
            this.registeredQueries = null;
        }
        if (this.clientRefs != null) {
            this.clientRefs = null;
        }
        if (this.addNotifications != null) {
            this.addNotifications = null;
        }
        if (this.updateNotifications != null) {
            this.updateNotifications = null;
        }
        if (this.removeNotifications != null) {
            this.removeNotifications = null;
        }
        this.maxRemoveDFAgainstCID = null;
        this.removeDFAgainstCUniqueID = null;
        this.maxAddDFAgainstCID = null;
        this.addDFAgainstCUniqueID = null;
        this.maxUpdateDFAgainstCID = null;
        this.updateDFAgainstCUniqueID = null;
    }

    public final void Clear() {
    }
}

