/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.EventContext;
import Alachisoft.NCache.Caching.EventId;
import Alachisoft.NCache.Caching.Exceptions.StateTransferException;
import Alachisoft.NCache.Caching.MetaInformation;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.Queries.ActiveQueryEvaluationIndex;
import Alachisoft.NCache.Caching.Queries.AttributeIndex;
import Alachisoft.NCache.Caching.Queries.CQCallbackInfo;
import Alachisoft.NCache.Caching.Queries.Continuous.ContinuousQueryStateInfo;
import Alachisoft.NCache.Caching.Queries.Filters.Predicate;
import Alachisoft.NCache.Caching.Queries.HashStore;
import Alachisoft.NCache.Caching.Queries.IQueryOperationsObserver;
import Alachisoft.NCache.Caching.Queries.PredicateHolder;
import Alachisoft.NCache.Caching.Queries.QueryChangeType;
import Alachisoft.NCache.Caching.Topologies.ICacheEventsListener;
import Alachisoft.NCache.Caching.Topologies.Local.LocalCacheBase;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import Alachisoft.NCache.Common.Threading.AsyncProcessor;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ActiveQueryAnalyzer
implements IQueryOperationsObserver {
    protected HashMap _dataSharingTypesMap;
    protected HashMap<String, AttributeIndex> _sharedAttributeIndex;
    protected String _cacheContext;
    private ICacheEventsListener _queryChangesListener;
    private HashMap<String, ArrayList<PredicateHolder>> _typeSpecificRegisteredPredicates;
    private HashMap<String, ActiveQueryEvaluationIndex> _typeSpecificEvalIndexes;
    private HashMap<String, HashMap<String, ArrayList<PredicateHolder>>> _typeSpecificPredicates;

    public ActiveQueryAnalyzer(ICacheEventsListener queryChangeListener, Map indexedTypes, String cacheContext, HashMap dataSharingKnownTypes) {
        this._queryChangesListener = queryChangeListener;
        this._typeSpecificPredicates = new HashMap();
        this._typeSpecificRegisteredPredicates = new HashMap();
        this._typeSpecificEvalIndexes = new HashMap();
        this._cacheContext = cacheContext;
        this._dataSharingTypesMap = dataSharingKnownTypes;
        if (this._dataSharingTypesMap != null && this._dataSharingTypesMap.size() > 0) {
            this._sharedAttributeIndex = new HashMap();
        }
        if (indexedTypes.containsKey("indexes")) {
            this.InitializeEvalIndexes(indexedTypes.get("indexes") instanceof Map ? indexedTypes.get("indexes") : null, this._cacheContext);
        }
    }

    public final HashMap<String, ArrayList<PredicateHolder>> getTypeSpecificRegisteredPredicates() {
        return this._typeSpecificRegisteredPredicates;
    }

    public final void setTypeSpecificRegisteredPredicates(HashMap<String, ArrayList<PredicateHolder>> value) {
        this._typeSpecificRegisteredPredicates = value;
    }

    public final HashMap<String, ActiveQueryEvaluationIndex> getTypeSpecificEvalIndexes() {
        return this._typeSpecificEvalIndexes;
    }

    public final void setTypeSpecificEvalIndexes(HashMap<String, ActiveQueryEvaluationIndex> value) {
        this._typeSpecificEvalIndexes = value;
    }

    public final HashMap<String, HashMap<String, ArrayList<PredicateHolder>>> getTypeSpecificPredicates() {
        return this._typeSpecificPredicates;
    }

    public final void setTypeSpecificPredicates(HashMap<String, HashMap<String, ArrayList<PredicateHolder>>> value) {
        this._typeSpecificPredicates = value;
    }

    public final boolean checkForSameClassNames(HashMap knownSharedClasses) {
        Collection coll = knownSharedClasses.values();
        HashMap[] values = new HashMap[coll.size()];
        values = coll.toArray(values);
        for (int outer = 0; outer < values.length - 1; ++outer) {
            HashMap outerValue = values[outer];
            String name = (String)outerValue.get("name");
            String[] temp = name.split("[:]", -1);
            String outerTypeName = temp[0];
            for (int inner = outer + 1; inner < values.length; ++inner) {
                HashMap innerValue = values[inner];
                String name1 = (String)innerValue.get("name");
                String[] temp1 = name1.split("[:]", -1);
                String innerTypeName = temp1[0];
                if (!outerTypeName.equals(innerTypeName)) continue;
                return false;
            }
        }
        return true;
    }

    public final void manipulateDataSharing(HashMap indexClasses) {
        if (this._dataSharingTypesMap != null && this._dataSharingTypesMap.size() > 0 && indexClasses != null) {
            for (Map.Entry current_1 : this._dataSharingTypesMap.entrySet()) {
                HashMap knownSharedClasses;
                HashMap typeHashMap = current_1.getValue() instanceof HashMap ? current_1.getValue() : null;
                if (typeHashMap == null || !typeHashMap.containsKey("known-classes") || !this.checkForSameClassNames(knownSharedClasses = (HashMap)typeHashMap.get("known-classes"))) continue;
                this.createSharedTypeAttributeIndex(knownSharedClasses, indexClasses);
            }
        }
    }

    public final void createSharedTypeAttributeIndex(HashMap knownSharedClasses, HashMap indexedClasses) {
        HashMap<Object, HashStore> commonRBStore = new HashMap<Object, HashStore>();
        HashMap<String, ActiveQueryEvaluationIndex> sharedAttributeIndexMap = new HashMap<String, ActiveQueryEvaluationIndex>();
        Iterator iteouterSharedTypes = knownSharedClasses.entrySet().iterator();
        commonRBStore.put("$Tag$", new HashStore());
        while (iteouterSharedTypes.hasNext()) {
            HashMap outerTypeAttributes;
            Map.Entry outerEntry = iteouterSharedTypes.next();
            HashMap outerEntryValue = (HashMap)outerEntry.getValue();
            String name = (String)outerEntryValue.get("name");
            String[] temp = name.split(":");
            String outerTypeName = temp[0];
            sharedAttributeIndexMap.put(outerTypeName, new ActiveQueryEvaluationIndex(this._cacheContext, outerTypeName));
            if (indexedClasses.size() <= 0 || !this.isQueryindexed(outerTypeName, indexedClasses) || (outerTypeAttributes = (HashMap)outerEntryValue.get("attribute")) == null) continue;
            for (Map.Entry tempEntry : outerTypeAttributes.entrySet()) {
                HashMap outerAttributeMeta = (HashMap)tempEntry.getValue();
                String outerOrderNo = (String)outerAttributeMeta.get("order");
                String outerAttributeName = (String)outerAttributeMeta.get("name");
                if (!this.isQueryindexedAttribute(outerTypeName, outerAttributeName, indexedClasses)) continue;
                block2: for (Map.Entry innerEntry : knownSharedClasses.entrySet()) {
                    HashMap innerEntryValue = (HashMap)innerEntry.getValue();
                    String name1 = (String)innerEntryValue.get("name");
                    String[] temp1 = name1.split(":");
                    String innerTypeName = temp1[0];
                    if (outerTypeName.equals(innerTypeName) || !this.isQueryindexed(innerTypeName, indexedClasses)) continue;
                    HashMap innerTypeAttributes = (HashMap)((HashMap)innerEntry.getValue()).get("attribute");
                    for (Map.Entry tempEntry1 : innerTypeAttributes.entrySet()) {
                        HashStore commonRB;
                        HashMap innerAttributeMeta = (HashMap)tempEntry1.getValue();
                        String innerorderNo = (String)innerAttributeMeta.get("order");
                        String innerAttributeName = (String)innerAttributeMeta.get("name");
                        if (!innerorderNo.equals(outerOrderNo) || !this.isQueryindexedAttribute(innerTypeName, innerAttributeName, indexedClasses)) continue;
                        if (commonRBStore.containsKey(outerTypeName + ":" + outerAttributeName)) {
                            commonRB = (HashStore)commonRBStore.get(outerTypeName + ":" + outerAttributeName);
                            commonRBStore.put(innerTypeName + ":" + innerAttributeName, commonRB);
                            continue block2;
                        }
                        commonRB = new HashStore();
                        commonRBStore.put(innerTypeName + ":" + innerAttributeName, commonRB);
                        commonRBStore.put(outerTypeName + ":" + outerAttributeName, commonRB);
                        continue block2;
                    }
                }
            }
        }
        if (sharedAttributeIndexMap.size() > 0) {
            Iterator iteSharedIndexMap = sharedAttributeIndexMap.entrySet().iterator();
            while (iteSharedIndexMap.hasNext()) {
                ArrayList<AttributeIndex> sharedTypes = new ArrayList<AttributeIndex>();
                Map.Entry outerEntry = iteSharedIndexMap.next();
                String outerTypeName = (String)outerEntry.getKey();
                ActiveQueryEvaluationIndex outerSharedIndex = (ActiveQueryEvaluationIndex)outerEntry.getValue();
                for (Map.Entry innerEntry : sharedAttributeIndexMap.entrySet()) {
                    String innerTypeName = (String)innerEntry.getKey();
                    if (innerTypeName.equals(outerTypeName)) continue;
                    ActiveQueryEvaluationIndex innerSharedIndex = (ActiveQueryEvaluationIndex)innerEntry.getValue();
                    sharedTypes.add(innerSharedIndex);
                }
                ((AttributeIndex)outerSharedIndex).setCommonRBStores(commonRBStore);
                ((AttributeIndex)outerSharedIndex).setSharedTypes(sharedTypes);
                this._sharedAttributeIndex.put(outerTypeName, outerSharedIndex);
            }
        }
    }

    public final boolean isQueryindexed(String typeName, HashMap indexedClasses) {
        for (Map.Entry current_1 : indexedClasses.entrySet()) {
            HashMap innerProps = current_1.getValue() instanceof HashMap ? current_1.getValue() : null;
            String queryIndexedTypename = "";
            if (innerProps == null || !typeName.equals(queryIndexedTypename = (String)innerProps.get("id"))) continue;
            return true;
        }
        return false;
    }

    public final boolean isQueryindexedAttribute(String typeName, String attributeName, HashMap indexedClasses) {
        for (Map.Entry current_1 : indexedClasses.entrySet()) {
            HashMap innerProps = current_1.getValue() instanceof HashMap ? current_1.getValue() : null;
            String queryIndexedTypeName = "";
            if (innerProps == null || !typeName.equals(queryIndexedTypeName = (String)innerProps.get("id"))) continue;
            ArrayList attribList = new ArrayList();
            for (Map.Entry current_2 : innerProps.entrySet()) {
                HashMap attribs = current_2.getValue() instanceof HashMap ? current_2.getValue() : null;
                if (attribs == null) continue;
                for (Map.Entry current_3 : attribs.entrySet()) {
                    String tempAttrib;
                    HashMap attrib = current_3.getValue() instanceof HashMap ? current_3.getValue() : null;
                    if (attrib == null || !attributeName.equals(tempAttrib = (String)attrib.get("id"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void InitializeEvalIndexes(Map indexedTypes, String cacheContext) {
        if (indexedTypes != null && indexedTypes.containsKey("index-classes")) {
            HashMap indexClasses = indexedTypes.get("index-classes") instanceof HashMap ? indexedTypes.get("index-classes") : null;
            this.manipulateDataSharing(indexClasses);
            for (Map.Entry entry : indexClasses.entrySet()) {
                AttributeIndex index;
                HashMap innerProps = entry.getValue() instanceof HashMap ? entry.getValue() : null;
                String typename = "";
                if (innerProps == null) continue;
                typename = (String)innerProps.get("id");
                ArrayList<String> attribList = new ArrayList<String>();
                for (Map.Entry current : innerProps.entrySet()) {
                    HashMap attribs = current.getValue() instanceof HashMap ? current.getValue() : null;
                    if (attribs == null) continue;
                    for (Map.Entry subcurrent : attribs.entrySet()) {
                        HashMap attrib = subcurrent.getValue() instanceof HashMap ? subcurrent.getValue() : null;
                        if (attrib == null) continue;
                        attribList.add(attrib.get("id") instanceof String ? attrib.get("id") : null);
                    }
                }
                if (attribList.size() <= 0) continue;
                if (this._sharedAttributeIndex != null && this._sharedAttributeIndex.containsKey(typename)) {
                    index = this._sharedAttributeIndex.get(typename);
                    index.Initialize(attribList);
                    this.getTypeSpecificEvalIndexes().put(typename, (ActiveQueryEvaluationIndex)index);
                    continue;
                }
                index = new ActiveQueryEvaluationIndex(attribList, cacheContext, typename);
                this.getTypeSpecificEvalIndexes().put(typename, (ActiveQueryEvaluationIndex)index);
            }
        }
    }

    public final ContinuousQueryStateInfo GetStateInfo() {
        ContinuousQueryStateInfo stateInfo = new ContinuousQueryStateInfo();
        stateInfo.setIsPartial(false);
        stateInfo.setTypeSpecificPredicates(this.getTypeSpecificPredicates());
        stateInfo.setTypeSpecificRegisteredPredicates(this.getTypeSpecificRegisteredPredicates());
        stateInfo.setTypeSpecificEvalIndexes(this.getTypeSpecificEvalIndexes());
        return stateInfo;
    }

    public final ArrayList<PredicateHolder> GetPredicatesForType(String type) {
        ArrayList<PredicateHolder> result = null;
        if (this.getTypeSpecificRegisteredPredicates().containsKey(type)) {
            result = this.getTypeSpecificRegisteredPredicates().get(type);
        }
        return result;
    }

    public final void RegisterPredicate(String type, String commandText, Map queryValues, Predicate predicate, String queryId, ArrayList keys) {
        HashMap<Object, Object> predicateKeys;
        ArrayList<Object> holders;
        PredicateHolder holder = new PredicateHolder();
        holder.setQueryId(queryId);
        holder.setPredicate(predicate);
        holder.setAttributeValues(queryValues);
        holder.setCommandText(commandText);
        holder.setObjectType(type);
        if (this.getTypeSpecificRegisteredPredicates().containsKey(type)) {
            holders = this.getTypeSpecificRegisteredPredicates().get(type);
            holders.add(holder);
        } else {
            holders = new ArrayList<PredicateHolder>();
            holders.add(holder);
            this.getTypeSpecificRegisteredPredicates().put(type, holders);
        }
        if (this.getTypeSpecificPredicates().containsKey(type)) {
            predicateKeys = this.getTypeSpecificPredicates().get(type);
            for (String key : keys) {
                ArrayList predicates;
                if (predicateKeys.containsKey(key)) {
                    predicates = (ArrayList)predicateKeys.get(key);
                    predicates.add(holder);
                    continue;
                }
                predicates = new ArrayList();
                predicates.add(holder);
                predicateKeys.put(key, predicates);
            }
        } else {
            predicateKeys = new HashMap();
            for (Object key : keys) {
                ArrayList<PredicateHolder> predicates = new ArrayList<PredicateHolder>();
                predicates.add(holder);
                predicateKeys.put((String)key, predicates);
            }
            this.getTypeSpecificPredicates().put(type, predicateKeys);
        }
    }

    public final void UnRegisterPredicate(String queryId) {
        PredicateHolder holder = new PredicateHolder();
        holder.setQueryId(queryId);
        ArrayList<String> typePredicatesKeysToRemove = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<PredicateHolder>> typePredicates : this._typeSpecificRegisteredPredicates.entrySet()) {
            int index = typePredicates.getValue().indexOf(holder);
            if (index == -1) continue;
            String objectType = typePredicates.getValue().get(index).getObjectType();
            ArrayList<String> typeSpecificKeysToRemove = new ArrayList<String>();
            if (this.getTypeSpecificPredicates().containsKey(objectType)) {
                HashMap<String, ArrayList<PredicateHolder>> typeSpecificPredicates = this.getTypeSpecificPredicates().get(objectType);
                for (Map.Entry<String, ArrayList<PredicateHolder>> keyPredicates : typeSpecificPredicates.entrySet()) {
                    keyPredicates.getValue().remove(holder);
                    if (keyPredicates.getValue().size() != 0) continue;
                    typeSpecificKeysToRemove.add(keyPredicates.getKey());
                }
                for (String key : typeSpecificKeysToRemove) {
                    typeSpecificPredicates.remove(key);
                }
                if (typeSpecificPredicates.isEmpty()) {
                    this.getTypeSpecificPredicates().remove(objectType);
                }
            }
            typePredicates.getValue().remove(index);
            if (typePredicates.getValue().size() != 0) break;
            typePredicatesKeysToRemove.add(typePredicates.getKey());
            break;
        }
        for (String key : typePredicatesKeysToRemove) {
            this._typeSpecificRegisteredPredicates.remove(key);
        }
    }

    @Override
    public void OnItemAdded(Object key, MetaInformation metaInfo, LocalCacheBase cache, String cacheContext, boolean notify, OperationContext operationContext, EventContext eventContext) throws RedBlackException, StateTransferException, CacheException {
        try {
            this.NotifyModifiedQueries(String.valueOf(key), metaInfo, cache, cacheContext, QueryChangeType.Add, notify, operationContext, eventContext);
        }
        catch (Exception exception) {
            throw new CacheException((Throwable)exception);
        }
    }

    @Override
    public void OnItemUpdated(Object key, MetaInformation metaInfo, LocalCacheBase cache, String cacheContext, boolean notify, OperationContext operationContext, EventContext eventContext) throws RedBlackException, StateTransferException, CacheException {
        try {
            this.NotifyModifiedQueries(String.valueOf(key), metaInfo, cache, cacheContext, QueryChangeType.Update, notify, operationContext, eventContext);
        }
        catch (Exception exception) {
            throw new CacheException((Throwable)exception);
        }
    }

    @Override
    public void OnItemRemoved(Object key, MetaInformation metaInfo, LocalCacheBase cache, String cacheContext, boolean notify, OperationContext operationContext, EventContext eventContext) throws RedBlackException, StateTransferException, CacheException {
        try {
            this.NotifyModifiedQueries(String.valueOf(key), metaInfo, cache, cacheContext, QueryChangeType.Remove, notify, operationContext, eventContext);
        }
        catch (Exception exception) {
            throw new CacheException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void NotifyModifiedQueries(String key, MetaInformation metaInfo, LocalCacheBase cache, String cacheContext, QueryChangeType changeType, boolean notify, OperationContext operationContext, EventContext eventContext) throws RedBlackException, StateTransferException, Exception {
        if (metaInfo == null) {
            return;
        }
        if (metaInfo.getType() == null) {
            return;
        }
        String baseType = metaInfo.getType();
        ArrayList<String> types = new ArrayList<String>();
        types.add(baseType);
        if (this._sharedAttributeIndex != null && this._sharedAttributeIndex.containsKey(baseType)) {
            AttributeIndex index = this._sharedAttributeIndex.get(baseType);
            for (AttributeIndex tempIndex : index._sharedTypes) {
                types.add(tempIndex._type);
            }
        }
        for (String type : types) {
            AttributeIndex index = null;
            try {
                ArrayList<CQCallbackInfo> modifiedQueries = new ArrayList<CQCallbackInfo>();
                if (changeType == QueryChangeType.Add || changeType == QueryChangeType.Update) {
                    HashMap indexedAttributes = metaInfo.getAttributeValues();
                    if (this.getTypeSpecificEvalIndexes().containsKey(type)) {
                        index = this.getTypeSpecificEvalIndexes().get(type);
                    } else {
                        index = new ActiveQueryEvaluationIndex(new ArrayList(indexedAttributes.keySet()), cacheContext, type);
                        this.getTypeSpecificEvalIndexes().put(type, (ActiveQueryEvaluationIndex)index);
                    }
                    ((ActiveQueryEvaluationIndex)index).AddToIndex(key, indexedAttributes);
                }
                EventId eventId = null;
                if (eventContext != null) {
                    eventId = eventContext.getEventID();
                }
                if (changeType == QueryChangeType.Add) {
                    if (eventId != null) {
                        eventId.setQueryChangeType(QueryChangeType.Add);
                    }
                    modifiedQueries.addAll(this.GetInclusion(key, type, index, cache, cacheContext, changeType));
                } else if (changeType == QueryChangeType.Update) {
                    ArrayList<CQCallbackInfo> includedQueries;
                    ArrayList<CQCallbackInfo> retainedQueries;
                    ArrayList<CQCallbackInfo> excludedQueries = this.GetExclusion(key, type, index, cache, cacheContext);
                    if (excludedQueries.size() > 0 && notify) {
                        if (eventId != null) {
                            eventId = (EventId)eventId.clone();
                            eventContext = (EventContext)eventContext.clone();
                            eventId.setQueryChangeType(QueryChangeType.Remove);
                        }
                        this._queryChangesListener.OnActiveQueryChanged(key, QueryChangeType.Remove, excludedQueries, operationContext, eventContext);
                    }
                    if ((retainedQueries = this.GetRetention(key, type, index, cache, cacheContext)).size() > 0 && notify) {
                        if (eventId != null) {
                            eventId = (EventId)eventId.clone();
                            eventContext = (EventContext)eventContext.clone();
                            eventId.setQueryChangeType(QueryChangeType.Update);
                        }
                        this._queryChangesListener.OnActiveQueryChanged(key, QueryChangeType.Update, retainedQueries, operationContext, eventContext);
                    }
                    if ((includedQueries = this.GetInclusion(key, type, index, cache, cacheContext, changeType)).size() > 0 && notify) {
                        if (eventId != null) {
                            eventId = (EventId)eventId.clone();
                            eventContext = (EventContext)eventContext.clone();
                            eventId.setQueryChangeType(QueryChangeType.Add);
                        }
                        this._queryChangesListener.OnActiveQueryChanged(key, QueryChangeType.Add, includedQueries, operationContext, eventContext);
                    }
                } else {
                    HashMap<String, ArrayList<PredicateHolder>> predicateKeys;
                    if (this.getTypeSpecificPredicates().containsKey(type) && (predicateKeys = this.getTypeSpecificPredicates().get(type)).containsKey(key)) {
                        for (PredicateHolder existingholder : predicateKeys.get(key)) {
                            CQCallbackInfo info = new CQCallbackInfo();
                            info.setCQId(existingholder.getQueryId());
                            modifiedQueries.add(info);
                        }
                        predicateKeys.remove(key);
                    }
                    if (eventId != null) {
                        eventId.setQueryChangeType(QueryChangeType.Remove);
                    }
                }
                if (modifiedQueries.size() <= 0 || !notify) continue;
                this._queryChangesListener.OnActiveQueryChanged(key, changeType, modifiedQueries, operationContext, eventContext);
            }
            finally {
                if (index == null) continue;
                index.Clear();
            }
        }
    }

    private ArrayList<CQCallbackInfo> GetInclusion(String key, String type, AttributeIndex index, LocalCacheBase cache, String cacheContext, QueryChangeType changeType) throws StateTransferException, Exception {
        ArrayList<CQCallbackInfo> modifiedQueries = new ArrayList<CQCallbackInfo>();
        if (this.getTypeSpecificRegisteredPredicates().containsKey(type)) {
            for (PredicateHolder holder : this.getTypeSpecificRegisteredPredicates().get(type)) {
                HashMap<Object, Object> predicateKeys;
                ArrayList keys = holder.getPredicate().ReEvaluate(index, cache, holder.getAttributeValues(), cacheContext);
                if (keys.size() <= 0) continue;
                CQCallbackInfo info = new CQCallbackInfo();
                info.setCQId(holder.getQueryId());
                if (this.getTypeSpecificPredicates().containsKey(type)) {
                    predicateKeys = this.getTypeSpecificPredicates().get(type);
                    if (predicateKeys.containsKey(key)) {
                        ArrayList existingholders = (ArrayList)predicateKeys.get(key);
                        if (existingholders.contains(holder)) continue;
                        existingholders.add(holder);
                        modifiedQueries.add(info);
                        continue;
                    }
                    ArrayList<PredicateHolder> newHolders = new ArrayList<PredicateHolder>();
                    newHolders.add(holder);
                    predicateKeys.put(key, newHolders);
                    modifiedQueries.add(info);
                    continue;
                }
                predicateKeys = new HashMap();
                ArrayList<PredicateHolder> holders = new ArrayList<PredicateHolder>();
                holders.add(holder);
                predicateKeys.put(key, holders);
                this.getTypeSpecificPredicates().put(type, predicateKeys);
                modifiedQueries.add(info);
            }
        }
        return modifiedQueries;
    }

    private ArrayList<CQCallbackInfo> GetExclusion(String key, String type, AttributeIndex index, LocalCacheBase cache, String cacheContext) throws StateTransferException, Exception {
        HashMap<String, ArrayList<PredicateHolder>> predicateKeys;
        ArrayList<CQCallbackInfo> removedQueries = new ArrayList<CQCallbackInfo>();
        if (this.getTypeSpecificPredicates().containsKey(type) && (predicateKeys = this.getTypeSpecificPredicates().get(type)).containsKey(key)) {
            ArrayList<PredicateHolder> existingholders = predicateKeys.get(key);
            ArrayList<PredicateHolder> holdersToRemove = new ArrayList<PredicateHolder>();
            for (PredicateHolder existingholder : existingholders) {
                ArrayList keys = existingholder.getPredicate().ReEvaluate(index, cache, existingholder.getAttributeValues(), cacheContext);
                if (!keys.isEmpty()) continue;
                CQCallbackInfo info = new CQCallbackInfo();
                info.setCQId(existingholder.getQueryId());
                removedQueries.add(info);
                holdersToRemove.add(existingholder);
            }
            for (PredicateHolder holder : holdersToRemove) {
                existingholders.remove(holder);
            }
            if (existingholders.isEmpty()) {
                predicateKeys.remove(key);
            }
            if (predicateKeys.isEmpty()) {
                this.getTypeSpecificPredicates().remove(type);
            }
        }
        return removedQueries;
    }

    private ArrayList<CQCallbackInfo> GetRetention(String key, String type, AttributeIndex index, LocalCacheBase cache, String cacheContext) throws StateTransferException, Exception {
        HashMap<String, ArrayList<PredicateHolder>> predicateKeys;
        ArrayList<CQCallbackInfo> updatedQueries = new ArrayList<CQCallbackInfo>();
        if (this.getTypeSpecificPredicates().containsKey(type) && (predicateKeys = this.getTypeSpecificPredicates().get(type)).containsKey(key)) {
            ArrayList<PredicateHolder> existingholders = predicateKeys.get(key);
            for (PredicateHolder existingholder : existingholders) {
                ArrayList keys = existingholder.getPredicate().ReEvaluate(index, cache, existingholder.getAttributeValues(), cacheContext);
                if (keys.size() <= 0) continue;
                CQCallbackInfo info = new CQCallbackInfo();
                info.setCQId(existingholder.getQueryId());
                updatedQueries.add(info);
            }
        }
        return updatedQueries;
    }

    public final ArrayList Search(String queryId) {
        ArrayList<String> keys = new ArrayList<String>();
        PredicateHolder holder = new PredicateHolder();
        holder.setQueryId(queryId);
        for (ArrayList<PredicateHolder> holders : this.getTypeSpecificRegisteredPredicates().values()) {
            int index = holders.indexOf(holder);
            if (index == -1) continue;
            String objectType = holders.get(index).getObjectType();
            if (!this.getTypeSpecificPredicates().containsKey(objectType)) break;
            for (Map.Entry<String, ArrayList<PredicateHolder>> keyPredicates : this.getTypeSpecificPredicates().get(objectType).entrySet()) {
                if (!keyPredicates.getValue().contains(holder)) continue;
                keys.add(keyPredicates.getKey());
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Clear(OperationContext operationContext, EventContext eventContext) {
        if (this._typeSpecificRegisteredPredicates != null) {
            HashMap<String, HashMap<String, ArrayList<PredicateHolder>>> hashMap = this._typeSpecificPredicates;
            synchronized (hashMap) {
                for (Map.Entry<String, HashMap<String, ArrayList<PredicateHolder>>> typePredicates : this._typeSpecificPredicates.entrySet()) {
                    HashMap<String, ArrayList<PredicateHolder>> typeSPredicates = this._typeSpecificPredicates.get(typePredicates.getKey());
                    if (typeSPredicates == null) continue;
                    typeSPredicates.clear();
                }
            }
        }
    }

    public final void dispose() {
        this.Clear(null, null);
        if (this._typeSpecificRegisteredPredicates != null) {
            this._typeSpecificRegisteredPredicates = null;
        }
        if (this._typeSpecificPredicates != null) {
            this._typeSpecificPredicates = null;
        }
        if (this._typeSpecificEvalIndexes != null) {
            this._typeSpecificEvalIndexes.clear();
            this._typeSpecificEvalIndexes = null;
        }
    }

    private final class ClearAsyncTask
    implements AsyncProcessor.IAsyncTask {
        ArrayList<CQCallbackInfo> _modifiedQueries;
        ActiveQueryAnalyzer _queryAnalyzer;
        OperationContext _operationContext;
        EventContext _eventContext;
        private Object _key;

        public ClearAsyncTask(ActiveQueryAnalyzer queryAnalyzer, Object key, ArrayList<CQCallbackInfo> modifiedQueries, OperationContext operationContext, EventContext eventContext) {
            this._queryAnalyzer = queryAnalyzer;
            this._key = key;
            this._modifiedQueries = modifiedQueries;
            this._operationContext = operationContext;
            this._eventContext = eventContext;
        }

        public void Process() {
            try {
                this._queryAnalyzer._queryChangesListener.OnActiveQueryChanged(this._key.toString(), QueryChangeType.Remove, this._modifiedQueries, this._operationContext, this._eventContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final class AsyncTask
    implements AsyncProcessor.IAsyncTask {
        LocalCacheBase _cache;
        String _cacheContext;
        boolean _notify;
        ActiveQueryAnalyzer _queryAnalyzer;
        QueryChangeType _taskType;
        OperationContext _operationContext;
        EventContext _eventContext;
        private Object _key;
        private MetaInformation _metaInfo;

        public AsyncTask(ActiveQueryAnalyzer queryAnalyzer, Object key, MetaInformation metaInfo, LocalCacheBase cache, String cacheContext, boolean notify, QueryChangeType taskType, OperationContext operationContext, EventContext eventContext) {
            this._key = key;
            this._metaInfo = metaInfo;
            this._cache = cache;
            this._cacheContext = cacheContext;
            this._notify = notify;
            this._taskType = taskType;
            this._queryAnalyzer = queryAnalyzer;
            this._operationContext = operationContext;
            this._eventContext = eventContext;
        }

        public void Process() {
            try {
                this._queryAnalyzer.NotifyModifiedQueries(this._key.toString(), this._metaInfo, this._cache, this._cacheContext, this._taskType, this._notify, this._operationContext, this._eventContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

