/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Messaging;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.ISizable;
import Alachisoft.NCache.Common.Messaging.MessageMetaData;
import Alachisoft.NCache.Common.Messaging.SubscriptionIdentifier;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public class Message
implements ISizable,
Cloneable,
ICompactSerializable,
Serializable {
    private static int PrimitiveDTSize = 200;
    private String _messageId;
    private long _size = -1L;
    private Date privateCreationTime = new Date(0L);
    private Object privatePayLoad;
    private BitSet privateFlagMap;
    private MessageMetaData privateMessageMetaData;
    private boolean privateIsMulticast;

    public Message(String messageId) {
        this._messageId = messageId;
    }

    public final String getMessageId() {
        return this._messageId;
    }

    public final Date getCreationTime() {
        return this.privateCreationTime;
    }

    public final void setCreationTime(Date value) {
        this.privateCreationTime = value;
    }

    public final Object getPayLoad() {
        return this.privatePayLoad;
    }

    public final void setPayLoad(Object value) {
        this.privatePayLoad = value;
    }

    public final BitSet getFlagMap() {
        return this.privateFlagMap;
    }

    public final void setFlagMap(BitSet value) {
        this.privateFlagMap = value;
    }

    public final MessageMetaData getMessageMetaData() {
        return this.privateMessageMetaData;
    }

    public final void setMessageMetaData(MessageMetaData value) {
        this.privateMessageMetaData = value;
    }

    public final boolean getIsMulticast() {
        return this.privateIsMulticast;
    }

    public final void setIsMulticast(boolean value) {
        this.privateIsMulticast = value;
    }

    public final int getSize() {
        return (int)((long)PrimitiveDTSize + this.getDataSize());
    }

    public final int getInMemorySize() {
        return (int)((long)PrimitiveDTSize + this.getInMemoryDataSize());
    }

    public final long getInMemoryDataSize() {
        int size = 0;
        if (this.getPayLoad() != null && this.getPayLoad() instanceof UserBinaryObject) {
            size = ((UserBinaryObject)this.getPayLoad()).getInMemorySize();
        }
        return size;
    }

    public final long getDataSize() {
        if (this._size > -1L) {
            return this._size;
        }
        int size = 0;
        if (this.getPayLoad() != null && this.getPayLoad() instanceof UserBinaryObject) {
            size = ((UserBinaryObject)this.getPayLoad()).getSize();
        }
        return size;
    }

    public final void setDataSize(long value) {
        this._size = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object clone() {
        Message messageEntry = new Message(this._messageId);
        Message message = this;
        synchronized (message) {
            messageEntry.setCreationTime(this.getCreationTime());
            messageEntry.setPayLoad(this.getPayLoad());
            messageEntry.setFlagMap((BitSet)this.getFlagMap().Clone());
        }
        return messageEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Message CloneWithoutValue() {
        Message messageEntry = new Message(this._messageId);
        Message message = this;
        synchronized (message) {
            messageEntry.setCreationTime(this.getCreationTime());
            messageEntry.setFlagMap((BitSet)this.getFlagMap().Clone());
        }
        return messageEntry;
    }

    public int hashCode() {
        return this.getMessageId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SubscriptionIdentifier) {
            SubscriptionIdentifier other = (SubscriptionIdentifier)(obj instanceof SubscriptionIdentifier ? obj : null);
            if (this.getMessageId().compareToIgnoreCase(other.getSubscriptionName()) == 0) {
                return true;
            }
        }
        return false;
    }

    public void serialize(NCacheObjectOutput out) throws IOException {
    }

    public void deserialize(NCacheObjectInput in) throws IOException, ClassNotFoundException {
    }
}

