/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.EvictionPolicies;

import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHintType;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimestampHint
extends EvictionHint
implements ICompactSerializable,
Serializable {
    protected Date _dt = new Date(0L);

    public TimestampHint() {
        this._hintType = EvictionHintType.TimestampHint;
        TimeZone utc = TimeZone.getTimeZone("UTC");
        this._dt = Calendar.getInstance(utc).getTime();
    }

    public final Date getTimeStamp() {
        return this._dt;
    }

    @Override
    public boolean getIsVariant() {
        return true;
    }

    @Override
    public boolean Update() {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        this._dt = Calendar.getInstance(utc).getTime();
        return true;
    }

    @Override
    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        this._dt = new NCDateTime(reader.readLong()).getDate();
    }

    @Override
    public void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(14, 0);
        c.setTime(this._dt);
        NCDateTime ncdt = null;
        try {
            ncdt = new NCDateTime(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        writer.writeLong(ncdt.getTicks());
    }
}

