/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.EvictionPolicies;

import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHintType;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;

public class PriorityEvictionHint
extends EvictionHint
implements ICompactSerializable,
Serializable {
    private CacheItemPriority _priority = CacheItemPriority.values()[0];

    public PriorityEvictionHint() {
        this._hintType = EvictionHintType.PriorityEvictionHint;
        this._priority = CacheItemPriority.Normal;
    }

    public PriorityEvictionHint(CacheItemPriority priority) {
        this._hintType = EvictionHintType.PriorityEvictionHint;
        this._priority = priority;
    }

    public final CacheItemPriority getPriority() {
        return this._priority;
    }

    public final void setPriority(CacheItemPriority value) {
        this._priority = value;
    }

    @Override
    public boolean getIsVariant() {
        return false;
    }

    @Override
    public boolean Update() {
        return false;
    }

    @Override
    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        int priority = reader.readInt();
        switch (priority) {
            case -2: {
                this._priority = CacheItemPriority.Low;
                break;
            }
            case -1: {
                this._priority = CacheItemPriority.BelowNormal;
                break;
            }
            case 0: {
                this._priority = CacheItemPriority.Normal;
                break;
            }
            case 1: {
                this._priority = CacheItemPriority.AboveNormal;
                break;
            }
            case 2: {
                this._priority = CacheItemPriority.High;
                break;
            }
            case 3: {
                this._priority = CacheItemPriority.NotRemovable;
                break;
            }
            case 4: {
                this._priority = CacheItemPriority.Default;
                break;
            }
            default: {
                this._priority = CacheItemPriority.Default;
            }
        }
    }

    @Override
    public void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        writer.writeInt(this._priority.value());
    }
}

