/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.EvictionPolicies;

import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.EvictionPolicies.IEvictionPolicy;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Common.Util.ReaderWriterLock;

public class EvictionPolicySyncWrapper
implements IEvictionPolicy {
    private IEvictionPolicy _evctPolicy;
    private ReaderWriterLock _sync = new ReaderWriterLock();

    public EvictionPolicySyncWrapper(IEvictionPolicy evictionPolicy) {
        this._evctPolicy = evictionPolicy;
    }

    public final ReaderWriterLock getSync() {
        return this._sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void Notify(Object key, EvictionHint oldhint, EvictionHint newHint) {
        this.getSync().AcquireWriterLock();
        try {
            this._evctPolicy.Notify(key, oldhint, newHint);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public final void Clear() {
        this.getSync().AcquireWriterLock();
        try {
            this._evctPolicy.Clear();
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public final EvictionHint CompatibleHint(EvictionHint eh) {
        return this._evctPolicy.CompatibleHint(eh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void Execute(CacheBase cache, CacheRuntimeContext context, long count) {
        this.getSync().AcquireWriterLock();
        try {
            this._evctPolicy.Execute(cache, context, count);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public final void Remove(Object key, EvictionHint hint) {
        this.getSync().AcquireWriterLock();
        try {
            this._evctPolicy.Remove(key, hint);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public final float getEvictRatio() {
        this.getSync().AcquireWriterLock();
        try {
            float f = this._evctPolicy.getEvictRatio();
            return f;
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public final void setEvictRatio(float value) {
        this.getSync().AcquireWriterLock();
        try {
            this._evctPolicy.setEvictRatio(value);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }
}

