/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.EvictionPolicies;

import Alachisoft.NCache.Caching.EvictionPolicies.EvictionIndexEntry;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import tangible.RefObject;

public class EvictionIndex {
    private HashMap _index = new HashMap();
    private long _head = -1L;
    private long _tail = -1L;
    private Object _syncLock = new Object();

    public final Object getSyncRoot() {
        return this._syncLock;
    }

    public final boolean Contains(long key, Object value) {
        if (this._index.containsKey(key)) {
            EvictionIndexEntry indexEntry = this._index.get(key) instanceof EvictionIndexEntry ? this._index.get(key) : null;
            return indexEntry.Contains(value);
        }
        return false;
    }

    public final void Add(long key, Object value) {
        if (this._index.isEmpty()) {
            this._head = key;
        }
        if (this._index.containsKey(key)) {
            EvictionIndexEntry indexEntry = (EvictionIndexEntry)this._index.get(key);
            if (indexEntry != null) {
                indexEntry.Insert(value);
            }
        } else {
            EvictionIndexEntry indexEntry = new EvictionIndexEntry();
            indexEntry.Insert(value);
            this._index.put(key, indexEntry);
            EvictionIndexEntry prevEntry = this._index.get(this._tail) instanceof EvictionIndexEntry ? this._index.get(this._tail) : null;
            if (prevEntry != null) {
                prevEntry.setNext(key);
            }
            indexEntry.setPrevious(this._tail);
        }
        if (key > this._tail) {
            this._tail = key;
        }
    }

    public final void Insert(long key, Object value) {
        this.Insert(key, value, -1L, this._head);
    }

    public final void Insert(long key, Object value, long previous, long next) {
        EvictionIndexEntry nextEntry = this._index.get(next) instanceof EvictionIndexEntry ? this._index.get(next) : null;
        EvictionIndexEntry prevEntry = this._index.get(previous) instanceof EvictionIndexEntry ? this._index.get(previous) : null;
        if (this._index.isEmpty() || key < this._head) {
            this._head = key;
        }
        if (this._index.containsKey(key)) {
            EvictionIndexEntry indexEntry = (EvictionIndexEntry)this._index.get(key);
            if (indexEntry != null) {
                indexEntry.Insert(value);
            }
        } else {
            EvictionIndexEntry indexEntry = new EvictionIndexEntry();
            indexEntry.Insert(value);
            this._index.put(key, indexEntry);
            if (prevEntry == null && nextEntry == null) {
                indexEntry.setNext(-1L);
                indexEntry.setPrevious(-1L);
            } else if (prevEntry == null && nextEntry != null) {
                indexEntry.setNext(next);
                indexEntry.setPrevious(-1L);
                nextEntry.setPrevious(key);
            } else if (prevEntry != null && nextEntry == null) {
                indexEntry.setPrevious(previous);
                indexEntry.setNext(-1L);
                prevEntry.setNext(key);
            } else {
                indexEntry.setPrevious(previous);
                indexEntry.setNext(next);
                prevEntry.setNext(key);
                nextEntry.setPrevious(key);
            }
        }
        if (key > this._tail) {
            this._tail = key;
        }
    }

    public final void Remove(long key, Object value) {
        EvictionIndexEntry indexEntry;
        EvictionIndexEntry previousEntry = null;
        EvictionIndexEntry nextEntry = null;
        if (this._index.containsKey(key) && (indexEntry = (EvictionIndexEntry)this._index.get(key)).Remove(value)) {
            if (indexEntry.getPrevious() != -1L) {
                previousEntry = (EvictionIndexEntry)this._index.get(indexEntry.getPrevious());
            }
            if (indexEntry.getNext() != -1L) {
                nextEntry = (EvictionIndexEntry)this._index.get(indexEntry.getNext());
            }
            if (previousEntry != null && nextEntry != null) {
                previousEntry.setNext(indexEntry.getNext());
                nextEntry.setPrevious(indexEntry.getPrevious());
            } else if (previousEntry != null) {
                previousEntry.setNext(indexEntry.getNext());
                this._tail = indexEntry.getPrevious();
            } else if (nextEntry != null) {
                nextEntry.setPrevious(indexEntry.getPrevious());
                this._head = indexEntry.getNext();
            } else {
                this._head = -1L;
                this._tail = -1L;
            }
            this._index.remove(key);
        }
    }

    public final void Remove(long key, Object value, RefObject<Long> previous, RefObject<Long> next) {
        EvictionIndexEntry previousEntry = null;
        EvictionIndexEntry nextEntry = null;
        previous.argvalue = key;
        if (this._index.containsKey(key)) {
            EvictionIndexEntry indexEntry = (EvictionIndexEntry)this._index.get(key);
            if (indexEntry.getPrevious() != -1L) {
                previousEntry = (EvictionIndexEntry)this._index.get(indexEntry.getPrevious());
            }
            if (indexEntry.getNext() != -1L) {
                nextEntry = (EvictionIndexEntry)this._index.get(indexEntry.getNext());
            }
            next.argvalue = indexEntry.getNext();
            if (indexEntry.Remove(value)) {
                previous.argvalue = indexEntry.getPrevious();
                if (previousEntry != null && nextEntry != null) {
                    previousEntry.setNext(indexEntry.getNext());
                    nextEntry.setPrevious(indexEntry.getPrevious());
                } else if (previousEntry != null) {
                    previousEntry.setNext(indexEntry.getNext());
                    this._tail = indexEntry.getPrevious();
                } else if (nextEntry != null) {
                    nextEntry.setPrevious(indexEntry.getPrevious());
                    this._head = indexEntry.getNext();
                } else {
                    this._head = -1L;
                    this._tail = -1L;
                }
                this._index.remove(key);
            }
        }
    }

    public final void Clear() {
        this._tail = -1L;
        this._head = -1L;
        this._index.clear();
    }

    public final ArrayList GetSelectedKeys(CacheBase cache, long evictSize) {
        EvictionIndexEntry entry = null;
        ArrayList<String> selectedKeys = new ArrayList<String>();
        int totalSize = 0;
        boolean selectionCompleted = false;
        long index = this._head;
        if (this._head != -1L) {
            do {
                entry = this._index.get(index) instanceof EvictionIndexEntry ? this._index.get(index) : null;
                Collection keys = entry.GetAllKeys();
                for (String key : keys) {
                    int itemSize = cache.GetItemSize(key);
                    if ((long)(totalSize + itemSize) >= evictSize && totalSize > 0) {
                        if (evictSize - (long)totalSize > (long)(itemSize + totalSize) - evictSize) {
                            selectedKeys.add(key);
                        }
                        selectionCompleted = true;
                        break;
                    }
                    selectedKeys.add(key);
                    totalSize += itemSize;
                }
                index = entry.getNext();
            } while (!selectionCompleted && index != -1L);
        }
        return selectedKeys;
    }
}

