/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.EvictionPolicies;

import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHintType;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;

public class CounterHint
extends EvictionHint
implements ICompactSerializable,
Serializable {
    protected short _count = 1;

    public CounterHint() {
        this._hintType = EvictionHintType.CounterHint;
    }

    public CounterHint(short count) {
        this._hintType = EvictionHintType.CounterHint;
        this._count = count;
    }

    public final short getCount() {
        return this._count;
    }

    @Override
    public boolean getIsVariant() {
        return this._count < Short.MAX_VALUE;
    }

    @Override
    public boolean Update() {
        if (this._count < Short.MAX_VALUE) {
            this._count = (short)(this._count + 1);
            return true;
        }
        return false;
    }

    @Override
    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        this._count = reader.readShort();
    }

    @Override
    public void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        writer.writeShort((int)this._count);
    }
}

