/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Enumeration;

import Alachisoft.NCache.Caching.Enumeration.CacheSnapshotPool;
import Alachisoft.NCache.Caching.Enumeration.IEnumerationProvider;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Caching.Topologies.Local.IndexedLocalCache;
import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.ServicePropValues;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.ArrayList;

public class SnapshotEnumerationProvider
implements IEnumerationProvider {
    private CacheBase _cache;
    private EnumerationPointer _pointer;
    private Object[] _snapshot;
    private int _chunkSize = 1000;
    private int _chunkId = 0;

    @Override
    public final void Initialize(EnumerationPointer pointer, IndexedLocalCache cache) throws GeneralFailureException, OperationFailedException, CacheException {
        this._cache = cache;
        this._pointer = pointer;
        if (ServicePropValues.CacheServer_EnumeratorChunkSize != null) {
            this._chunkSize = Integer.decode(ServicePropValues.CacheServer_EnumeratorChunkSize);
        }
        this._snapshot = CacheSnapshotPool.getInstance().GetSnaphot(pointer.getId(), cache);
    }

    @Override
    public final EnumerationDataChunk GetNextChunk(EnumerationPointer pointer) {
        EnumerationDataChunk chunk = new EnumerationDataChunk();
        chunk.setData(new ArrayList());
        int currentIndex = pointer.getChunkId();
        for (int count = 0; currentIndex < this._snapshot.length - 1 && count < this._chunkSize; ++count) {
            chunk.getData().add(this._snapshot[++currentIndex].toString());
        }
        if (currentIndex == this._snapshot.length - 1) {
            this._pointer.setChunkId(-1);
        } else {
            this._pointer.setChunkId(currentIndex);
        }
        chunk.setPointer(this._pointer);
        return chunk;
    }

    @Override
    public final void dispose() {
        CacheSnapshotPool.getInstance().DiposeSnapshot(this._pointer.getId(), this._cache);
        this._cache = null;
        this._pointer = null;
        this._snapshot = null;
    }
}

