/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Enumeration;

import Alachisoft.NCache.Caching.Enumeration.IEnumerationProvider;
import Alachisoft.NCache.Caching.Enumeration.SnapshotEnumerationProvider;
import Alachisoft.NCache.Caching.Topologies.Local.IndexedLocalCache;
import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import java.util.HashMap;

public class EnumerationIndex {
    private IndexedLocalCache _cache;
    private HashMap<EnumerationPointer, IEnumerationProvider> _index;

    public EnumerationIndex(IndexedLocalCache cache) {
        this._cache = cache;
    }

    public final EnumerationDataChunk GetNextChunk(EnumerationPointer pointer) throws Exception {
        EnumerationDataChunk nextChunk = null;
        IEnumerationProvider provider = this.GetProvider(pointer);
        if (pointer.isDisposable() && provider != null) {
            provider.dispose();
            if (this._index.containsKey(pointer)) {
                this._index.remove(pointer);
            }
            nextChunk = new EnumerationDataChunk();
            nextChunk.setPointer(pointer);
        } else if (provider != null && (nextChunk = provider.GetNextChunk(pointer)).isLastChunk()) {
            provider.dispose();
            if (this._index.containsKey(pointer)) {
                this._index.remove(pointer);
            }
        }
        return nextChunk;
    }

    private IEnumerationProvider GetProvider(EnumerationPointer pointer) throws Exception {
        if (this._index == null) {
            this._index = new HashMap();
        }
        IEnumerationProvider provider = null;
        if (this._index.containsKey(pointer)) {
            provider = this._index.get(pointer);
        } else if (pointer.getChunkId() == -1 && !pointer.isSocketServerDispose() && !pointer.isDisposable()) {
            provider = new SnapshotEnumerationProvider();
            provider.Initialize(pointer, this._cache);
            this._index.put(pointer, provider);
        }
        return provider;
    }

    public final boolean Contains(EnumerationPointer pointer) {
        if (this._index != null) {
            return this._index.containsKey(pointer);
        }
        return false;
    }
}

