/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.DatasourceProviders;

import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheLoader.JarFileLoader;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.DatasourceProviders.ClassPaths;
import Alachisoft.NCache.Caching.DatasourceProviders.DSWriteBehindOperation;
import Alachisoft.NCache.Caching.DatasourceProviders.DSWriteOperation;
import Alachisoft.NCache.Caching.DatasourceProviders.WriteBehindAsyncProcessor;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OpCode;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.DirectoryUtil;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Util.AuthenticateFeature;
import Alachisoft.NCache.Common.Util.LanguageContext;
import com.alachisoft.ncache.runtime.datasourceprovider.OperationResult;
import com.alachisoft.ncache.runtime.datasourceprovider.WriteOperation;
import com.alachisoft.ncache.runtime.datasourceprovider.WriteThruProvider;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import tangible.DotNetToJavaStringHelper;

public class WriteThruProviderMgr
implements IDisposable {
    private JarFileLoader _loader;
    private String _myProvider;
    private CacheRuntimeContext _context;
    private WriteThruProvider _dsWriter;
    private LanguageContext _languageContext = LanguageContext.values()[0];
    private boolean _asyncWrites = true;
    private String _cacheName;
    private long _operationDelay;

    public WriteThruProviderMgr() {
    }

    public WriteThruProviderMgr(String cacheName, Map properties, CacheRuntimeContext context, int timeout, long operationDelay, String providerName) throws ConfigurationException {
        this._context = context;
        this._cacheName = cacheName;
        this._operationDelay = operationDelay;
        this._myProvider = providerName;
        this.Initialize(properties);
    }

    public final LanguageContext getLanguageContext() {
        return this._languageContext;
    }

    public final void setLanguageContext(LanguageContext value) {
        this._languageContext = value;
    }

    private ILogger getNCacheLog() {
        return this._context.getNCacheLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this._dsWriter != null) {
            WriteThruProvider writeThruProvider = this._dsWriter;
            synchronized (writeThruProvider) {
                try {
                    this._dsWriter.close();
                }
                catch (Exception e) {
                    this.getNCacheLog().Error("WriteThruProviderMgr", "User code threw " + e.toString());
                }
                this._dsWriter = null;
            }
        }
    }

    private void Initialize(Map properties) throws ConfigurationException {
        Object asm = null;
        if (properties == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: properties");
        }
        try {
            if (!properties.containsKey("assembly-name")) {
                throw new ConfigurationException("Missing assembly name for write-thru option");
            }
            if (!properties.containsKey("class-name")) {
                throw new ConfigurationException("Missing class name for write-thru option");
            }
            String assembly = String.valueOf(properties.get("assembly-name"));
            String classname = String.valueOf(properties.get("class-name"));
            HashMap startupparams = properties.get("parameters") instanceof Map ? properties.get("parameters") : null;
            String extension = ".dll";
            if (properties.containsKey("full-name")) {
                extension = String.valueOf(properties.get("full-name")).split("\\.")[String.valueOf(properties.get("full-name")).split("\\.").length - 1];
            }
            if (startupparams == null) {
                startupparams = new HashMap();
            }
            try {
                if (extension.equals(".dll") || extension.equals(".exe")) {
                    AuthenticateFeature.Authenticate((LanguageContext)LanguageContext.DOTNET);
                    this._languageContext = LanguageContext.DOTNET;
                    String path = AppUtil.DeployedAssemblyDir + this._cacheName.toLowerCase() + this.GetWriteThruAssemblyPath(assembly) + extension;
                    if (asm != null) {
                        // empty if block
                    }
                    if (this._dsWriter == null) {
                        throw new Exception("Unable to instantiate " + classname);
                    }
                    this._dsWriter.init(startupparams, this._cacheName);
                } else if (extension.equals("jar") || extension.equals("class")) {
                    AuthenticateFeature.Authenticate((LanguageContext)LanguageContext.JAVA);
                    this._languageContext = LanguageContext.JAVA;
                    File deployedFolder = DirectoryUtil.createDeployAssemblyFolder((String)this._cacheName);
                    if (!deployedFolder.exists()) {
                        throw new ConfigurationException("Could not load " + assembly + ". Deploy the required provider's Jar file(s)");
                    }
                    try {
                        if (this._loader == null) {
                            this._loader = ClassPaths.addPath(deployedFolder, this._context.getNCacheLog());
                        }
                        this._dsWriter = (WriteThruProvider)this._loader.loadClass(classname).newInstance();
                        this._dsWriter.init(startupparams, this._cacheName);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("The class specified in write-thru does not implement IDatasourceWriter");
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("ClassNotFoundException " + classname);
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        catch (ConfigurationException e2) {
            throw e2;
        }
        catch (Exception e) {
            throw new ConfigurationException("Configuration Error: " + e.toString(), (Throwable)e);
        }
    }

    private void modifyDefualtClassLoader() {
        Thread.currentThread().setContextClassLoader(this._loader);
    }

    public final void HotApplyConfig(long operationDelay) {
        this._operationDelay = operationDelay;
    }

    public final boolean getAsyncWriteEnabled() {
        return this._asyncWrites;
    }

    public final String getMyProviderName() {
        return this._myProvider;
    }

    private String GetWriteThruAssemblyPath(String asm) {
        Object path = "\\";
        String[] folderNames = asm.split("[,=]", -1);
        path = (String)path + folderNames[0];
        return path;
    }

    private String GetWriteThruAssembly(String asm) {
        String path = "";
        String[] folderNames = asm.split("[,=]", -1);
        path = folderNames[0];
        return path;
    }

    public final void WriteBehind(CacheBase internalCache, Object key, CacheEntry entry, String source, String taskId, OpCode operationCode) throws Exception {
        if (this._context.getDsMgr()._writeBehindAsyncProcess != null && !this._context.getCacheRoot().getIsBridgeTargetCache()) {
            this._context.getDsMgr()._writeBehindAsyncProcess.Enqueue(new DSWriteBehindOperation(this._context._serializationContext, key, null, entry, operationCode, this._myProvider, this._operationDelay, taskId, source, WriteBehindAsyncProcessor.TaskState.Waite));
        }
    }

    public final void WriteBehind(CacheBase internalCache, Object key, CacheEntry entry, String source, String taskId, OpCode operationCode, WriteBehindAsyncProcessor.TaskState state) throws Exception {
        if (this._context.getDsMgr()._writeBehindAsyncProcess != null && !this._context.getCacheRoot().getIsBridgeTargetCache()) {
            this._context.getDsMgr()._writeBehindAsyncProcess.Enqueue(new DSWriteBehindOperation(this._context._serializationContext, key, null, entry, operationCode, this._myProvider, this._operationDelay, taskId, source, state));
        }
    }

    public final void WriteBehind(CacheBase internalCache, Object[] keys, Object[] values, CacheEntry[] entries, String source, String taskId, OpCode operationCode) throws Exception {
        if (this._context.getDsMgr()._writeBehindAsyncProcess != null && !this._context.getCacheRoot().getIsBridgeTargetCache()) {
            for (int i = 0; i < keys.length; ++i) {
                this._context.getDsMgr()._writeBehindAsyncProcess.Enqueue(new DSWriteBehindOperation(this._context._serializationContext, keys[i], values[i], entries[i], operationCode, this._myProvider, this._operationDelay, taskId + "-" + i, source, WriteBehindAsyncProcessor.TaskState.Waite));
            }
        }
    }

    public final void WriteBehind(CacheBase internalCache, Object[] keys, Object[] values, CacheEntry[] entries, String source, String taskId, OpCode operationCode, WriteBehindAsyncProcessor.TaskState state) throws Exception {
        if (this._context.getDsMgr()._writeBehindAsyncProcess != null && !this._context.getCacheRoot().getIsBridgeTargetCache()) {
            for (int i = 0; i < keys.length; ++i) {
                this._context.getDsMgr()._writeBehindAsyncProcess.Enqueue(new DSWriteBehindOperation(this._context._serializationContext, keys[i], values[i], entries[i], operationCode, this._myProvider, this._operationDelay, taskId + "-" + i, source, state));
            }
        }
    }

    public final void WriteBehind(DSWriteBehindOperation operation) throws Exception {
        if (this._context.getDsMgr()._writeBehindAsyncProcess != null && !this._context.getCacheRoot().getIsBridgeTargetCache() && operation != null) {
            operation.incrementRetryCount();
            operation.setOperationState(WriteBehindAsyncProcessor.OperationState.Requeue);
            operation.setOperationDelay(this._operationDelay);
            this._context.getDsMgr()._writeBehindAsyncProcess.Enqueue(operation);
        }
    }

    public final void WriteBehind(ArrayList operations) throws Exception {
        if (this._context.getDsMgr()._writeBehindAsyncProcess != null && !this._context.getCacheRoot().getIsBridgeTargetCache()) {
            DSWriteBehindOperation operation = null;
            for (int i = 0; i < operations.size(); ++i) {
                operation = operations.get(i) instanceof DSWriteBehindOperation ? operations.get(i) : null;
                if (operations == null) continue;
                operation.incrementRetryCount();
                operation.setOperationState(WriteBehindAsyncProcessor.OperationState.Requeue);
                operation.setOperationDelay(this._operationDelay);
                this._context.getDsMgr()._writeBehindAsyncProcess.Enqueue(operation);
            }
        }
    }

    public final void DequeueWriteBehindTask(String[] taskId) throws Exception {
        if (this._context.getDsMgr() != null && this._context.getDsMgr()._writeBehindAsyncProcess != null) {
            this._context.getDsMgr()._writeBehindAsyncProcess.Dequeue(taskId);
        }
    }

    public final void SetState(String taskId, WriteBehindAsyncProcessor.TaskState state) throws Exception {
        if (this._context.getDsMgr() != null && this._context.getDsMgr()._writeBehindAsyncProcess != null) {
            this._context.getDsMgr()._writeBehindAsyncProcess.SetState(taskId, state);
        }
    }

    public final void SetState(String taskId, WriteBehindAsyncProcessor.TaskState state, HashMap newTable) throws Exception {
        if (this._context.getDsMgr() != null && this._context.getDsMgr()._writeBehindAsyncProcess != null) {
            this._context.getDsMgr()._writeBehindAsyncProcess.SetState(taskId, state, newTable);
        }
    }

    public final WriteBehindAsyncProcessor.WriteBehindQueue CloneQueue() {
        if (this._context.getDsMgr() != null && this._context.getDsMgr()._writeBehindAsyncProcess != null) {
            return this._context.getDsMgr()._writeBehindAsyncProcess.CloneQueue();
        }
        return null;
    }

    public final void CopyQueue(WriteBehindAsyncProcessor.WriteBehindQueue queue) throws Exception {
        if (this._context.getDsMgr() != null && this._context.getDsMgr()._writeBehindAsyncProcess != null) {
            this._context.getDsMgr()._writeBehindAsyncProcess.MergeQueue(this._context, queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final OperationResult WriteThru(CacheBase cacheImpl, DSWriteOperation operation, boolean async, OperationContext operationContext) throws OperationFailedException {
        if (this._context.getDsMgr() == null || this._context != null && !this._context.getDsMgr().getIsWriteThruEnabled() && !this._context.getDsMgr().getIsWriteBehindEnabled()) {
            throw new OperationFailedException("Backing source not available. Verify backing source settings");
        }
        Exception exc = null;
        OperationResult dsResult = null;
        this._context.PerfStatsColl.mSecPerDSWriteBeginSample();
        if (this._languageContext == LanguageContext.JAVA) {
            DSWriteOperation.setClassLoader(this._loader);
        }
        dsResult = this.WriteThru(operation.GetWriteOperation(this._languageContext));
        this._context.PerfStatsColl.mSecPerDSWriteEndSample();
        try {
            if (!async) {
                this._context.PerfStatsColl.incrementWriteThruPerSec();
            } else {
                this._context.PerfStatsColl.incrementWriteBehindPerSec();
            }
            if (exc != null || dsResult != null && dsResult.getOperationStatus() == OperationResult.Status.Failure) {
                switch (operation.getOperationCode()) {
                    case Add: 
                    case Update: {
                        cacheImpl.Remove(operation.getKey(), ItemRemoveReason.Removed, false, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
                        cacheImpl.getContext().getNCacheLog().CriticalInfo("Removing key: " + operation.getKey() + " after data source write operation");
                    }
                }
                this._context.PerfStatsColl.incrementDSFailedOpsPerSec();
                if (exc != null) {
                    throw new OperationFailedException("IWriteThruProvider failed." + exc.getMessage(), (Throwable)exc);
                }
            }
            if (dsResult != null && (dsResult.getOperationStatus() == OperationResult.Status.Failure || dsResult.getOperationStatus() == OperationResult.Status.FailureDontRemove)) {
                this._context.PerfStatsColl.incrementDSFailedOpsPerSec();
                throw new OperationFailedException("IWriteThruProvider failed. " + (String)(dsResult.getException() != null ? "Exception: " + dsResult.getException().getMessage() : (dsResult.getError() != null ? "ErrorMessage: " + dsResult.getError() : "")), (Throwable)exc);
            }
            if (dsResult == null || dsResult.getOperationStatus() != OperationResult.Status.Failure && dsResult.getOperationStatus() != OperationResult.Status.FailureRetry) return dsResult;
            this._context.PerfStatsColl.incrementDSFailedOpsPerSec();
            return dsResult;
        }
        catch (Exception ex) {
            throw new OperationFailedException("Error: " + ex.getMessage(), (Throwable)ex);
        }
        catch (Exception e) {
            try {
                exc = e;
            }
            catch (Throwable throwable) {
                try {
                    if (!async) {
                        this._context.PerfStatsColl.incrementWriteThruPerSec();
                    } else {
                        this._context.PerfStatsColl.incrementWriteBehindPerSec();
                    }
                    if (exc != null || dsResult != null && dsResult.getOperationStatus() == OperationResult.Status.Failure) {
                        switch (operation.getOperationCode()) {
                            case Add: 
                            case Update: {
                                cacheImpl.Remove(operation.getKey(), ItemRemoveReason.Removed, false, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
                                cacheImpl.getContext().getNCacheLog().CriticalInfo("Removing key: " + operation.getKey() + " after data source write operation");
                            }
                        }
                        this._context.PerfStatsColl.incrementDSFailedOpsPerSec();
                        if (exc != null) {
                            throw new OperationFailedException("IWriteThruProvider failed." + exc.getMessage(), (Throwable)exc);
                        }
                    }
                    if (dsResult != null && (dsResult.getOperationStatus() == OperationResult.Status.Failure || dsResult.getOperationStatus() == OperationResult.Status.FailureDontRemove)) {
                        this._context.PerfStatsColl.incrementDSFailedOpsPerSec();
                        throw new OperationFailedException("IWriteThruProvider failed. " + (String)(dsResult.getException() != null ? "Exception: " + dsResult.getException().getMessage() : (dsResult.getError() != null ? "ErrorMessage: " + dsResult.getError() : "")), (Throwable)exc);
                    }
                    if (dsResult == null || dsResult.getOperationStatus() != OperationResult.Status.Failure && dsResult.getOperationStatus() != OperationResult.Status.FailureRetry) throw throwable;
                    this._context.PerfStatsColl.incrementDSFailedOpsPerSec();
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new OperationFailedException("Error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            try {
                if (!async) {
                    this._context.PerfStatsColl.incrementWriteThruPerSec();
                } else {
                    this._context.PerfStatsColl.incrementWriteBehindPerSec();
                }
                if (exc != null || dsResult != null && dsResult.getOperationStatus() == OperationResult.Status.Failure) {
                    switch (operation.getOperationCode()) {
                        case Add: 
                        case Update: {
                            cacheImpl.Remove(operation.getKey(), ItemRemoveReason.Removed, false, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
                            cacheImpl.getContext().getNCacheLog().CriticalInfo("Removing key: " + operation.getKey() + " after data source write operation");
                        }
                    }
                    this._context.PerfStatsColl.incrementDSFailedOpsPerSec();
                    if (exc != null) {
                        throw new OperationFailedException("IWriteThruProvider failed." + exc.getMessage(), (Throwable)exc);
                    }
                }
                if (dsResult != null && (dsResult.getOperationStatus() == OperationResult.Status.Failure || dsResult.getOperationStatus() == OperationResult.Status.FailureDontRemove)) {
                    this._context.PerfStatsColl.incrementDSFailedOpsPerSec();
                    throw new OperationFailedException("IWriteThruProvider failed. " + (String)(dsResult.getException() != null ? "Exception: " + dsResult.getException().getMessage() : (dsResult.getError() != null ? "ErrorMessage: " + dsResult.getError() : "")), (Throwable)exc);
                }
                if (dsResult == null || dsResult.getOperationStatus() != OperationResult.Status.Failure && dsResult.getOperationStatus() != OperationResult.Status.FailureRetry) return dsResult;
                this._context.PerfStatsColl.incrementDSFailedOpsPerSec();
                return dsResult;
            }
            catch (Exception ex) {
                throw new OperationFailedException("Error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OperationResult[] WriteThru(CacheBase cacheImpl, DSWriteOperation[] operations, HashMap returnSet, boolean async, OperationContext operationContext) throws OperationFailedException {
        Exception exc = null;
        OperationResult[] result = null;
        try {
            int count = operations.length;
            WriteOperation[] writeOperations = new WriteOperation[count];
            if (this._languageContext == LanguageContext.JAVA) {
                DSWriteOperation.setClassLoader(this._loader);
            }
            for (int i = 0; i < operations.length; ++i) {
                writeOperations[i] = operations[i].GetWriteOperation(this._languageContext);
            }
            this._context.PerfStatsColl.mSecPerDSWriteBeginSample();
            result = this.WriteThru(writeOperations);
            this._context.PerfStatsColl.mSecPerDSWriteEndSample(writeOperations.length);
        }
        catch (Exception e) {
            exc = e;
            return exc;
        }
        finally {
            if (!async) {
                this._context.PerfStatsColl.incrementWriteThruPerSecBy(operations.length);
            } else {
                this._context.PerfStatsColl.incrementWriteBehindPerSecBy(operations.length);
            }
            ArrayList failedOpsKeys = new ArrayList();
            if (result != null) {
                for (int i = 0; i < result.length; ++i) {
                    if (result[i].getOperationStatus() == OperationResult.Status.Failure || result[i].getOperationStatus() == OperationResult.Status.FailureDontRemove) {
                        if (result[i].getException() != null) {
                            returnSet.put(result[i].getOperation().getKey(), result[i].getException());
                        } else if (!DotNetToJavaStringHelper.isNullOrEmpty((String)result[i].getError())) {
                            returnSet.put(result[i].getOperation().getKey(), new Exception(result[i].getError()));
                        } else {
                            returnSet.put(result[i].getOperation().getKey(), result[i].getOperationStatus());
                        }
                        this._context.PerfStatsColl.incrementDSFailedOpsPerSec();
                    } else {
                        if (result[i].getOperationStatus() == OperationResult.Status.FailureRetry) {
                            this._context.PerfStatsColl.incrementDSFailedOpsPerSec();
                        }
                        returnSet.put(result[i].getOperation().getKey(), result[i].getOperationStatus());
                    }
                    if (result[i].getOperationStatus() != OperationResult.Status.Failure) continue;
                }
                try {
                    if (failedOpsKeys.size() > 0) {
                        Object[] failedOps = new String[failedOpsKeys.size()];
                        System.arraycopy(failedOpsKeys.toArray(new Object[0]), 0, failedOps, 0, failedOpsKeys.size());
                        cacheImpl.Remove(failedOps, ItemRemoveReason.Removed, false, operationContext);
                    }
                }
                catch (Exception e) {
                    throw new OperationFailedException("Data Source write operation failed. Error: " + e.getMessage(), (Throwable)e);
                }
            }
            return result;
        }
    }

    private OperationResult WriteThru(WriteOperation writeOperation) throws Exception {
        OperationResult result = null;
        if (this._dsWriter == null || this._context.getCacheRoot().getIsBridgeTargetCache()) {
            return result;
        }
        result = this._dsWriter.writeToDataSource(writeOperation);
        return result;
    }

    private OperationResult[] WriteThru(WriteOperation[] writeOperations) throws Exception {
        if (this._dsWriter == null || this._context.getCacheRoot().getIsBridgeTargetCache()) {
            return null;
        }
        return (OperationResult[])Iterables.toArray((Iterable)this._dsWriter.writeToDataSource(Arrays.asList(writeOperations)), OperationResult.class);
    }
}

