/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.DatasourceProviders;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Caching.DataGrouping.GroupInfo;
import Alachisoft.NCache.Caching.DatasourceProviders.DSAsyncUpdatesProcessor;
import Alachisoft.NCache.Caching.DatasourceProviders.DSWriteBehindOperation;
import Alachisoft.NCache.Caching.DatasourceProviders.DSWriteOperation;
import Alachisoft.NCache.Caching.DatasourceProviders.ReadThruProviderMgr;
import Alachisoft.NCache.Caching.DatasourceProviders.WriteBehindAsyncProcessor;
import Alachisoft.NCache.Caching.DatasourceProviders.WriteThruProviderMgr;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.IGRShutDown;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OpCode;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Caching.Topologies.CacheInsResult;
import Alachisoft.NCache.Caching.Topologies.CacheInsResultWithEntry;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Threading.AsyncProcessor;
import Alachisoft.NCache.Common.Util.LanguageContext;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.runtime.datasourceprovider.OperationResult;
import com.alachisoft.ncache.runtime.datasourceprovider.ProviderCacheItem;
import com.alachisoft.ncache.runtime.datasourceprovider.WriteOperation;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tangible.DotNetToJavaStringHelper;
import tangible.RefObject;

public class DatasourceMgr
implements IGRShutDown {
    public AsyncProcessor _asyncProc;
    public WriteBehindAsyncProcessor _writeBehindAsyncProcess;
    public DSAsyncUpdatesProcessor _dsUpdateProcessor;
    private CacheRuntimeContext _context;
    private CacheBase _cacheImpl;
    private String _cacheName;
    private Map<String, ReadThruProviderMgr> _readerProivder = new HashMap<String, ReadThruProviderMgr>();
    private HashMap<String, WriteThruProviderMgr> _writerProivder = new HashMap();
    private HashMap<String, LanguageContext> _updateOpProviderMgr = new HashMap();
    private HashMap _queue;
    private String _defaultReadThruProvider;
    private String _defaultWriteThruProvider;
    private boolean anyWriteBehindEnabled = false;
    private boolean anyWriteThruEnabled = false;
    private Class _type = ICompactSerializable.class;

    public DatasourceMgr(String cacheName, Map properties, CacheRuntimeContext context, long timeout) throws ConfigurationException {
        this._cacheName = cacheName;
        this._context = context;
        this._queue = new HashMap();
        this.Initialize(properties, timeout);
    }

    public final String getCacheName() {
        return this._cacheName;
    }

    public final boolean getLoadCompactTypes() {
        return this.getIsReadThruEnabled() || this.getIsWriteThruEnabled();
    }

    public CacheBase getCacheImpl() {
        return this._context.getCacheImpl();
    }

    public void setCacheImpl(CacheBase cacheImpl) {
        if (this._writeBehindAsyncProcess != null) {
            this._writeBehindAsyncProcess.setCacheImpl(this._context.getCacheImpl());
        }
        this._cacheImpl = cacheImpl;
    }

    public final boolean getIsReadThruEnabled() {
        return this._readerProivder.size() > 0;
    }

    public final boolean getIsWriteThruEnabled() {
        return this.anyWriteThruEnabled;
    }

    public final String getDefaultReadThruProvider() {
        if (this._defaultReadThruProvider != null) {
            return this._defaultReadThruProvider.toLowerCase();
        }
        return null;
    }

    public final void setDefaultReadThruProvider(String value) {
        this._defaultReadThruProvider = value;
    }

    public final WriteThruProviderMgr GetProvider(String providerName) {
        WriteThruProviderMgr writeThruManager = null;
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
            providerName = this.getDefaultWriteThruProvider();
        }
        if (this._writerProivder != null && this._writerProivder.containsKey(providerName.toLowerCase())) {
            writeThruManager = this._writerProivder.get(providerName.toLowerCase());
        }
        return writeThruManager;
    }

    public final String getDefaultWriteThruProvider() {
        if (this._defaultWriteThruProvider != null) {
            return this._defaultWriteThruProvider.toLowerCase();
        }
        return null;
    }

    public final void setDefaultWriteThruProvider(String value) {
        this._defaultWriteThruProvider = value;
    }

    public final boolean getIsWriteBehindEnabled() {
        return this.anyWriteBehindEnabled;
    }

    public final void dispose() {
        if (this._readerProivder != null) {
            for (IDisposable iDisposable : this._readerProivder.values()) {
                if (iDisposable == null) continue;
                iDisposable.dispose();
            }
            this._readerProivder = null;
        }
        if (this._writeBehindAsyncProcess != null) {
            this._writeBehindAsyncProcess.Stop();
            this._writeBehindAsyncProcess = null;
        }
        if (this._writerProivder != null) {
            for (IDisposable iDisposable : this._writerProivder.values()) {
                if (iDisposable == null) continue;
                iDisposable.dispose();
            }
            this._writerProivder = null;
        }
        if (this._asyncProc != null) {
            this._asyncProc.Stop();
            this._asyncProc = null;
        }
    }

    private void Initialize(Map properties, long timeout) throws ConfigurationException {
        String mode = "";
        int throttlingRate = 0;
        int requeueLimit = 0;
        int evictionRate = 0;
        long batchInterval = 0L;
        long operationDelay = 0L;
        if (properties == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: properties");
        }
        try {
            Map writeThruProps;
            Map providers;
            Map readThruProps;
            String enabled;
            if (properties.containsKey("read-thru") && (enabled = (String)(readThruProps = (Map)properties.get("read-thru")).get("enabled")).toLowerCase().equals("true") && (providers = (Map)readThruProps.get("read-thru-providers")) != null) {
                for (Map.Entry pair : providers.entrySet()) {
                    if (this._readerProivder.containsKey(pair.getKey().toString().toLowerCase())) continue;
                    this._readerProivder.put(pair.getKey().toString().toLowerCase(), new ReadThruProviderMgr(this._cacheName, providers.get(pair.getKey()) instanceof HashMap ? providers.get(pair.getKey()) : null, this._context));
                }
            }
            if (properties.containsKey("write-thru") && (enabled = (String)(writeThruProps = (Map)properties.get("write-thru")).get("enabled")).toLowerCase().equals("true")) {
                this.anyWriteThruEnabled = true;
                if (writeThruProps.containsKey("write-behind")) {
                    this.anyWriteBehindEnabled = true;
                    Map writeBehindProps = (Map)writeThruProps.get("write-behind");
                    mode = writeBehindProps.get("mode").toString();
                    throttlingRate = Integer.parseInt(writeBehindProps.get("throttling-rate-per-sec").toString());
                    requeueLimit = Integer.parseInt(writeBehindProps.get("failed-operations-queue-limit").toString());
                    evictionRate = Integer.parseInt(writeBehindProps.get("failed-operations-eviction-ratio").toString());
                    if (mode.toLowerCase().equals("batch")) {
                        Map batchConfig = (Map)writeBehindProps.get("batch-mode-config");
                        batchInterval = Integer.parseInt(batchConfig.get("batch-interval").toString());
                        operationDelay = Integer.parseInt(batchConfig.get("operation-delay").toString());
                    }
                }
                if ((providers = (Map)writeThruProps.get("write-thru-providers")) != null) {
                    for (Map.Entry pair : providers.entrySet()) {
                        if (this._writerProivder.containsKey(pair.getKey().toString().toLowerCase())) continue;
                        this._writerProivder.put(pair.getKey().toString().toLowerCase(), new WriteThruProviderMgr(this._cacheName, providers.get(pair.getKey()) instanceof HashMap ? providers.get(pair.getKey()) : null, this._context, (int)timeout, operationDelay, pair.getKey().toString()));
                    }
                }
            }
            if (this._writerProivder != null && this.anyWriteThruEnabled) {
                this._dsUpdateProcessor = new DSAsyncUpdatesProcessor(this, this._context.getNCacheLog());
            }
            if (this._writerProivder != null && this.anyWriteBehindEnabled) {
                this._writeBehindAsyncProcess = new WriteBehindAsyncProcessor(this, throttlingRate, mode, batchInterval, operationDelay, requeueLimit, evictionRate, timeout, this._writerProivder, this._context.getCacheImpl(), this._context);
            }
            if (this._readerProivder != null && !this._context.getIsStartedAsMirror()) {
                this._asyncProc = new AsyncProcessor(this._context.getNCacheLog());
                this._asyncProc.Start();
            }
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Configuration Error: " + e.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheResyncTask GetQueuedReadRequest(Object key) {
        HashMap hashMap = this._queue;
        synchronized (hashMap) {
            return (CacheResyncTask)this._queue.get(key);
        }
    }

    public final void StartWriteBehindProcessor() {
        if (!LicenseManager.isExpress() && this._writeBehindAsyncProcess != null) {
            this._writeBehindAsyncProcess.Start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object ResyncCacheItemAsync(Object key, ExpirationHint exh, EvictionHint evh, GroupInfo groupInfo, HashMap queryInfo, String resyncProviderName) {
        HashMap hashMap = this._queue;
        synchronized (hashMap) {
            if (this._asyncProc != null && this.GetQueuedReadRequest(key) == null) {
                CacheResyncTask task = new CacheResyncTask(this, (String)(key instanceof String ? key : null), exh, evh, this._context.getCompressionThreshold(), groupInfo, queryInfo, resyncProviderName);
                this._queue.put(key, task);
                this._asyncProc.Enqueue((AsyncProcessor.IAsyncTask)task);
            }
            return null;
        }
    }

    public final UserBinaryObject GetCacheEntry(String key, ProviderCacheItem item, RefObject<BitSet> flag, String group, String subGroup, RefObject<CacheEntry> cacheEntry, LanguageContext langContext) throws OperationFailedException, IllegalArgumentException, IOException {
        UserBinaryObject userObject = null;
        cacheEntry.argvalue = null;
        switch (langContext) {
            case DOTNET: {
                userObject = this.GetCacheEntryDotNet(key, item, flag, group, subGroup, cacheEntry);
                break;
            }
            case JAVA: {
                userObject = this.GetCacheEntryDotNet(key, item, flag, group, subGroup, cacheEntry);
            }
        }
        return userObject;
    }

    private UserBinaryObject GetCacheEntryJava(String key, ProviderCacheItem item, RefObject<BitSet> flag, String group, String subGroup, RefObject<CacheEntry> cacheEntry) throws OperationFailedException {
        UserBinaryObject userObject = null;
        return userObject;
    }

    private UserBinaryObject GetCacheEntryDotNet(String key, ProviderCacheItem item, RefObject<BitSet> flag, String group, String subGroup, RefObject<CacheEntry> cacheEntry) throws OperationFailedException, IllegalArgumentException, IOException {
        UserBinaryObject userObject = null;
        return userObject;
    }

    public final Object ResyncCacheItem(String key, RefObject<CacheEntry> entry, RefObject<BitSet> flag, String group, String subGroup, String providerName, OperationContext operationContext) throws OperationFailedException, Exception {
        ProviderCacheItem item = null;
        LanguageContext langContext = LanguageContext.forValue((int)0);
        Object exh = null;
        Object evh = null;
        RefObject tempRef_item = new RefObject(item);
        RefObject tempRef_langContext = new RefObject((Object)langContext);
        this.ReadThru(key, (RefObject<ProviderCacheItem>)tempRef_item, providerName, (RefObject<LanguageContext>)tempRef_langContext);
        item = (ProviderCacheItem)tempRef_item.argvalue;
        langContext = (LanguageContext)tempRef_langContext.argvalue;
        UserBinaryObject userObject = null;
        try {
            userObject = this.GetCacheEntry(key, item, flag, group, subGroup, entry, langContext);
            if (userObject == null) {
                return userObject;
            }
            CacheInsResultWithEntry result = this._context.getCacheImpl().Insert(key, (CacheEntry)entry.argvalue, false, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
            if (result != null && result.getResult() == CacheInsResult.IncompatibleGroup) {
                throw new OperationFailedException("Data group of the inserted item does not match the existing item's data group");
            }
            if (result.getResult() == CacheInsResult.Failure) {
                throw new OperationFailedException("Operation failed to synchronize with data source");
            }
            if (result.getResult() == CacheInsResult.NeedsEviction) {
                throw new OperationFailedException("The cache is full and not enough items could be evicted.");
            }
        }
        catch (Exception ex) {
            throw new OperationFailedException("Error occurred while synchronization with data source. Error: " + ex.getMessage());
        }
        return userObject;
    }

    public final void ResyncCacheItem(HashMap orginalTable, String[] keys, CacheEntry[] e, BitSet[] flag, String providerName, OperationContext operationContext) throws OperationFailedException {
        LanguageContext langContext = LanguageContext.forValue((int)0);
        RefObject tempRef_langContext = new RefObject((Object)langContext);
        HashMap<String, ProviderCacheItem> cacheItems = this.ReadThru(keys, providerName, (RefObject<LanguageContext>)tempRef_langContext);
        langContext = (LanguageContext)tempRef_langContext.argvalue;
        if (cacheItems == null || cacheItems != null && cacheItems.isEmpty()) {
            return;
        }
        Object[] refinedKeys = new Object[cacheItems.size()];
        CacheEntry[] refinedEnteries = new CacheEntry[cacheItems.size()];
        int counter = 0;
        for (int i = 0; i < keys.length; ++i) {
            ProviderCacheItem cacheItem = null;
            cacheItem = cacheItems.get(keys[i]);
            if (cacheItem == null || cacheItem == null) continue;
            try {
                CacheEntry entry = null;
                RefObject tempRef_Object = new RefObject((Object)flag[i]);
                RefObject tempRef_entry = new RefObject(entry);
                UserBinaryObject userBinaryObject = this.GetCacheEntry(keys[i], cacheItem, (RefObject<BitSet>)tempRef_Object, null, null, (RefObject<CacheEntry>)tempRef_entry, langContext);
                flag[i] = (BitSet)tempRef_Object.argvalue;
                entry = (CacheEntry)tempRef_entry.argvalue;
                if (userBinaryObject == null) continue;
                refinedKeys[counter] = keys[i];
                refinedEnteries[counter++] = entry;
                continue;
            }
            catch (Exception exception) {
                this._context.getNCacheLog().Error("DatasourceMgr.ResyncCacheItem", "Error occurred while synchronization with data source; " + exception.getMessage());
            }
        }
        if (counter == 0) {
            return;
        }
        RefObject tempRef_refinedKeys = new RefObject((Object)refinedKeys);
        Cache.Resize((RefObject<Object[]>)tempRef_refinedKeys, counter);
        refinedKeys = (Object[])tempRef_refinedKeys.argvalue;
        RefObject tempRef_refinedEnteries = new RefObject((Object)refinedEnteries);
        Cache.Resize((RefObject<Object[]>)tempRef_refinedEnteries, counter);
        refinedEnteries = (CacheEntry[])tempRef_refinedEnteries.argvalue;
        HashMap insertedValues = null;
        try {
            insertedValues = this._context.getCacheImpl().Insert(refinedKeys, refinedEnteries, false, operationContext);
        }
        catch (Exception ex) {
            throw new OperationFailedException("error while trying to synchronize the cache with data source. Error: " + ex.getMessage(), (Throwable)ex);
        }
        for (int i = 0; i < refinedKeys.length; ++i) {
            if (insertedValues.containsKey(refinedKeys[i])) {
                CacheInsResultWithEntry insResult = insertedValues.get(refinedKeys[i]) instanceof CacheInsResultWithEntry ? insertedValues.get(refinedKeys[i]) : null;
                if (insResult == null || insResult.getResult() != CacheInsResult.Success && insResult.getResult() != CacheInsResult.SuccessOverwrite) continue;
                Object value = refinedEnteries[i].getValue();
                if (value instanceof CallbackEntry) {
                    value = ((CallbackEntry)value).getValue();
                }
                orginalTable.put(refinedKeys[i], new CompressedValueEntry(value, refinedEnteries[i].getFlag()));
                continue;
            }
            Object value = refinedEnteries[i].getValue();
            if (value instanceof CallbackEntry) {
                value = ((CallbackEntry)value).getValue();
            }
            orginalTable.put(refinedKeys[i], new CompressedValueEntry(value, refinedEnteries[i].getFlag()));
        }
    }

    public final void ReadThru(String key, RefObject<ProviderCacheItem> item, String providerName, RefObject<LanguageContext> langContext) throws Exception {
        item.argvalue = null;
        langContext.argvalue = LanguageContext.NONE;
        if (this._readerProivder == null) {
            return;
        }
        ReadThruProviderMgr readThruManager = null;
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
            providerName = this.getDefaultReadThruProvider();
        }
        if (this._readerProivder.containsKey(providerName.toLowerCase())) {
            readThruManager = this._readerProivder.get(providerName.toLowerCase());
            langContext.argvalue = readThruManager.getProviderType();
            if (readThruManager != null) {
                readThruManager.ReadThru(key, item);
            }
        }
    }

    public final HashMap<String, ProviderCacheItem> ReadThru(String[] keys, String providerName, RefObject<LanguageContext> langContext) throws OperationFailedException {
        langContext.argvalue = LanguageContext.NONE;
        if (this._readerProivder == null) {
            return null;
        }
        ReadThruProviderMgr readThruManager = null;
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
            providerName = this.getDefaultReadThruProvider();
        }
        if (this._readerProivder.containsKey(providerName.toLowerCase()) && (readThruManager = this._readerProivder.get(providerName.toLowerCase())) != null) {
            langContext.argvalue = readThruManager.getProviderType();
            return readThruManager.ReadThru(keys);
        }
        return null;
    }

    public final void WriteBehind(CacheBase internalCache, Object key, CacheEntry entry, String source, String taskId, String providerName, OpCode operationCode) throws Exception {
        if (this._writerProivder == null) {
            return;
        }
        WriteThruProviderMgr writeThruManager = this.GetProvider(providerName);
        if (writeThruManager != null) {
            writeThruManager.WriteBehind(internalCache, key, entry, source, taskId, operationCode);
        }
    }

    public final void WriteBehind(CacheBase internalCache, Object key, CacheEntry entry, String source, String taskId, String providerName, OpCode operationCode, WriteBehindAsyncProcessor.TaskState state) throws Exception {
        if (this._writerProivder == null) {
            return;
        }
        WriteThruProviderMgr writeThruManager = this.GetProvider(providerName);
        if (writeThruManager != null) {
            writeThruManager.WriteBehind(internalCache, key, entry, source, taskId, operationCode, state);
        }
    }

    public final void WriteBehind(CacheBase internalCache, Object[] keys, Object[] values, CacheEntry[] entries, String source, String taskId, String providerName, OpCode operationCode) throws Exception {
        if (this._writerProivder == null) {
            return;
        }
        WriteThruProviderMgr writeThruManager = this.GetProvider(providerName);
        if (writeThruManager != null) {
            if (values == null) {
                values = new Object[keys.length];
            }
            writeThruManager.WriteBehind(internalCache, keys, values, entries, source, taskId, operationCode);
        }
    }

    public final void WriteBehind(CacheBase internalCache, Object[] keys, Object[] values, CacheEntry[] entries, String source, String taskId, String providerName, OpCode operationCode, WriteBehindAsyncProcessor.TaskState state) throws Exception {
        if (this._writerProivder == null) {
            return;
        }
        WriteThruProviderMgr writeThruManager = this.GetProvider(providerName);
        if (writeThruManager != null) {
            if (values == null) {
                values = new Object[keys.length];
            }
            writeThruManager.WriteBehind(internalCache, keys, values, entries, source, taskId, operationCode, state);
        }
    }

    public void WriteBehind(DSWriteBehindOperation operation) throws Exception {
        if (this._writerProivder == null) {
            return;
        }
        WriteThruProviderMgr writeThruManager = this.GetProvider(operation.getProviderName());
        if (writeThruManager != null) {
            writeThruManager.WriteBehind(operation);
        }
    }

    public void WriteBehind(ArrayList operations) throws Exception {
        WriteThruProviderMgr writeThruManager;
        if (operations == null || this._writerProivder == null) {
            return;
        }
        DSWriteBehindOperation operation = operations.get(0) instanceof DSWriteBehindOperation ? (DSWriteBehindOperation)operations.get(0) : null;
        WriteThruProviderMgr writeThruProviderMgr = writeThruManager = operation != null ? this.GetProvider(operation.getProviderName()) : null;
        if (writeThruManager != null) {
            writeThruManager.WriteBehind(operations);
        }
    }

    public final void SetState(String taskId, String providerName, OpCode opCode, WriteBehindAsyncProcessor.TaskState state) throws Exception {
        for (WriteThruProviderMgr provider : this.GetWriteThruMgr(providerName, this._writerProivder, opCode)) {
            if (provider == null) continue;
            provider.SetState(taskId, state);
        }
    }

    public final void SetState(String taskId, String providerName, OpCode opCode, WriteBehindAsyncProcessor.TaskState state, HashMap table) throws Exception {
        for (WriteThruProviderMgr provider : this.GetWriteThruMgr(providerName, this._writerProivder, opCode)) {
            if (provider == null) continue;
            provider.SetState(taskId, state, table);
        }
    }

    private Iterator<WriteThruProviderMgr> GetWriteThruMgr(String providerName, Map<String, WriteThruProviderMgr> providers) {
        if (providerName == null) {
            providerName = this._defaultWriteThruProvider;
        }
        if (providerName == null) {
            return new ArrayList().iterator();
        }
        ArrayList<WriteThruProviderMgr> arr = new ArrayList<WriteThruProviderMgr>();
        while (providers.entrySet().iterator().hasNext()) {
            Map.Entry<String, WriteThruProviderMgr> pair = providers.entrySet().iterator().next();
            arr.add(pair.getValue());
        }
        return arr.iterator();
    }

    private Iterable<WriteThruProviderMgr> GetWriteThruMgr(String providerName, Map<String, WriteThruProviderMgr> providers, OpCode operationCode) {
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
            providerName = this._defaultWriteThruProvider;
        }
        if (providerName == null) {
            return new ArrayList<WriteThruProviderMgr>();
        }
        if (operationCode != OpCode.Clear) {
            WriteThruProviderMgr selected = null;
            selected = providers.get(providerName.toLowerCase());
            ArrayList<WriteThruProviderMgr> arr = new ArrayList<WriteThruProviderMgr>();
            arr.add(selected);
            return arr;
        }
        ArrayList<WriteThruProviderMgr> arr = new ArrayList<WriteThruProviderMgr>();
        for (Map.Entry<String, WriteThruProviderMgr> pair : providers.entrySet()) {
            arr.add(pair.getValue());
        }
        return arr;
    }

    @Override
    public final void WindUpTask() {
    }

    @Override
    public final void WaitForShutDown(long interval) {
        this._context.getNCacheLog().CriticalInfo("DatasourceMgr", "Waiting for  Write Behind queue shutdown task completion.");
        Date startShutDown = new Date();
        if (this._writeBehindAsyncProcess != null) {
            this._writeBehindAsyncProcess.WaitForShutDown(interval);
        }
        this._context.getNCacheLog().CriticalInfo("DatasourceMgr", "Waiting for  Write Behind Update queue shutdown task completion.");
        if (this._dsUpdateProcessor != null) {
            long startTime = (Calendar.getInstance().getTime().getTime() - 621355968000000000L) / 10000L;
            long timeout = (int)(interval * 1000L) - (int)(((Calendar.getInstance().getTime().getTime() - 621355968000000000L) / 10000L - startTime) * 1000L);
            if ((timeout /= 1000L) > 0L) {
                this._dsUpdateProcessor.WaitForShutDown(timeout);
            }
        }
        this._context.getNCacheLog().CriticalInfo("DatasourceMgr", "Shutdown task completed.");
    }

    public final void DequeueWriteBehindTask(String[] taskId, String providerName) throws Exception {
        WriteThruProviderMgr provider = null;
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
            providerName = this.getDefaultWriteThruProvider();
        }
        if ((provider = this._writerProivder.get(providerName.toLowerCase())) != null) {
            provider.DequeueWriteBehindTask(taskId);
        }
    }

    public final OperationResult WriteThru(String key, CacheEntry val, OpCode opCode, String providerName, OperationContext operationContext) throws OperationFailedException {
        OperationResult result = null;
        if (this._writerProivder == null) {
            return null;
        }
        WriteThruProviderMgr writeThruManager = this.GetProvider(providerName);
        if (writeThruManager != null) {
            DSWriteOperation operation = new DSWriteOperation(this._context.getSerializationContext(), key, null, val, opCode, providerName);
            result = writeThruManager.WriteThru(this._context.getCacheImpl(), operation, false, operationContext);
            if (result != null && result.getUpdateInCache() && result.getOperationStatus() == OperationResult.Status.Success) {
                this.DSUpdateInCache((WriteOperation)result.getOperation(), writeThruManager.getLanguageContext());
            }
        }
        return result;
    }

    public final void DSUpdateInCache(WriteOperation operation, LanguageContext languageContext) {
    }

    private boolean ValidateWriteOperation(WriteOperation operation) {
        return false;
    }

    public OperationResult[] WriteThru(String[] keys, Object[] values, CacheEntry[] entries, HashMap returnSet, OpCode opCode, String providerName, OperationContext operationContext) throws OperationFailedException {
        OperationResult[] resultSet = null;
        if (this._writerProivder == null) {
            return null;
        }
        WriteThruProviderMgr writeThruManager = this.GetProvider(providerName);
        if (writeThruManager != null) {
            DSWriteOperation[] dsOperations = new DSWriteOperation[keys.length];
            if (values == null) {
                values = new Object[keys.length];
            }
            for (int i = 0; i < keys.length; ++i) {
                dsOperations[i] = new DSWriteOperation(this._context.getSerializationContext(), keys[i], values[i], entries[i], opCode, providerName);
            }
            resultSet = writeThruManager.WriteThru(this._context.getCacheImpl(), dsOperations, returnSet, false, operationContext);
            if (resultSet == null) {
                return null;
            }
            this.DSUpdateInCache(resultSet, writeThruManager.getLanguageContext());
        }
        return resultSet;
    }

    public final OperationResult WriteThru(DSWriteBehindOperation operation, OperationContext context) throws OperationFailedException {
        OperationResult result = null;
        if (this._writerProivder == null) {
            return null;
        }
        WriteThruProviderMgr writeThruManager = this.GetProvider(operation.getProviderName());
        if (writeThruManager == null || (result = writeThruManager.WriteThru(this._context.getCacheImpl(), operation, true, context)) == null || !result.getUpdateInCache() || result.getOperationStatus() != OperationResult.Status.Success || result.getOperation() != null) {
            // empty if block
        }
        return result;
    }

    public final OperationResult[] WriteThru(DSWriteBehindOperation[] operations, String provider, HashMap returnSet, OperationContext context) throws OperationFailedException {
        OperationResult[] result = null;
        if (this._writerProivder == null) {
            return null;
        }
        WriteThruProviderMgr writeThruManager = this.GetProvider(provider);
        if (writeThruManager != null) {
            result = writeThruManager.WriteThru(this._context.getCacheImpl(), operations, returnSet, true, context);
            if (result == null) {
                return null;
            }
            for (int i = 0; i < result.length; ++i) {
                if (result[i] != null && !result[i].getUpdateInCache()) continue;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void DSUpdateInCache(OperationResult[] resultSet, LanguageContext languageContext) {
        block27: {
            HashMap keysInserted;
            ArrayList<Object> keysToRemove;
            Object[] keys;
            block26: {
                if (resultSet == null) {
                    return;
                }
                BitSet[] flags = new BitSet[resultSet.length];
                keys = new Object[resultSet.length];
                CacheEntry[] enteries = new CacheEntry[resultSet.length];
                keysToRemove = new ArrayList<Object>();
                int counter = 0;
                for (int i = 0; i < resultSet.length; ++i) {
                    ProviderCacheItem cacheItem;
                    if (!resultSet[i].getUpdateInCache()) continue;
                    WriteOperation operation = (WriteOperation)resultSet[i].getOperation();
                    boolean rollback = this.ValidateWriteOperation(operation);
                    if (rollback) {
                        keysToRemove.add(operation);
                        continue;
                    }
                    if (resultSet[i].getOperationStatus() == OperationResult.Status.Success && (cacheItem = ((WriteOperation)resultSet[i].getOperation()).getProviderCacheItem()) != null) continue;
                }
                if (counter == 0) {
                    return;
                }
                RefObject tempRef_keys = new RefObject((Object)keys);
                Cache.Resize((RefObject<Object[]>)tempRef_keys, counter);
                keys = (Object[])tempRef_keys.argvalue;
                RefObject tempRef_enteries = new RefObject((Object)enteries);
                Cache.Resize((RefObject<Object[]>)tempRef_enteries, counter);
                enteries = tempRef_enteries.argvalue instanceof CacheEntry[] ? (CacheEntry[])tempRef_enteries.argvalue : null;
                keysInserted = null;
                this._context.PerfStatsColl.mSecPerDSUpdBeginSample();
                keysInserted = this._context.getCacheImpl().Insert(keys, enteries, true, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                this._context.PerfStatsColl.mSecPerDSUpdEndSample(keys.length);
                this._context.PerfStatsColl.incrementDSUpdatePerSecBy(keys.length);
                if (keysInserted == null || keysInserted.size() <= 0) break block26;
                for (int i = 0; i < keys.length; ++i) {
                    if (!keysInserted.containsKey(keys[i])) continue;
                    if (!(keysInserted.get(keys[i]) instanceof Exception)) {
                        CacheInsResultWithEntry insResult = keysInserted.get(keys[i]) instanceof CacheInsResultWithEntry ? keysInserted.get(keys[i]) : null;
                        if (insResult == null || insResult.getResult() == CacheInsResult.Success && insResult.getResult() == CacheInsResult.SuccessOverwrite) continue;
                        keysToRemove.add(keys[i]);
                        continue;
                    }
                    keysToRemove.add(keys[i]);
                }
            }
            try {
                if (keysToRemove.size() > 0) {
                    Object[] selectedKeys = new String[keysToRemove.size()];
                    System.arraycopy(keysToRemove.toArray(new Object[0]), 0, selectedKeys, 0, keysToRemove.size());
                    this._context.getCacheImpl().Remove(selectedKeys, ItemRemoveReason.Removed, true, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                }
                break block27;
            }
            catch (Exception exp) {
                this._context.getNCacheLog().Error("DSWrite Operation:UpdateInCache", "Error occurred while removing keys ; Error: " + exp.getMessage());
            }
            break block27;
            catch (Exception ex) {
                block28: {
                    try {
                        this._context.getNCacheLog().Error("DSWrite Operation:UpdateInCache", "Data source Update in cache failed, Error: " + ex.getMessage());
                        this._context.getCacheImpl().Remove(keys, ItemRemoveReason.Removed, true, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                    }
                    catch (Exception exp) {
                        this._context.getNCacheLog().Error("DSWrite Operation:UpdateInCache", "Error occurred while removing keys ; Error: " + exp.getMessage());
                    }
                    if (keysInserted == null || keysInserted.size() <= 0) break block28;
                    for (int i = 0; i < keys.length; ++i) {
                        if (!keysInserted.containsKey(keys[i])) continue;
                        if (!(keysInserted.get(keys[i]) instanceof Exception)) {
                            CacheInsResultWithEntry insResult = keysInserted.get(keys[i]) instanceof CacheInsResultWithEntry ? keysInserted.get(keys[i]) : null;
                            if (insResult == null || insResult.getResult() == CacheInsResult.Success && insResult.getResult() == CacheInsResult.SuccessOverwrite) continue;
                            keysToRemove.add(keys[i]);
                            continue;
                        }
                        keysToRemove.add(keys[i]);
                    }
                }
                try {
                    if (keysToRemove.size() > 0) {
                        Object[] selectedKeys = new String[keysToRemove.size()];
                        System.arraycopy(keysToRemove.toArray(new Object[0]), 0, selectedKeys, 0, keysToRemove.size());
                        this._context.getCacheImpl().Remove(selectedKeys, ItemRemoveReason.Removed, true, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                    }
                }
                catch (Exception exp) {
                    this._context.getNCacheLog().Error("DSWrite Operation:UpdateInCache", "Error occurred while removing keys ; Error: " + exp.getMessage());
                }
                catch (Throwable throwable) {
                    if (keysInserted != null && keysInserted.size() > 0) {
                        for (int i = 0; i < keys.length; ++i) {
                            if (!keysInserted.containsKey(keys[i])) continue;
                            if (!(keysInserted.get(keys[i]) instanceof Exception)) {
                                CacheInsResultWithEntry insResult = keysInserted.get(keys[i]) instanceof CacheInsResultWithEntry ? keysInserted.get(keys[i]) : null;
                                if (insResult == null || insResult.getResult() == CacheInsResult.Success && insResult.getResult() == CacheInsResult.SuccessOverwrite) continue;
                                keysToRemove.add(keys[i]);
                                continue;
                            }
                            keysToRemove.add(keys[i]);
                        }
                    }
                    try {
                        if (keysToRemove.size() > 0) {
                            Object[] selectedKeys = new String[keysToRemove.size()];
                            System.arraycopy(keysToRemove.toArray(new Object[0]), 0, selectedKeys, 0, keysToRemove.size());
                            this._context.getCacheImpl().Remove(selectedKeys, ItemRemoveReason.Removed, true, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                        }
                    }
                    catch (Exception exp) {
                        this._context.getNCacheLog().Error("DSWrite Operation:UpdateInCache", "Error occurred while removing keys ; Error: " + exp.getMessage());
                    }
                    throw throwable;
                }
            }
        }
    }

    public final void DSAsyncUpdateInCache(WriteOperation operation) {
        if (this._updateOpProviderMgr == null) {
            return;
        }
        LanguageContext languageContext = LanguageContext.NONE;
        if (this._updateOpProviderMgr.containsKey(operation.getKey()) && (languageContext = this._updateOpProviderMgr.get(operation.getKey())) != LanguageContext.NONE) {
            this.DSUpdateInCache(operation, languageContext);
        }
    }

    public final void HotApplyWriteBehind(String mode, int throttlingrate, int requeueLimit, int requeueEvictionRatio, int batchInterval, int operationDelay) {
        if (this._writeBehindAsyncProcess != null) {
            this._writeBehindAsyncProcess.SetConfigDefaults(mode, throttlingrate, batchInterval, operationDelay, requeueLimit, requeueEvictionRatio);
        }
    }

    private static class CacheResyncTask
    implements AsyncProcessor.IAsyncTask {
        private DatasourceMgr _parent;
        private String _key;
        private Object _val;
        private ExpirationHint _exh;
        private EvictionHint _evh;
        private BitSet _flag;
        private long _compressionThreshold;
        private GroupInfo _groupInfo;
        private HashMap _queryInfo;
        private String _resyncProviderName;

        public CacheResyncTask(DatasourceMgr parent, String key, ExpirationHint exh, EvictionHint evh, long compressionThreshold, GroupInfo groupInfo, HashMap queryInfo, String resyncProviderName) {
            this._parent = parent;
            this._key = key;
            this._exh = exh;
            this._evh = evh;
            this._compressionThreshold = compressionThreshold;
            this._groupInfo = groupInfo;
            this._queryInfo = queryInfo;
            this._resyncProviderName = resyncProviderName;
        }

        public final Object getValue() {
            return this._val;
        }

        public final ExpirationHint getExpirationHint() {
            return this._exh;
        }

        public final EvictionHint getEvictionHint() {
            return this._evh;
        }

        public final BitSet getFlag() {
            return this._flag;
        }

        public final GroupInfo getGroupInfo() {
            return this._groupInfo;
        }

        public final HashMap getQueryInfo() {
            return this._queryInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void Process() throws GeneralFailureException, OperationFailedException, OperationFailedException, CacheException {
            CacheResyncTask cacheResyncTask = this;
            synchronized (cacheResyncTask) {
                block13: {
                    try {
                        if (this._val != null) break block13;
                        ProviderCacheItem item = null;
                        LanguageContext languageContext = LanguageContext.NONE;
                        CacheEntry entry = null;
                        UserBinaryObject userBrinaryObject = null;
                        try {
                            RefObject tempRef_item = new RefObject(item);
                            RefObject tempRef_languageContext = new RefObject((Object)languageContext);
                            this._parent.ReadThru(this._key, (RefObject<ProviderCacheItem>)tempRef_item, this._resyncProviderName, (RefObject<LanguageContext>)tempRef_languageContext);
                            item = (ProviderCacheItem)tempRef_item.argvalue;
                            languageContext = (LanguageContext)tempRef_languageContext.argvalue;
                            RefObject tempRef__flag = new RefObject((Object)this._flag);
                            RefObject tempRef_entry = new RefObject(entry);
                            userBrinaryObject = this._parent.GetCacheEntry(this._key, item, (RefObject<BitSet>)tempRef__flag, this._groupInfo != null ? this._groupInfo.getGroup() : null, this._groupInfo != null ? this._groupInfo.getSubGroup() : null, (RefObject<CacheEntry>)tempRef_entry, languageContext);
                            this._flag = (BitSet)tempRef__flag.argvalue;
                            entry = (CacheEntry)tempRef_entry.argvalue;
                        }
                        catch (Exception ex) {
                            this._val = ex;
                            this._parent._context.getNCacheLog().Error("DatasourceMgr.ResyncCacheItem", ex.getMessage() + " " + ex.getStackTrace());
                        }
                        OperationContext operationContext = new OperationContext();
                        operationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                        operationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                        if (!(this._val instanceof Exception) && userBrinaryObject != null) {
                            CacheInsResultWithEntry result = this._parent._context.getCacheImpl().Insert(this._key, entry, true, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
                            if (result != null && result.getResult() == CacheInsResult.IncompatibleGroup) {
                                this._parent._context.getCacheImpl().Remove(this._key, ItemRemoveReason.Removed, true, null, 0L, LockAccessType.IGNORE_LOCK, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                            }
                        } else {
                            this._parent._context.getCacheImpl().Remove(this._key, ItemRemoveReason.Expired, true, null, 0L, LockAccessType.IGNORE_LOCK, operationContext);
                        }
                    }
                    catch (Exception e) {
                        this._val = e;
                        this._parent._context.getNCacheLog().Error("DatasourceMgr.ResyncCacheItem", e.getMessage() + " " + e.getStackTrace());
                    }
                    finally {
                        ((DatasourceMgr)this._parent)._context.PerfStatsColl.setCountStats(this._parent._context.getCacheInternal().getCount());
                        ((DatasourceMgr)this._parent)._context.PerfStatsColl.setCacheSizeStats(this._parent._context.getCacheInternal().getSize());
                        this._parent._queue.remove(this._key);
                    }
                }
            }
        }

        private HashMap GetQueryInfo(Object value) {
            HashMap queryInfo = null;
            if (this._parent._context.getCacheImpl().getTypeInfoMap() == null) {
                return null;
            }
            try {
                String typeName = value.getClass().getName();
                typeName = typeName.replace("+", ".");
                int handleId = this._parent._context.getCacheImpl().getTypeInfoMap().getHandleId(typeName);
                if (handleId != -1) {
                    queryInfo = new HashMap();
                    Object valType = null;
                    ArrayList<Object> attribValues = new ArrayList<Object>();
                    ArrayList attributes = this._parent._context.getCacheImpl().getTypeInfoMap().getAttribList(handleId);
                    for (int i = 0; i < attributes.size(); ++i) {
                        Object propertyAttrib = null;
                        if (propertyAttrib != null) continue;
                        Field fieldAttrib = value.getClass().getDeclaredField((String)attributes.get(i));
                        if (fieldAttrib != null) {
                            Object attribValue = fieldAttrib.get(value);
                            if (attribValue instanceof String) {
                                attribValue = attribValue.toString().toLowerCase();
                            }
                            attribValues.add(attribValue);
                            continue;
                        }
                        throw new Exception("Unable extracting query information from user object.");
                    }
                    queryInfo.put(handleId, attribValues);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return queryInfo;
        }
    }
}

