/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.DatasourceProviders;

import Alachisoft.NCache.Caching.AutoExpiration.DependencyHelper;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheLoader.JarFileLoader;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHintType;
import Alachisoft.NCache.Caching.EvictionPolicies.PriorityEvictionHint;
import Alachisoft.NCache.Caching.OpCode;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.CompressionUtil;
import Alachisoft.NCache.Common.Util.LanguageContext;
import Alachisoft.NCache.Util.EncryptionUtil;
import com.alachisoft.ncache.runtime.caching.NamedTagsDictionary;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.caching.datasource.ResyncOptions;
import com.alachisoft.ncache.runtime.caching.expiration.Expiration;
import com.alachisoft.ncache.runtime.datasourceprovider.ProviderCacheItem;
import com.alachisoft.ncache.runtime.datasourceprovider.WriteOperation;
import com.alachisoft.ncache.runtime.datasourceprovider.WriteOperationType;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.util.SerializationBitSet;
import com.alachisoft.ncache.serialization.util.SerializationUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import tangible.RefObject;

public class DSWriteOperation
implements ICompactSerializable {
    static JarFileLoader _loader;
    protected Object _key;
    protected Object _value;
    protected CacheEntry _entry;
    protected OpCode _opCode;
    protected WriteOperation _writeOperation = null;
    protected String _providerName;
    protected String _cacheId;
    protected int _retryCount = 0;

    public DSWriteOperation() {
    }

    public DSWriteOperation(String cacheId, Object key, Object value, CacheEntry entry, OpCode opcode, String providerName) {
        this._key = key;
        this._value = value;
        this._entry = entry;
        this._opCode = opcode;
        this._providerName = providerName;
        this._cacheId = cacheId;
    }

    static void setClassLoader(JarFileLoader value) {
        _loader = value;
    }

    public final Object getKey() {
        return this._key;
    }

    public final Object getValue() {
        return this._value;
    }

    public final CacheEntry getEntry() {
        return this._entry;
    }

    public final OpCode getOperationCode() {
        return this._opCode;
    }

    public final String getProviderName() {
        return this._providerName;
    }

    public final void setProviderName(String value) {
        this._providerName = value;
    }

    public final int getRetryCount() {
        return this._retryCount;
    }

    public final void incrementRetryCount() {
        ++this._retryCount;
    }

    public final WriteOperation getWriteOperation() {
        return this._writeOperation;
    }

    public final void setWriteOperation(WriteOperation value) {
        this._writeOperation = value;
    }

    public final WriteOperation GetWriteOperation(LanguageContext languageContext) throws IOException, ClassNotFoundException, OperationFailedException {
        if (this._writeOperation != null) {
            return new WriteOperation(this._writeOperation.getKey(), this._writeOperation.getProviderCacheItem(), this._writeOperation.getOperationType(), this._retryCount);
        }
        if (this._value != null) {
            this._value = this.Deserialize(languageContext, this._value, this._entry.getFlag());
        } else if (this.getEntry() != null) {
            this._value = this._entry.getValue() instanceof CallbackEntry ? ((CallbackEntry)this._entry.getValue()).getValue() : this.getEntry().getValue();
            if (this._value != null && this._value instanceof UserBinaryObject) {
                this._value = ((UserBinaryObject)this._value).getFullObject();
                try {
                    this._value = CompressionUtil.Decompress((byte[])((byte[])(this._value instanceof byte[] ? this._value : null)), (BitSet)this._entry.getFlag());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._value = EncryptionUtil.DecryptData((byte[])this._value, this._cacheId);
                this._value = this.Deserialize(languageContext, this._value, this._entry.getFlag());
            }
        }
        ProviderCacheItem providerCacheItem = null;
        if (this._entry != null) {
            providerCacheItem = this.GetProviderCacheItemFromCacheEntry(this._entry, this._value);
        }
        return new WriteOperation(this._key.toString(), providerCacheItem, this.SetWriteOperationType(this._opCode), this._retryCount);
    }

    private WriteOperationType SetWriteOperationType(OpCode opCode) {
        switch (opCode) {
            case Add: {
                return WriteOperationType.Add;
            }
            case Update: {
                return WriteOperationType.Update;
            }
            case Remove: {
                return WriteOperationType.Delete;
            }
        }
        return WriteOperationType.Add;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object Deserialize(LanguageContext languageContext, Object value, BitSet flag) throws IOException, ClassNotFoundException {
        switch (languageContext) {
            case DOTNET: {
                SerializationBitSet tempFlag = new SerializationBitSet();
                if (flag != null) {
                    tempFlag.setData(flag.getData());
                }
                value = SerializationUtil.safeDeserialize((Object)value, (String)this._cacheId, (SerializationBitSet)tempFlag);
                break;
            }
            case JAVA: {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    if (_loader != null) {
                        Thread.currentThread().setContextClassLoader(_loader);
                    }
                    SerializationBitSet tempFlag = new SerializationBitSet();
                    if (flag != null) {
                        tempFlag.setData(flag.getData());
                    }
                    value = SerializationUtil.safeDeserialize((Object)value, (String)this._cacheId, (SerializationBitSet)tempFlag);
                    break;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
        }
        return value;
    }

    private ProviderCacheItem GetProviderCacheItemFromCacheEntry(CacheEntry cacheEntry, Object value) throws OperationFailedException {
        ProviderCacheItem providerCacheItem = new ProviderCacheItem(value);
        if (cacheEntry.getEvictionHint() != null && cacheEntry.getEvictionHint()._hintType == EvictionHintType.PriorityEvictionHint) {
            providerCacheItem.setItemPriority(((PriorityEvictionHint)cacheEntry.getEvictionHint()).getPriority());
        } else {
            providerCacheItem.setItemPriority(cacheEntry.getPriority());
        }
        if (cacheEntry.getGroupInfo() != null) {
            providerCacheItem.setGroup(cacheEntry.getGroupInfo().getGroup());
        }
        Object absoluteExpiration = null;
        TimeSpan slidingExpiration = TimeSpan.Zero;
        ExpirationHint hint = cacheEntry.getExpirationHint();
        if (hint != null) {
            providerCacheItem.setResyncOptions(new ResyncOptions(hint.getNeedsReSync()));
            DependencyHelper helper = new DependencyHelper();
            RefObject tempRef_absoluteExpiration = new RefObject(absoluteExpiration);
            RefObject tempRef_slidingExpiration = new RefObject((Object)slidingExpiration);
            providerCacheItem.setDependency(DependencyHelper.GetCacheDependency(hint, (RefObject<Date>)tempRef_absoluteExpiration, (RefObject<TimeSpan>)tempRef_slidingExpiration));
        }
        providerCacheItem.setExpiration(new Expiration());
        if (cacheEntry.getQueryInfo() != null) {
            ArrayList tagsList;
            HashMap tagInfo;
            if (cacheEntry.getQueryInfo().get("tag-info") != null) {
                HashMap hashMap = tagInfo = cacheEntry.getQueryInfo().get("tag-info") instanceof HashMap ? (HashMap)cacheEntry.getQueryInfo().get("tag-info") : null;
                if (tagInfo != null) {
                    ArrayList arrayList = tagsList = tagInfo.get("tags-list") instanceof ArrayList ? (ArrayList)tagInfo.get("tags-list") : null;
                    if (tagsList != null && tagsList.size() > 0) {
                        Tag[] tags = new Tag[tagsList.size()];
                        int i = 0;
                        for (Object tag : tagsList) {
                            tags[i++] = new Tag(tag.toString());
                        }
                        providerCacheItem.setTags(Arrays.asList(tags));
                    }
                }
            }
            if (cacheEntry.getQueryInfo().get("named-tag-info") != null) {
                HashMap hashMap = tagInfo = cacheEntry.getQueryInfo().get("named-tag-info") instanceof HashMap ? (HashMap)cacheEntry.getQueryInfo().get("named-tag-info") : null;
                if (tagInfo != null) {
                    Cloneable cloneable = tagsList = tagInfo.get("named-tags-list") instanceof HashMap ? (HashMap)tagInfo.get("named-tags-list") : null;
                    if (tagsList != null) {
                        NamedTagsDictionary namedTags = new NamedTagsDictionary();
                        for (Map.Entry tagObj : ((HashMap)((Object)tagsList)).entrySet()) {
                            Object tag;
                            if (!(tagObj instanceof Map.Entry)) continue;
                            tag = tagObj;
                            Class<?> tagType = tag.getValue().getClass();
                            String tagKey = tag.getKey().toString();
                            try {
                                if (tag.getValue() instanceof Integer) {
                                    namedTags.add(tagKey, ((Integer)tag.getValue()).intValue());
                                    continue;
                                }
                                if (tag.getValue() instanceof Long) {
                                    namedTags.add(tagKey, ((Long)tag.getValue()).longValue());
                                    continue;
                                }
                                if (tag.getValue() instanceof Float) {
                                    namedTags.add(tagKey, ((Float)tag.getValue()).floatValue());
                                    continue;
                                }
                                if (tag.getValue() instanceof Double) {
                                    namedTags.add(tagKey, ((Double)tag.getValue()).doubleValue());
                                    continue;
                                }
                                if (tag.getValue() instanceof Boolean) {
                                    namedTags.add(tagKey, ((Boolean)tag.getValue()).booleanValue());
                                    continue;
                                }
                                if (tag.getValue() instanceof Character) {
                                    namedTags.add(tagKey, ((Character)tag.getValue()).charValue());
                                    continue;
                                }
                                if (tag.getValue() instanceof String) {
                                    namedTags.add(tagKey, (String)tag.getValue());
                                    continue;
                                }
                                if (!(tag.getValue() instanceof Date)) continue;
                                namedTags.add(tagKey, (Date)tag.getValue());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                        if (namedTags.getCount() > 0) {
                            providerCacheItem.setNamedTags(namedTags);
                        }
                    }
                }
            }
        }
        return providerCacheItem;
    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeObject(this._key);
        writer.writeObject(this._value);
        writer.writeObject((Object)this._entry);
        writer.writeObject((Object)this._opCode);
        writer.writeObject((Object)this._providerName);
        writer.writeObject((Object)this._cacheId);
        writer.writeInt(this._retryCount);
    }

    public void deserialize(NCacheObjectInput reader) throws IOException, ClassNotFoundException {
        Object tempVar = reader.readObject();
        this._key = (String)(tempVar instanceof String ? tempVar : null);
        this._value = reader.readObject();
        Object tempVar2 = reader.readObject();
        this._entry = (CacheEntry)(tempVar2 instanceof CacheEntry ? tempVar2 : null);
        this._opCode = (OpCode)((Object)reader.readObject());
        Object tempVar3 = reader.readObject();
        this._providerName = (String)(tempVar3 instanceof String ? tempVar3 : null);
        Object tempVar4 = reader.readObject();
        this._cacheId = (String)(tempVar4 instanceof String ? tempVar4 : null);
        this._retryCount = reader.readInt();
    }
}

