/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Net.IRentableObject;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class CompactCacheEntry
implements ICompactSerializable,
IRentableObject {
    private Object _key;
    private Object _value;
    private BitSet _flag;
    private ExpirationHint _dependency;
    private CacheSyncDependency _syncDependency;
    private long _expiration;
    private byte _options;
    private Object _itemRemovedCallback;
    private String _group;
    private String _subgroup;
    private int _rentId;
    private HashMap _queryInfo;
    private ArrayList _keysDependingOnMe;
    private Object _lockId;
    private LockAccessType _accessType;
    private long _version;
    private String _providerName;
    private String _resyncProviderName;

    public CompactCacheEntry(Object key, Object value, ExpirationHint dependency, CacheSyncDependency syncDependency, long expiration, byte options, Object itemRemovedCallback, String group, HashMap queryInfo, BitSet Flag, Object lockId, long version, LockAccessType accessType, String providername, String resyncProviderName) {
        this.getLockAccessType();
        this._accessType = LockAccessType.values()[0];
        this._key = key;
        this._flag = Flag;
        this._value = value;
        this._dependency = dependency;
        this._syncDependency = syncDependency;
        this._expiration = expiration;
        this._options = options;
        this._itemRemovedCallback = itemRemovedCallback;
        if (group != null) {
            this._group = group;
        }
        this._queryInfo = queryInfo;
        this._lockId = lockId;
        this._accessType = accessType;
        this._version = version;
        this._providerName = providername;
        this._resyncProviderName = resyncProviderName;
    }

    public CompactCacheEntry() {
        this.getLockAccessType();
        this._accessType = LockAccessType.values()[0];
    }

    public final Object getKey() {
        return this._key;
    }

    public final Object getValue() {
        return this._value;
    }

    public final BitSet getFlag() {
        return this._flag;
    }

    public final long getExpiration() {
        return this._expiration;
    }

    public final Object getLockId() {
        return this._lockId;
    }

    public final LockAccessType getLockAccessType() {
        return this._accessType;
    }

    public final String getProviderName() {
        return this._providerName;
    }

    public final String getResyncProviderName() {
        return this._resyncProviderName;
    }

    public final long getVersion() {
        return this._version;
    }

    public final ExpirationHint getDependency() {
        return this._dependency;
    }

    public final CacheSyncDependency getSyncDependency() {
        return this._syncDependency;
    }

    public final byte getOptions() {
        return this._options;
    }

    public final Object getCallback() {
        return this._itemRemovedCallback;
    }

    public final String getGroup() {
        return this._group;
    }

    public final String getSubGroup() {
        return this._subgroup;
    }

    public final HashMap getQueryInfo() {
        return this._queryInfo;
    }

    public final ArrayList getKeysDependingOnMe() {
        return this._keysDependingOnMe;
    }

    public final void setKeysDependingOnMe(ArrayList value) {
        this._keysDependingOnMe = value;
    }

    public final void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        this._key = reader.readObject();
        this._value = reader.readObject();
        this._expiration = reader.readLong();
        this._dependency = ExpirationHint.ReadExpHint(reader);
        this._options = reader.readByte();
        this._itemRemovedCallback = reader.readObject();
        this._group = (String)reader.readObject();
        this._subgroup = (String)reader.readObject();
        this._queryInfo = (HashMap)reader.readObject();
        this._keysDependingOnMe = (ArrayList)reader.readObject();
    }

    public final void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeObject(this._key);
        writer.writeObject(this._value);
        writer.writeLong(this._expiration);
        ExpirationHint.WriteExpHint(writer, this._dependency);
        writer.writeByte((int)this._options);
        writer.writeObject(this._itemRemovedCallback);
        writer.writeObject((Object)this._group);
        writer.writeObject((Object)this._subgroup);
        writer.writeObject((Object)this._queryInfo);
        writer.writeObject((Object)this._keysDependingOnMe);
    }

    public final int getRentId() {
        return this._rentId;
    }

    public final void setRentId(int value) {
        this._rentId = value;
    }

    public final void Reset() {
        this._key = null;
        this._value = null;
        this._dependency = null;
        this._expiration = 0L;
        this._options = 0;
        this._itemRemovedCallback = null;
        this._group = null;
        this._subgroup = null;
        this._queryInfo = null;
    }
}

