/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching;

import Alachisoft.NCache.Caching.AutoExpiration.AggregateExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.AutoExpiration.KeyDependency;
import Alachisoft.NCache.Caching.AutoExpiration.LockExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.NodeExpiration;
import Alachisoft.NCache.Caching.CacheItemBase;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.CallbackInfo;
import Alachisoft.NCache.Caching.DataGrouping.GroupInfo;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.MetaInformation;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.CompressionUtil;
import Alachisoft.NCache.Common.DataStructures.IStreamItem;
import Alachisoft.NCache.Common.DataStructures.VirtualArray;
import Alachisoft.NCache.Common.ICloneable;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.ISizable;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Locking.LockManager;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.Stats.HPTime;
import com.alachisoft.ncache.common.caching.EntryType;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.security.encryption.EncryptionMgr;
import com.alachisoft.ncache.serialization.core.io.BlockDataInputStream;
import com.alachisoft.ncache.serialization.core.io.BlockDataOutputStream;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.ICustomSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import tangible.RefObject;

public class CacheEntry
extends CacheItemBase
implements IDisposable,
ICloneable,
ICompactSerializable,
ICustomSerializable,
ISizable,
IStreamItem,
Serializable {
    private static final int PrimitiveDTSize = 200;
    private static final int FLATTENED = 1;
    private static final int COMPRESSED = 2;
    private String _resyncProviderName;
    private String _providerName;
    private BitSet _flags = new BitSet();
    private EvictionHint _evh;
    private ExpirationHint _exh;
    private GroupInfo _grpInfo = null;
    private HashMap _queryInfo = null;
    private HashMap _keysDependingOnMe;
    private Date _creationTime = new Date(0L);
    private Date _lastModifiedTime = new Date(0L);
    private CacheItemPriority _priorityValue = CacheItemPriority.values()[0];
    private long _size = -1L;
    private Object _lockId;
    private Date _lockDate = new Date(70, 0, 1, 0, 0, 0);
    private TimeSpan _lockAge = new TimeSpan();
    private LockAccessType _accessType;
    private LockExpiration _lockExpiration;
    private long _version;
    private LockManager _lockManager;
    private CacheSyncDependency _syncDependency;
    private MetaInformation _metaInformation;
    private HPTime _bridgeOpTimeStamp;
    private String _type;

    public CacheEntry() {
        this.getLockAccessType();
        this._accessType = LockAccessType.values()[0];
        this._version = 1L;
        this._type = null;
        try {
            NCDateTime time = new NCDateTime(1970, 1, 1, 0, 0, 0, 0);
            Date date = time.getDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CacheEntry(Object val, ExpirationHint expiryHint, EvictionHint evictionHint) {
        super(val);
        this.getLockAccessType();
        this._accessType = LockAccessType.values()[0];
        this._version = 1L;
        this._type = null;
        this._exh = expiryHint;
        this._evh = evictionHint;
        this._flags.SetBit((byte)1);
        this._creationTime = new Date();
        this._lastModifiedTime = new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (this._exh != null) {
                this._exh.dispose();
                if (!(this.getKeysIAmDependingOn() != null && this.getKeysIAmDependingOn().length != 0 || this.getKeysDependingOnMe() != null && !this.getKeysDependingOnMe().isEmpty())) {
                    this._exh = null;
                }
            }
            this._evh = null;
        }
    }

    public EntryType getType() {
        return EntryType.CacheItem;
    }

    public final String getObjectType() {
        return this._type;
    }

    public final void setObjectType(String value) {
        this._type = value;
    }

    public final boolean getHasQueryInfo() {
        return this._queryInfo != null && (this._queryInfo.get("query-info") != null || this._queryInfo.get("tag-info") != null || this._queryInfo.get("named-tag-info") != null);
    }

    public final MetaInformation getMetaInformation() {
        return this._metaInformation;
    }

    public final void setMetaInformation(MetaInformation value) {
        this._metaInformation = value;
    }

    public final String getResyncProviderName() {
        return this._resyncProviderName;
    }

    public final void setResyncProviderName(String value) {
        this._resyncProviderName = value;
    }

    public final String getProviderName() {
        return this._providerName;
    }

    public final void setProviderName(String value) {
        this._providerName = value;
    }

    public final EvictionHint getEvictionHint() {
        return this._evh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setEvictionHint(EvictionHint value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._evh = value;
        }
    }

    public final CacheItemPriority getPriority() {
        return this._priorityValue;
    }

    public final void setPriority(CacheItemPriority value) {
        this._priorityValue = value;
    }

    public final ExpirationHint getExpirationHint() {
        return this._exh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExpirationHint(ExpirationHint value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._exh = value;
        }
    }

    public final GroupInfo getGroupInfo() {
        return this._grpInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setGroupInfo(GroupInfo value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._grpInfo = value;
        }
    }

    public final HashMap getQueryInfo() {
        return this._queryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setQueryInfo(HashMap value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._queryInfo = value;
        }
    }

    public final HashMap getKeysDependingOnMe() {
        return this._keysDependingOnMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setKeysDependingOnMe(HashMap value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._keysDependingOnMe = value;
        }
    }

    public final Object getLockId() {
        return this._lockId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLockId(Object value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._lockId = value;
        }
    }

    public final TimeSpan getLockAge() {
        return this._lockAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLockAge(TimeSpan value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._lockAge = value;
        }
    }

    public final Date getLockDate() {
        return this._lockDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLockDate(Date value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._lockDate = value;
        }
    }

    public final Date getCreationTime() {
        return this._creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCreationTime(Date value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._creationTime = value;
        }
    }

    public final Date getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLastModifiedTime(Date value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._lastModifiedTime = value;
        }
    }

    public final LockAccessType getLockAccessType() {
        return this._accessType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLockAccessType(LockAccessType value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._accessType = value;
        }
    }

    public final HPTime getBridgeOpTimeStamp() {
        return this._bridgeOpTimeStamp;
    }

    public final void setBridgeOpTimeStamp(HPTime value) {
        this._bridgeOpTimeStamp = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LockManager getRWLockManager() {
        if (this._lockManager == null) {
            CacheEntry cacheEntry = this;
            synchronized (cacheEntry) {
                if (this._lockManager == null) {
                    this._lockManager = new LockManager();
                }
            }
        }
        return this._lockManager;
    }

    public final LockExpiration getLockExpiration() {
        return this._lockExpiration;
    }

    public final void setLockExpiration(LockExpiration value) {
        this._lockExpiration = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean IsLocked(RefObject<Object> lockId, RefObject<Date> lockDate) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (this.getFlag().IsAnyBitSet((byte)64)) {
                if (this.getLockExpiration() == null || !this.getLockExpiration().HasExpired()) {
                    lockId.argvalue = this.getLockId();
                    lockDate.argvalue = this.getLockDate();
                    return true;
                }
                this.ReleaseLock();
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean CompareLock(Object lockId) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (this.getFlag().IsAnyBitSet((byte)64)) {
                if (lockId == null) {
                    return false;
                }
                if (this.getLockId().equals(lockId)) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean IsItemLocked() {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (this.getLockExpiration() == null || !this.getLockExpiration().HasExpired()) {
                return this.getFlag().IsAnyBitSet((byte)64);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ReleaseLock() {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this.setLockId(null);
            try {
                NCDateTime time = new NCDateTime(1970, 1, 1, 0, 0, 0, 0);
                this.setLockDate(time.getDate());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getFlag().UnsetBit((byte)64);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void CopyLock(Object lockId, Date lockDate, LockExpiration lockExpiration) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (lockId != null) {
                this.getFlag().SetBit((byte)64);
            } else {
                this.getFlag().UnsetBit((byte)64);
            }
            this.setLockId(lockId);
            this.setLockDate(lockDate);
            this.setLockExpiration(lockExpiration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean Lock(LockExpiration lockExpiration, RefObject<Object> lockId, RefObject<Date> lockDate) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (!this.IsLocked(lockId, lockDate)) {
                this.getFlag().SetBit((byte)64);
                this.setLockId(lockId.argvalue);
                this.setLockDate((Date)lockDate.argvalue);
                this.setLockExpiration(lockExpiration);
                if (this.getLockExpiration() != null) {
                    this.getLockExpiration().Set();
                }
                return true;
            }
            lockId.argvalue = this.getLockId();
            lockDate.argvalue = this.getLockDate();
            return false;
        }
    }

    public final long getVersion() {
        return this._version;
    }

    public final void setVersion(long value) {
        this._version = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void UpdateVersion(CacheEntry entry) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this.CopyVersion(entry);
            ++this._version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CopyVersion(CacheEntry entry) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._version = entry.getVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void UpdateLastModifiedTime(CacheEntry entry) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._creationTime = entry.getCreationTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean IsNewer(long version) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            return this.getVersion() > version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean CompareVersion(long version) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            return this._version == version;
        }
    }

    public final Object[] getKeysIAmDependingOn() {
        ArrayList<String> keyList = null;
        if (this.getExpirationHint() != null) {
            if (this.getExpirationHint()._hintType == ExpirationHintType.AggregateExpirationHint) {
                ExpirationHint[] hints = ((AggregateExpirationHint)this.getExpirationHint()).getHints();
                for (int i = 0; i < hints.length; ++i) {
                    String[] tmp;
                    if (hints[i]._hintType != ExpirationHintType.KeyDependency) continue;
                    if (keyList == null) {
                        keyList = new ArrayList<String>();
                    }
                    if ((tmp = ((KeyDependency)hints[i]).getCacheKeys()) == null || tmp.length <= 0) continue;
                    for (int j = 0; j < tmp.length; ++j) {
                        if (keyList.contains(tmp[j])) continue;
                        keyList.add(tmp[j]);
                    }
                }
                if (keyList != null && keyList.size() > 0) {
                    Object[] cacheKeys = new Object[keyList.size()];
                    System.arraycopy(keyList.toArray(), 0, cacheKeys, 0, keyList.size());
                    return cacheKeys;
                }
            } else if (this.getExpirationHint()._hintType == ExpirationHintType.KeyDependency) {
                return ((KeyDependency)this.getExpirationHint()).getCacheKeys();
            }
        }
        return null;
    }

    public final CacheSyncDependency getSyncDependency() {
        return this._syncDependency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSyncDependency(CacheSyncDependency value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._syncDependency = value;
        }
    }

    public final Object getUserData() {
        Object[] userData = null;
        if (this.getValue() != null) {
            UserBinaryObject ubObject = (UserBinaryObject)(this.getValue() instanceof UserBinaryObject ? this.getValue() : null);
            userData = ubObject.getData();
        }
        return userData;
    }

    @Override
    public Object getValue() {
        return super.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (this._flags != null) {
                if (value instanceof byte[] || value instanceof UserBinaryObject) {
                    this._flags.SetBit((byte)1);
                } else {
                    this._flags.UnsetBit((byte)1);
                }
            }
            Object val1 = value;
            if (value instanceof Object[] && !(val1 instanceof byte[])) {
                val1 = UserBinaryObject.createUserBinaryObject(Collections.singleton((byte[][])value));
            }
            if (super.getValue() instanceof CallbackEntry && val1 instanceof UserBinaryObject) {
                Object tempVar = super.getValue();
                CallbackEntry cbEntry = (CallbackEntry)(tempVar instanceof CallbackEntry ? tempVar : null);
                cbEntry.setValue(val1);
            } else {
                super.setValue(val1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddCallbackInfo(CallbackInfo updateCallback, CallbackInfo removeCallback) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            CallbackEntry cbEntry;
            if (this.getValue() instanceof CallbackEntry) {
                Object tempVar = this.getValue();
                cbEntry = (CallbackEntry)(tempVar instanceof CallbackEntry ? tempVar : null);
            } else {
                cbEntry = new CallbackEntry();
                cbEntry.setValue(this.getValue());
                cbEntry.setFlag(this.getFlag());
                this.setValue(cbEntry);
            }
            if (updateCallback != null && updateCallback.getCallback() != null && (Short)updateCallback.getCallback() != -1) {
                cbEntry.AddItemUpdateCallback(updateCallback);
            }
            if (removeCallback != null && removeCallback.getCallback() != null && (Short)removeCallback.getCallback() != -1) {
                cbEntry.AddItemRemoveCallback(removeCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveCallbackInfo(CallbackInfo updateCallback, CallbackInfo removeCallback) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (updateCallback != null || removeCallback != null) {
                CallbackEntry cbEntry = null;
                if (this.getValue() instanceof CallbackEntry) {
                    Object tempVar = this.getValue();
                    cbEntry = (CallbackEntry)(tempVar instanceof CallbackEntry ? tempVar : null);
                    if (updateCallback != null) {
                        cbEntry.RemoveItemUpdateCallback(updateCallback);
                    }
                    if (removeCallback != null) {
                        cbEntry.RemoveItemRemoveCallback(removeCallback);
                    }
                }
            }
        }
    }

    public final boolean getIsFlattened() {
        return this._flags.IsBitSet((byte)1);
    }

    public final boolean getIsCompressed() {
        return this._flags.IsBitSet((byte)2);
    }

    public final BitSet getFlag() {
        return this._flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFlag(BitSet value) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this._flags = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CacheEntry CloneWithoutValue() {
        CacheEntry e = new CacheEntry();
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            e._exh = this._exh;
            e._evh = this._evh;
            if (this._grpInfo != null) {
                e._grpInfo = (GroupInfo)this._grpInfo.clone();
            }
            e._flags = (BitSet)this._flags.Clone();
            e._syncDependency = this._syncDependency;
            e._queryInfo = this._queryInfo;
            if (this._keysDependingOnMe != null) {
                Object tempVar = this._keysDependingOnMe.clone();
                e._keysDependingOnMe = (HashMap)(tempVar instanceof HashMap ? tempVar : null);
            }
            e._lockId = this._lockId;
            e._lockDate = this._lockDate;
            e._size = this._size;
            e._lockAge = this._lockAge;
            e._version = this._version;
            e._creationTime = this._creationTime;
            e._lastModifiedTime = this._lastModifiedTime;
            e._lockExpiration = this._lockExpiration;
            e._resyncProviderName = this._resyncProviderName;
            e._providerName = this._providerName;
            e._bridgeOpTimeStamp = this._bridgeOpTimeStamp;
            if (this.getValue() instanceof CallbackEntry) {
                CallbackEntry cbEntry = (CallbackEntry)this.getValue();
                Object tempVar2 = cbEntry.clone();
                cbEntry = (CallbackEntry)(tempVar2 instanceof CallbackEntry ? tempVar2 : null);
                cbEntry.setValue(null);
                e.setValue(cbEntry);
            }
            e._lockManager = this._lockManager;
            e._type = this._type;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object clone() {
        CacheEntry e = new CacheEntry(this.getValue(), this._exh, this._evh);
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (this._grpInfo != null) {
                e._grpInfo = (GroupInfo)this._grpInfo.clone();
            }
            e._flags = (BitSet)this._flags.Clone();
            e.setPriority(this.getPriority());
            e._syncDependency = this._syncDependency;
            e._queryInfo = this._queryInfo;
            if (this._keysDependingOnMe != null) {
                Object tempVar = this._keysDependingOnMe.clone();
                e._keysDependingOnMe = (HashMap)(tempVar instanceof HashMap ? tempVar : null);
            }
            e._lockId = this._lockId;
            e._lockDate = this._lockDate;
            e._size = this._size;
            e._lockAge = this._lockAge;
            e._version = this._version;
            e._creationTime = this._creationTime;
            e._lastModifiedTime = this._lastModifiedTime;
            e._lockExpiration = this._lockExpiration;
            e._resyncProviderName = this._resyncProviderName;
            e._providerName = this._providerName;
            e._lockManager = this._lockManager;
            e._bridgeOpTimeStamp = this._bridgeOpTimeStamp;
            e._type = this._type;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CacheEntry RoutableClone(Address localAddress) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (this._syncDependency != null || this._exh != null) {
                NodeExpiration expiry = null;
                if (localAddress != null) {
                    expiry = new NodeExpiration(localAddress);
                }
                if (this.getSyncDependency() == null) {
                    if (!this._exh.getIsRoutable()) {
                        CacheEntry e = new CacheEntry(this.getValue(), expiry, this._evh);
                        if (this._grpInfo != null) {
                            e._grpInfo = (GroupInfo)this._grpInfo.clone();
                        }
                        e._flags = (BitSet)this._flags.Clone();
                        e._version = this._version;
                        e._creationTime = this._creationTime;
                        e._lastModifiedTime = this._lastModifiedTime;
                        e._lockExpiration = this._lockExpiration;
                        e._resyncProviderName = this._resyncProviderName;
                        e.setPriority(this.getPriority());
                        return e;
                    }
                } else {
                    if (this._exh != null && this._exh.getIsRoutable()) {
                        AggregateExpirationHint aggHint = new AggregateExpirationHint();
                        aggHint.Add(this._exh);
                        CacheEntry e = new CacheEntry(this.getValue(), aggHint, this._evh);
                        if (this._grpInfo != null) {
                            e._grpInfo = (GroupInfo)this._grpInfo.clone();
                        }
                        e._flags = (BitSet)this._flags.Clone();
                        e._version = this._version;
                        e._creationTime = this._creationTime;
                        e._lastModifiedTime = this._lastModifiedTime;
                        e._lockExpiration = this._lockExpiration;
                        e._resyncProviderName = this._resyncProviderName;
                        e.setPriority(this.getPriority());
                        return e;
                    }
                    CacheEntry e = new CacheEntry(this.getValue(), expiry, this._evh);
                    if (this._grpInfo != null) {
                        e._grpInfo = (GroupInfo)this._grpInfo.clone();
                    }
                    e._flags = (BitSet)this._flags.Clone();
                    e._version = this._version;
                    e._creationTime = this._creationTime;
                    e._lastModifiedTime = this._lastModifiedTime;
                    e._lockExpiration = this._lockExpiration;
                    e._resyncProviderName = this._resyncProviderName;
                    e.setPriority(this.getPriority());
                    return e;
                }
            }
        }
        return (CacheEntry)this.clone();
    }

    public final CacheEntry FlattenedClone(String cacheContext) {
        CacheEntry e = (CacheEntry)this.clone();
        e.FlattenObject(cacheContext);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object FlattenObject(String cacheContext) {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (this.getIsFlattened()) {
                try {
                    this.setValue(CompactBinaryFormatter.fromByteBuffer((byte[])((byte[])this.getUserData()), (String)cacheContext));
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return this.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object DeflattenObject(String cacheContext) throws IOException, ClassNotFoundException {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            UserBinaryObject userBinaryObject;
            Object val = this.getValue();
            if (this.getIsFlattened() && (userBinaryObject = (UserBinaryObject)(val instanceof UserBinaryObject ? val : null)) != null) {
                byte[] data = userBinaryObject.getFullObject();
                if (this.getIsCompressed()) {
                    data = CompressionUtil.Decompress((byte[])data);
                    this._flags.UnsetBit((byte)2);
                }
                this._size = data.length;
                val = CompactBinaryFormatter.fromByteBuffer((byte[])data, (String)cacheContext);
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object DeflattedValue(String cacheContext) throws Exception {
        Object obj = this.getValue();
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (this.getIsFlattened()) {
                Object tempVar;
                UserBinaryObject ub = null;
                CallbackEntry cbEntry = (CallbackEntry)(obj instanceof CallbackEntry ? obj : null);
                ub = cbEntry != null ? (UserBinaryObject)((tempVar = cbEntry.getValue()) instanceof UserBinaryObject ? tempVar : null) : (UserBinaryObject)(obj instanceof UserBinaryObject ? obj : null);
                byte[] data = ub.getFullObject();
                if (this.getIsCompressed()) {
                    data = CompressionUtil.Decompress((byte[])data);
                    this._flags.UnsetBit((byte)2);
                }
                data = EncryptionMgr.Decrypt((byte[])data, (String)cacheContext);
                this._size = data.length;
                obj = CompactBinaryFormatter.fromByteBuffer((byte[])data, (String)cacheContext);
                if (cbEntry != null) {
                    cbEntry.setValue(obj);
                    obj = cbEntry;
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void KeepDeflattedValue(String cacheContext) throws Exception {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            try {
                if (this.getIsFlattened()) {
                    this.setValue(this.DeflattedValue(cacheContext));
                    this._flags.UnsetBit((byte)1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "CacheEntry[" + this.getValue().toString() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            this.setValue(reader.readObject());
            this._flags = new BitSet(reader.readByte());
            this.getEvictionHint();
            this._evh = EvictionHint.ReadEvcHint(reader);
            this.getExpirationHint();
            this._exh = ExpirationHint.ReadExpHint(reader);
            this.getGroupInfo();
            this._grpInfo = GroupInfo.ReadGrpInfo(reader);
            Object tempVar = reader.readObject();
            this._syncDependency = (CacheSyncDependency)(tempVar instanceof CacheSyncDependency ? tempVar : null);
            this._queryInfo = (HashMap)reader.readObject();
            this._keysDependingOnMe = (HashMap)reader.readObject();
            this._size = reader.readLong();
            this._lockId = reader.readObject();
            this._lockDate = new NCDateTime(reader.readLong()).getDate();
            this._version = reader.readLong();
            Object tempVar2 = reader.readObject();
            this._lockExpiration = (LockExpiration)(tempVar2 instanceof LockExpiration ? tempVar2 : null);
            this._creationTime = new NCDateTime(reader.readLong()).getDate();
            this._lastModifiedTime = new NCDateTime(reader.readLong()).getDate();
            Object tempVar3 = reader.readObject();
            this._resyncProviderName = (String)(tempVar3 instanceof String ? tempVar3 : null);
            this._priorityValue = CacheItemPriority.forValue((int)reader.readInt());
            Object tempVar4 = reader.readObject();
            this._lockManager = (LockManager)(tempVar4 instanceof LockManager ? tempVar4 : null);
            Object tempVar5 = reader.readObject();
            this._providerName = (String)(tempVar5 instanceof String ? tempVar5 : null);
            Object tempVar6 = reader.readObject();
            this._bridgeOpTimeStamp = (HPTime)(tempVar6 instanceof HPTime ? tempVar6 : null);
            Object tempVar7 = reader.readObject();
            this._type = (String)(tempVar7 instanceof String ? tempVar7 : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(NCacheObjectOutput writer) throws IOException {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            writer.writeObject(this.getValue());
            writer.writeByte((int)this._flags.getData());
            this.getEvictionHint();
            EvictionHint.WriteEvcHint(writer, this._evh);
            this.getExpirationHint();
            ExpirationHint.WriteExpHint(writer, this._exh);
            this.getGroupInfo();
            GroupInfo.WriteGrpInfo(writer, this._grpInfo);
            writer.writeObject((Object)this._syncDependency);
            writer.writeObject((Object)this._queryInfo);
            writer.writeObject((Object)this._keysDependingOnMe);
            writer.writeLong(this._size);
            writer.writeObject(this._lockId);
            Calendar c = Calendar.getInstance();
            c.clear();
            c.set(14, 0);
            c.setTime(this._lockDate);
            NCDateTime ncdt = null;
            try {
                ncdt = new NCDateTime(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            writer.writeLong(ncdt.getTicks());
            writer.writeLong(this._version);
            writer.writeObject((Object)this._lockExpiration);
            c = Calendar.getInstance();
            c.clear();
            c.set(14, 0);
            c.setTime(this._creationTime);
            ncdt = null;
            try {
                ncdt = new NCDateTime(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            writer.writeLong(ncdt.getTicks());
            c = Calendar.getInstance();
            c.clear();
            c.set(14, 0);
            c.setTime(this._lastModifiedTime);
            ncdt = null;
            try {
                ncdt = new NCDateTime(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            writer.writeLong(ncdt.getTicks());
            writer.writeObject((Object)this._resyncProviderName);
            writer.writeInt(this._priorityValue.value());
            writer.writeObject((Object)this._lockManager);
            writer.writeObject((Object)this._providerName);
            writer.writeObject((Object)this._bridgeOpTimeStamp);
            writer.writeObject((Object)this._type);
        }
    }

    public final void DeserializeLocal(BlockDataInputStream reader) {
        throw new UnsupportedOperationException("The method or operation is not implemented.");
    }

    public final void SerializeLocal(BlockDataOutputStream writer) {
        throw new UnsupportedOperationException("The method or operation is not implemented.");
    }

    public final int getSize() {
        return (int)(200L + this.getDataSize());
    }

    public int getInMemorySize() {
        return 0;
    }

    public final long getDataSize() {
        if (this._size > -1L) {
            return this._size;
        }
        int size = 0;
        if (this.getValue() != null) {
            if (this.getValue() instanceof UserBinaryObject) {
                size = ((UserBinaryObject)this.getValue()).getSize();
            } else if (this.getValue() instanceof CallbackEntry && ((CallbackEntry)this.getValue()).getValue() != null) {
                size = ((UserBinaryObject)((CallbackEntry)this.getValue()).getValue()).getSize();
            }
        }
        return size;
    }

    public final void setDataSize(long value) {
        this._size = value;
    }

    public final VirtualArray Read(int offset, int length) {
        VirtualArray vBuffer = null;
        UserBinaryObject ubObject = (UserBinaryObject)(this.getValue() instanceof CallbackEntry ? ((CallbackEntry)this.getValue()).getValue() : this.getValue());
        if (ubObject != null) {
            vBuffer = ubObject.Read(offset, length);
        }
        return vBuffer;
    }

    public final void Write(VirtualArray vBuffer, int srcOffset, int dstOffset, int length) {
        UserBinaryObject ubObject = (UserBinaryObject)(this.getValue() instanceof CallbackEntry ? ((CallbackEntry)this.getValue()).getValue() : this.getValue());
        if (ubObject != null) {
            ubObject.Write(vBuffer, srcOffset, dstOffset, length);
        }
    }

    public final int getLength() {
        int size = 0;
        if (this.getValue() != null) {
            if (this.getValue() instanceof UserBinaryObject) {
                size = ((UserBinaryObject)this.getValue()).getSize();
            } else if (this.getValue() instanceof CallbackEntry && ((CallbackEntry)this.getValue()).getValue() != null) {
                size = ((UserBinaryObject)((CallbackEntry)this.getValue()).getValue()).getSize();
            }
        }
        return size;
    }

    public void setLength(int value) {
        throw new UnsupportedOperationException("Set length is not supported.");
    }
}

