/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.DBCacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.io.Serializable;
import java.sql.SQLException;

public class Sql7CacheDependency
extends DBCacheDependency
implements Serializable {
    public Sql7CacheDependency() {
        this._hintType = ExpirationHintType.Sql7CacheDependency;
    }

    public Sql7CacheDependency(String connectionString, String pk) {
        this._connectionString = connectionString;
        this._dbCacheKey = pk;
        this._hintType = ExpirationHintType.Sql7CacheDependency;
    }

    public final String getConnectionString() {
        return this._connectionString;
    }

    public final String getDbCacheKey() {
        return this._dbCacheKey;
    }

    @Override
    public boolean Reset(CacheRuntimeContext context) throws OperationFailedException {
        if (context.IsClientCache) {
            return true;
        }
        super.Reset(context);
        try {
            if (this._connectionString != null) {
                if (!context.ExpiryMgr.getCacheDbSyncManager().ConnectionStringExists(this._connectionString)) {
                    context.ExpiryMgr.getCacheDbSyncManager().AddConnectionString(this._connectionString, true);
                    context.getCacheImpl().ReplicateConnectionString(this._connectionString, true);
                }
                if (context.getIsDbSyncCoordinator()) {
                    return this.Initialize(context);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public final boolean Initialize(CacheRuntimeContext context) throws SQLException {
        try {
            this._cdbSyncManager = context.ExpiryMgr.getCacheDbSyncManager();
            this._cacheName = this._cdbSyncManager.GetCacheID(context.getCacheImpl().getName());
            this._connection = this._cdbSyncManager.AddToSqlConnectionPool(this._connectionString);
            if (this.SetSyncData()) {
                this._cdbSyncManager.AddDBMapping(this._dbCacheKey, this.getCacheKey(), this);
                return true;
            }
        }
        catch (SQLException e) {
            if (e.getMessage().contains("Unsuported connection string:")) {
                this._cdbSyncManager.RemoveFromSqlConnectionPool(this._connectionString);
            }
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "SQL7DEPENDENCY \"" + this._connectionString + "\"" + this._dbCacheKey + "\"\r\n";
    }
}

