/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.DBCacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.sql.SQLException;

public class OleDbCacheDependency
extends DBCacheDependency
implements ICompactSerializable {
    public OleDbCacheDependency() {
        this._hintType = ExpirationHintType.OleDbCacheDependency;
    }

    public OleDbCacheDependency(String connectionString, String pk) {
        this._connectionString = connectionString;
        this._dbCacheKey = pk;
        this._hintType = ExpirationHintType.OleDbCacheDependency;
    }

    public final String getConnectionString() {
        return this._connectionString;
    }

    public final String getDbCacheKey() {
        return this._dbCacheKey;
    }

    @Override
    public boolean Reset(CacheRuntimeContext context) throws OperationFailedException {
        if (context.IsClientCache) {
            return true;
        }
        super.Reset(context);
        try {
            if (this._connectionString != null) {
                if (!context.ExpiryMgr.getCacheDbSyncManager().ConnectionStringExists(this._connectionString)) {
                    context.ExpiryMgr.getCacheDbSyncManager().AddConnectionString(this._connectionString, false);
                    context.getCacheImpl().ReplicateConnectionString(this._connectionString, false);
                }
                if (context.getIsDbSyncCoordinator()) {
                    return this.Initialize(context);
                }
            }
        }
        catch (Exception e) {
            this.getNCacheLog().DevTrace(e.getMessage());
            throw new OperationFailedException(e.getMessage());
        }
        return false;
    }

    private boolean Initialize(CacheRuntimeContext context) throws SQLException {
        try {
            this._cdbSyncManager = context.ExpiryMgr.getCacheDbSyncManager();
            this._cacheName = this._cdbSyncManager.GetCacheID(context.getCacheImpl().getName());
            this._connection = this._cdbSyncManager.AddToOleDbConnectionPool(this._connectionString);
            if (this.SetSyncData()) {
                this._cdbSyncManager.AddDBMapping(this._dbCacheKey, this.getCacheKey(), this);
                return true;
            }
        }
        catch (SQLException e) {
            if (e.getMessage().contains("Unsuported connection string:")) {
                this._cdbSyncManager.RemoveFromOleDbConnectionPool(this._connectionString);
            }
            throw e;
        }
        catch (Exception e) {
            this.getNCacheLog().DevTrace(e.getMessage());
        }
        return false;
    }

    public String toString() {
        return "OLEDBDEPENDENCY \"" + this._connectionString + "\"" + this._dbCacheKey + "\"\r\n";
    }

    @Override
    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
    }

    @Override
    public void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
    }
}

