/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Common.AppUtil;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class FixedExpiration
extends ExpirationHint
implements ICompactSerializable,
Serializable {
    private int _absoluteTime;
    private int _milliseconds;
    private long _ticks;

    public FixedExpiration(Date absoluteTime) {
        try {
            this._hintType = ExpirationHintType.FixedExpiration;
            this._absoluteTime = AppUtil.DiffSeconds((Date)absoluteTime);
            this._milliseconds = AppUtil.DiffMilliseconds((Date)absoluteTime);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public FixedExpiration(Date absoluteTime, long ticks) {
        this(absoluteTime);
        this._ticks = ticks;
    }

    public FixedExpiration() {
        this._hintType = ExpirationHintType.FixedExpiration;
    }

    public void setTime(Date absoluteTime) {
        try {
            this._absoluteTime = AppUtil.DiffSeconds((Date)absoluteTime);
            this._milliseconds = AppUtil.DiffMilliseconds((Date)absoluteTime);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public int getSortKey() {
        return this._absoluteTime;
    }

    public long getTicks() {
        return this._ticks;
    }

    @Override
    public boolean DetermineExpiration(CacheRuntimeContext context) {
        if (this.getHasExpired()) {
            return true;
        }
        try {
            int currentTime = AppUtil.DiffSeconds((Date)NCDateTime.getUTCNow());
            if (this._absoluteTime < currentTime) {
                this.NotifyExpiration(this, null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.getHasExpired();
    }

    public final Date getAbsoluteTime() {
        Date dt = AppUtil.GetDateTime((int)this._absoluteTime);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(14, this._milliseconds);
        return cal.getTime();
    }

    public String toString() {
        return "";
    }

    @Override
    public final void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        this._absoluteTime = reader.readInt();
        this._milliseconds = reader.readInt();
        this._ticks = reader.readLong();
    }

    @Override
    public final void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        writer.writeInt(this._absoluteTime);
        writer.writeInt(this._milliseconds);
        writer.writeLong(this._ticks);
    }
}

